/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAttributeInfo;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;

public class MiningModelAttributes {
    private static final String _ALL_MINING_MODEL_ATTRIBUTES = "WITH \n T1 AS (\n   SELECT * FROM ALL_MINING_MODEL_ATTRIBUTES WHERE owner = <2> AND model_name = <3> ),\n T2 AS (\n     select attribute_name, attribute_subname, attr_non_null, expression, reverse_expression from (\n     SELECT attribute_name, attribute_subname,\n                 nvl(attribute_name, attribute_subname) attr_non_null,\n                 expression, reverse_expression,\n                row_number() OVER ( PARTITION BY nvl(attribute_name, attribute_subname) ORDER BY nvl(attribute_subname, attribute_name ) ) rn\n            FROM TABLE(DBMS_DATA_MINING.GET_MODEL_TRANSFORMATIONS(<1>)) \n     ) where rn = 1\n   )\nSELECT T1.*, T2.attribute_subname, T2.expression, T2.reverse_expression FROM  T1, T2\nWHERE T1.attribute_name = attr_non_null(+)\n";
    private static final String ALL_MINING_MODEL_ATTRIBUTES = "select  ATTRIBUTE_NAME, ATTRIBUTE_TYPE, DATA_TYPE, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, USAGE_TYPE,  TARGET from ALL_MINING_MODEL_ATTRIBUTES where OWNER=<1> and MODEL_NAME = <2>";
    private static final String _ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    private static final String _ATTRIBUTE_SUBNAME = "ATTRIBUTE_SUBNAME";
    private static final String _ATTRIBUTE_TYPE = "ATTRIBUTE_TYPE";
    private static final String _DATA_TYPE = "DATA_TYPE";
    private static final String _DATA_LENGTH = "DATA_LENGTH";
    private static final String _DATA_PRECISION = "DATA_PRECISION";
    private static final String _DATA_SCALE = "DATA_SCALE";
    private static final String _USAGE_TYPE = "USAGE_TYPE";
    private static final String _TARGET = "TARGET";
    private static final String _EXPRESSION = "EXPRESSION";
    private static final String _REVERSE_EXPRESSION = "REVERSE_EXPRESSION";
    private static Hashtable<String, String> _columns = new Hashtable();
    private String _owner;
    private String _modelName;
    private Hashtable<String, MiningAttributeInfo> _attributes;

    static MiningModelAttributes getMiningModelAttributes(Connection connection, String string, String string2, List<MiningAttributeType> list) throws Exception {
        MiningModelAttributes miningModelAttributes = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string3 = StringUtils.escapeSingleQuotesForSQL(string);
            String string4 = "\"" + string3 + "\".\"" + string2 + "\"";
            String string5 = StringUtils.getReplacedString(_ALL_MINING_MODEL_ATTRIBUTES, "<1>", StringUtils.addSingleQuotes(string4));
            string5 = StringUtils.getReplacedString(string5, "<2>", StringUtils.addSingleQuotes(string3));
            string5 = StringUtils.getReplacedString(string5, "<3>", StringUtils.addSingleQuotes(string2));
            sQLHelper.pstmt = connection.prepareStatement(string5);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            miningModelAttributes = new MiningModelAttributes(string3, string2, sQLHelper.rs, list);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return miningModelAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MiningModelAttributes getMiningModelAttributes2(Connection connection, String string, String string2) throws Exception {
        MiningModelAttributes miningModelAttributes = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string3 = StringUtils.getReplacedString(ALL_MINING_MODEL_ATTRIBUTES, "<1>", StringUtils.addSingleQuotes(string));
            string3 = StringUtils.getReplacedString(string3, "<2>", StringUtils.addSingleQuotes(string2));
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            miningModelAttributes = new MiningModelAttributes(string, string2);
            miningModelAttributes._attributes = new Hashtable();
            while (sQLHelper.rs.next()) {
                MiningAttributeInfo miningAttributeInfo = new MiningAttributeInfo();
                String string4 = (String)MiningModelAttributes.getAttribute(sQLHelper.rs, _ATTRIBUTE_NAME);
                miningAttributeInfo.setAttributeName(string4);
                miningAttributeInfo.setAttributeType((String)MiningModelAttributes.getAttribute(sQLHelper.rs, _ATTRIBUTE_TYPE));
                miningAttributeInfo.setDataType((String)MiningModelAttributes.getAttribute(sQLHelper.rs, _DATA_TYPE));
                miningAttributeInfo.setDataLength((BigDecimal)MiningModelAttributes.getAttribute(sQLHelper.rs, _DATA_LENGTH));
                miningAttributeInfo.setDataPrecision((BigDecimal)MiningModelAttributes.getAttribute(sQLHelper.rs, _DATA_PRECISION));
                miningAttributeInfo.setDataScale((BigDecimal)MiningModelAttributes.getAttribute(sQLHelper.rs, _DATA_SCALE));
                miningAttributeInfo.setUsageType((String)MiningModelAttributes.getAttribute(sQLHelper.rs, _USAGE_TYPE));
                miningAttributeInfo.setTarget((String)MiningModelAttributes.getAttribute(sQLHelper.rs, _TARGET));
                miningModelAttributes._attributes.put(string4, miningAttributeInfo);
            }
        }
        finally {
            sQLHelper.close();
        }
        return miningModelAttributes;
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getOwner() {
        return this._owner;
    }

    public Vector<MiningAttributeInfo> getAttributes() {
        if (this._attributes == null) {
            return null;
        }
        return new Vector<MiningAttributeInfo>(this._attributes.values());
    }

    private MiningModelAttributes(String string, String string2) {
        this._owner = string;
        this._modelName = string2;
    }

    private MiningModelAttributes(String string, String string2, ResultSet resultSet, List<MiningAttributeType> list) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object : list) {
            hashMap.put(object.getName(), object.getAutoPrep());
        }
        this._owner = string;
        this._modelName = string2;
        this._attributes = new Hashtable();
        while (resultSet.next()) {
            Object object;
            MiningAttributeInfo miningAttributeInfo = new MiningAttributeInfo();
            object = (String)MiningModelAttributes.getAttribute(resultSet, _ATTRIBUTE_NAME);
            miningAttributeInfo.setAttributeName((String)object);
            String string3 = (String)MiningModelAttributes.getAttribute(resultSet, _ATTRIBUTE_SUBNAME);
            miningAttributeInfo.setAttributeSubName(string3 != null ? string3 : "");
            miningAttributeInfo.setAttributeType((String)MiningModelAttributes.getAttribute(resultSet, _ATTRIBUTE_TYPE));
            miningAttributeInfo.setDataType((String)MiningModelAttributes.getAttribute(resultSet, _DATA_TYPE));
            miningAttributeInfo.setDataLength((BigDecimal)MiningModelAttributes.getAttribute(resultSet, _DATA_LENGTH));
            miningAttributeInfo.setDataPrecision((BigDecimal)MiningModelAttributes.getAttribute(resultSet, _DATA_PRECISION));
            miningAttributeInfo.setDataScale((BigDecimal)MiningModelAttributes.getAttribute(resultSet, _DATA_SCALE));
            miningAttributeInfo.setUsageType((String)MiningModelAttributes.getAttribute(resultSet, _USAGE_TYPE));
            miningAttributeInfo.setTarget((String)MiningModelAttributes.getAttribute(resultSet, _TARGET));
            miningAttributeInfo.setExpression((StringBuffer)MiningModelAttributes.getAttribute(resultSet, _EXPRESSION));
            miningAttributeInfo.setRevExpression((StringBuffer)MiningModelAttributes.getAttribute(resultSet, _REVERSE_EXPRESSION));
            String string4 = (String)hashMap.get(object);
            if (string4.equals("Yes")) {
                miningAttributeInfo.setDataPrep(true);
            } else {
                miningAttributeInfo.setDataPrep(false);
            }
            this._attributes.put((String)object, miningAttributeInfo);
        }
    }

    private static Object getAttribute(ResultSet resultSet, String string) throws SQLException {
        Object object = null;
        String string2 = _columns.get(string);
        if (string2 == null) {
            return null;
        }
        if (string2.equals("NUMBER")) {
            object = resultSet.getBigDecimal(string);
        } else if (string2.equals("VARCHAR2")) {
            object = resultSet.getString(string);
        } else if (string2.equals("CLOB")) {
            Clob clob = resultSet.getClob(string);
            object = clob != null ? DatabaseMetadataUtils.clobToStringBuffer(clob) : new StringBuffer("");
        }
        return object;
    }

    static {
        _columns.put(_ATTRIBUTE_NAME, "VARCHAR2");
        _columns.put(_ATTRIBUTE_SUBNAME, "VARCHAR2");
        _columns.put(_ATTRIBUTE_TYPE, "VARCHAR2");
        _columns.put(_DATA_TYPE, "VARCHAR2");
        _columns.put(_DATA_LENGTH, "NUMBER");
        _columns.put(_DATA_PRECISION, "NUMBER");
        _columns.put(_DATA_SCALE, "NUMBER");
        _columns.put(_USAGE_TYPE, "VARCHAR2");
        _columns.put(_TARGET, "VARCHAR2");
        _columns.put(_EXPRESSION, "CLOB");
        _columns.put(_REVERSE_EXPRESSION, "CLOB");
    }
}

