/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.HashMap;
import java.util.Map;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;

public final class MiningAlgorithms
extends Enum<MiningAlgorithms> {
    public static final /* enum */ MiningAlgorithms APRIORI = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_APRIORI_ASSOCIATION_RULES"));
    public static final /* enum */ MiningAlgorithms DECISION_TREE = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_DECISION_TREE"));
    public static final /* enum */ MiningAlgorithms GENERALIZED_LINEAR_MODEL = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_GENERALIZED_LINEAR_MODEL"));
    public static final /* enum */ MiningAlgorithms KMEANS = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_KMEANS"));
    public static final /* enum */ MiningAlgorithms NAIVE_BAYES = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_NAIVE_BAYES"));
    public static final /* enum */ MiningAlgorithms NON_NEGATIVE_MATRIX_FACTORIZATION = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_NONNEGATIVE_MATRIX_FACTOR"));
    public static final /* enum */ MiningAlgorithms OCLUSTER = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_O_CLUSTER"));
    public static final /* enum */ MiningAlgorithms SUPPORT_VECTOR_MACHINE = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
    private final String translation;
    private static final Map<String, MiningAlgorithms> stringToEnum;
    private static final /* synthetic */ MiningAlgorithms[] $VALUES;

    public static MiningAlgorithms[] values() {
        return (MiningAlgorithms[])$VALUES.clone();
    }

    public static MiningAlgorithms valueOf(String string) {
        return Enum.valueOf(MiningAlgorithms.class, string);
    }

    private MiningAlgorithms(String string2) {
        this.translation = string2;
    }

    public static MiningAlgorithms fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static String translateFromODMServerAlgorithm(String string) {
        String string2 = "";
        string2 = string.compareTo("APRIORI_ASSOCIATION_RULES") == 0 ? APRIORI.toString() : (string.compareTo("DECISION_TREE") == 0 ? DECISION_TREE.toString() : (string.compareTo("GENERALIZED_LINEAR_MODEL") == 0 ? GENERALIZED_LINEAR_MODEL.toString() : (string.compareTo("KMEANS") == 0 ? KMEANS.toString() : (string.compareTo("NAIVE_BAYES") == 0 ? NAIVE_BAYES.toString() : (string.compareTo("O_CLUSTER") == 0 ? OCLUSTER.toString() : (string.compareTo("SUPPORT_VECTOR_MACHINES") == 0 ? SUPPORT_VECTOR_MACHINE.toString() : (string.compareTo("NONNEGATIVE_MATRIX_FACTOR") == 0 ? NON_NEGATIVE_MATRIX_FACTORIZATION.toString() : "UNKNOWN:" + string)))))));
        return string2;
    }

    public static MiningAlgorithmType translateToODMServerMiningAlgorithm(MiningAlgorithms miningAlgorithms) {
        MiningAlgorithmType miningAlgorithmType = null;
        switch (miningAlgorithms) {
            case APRIORI: {
                miningAlgorithmType = MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
                break;
            }
            case DECISION_TREE: {
                miningAlgorithmType = MiningAlgorithmType.DECISION_TREE;
                break;
            }
            case GENERALIZED_LINEAR_MODEL: {
                miningAlgorithmType = MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
                break;
            }
            case KMEANS: {
                miningAlgorithmType = MiningAlgorithmType.KMEANS;
                break;
            }
            case NAIVE_BAYES: {
                miningAlgorithmType = MiningAlgorithmType.NAIVE_BAYES;
                break;
            }
            case NON_NEGATIVE_MATRIX_FACTORIZATION: {
                miningAlgorithmType = MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
                break;
            }
            case OCLUSTER: {
                miningAlgorithmType = MiningAlgorithmType.O_CLUSTER;
                break;
            }
            case SUPPORT_VECTOR_MACHINE: {
                miningAlgorithmType = MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
                break;
            }
            default: {
                assert (false) : "Invalid Algorithm Type";
                break;
            }
        }
        return miningAlgorithmType;
    }

    static {
        $VALUES = new MiningAlgorithms[]{APRIORI, DECISION_TREE, GENERALIZED_LINEAR_MODEL, KMEANS, NAIVE_BAYES, NON_NEGATIVE_MATRIX_FACTORIZATION, OCLUSTER, SUPPORT_VECTOR_MACHINE};
        stringToEnum = new HashMap<String, MiningAlgorithms>();
        for (MiningAlgorithms miningAlgorithms : MiningAlgorithms.values()) {
            stringToEnum.put(miningAlgorithms.toString(), miningAlgorithms);
        }
    }
}

