/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARItemSetsSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARItemSetsViewerState;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class ItemSetsFilterSetting {
    private Double _minSupport;
    private int _maxItemSetLength;
    private int _fetchSize;
    private boolean bUseFilterSpec = false;
    private Vector<SortSpec> _sortSpecs;
    private ARItemSetsViewerState _viewerState;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private ARItemSetsSettings _arItemSetsFilterSettings = ARItemSetsSettings.getInstance((PropertyStorage)_p);

    public ItemSetsFilterSetting() throws Exception {
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeARModel();
        this._minSupport = new Double(this._arItemSetsFilterSettings.getMinimumSupport());
        this._maxItemSetLength = this._arItemSetsFilterSettings.getMaximumItems();
        this._sortSpecs = new Vector();
        this._sortSpecs.add(new SortSpec("SUPPORT", SortSpec.SORT_DECENDING, true));
        this._sortSpecs.add(new SortSpec("NUMBER_OF_ITEMS", SortSpec.SORT_DECENDING, true));
        this._sortSpecs.add(new SortSpec("ITEMSET_ID", SortSpec.SORT_ASCENDING, true));
    }

    public ItemSetsFilterSetting(ARItemSetsViewerState aRItemSetsViewerState) throws Exception {
        this._viewerState = aRItemSetsViewerState;
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeARModel();
        this._minSupport = new Double(this._arItemSetsFilterSettings.getMinimumSupport());
        this._maxItemSetLength = this._arItemSetsFilterSettings.getMaximumItems();
        this._sortSpecs = new Vector();
        this._sortSpecs.add(new SortSpec("SUPPORT", SortSpec.SORT_DECENDING, true));
        this._sortSpecs.add(new SortSpec("NUMBER_OF_ITEMS", SortSpec.SORT_DECENDING, true));
        this._sortSpecs.add(new SortSpec("ITEMSET_ID", SortSpec.SORT_ASCENDING, true));
    }

    public ItemSetsFilterSetting(int n, Double d, int n2, Vector<SortSpec> vector) throws Exception {
        this._fetchSize = n;
        this._minSupport = d;
        this._maxItemSetLength = n2;
        this._sortSpecs = vector;
    }

    public boolean isFirstSortColumnSupport() {
        SortSpec sortSpec = this._sortSpecs.get(0);
        return sortSpec.getAttributeName().equalsIgnoreCase("SUPPORT");
    }

    public int getFetchSize() {
        return this._fetchSize;
    }

    public void setFetchSize(int n) {
        this._fetchSize = n;
    }

    public Vector<SortSpec> getSortSpecification() {
        return this._sortSpecs;
    }

    public void setSortSpecification(Vector<SortSpec> vector) {
        this._sortSpecs = vector;
    }

    public ARItemSetsViewerState getViewerState() {
        return this._viewerState;
    }

    private Vector<SortSpec> getIsUsedSortSpecItems() {
        Iterator<SortSpec> iterator = this._sortSpecs.iterator();
        Vector<SortSpec> vector = new Vector<SortSpec>();
        SortSpec sortSpec = null;
        while (iterator.hasNext()) {
            sortSpec = iterator.next();
            if (!sortSpec.isUseIt()) continue;
            vector.add(sortSpec);
        }
        return vector;
    }

    public String getSortString() {
        Vector<SortSpec> vector = this.getIsUsedSortSpecItems();
        Iterator<SortSpec> iterator = vector.iterator();
        SortSpec sortSpec = null;
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            sortSpec = iterator.next();
            if (iterator.hasNext()) {
                stringBuffer.append(sortSpec.getSortSQLString() + ",");
                continue;
            }
            stringBuffer.append(sortSpec.getSortSQLString() + " ");
        }
        return stringBuffer.toString();
    }

    public void setMaxItemSetLength(int n) {
        this._maxItemSetLength = n;
    }

    public int getMaxItemSetLength() {
        return this._maxItemSetLength;
    }

    public void setMinSupport(Double d) {
        this._minSupport = d;
    }

    public Double getMinSupport() {
        return this._minSupport;
    }

    public void setUseFilterSpecification(boolean bl) {
        this.bUseFilterSpec = bl;
    }

    public boolean isUseFilterSpecification() {
        return this.bUseFilterSpec;
    }
}

