/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmItemset;
import oracle.dmt.dataminer.server.model.Item;
import oracle.dmt.dataminer.server.model.RuleContentOption;

public class ItemSet {
    private Integer _itemsets_id;
    private Vector<Item> _items;
    private Double _support;
    private Integer _number_of_items;
    private static final String COMMA = ", ";
    private static final String BROWSER_NEXT_LINE = "<BR>";

    public ItemSet() {
        this._itemsets_id = new Integer(0);
        this._items = new Vector();
        this._support = new Double(0.0);
        this._number_of_items = new Integer(0);
    }

    public ItemSet(Integer n, Vector<Item> vector, Double d, Integer n2) {
        this._itemsets_id = n;
        this._items = vector;
        this._support = d;
        this._number_of_items = n2;
    }

    public ItemSet(Integer n, Item item, Double d, Integer n2) {
        this._itemsets_id = n;
        this._items = new Vector();
        this._items.add(item);
        this._support = d;
        this._number_of_items = n2;
    }

    public ItemSet(DmItemset dmItemset) throws Exception {
        this._itemsets_id = dmItemset.getItemsetId();
        this._items = Item.createItemsFromDmItems(dmItemset.getItems());
        this._support = new Double(dmItemset.getSupport().doubleValue());
        this._number_of_items = new Integer(dmItemset.getNumberOfItems().intValue());
    }

    public Integer getItemsets_id() {
        return this._itemsets_id;
    }

    public Vector<Item> getItems() {
        return this._items;
    }

    public Double getSupport() {
        return this._support;
    }

    public Integer getNumber_of_items() {
        return this._number_of_items;
    }

    public String getItemSetString() {
        return this.getItemSetString(RuleContentOption.NAME_SUBNAME_VALUE, false);
    }

    public String getItemSetString(RuleContentOption ruleContentOption, Boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Item> iterator = this._items.iterator();
        while (iterator.hasNext()) {
            Item item = iterator.next();
            stringBuffer.append(item.getItemDetail(ruleContentOption));
            if (!iterator.hasNext()) continue;
            if (bl.booleanValue()) {
                stringBuffer.append(", <BR>");
                continue;
            }
            stringBuffer.append(COMMA);
        }
        return stringBuffer.toString();
    }

    public String getItemSetStringOld() {
        String string = " = ";
        String string2 = COMMA;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Item> iterator = this._items.iterator();
        while (iterator.hasNext()) {
            Item item = iterator.next();
            stringBuffer.append(item.getFullAttributeName() + string + item.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

