/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.server.model.FilterSetting;
import oracle.dmt.dataminer.server.model.GLMCoefficientRowData;
import oracle.dmt.dataminer.server.model.GLMModelDetails;
import oracle.dmt.dataminer.server.model.GLMModelDetailsRowData;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class GLMModelDetailsImpl
implements GLMModelDetails {
    public static final String CLASSIFICATION = "CLASSIFICATION";
    public static final String REGRESSION = "REGRESSION";
    static String PROPENSITY_TARGET_ONE = "propensity_target_one";
    static String PROPENSITY_TARGET_TWO = "propensity_target_two";
    static final String QRY_CLASSIFICATION_COEFFICIENTS = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT * FROM ( \n SELECT NVL2(attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n      attribute_name \"attribute_name\", attribute_value \"attribute_value\", coefficient \"coefficient\", \n      STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT, \n       LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT \n FROM  \t (SELECT class, attribute_name, attribute_subname, attribute_value,\n \t         STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT, \n \t         LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT, \n \t         <coefficient_value> \n \t FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) \n \t WHERE class = :target_value_param \n \t <and1> <and2> <and3> ) r )\n \t <where_condition> \t) <order> \n \t) <rownum>  \n";
    static final String QRY_REGRESSION_COEFFICIENTS = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT * FROM ( \n SELECT NVL2(attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n      attribute_name \"attribute_name\", attribute_value \"attribute_value\", coefficient \"coefficient\", \n      STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT, \n       LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT \n FROM  \t (SELECT class, attribute_name, attribute_subname, attribute_value,\n \t         STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT, \n \t         LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT, \n \t         <coefficient_value> \n \t FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) \n \t <where_key_word>  \t <and2> <and3> ) r )\n \t <where_condition> \t) <order> \n \t) <rownum>  \n";
    static final String QRY_CLASSIFICATION_COEFFICIENTS_ALL = "SELECT * from (\nSELECT * from (\nSELECT \n<select_stmt>\n\tfrom (  SELECT NVL2(attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n      attribute_name \"attribute_name\", attribute_value \"attribute_value\", class \n FROM  \t (SELECT class, attribute_name, attribute_subname, attribute_value \n \t FROM TABLE(dbms_data_mining.get_model_details_glm(<model_name>)) \n<target_condition>) ) <name_filter_condition><group_by> \n) <order> \n \t) <rownum>  \n";
    static final String QRY_ALL_PROPENSITIES = "SELECT <COUNT_ONLY> FROM (\nSELECT * FROM (\n  SELECT \"target\",\n       NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n       attribute_name  \"attribute_name\", \n        \"attribute_value\", \n       case when (c1 is not null) AND (c2 is not null) AND (c1 > c2) then c1 \n             when (c2 is null) then c1 \n             else null \n       end \"propensity_target_one\",\n       case when (c2 is not null) AND (c1 is not null) AND (c2 > c1) then c2 \n             when (c1 is null) then c2 \n             else null \n       end \"propensity_target_two\", \n       ( <ABSOLUTE_VALUE>( nvl(c1, 0) ) +  <ABSOLUTE_VALUE>(nvl(c2,0)) ) \"propensity_target\"\n  FROM (\n    SELECT t.class \"target_attribute_value\", t.class \"target\", \n           t.attribute_name, t.attribute_subname, t.attribute_value \"attribute_value\", \n           t.coefficient \"coefficient\" \n   FROM \n     TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) t \n   <where_clause> \n  )\n  pivot(max(\"coefficient\") FOR \"target_attribute_value\" IN (<target_value_one> c1, <target_value_two> c2 ) )  where c1 is not null or c2 is not null \n) <where_clause_like> \n <order> \n) <rownum>  \n";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param))  \n   WHERE class IN(<target_values>)  ";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param))";
    static String QUERY_MIN_MAX = "WITH base_query AS\n  (SELECT attribute_name, nvl(t.std_coefficient, t.coefficient) coefficient\n  FROM TABLE(dbms_data_mining.get_model_details_glm(:model_name_param)) t)\nSELECT MIN(coefficient) minimum_coefficient, MAX(coefficient) maximum_coefficient\nFROM base_query\nWHERE attribute_name is not null";

    public GLMModelDetailsImpl(String string) {
        assert (string.equalsIgnoreCase(CLASSIFICATION) || string.equalsIgnoreCase(REGRESSION)) : "Invalid GLM model type";
    }

    private Vector<GLMCoefficientRowData> invokeCoefficientQuery(Connection connection, String string) throws Exception {
        Vector<GLMCoefficientRowData> vector = new Vector<GLMCoefficientRowData>();
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.stmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string);
            Double d = null;
            Double d2 = null;
            Double d3 = null;
            Double d4 = null;
            Double d5 = null;
            Double d6 = null;
            Double d7 = null;
            Double d8 = null;
            Double d9 = null;
            while (sQLHelper.rs.next()) {
                String string2;
                String string3 = sQLHelper.rs.getString("attribute_name_subname");
                if (string3 == null) {
                    string3 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string2 = sQLHelper.rs.getString("attribute_value")) == null) {
                    string2 = "";
                }
                Double d10 = sQLHelper.rs.getDouble("coefficient");
                d = sQLHelper.rs.getDouble("STD_ERROR");
                d2 = sQLHelper.rs.getDouble("TEST_STATISTIC");
                d3 = sQLHelper.rs.getDouble("P_VALUE");
                d4 = sQLHelper.rs.getDouble("STD_COEFFICIENT");
                d5 = sQLHelper.rs.getDouble("LOWER_COEFF_LIMIT");
                d6 = sQLHelper.rs.getDouble("UPPER_COEFF_LIMIT");
                d7 = sQLHelper.rs.getDouble("EXP_COEFFICIENT");
                d8 = sQLHelper.rs.getDouble("EXP_LOWER_COEFF_LIMIT");
                d9 = sQLHelper.rs.getDouble("EXP_UPPER_COEFF_LIMIT");
                GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(string3, string2, d10, d, d2, d3, d4, d5, d6, d7, d8, d9);
                vector.add(gLMCoefficientRowData);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    private Vector<GLMCoefficientRowData> invokeCoefficientQuery(SQLHelper sQLHelper) throws Exception {
        Vector<GLMCoefficientRowData> vector = new Vector<GLMCoefficientRowData>();
        try {
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            Double d = null;
            Double d2 = null;
            Double d3 = null;
            Double d4 = null;
            Double d5 = null;
            Double d6 = null;
            Double d7 = null;
            Double d8 = null;
            Double d9 = null;
            while (sQLHelper.rs.next()) {
                String string;
                String string2 = sQLHelper.rs.getString("attribute_name_subname");
                if (string2 == null) {
                    string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string = sQLHelper.rs.getString("attribute_value")) == null) {
                    string = "";
                }
                Double d10 = sQLHelper.rs.getDouble("coefficient");
                d = sQLHelper.rs.getDouble("STD_ERROR");
                d2 = sQLHelper.rs.getDouble("TEST_STATISTIC");
                d3 = sQLHelper.rs.getDouble("P_VALUE");
                d4 = sQLHelper.rs.getDouble("STD_COEFFICIENT");
                d5 = sQLHelper.rs.getDouble("LOWER_COEFF_LIMIT");
                d6 = sQLHelper.rs.getDouble("UPPER_COEFF_LIMIT");
                d7 = sQLHelper.rs.getDouble("EXP_COEFFICIENT");
                d8 = sQLHelper.rs.getDouble("EXP_LOWER_COEFF_LIMIT");
                d9 = sQLHelper.rs.getDouble("EXP_UPPER_COEFF_LIMIT");
                GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(string2, string, d10, d, d2, d3, d4, d5, d6, d7, d8, d9);
                vector.add(gLMCoefficientRowData);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    private void prepareCoefficientSQL(Connection connection, SQLHelper sQLHelper, String string, String string2, CoefficientFilterSetting coefficientFilterSetting, String string3, boolean bl) throws Exception {
        String string4 = QRY_CLASSIFICATION_COEFFICIENTS;
        String string5 = "";
        String string6 = string2;
        String string7 = string;
        String string8 = "";
        String string9 = "";
        String string10 = "";
        StringBuilder stringBuilder = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string11 = "";
        Object var18_19 = null;
        Object var19_20 = null;
        Boolean bl2 = null;
        Vector<CoefficientSortSpec> vector = null;
        Object var22_23 = null;
        if (coefficientFilterSetting != null) {
            bl2 = coefficientFilterSetting.getFilterAndSortByAbsolute();
            vector = coefficientFilterSetting.getSortSpecification();
            String string12 = string5 = bl ? "coefficient * -1 as coefficient" : "coefficient";
            if (coefficientFilterSetting.getFetchSize() > 0) {
                string11 = " where rownum <= :fetch_size_param";
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("attribute_name_subname") || coefficientSortSpec.getAttributeName().equals("attribute_value")) {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    } else if (coefficientFilterSetting.getFilterAndSortByAbsolute()) {
                        stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string4 = StringUtils.getReplacedString(string4, "<coefficient_value>", string5);
        string4 = StringUtils.getReplacedString(string4, "<and1>", string8);
        string4 = StringUtils.getReplacedString(string4, "<and2>", string9);
        string4 = StringUtils.getReplacedString(string4, "<and3>", string10);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string4 = StringUtils.getReplacedString(string4, "<where_condition>", stringBuilder.toString());
        string4 = StringUtils.getReplacedString(string4, "<order>", stringBuffer.toString());
        string4 = StringUtils.getReplacedString(string4, "<rownum>", string11);
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string4);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string7, string6, false));
        if (coefficientFilterSetting.getTargetValue() instanceof Number) {
            sQLHelper.opstmt.setBigDecimalAtName("target_value_param", BigDecimal.valueOf(Double.parseDouble(string3)));
        } else {
            sQLHelper.opstmt.setStringAtName("target_value_param", string3);
        }
        if (string11.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", coefficientFilterSetting.getFetchSize());
        }
    }

    private void prepareRegressionCoefficientSQL(Connection connection, SQLHelper sQLHelper, String string, String string2, CoefficientFilterSetting coefficientFilterSetting, boolean bl) throws Exception {
        String string3 = QRY_REGRESSION_COEFFICIENTS;
        String string4 = "";
        String string5 = string2;
        String string6 = string;
        String string7 = "";
        String string8 = "";
        StringBuilder stringBuilder = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string9 = "";
        Object var16_17 = null;
        Object var17_18 = null;
        Boolean bl2 = null;
        Vector<CoefficientSortSpec> vector = null;
        Object var20_21 = null;
        if (coefficientFilterSetting != null) {
            bl2 = coefficientFilterSetting.getFilterAndSortByAbsolute();
            vector = coefficientFilterSetting.getSortSpecification();
            String string10 = string4 = bl ? "coefficient * -1 as coefficient" : "coefficient";
            if (coefficientFilterSetting.getFetchSize() > 0) {
                string9 = " where rownum <= :fetch_size_param";
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("attribute_name_subname") || coefficientSortSpec.getAttributeName().equals("attribute_value")) {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    } else if (coefficientFilterSetting.getFilterAndSortByAbsolute()) {
                        stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string3 = StringUtils.getReplacedString(string3, "<coefficient_value>", string4);
        if (!string7.isEmpty() || !string8.isEmpty()) {
            if (string8.isEmpty()) {
                string3 = StringUtils.getReplacedString(string3, "<and2>", string7);
                string3 = StringUtils.getReplacedString(string3, "<and3>", string8);
            } else {
                string3 = StringUtils.getReplacedString(string3, "<and2>", string7);
                string3 = StringUtils.getReplacedString(string3, "<and3>", " AND " + string8);
            }
        } else {
            string3 = StringUtils.getReplacedString(string3, "<where_key_word>", "");
            string3 = StringUtils.getReplacedString(string3, "<and2>", "");
            string3 = StringUtils.getReplacedString(string3, "<and3>", "");
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string3 = StringUtils.getReplacedString(string3, "<where_condition>", stringBuilder.toString());
        string3 = StringUtils.getReplacedString(string3, "<order>", stringBuffer.toString());
        string3 = StringUtils.getReplacedString(string3, "<rownum>", string9);
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string6, string5, false));
        if (string9.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", coefficientFilterSetting.getFetchSize());
        }
    }

    @Override
    public Vector<GLMCoefficientRowData> getAllCoefficients(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Vector<GLMCoefficientRowData> vector = new Vector<GLMCoefficientRowData>();
        return vector;
    }

    public Vector<GLMCoefficientRowData> getRegressionCoefficients(Connection connection, String string, String string2, CoefficientFilterSetting coefficientFilterSetting) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        this.prepareRegressionCoefficientSQL(connection, sQLHelper, string, string2, coefficientFilterSetting, false);
        return this.invokeCoefficientQuery(sQLHelper);
    }

    @Override
    public Vector<GLMCoefficientRowData> getCoefficients(Connection connection, String string, String string2, CoefficientFilterSetting coefficientFilterSetting) throws Exception {
        Vector<Object> vector = new Vector();
        SQLHelper sQLHelper = new SQLHelper();
        if (coefficientFilterSetting.isBinaryClassModel()) {
            this.prepareCoefficientSQL(connection, sQLHelper, string, string2, coefficientFilterSetting, coefficientFilterSetting.getTargetValue().toString(), false);
            vector = this.invokeCoefficientQuery(sQLHelper);
            if (vector.size() == 0) {
                this.prepareCoefficientSQL(connection, sQLHelper, string, string2, coefficientFilterSetting, coefficientFilterSetting.getNonSelectedBinaryClassValue().toString(), true);
                vector = this.invokeCoefficientQuery(sQLHelper);
            }
        } else {
            this.prepareCoefficientSQL(connection, sQLHelper, string, string2, coefficientFilterSetting, coefficientFilterSetting.getTargetValue().toString(), false);
            vector = this.invokeCoefficientQuery(sQLHelper);
        }
        return vector;
    }

    public Integer getTotalCountCoefficients(Connection connection, String string, String string2) throws Exception {
        Integer n = null;
        Object var5_5 = null;
        return n;
    }

    public Integer getTotalCountCoefficients(Connection connection, String string, String string2, List<Object> list, FilterSetting filterSetting) throws Exception {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        Integer n = null;
        Object var7_7 = null;
        return n;
    }

    private void prepareTotalCountCoefficientsClassificationQuery(Connection connection, SQLHelper sQLHelper, String string, String string2, List<Object> list) throws Exception {
        String string3 = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        boolean bl = list.get(0) instanceof String;
        String string4 = "";
        boolean bl2 = true;
        int n = 0;
        for (Object object : list) {
            ++n;
            if (bl2) {
                bl2 = false;
            } else {
                string4 = string4 + ",";
            }
            string4 = string4 + ":target_value_" + n;
            hashMap.put(object, n);
        }
        string3 = StringUtils.getReplacedString(string3, "<target_values>", string4);
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
        if (bl) {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string5 = "target_value_" + ((Integer)entry.getValue()).toString();
                String string6 = entry.getKey().toString();
                sQLHelper.opstmt.setStringAtName(string5, string6);
            }
        } else {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string7 = "target_value_" + ((Integer)entry.getValue()).toString();
                BigDecimal bigDecimal = (BigDecimal)entry.getKey();
                sQLHelper.opstmt.setBigDecimalAtName(string7, bigDecimal);
            }
        }
    }

    private void prepareTotalCountCoefficientsRegressionQuery(Connection connection, SQLHelper sQLHelper, String string, String string2) throws Exception {
        String string3 = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION;
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
    }

    private Integer invokeTotalCountCoefficientsQuery(Connection connection, String string) throws Exception {
        Integer n = new Integer(0);
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string);
            if (sQLHelper.rs.next()) {
                n = new Integer(sQLHelper.rs.getInt("TOTAL_COEFFICIENTS"));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return n;
    }

    public HashMap getCoefficientStatistics(Connection connection, String string, String string2, List<Object> list, FilterSetting filterSetting) throws Exception {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        HashMap hashMap = null;
        SQLHelper sQLHelper = new SQLHelper();
        if (filterSetting.isBinaryClassModel()) {
            this.prepareTotalCountCoefficientsClassificationQuery(connection, sQLHelper, string, string2, list);
            hashMap = this.invokeCoefficientsStatisticsQuery(sQLHelper);
            Integer n = (Integer)hashMap.get("TOTAL_COEFFICIENTS");
            if (n == 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(filterSetting.getNonSelectedBinaryClassValue());
                this.prepareTotalCountCoefficientsClassificationQuery(connection, sQLHelper, string, string2, arrayList);
                hashMap = this.invokeCoefficientsStatisticsQuery(sQLHelper);
            }
        } else {
            this.prepareTotalCountCoefficientsClassificationQuery(connection, sQLHelper, string, string2, list);
            hashMap = this.invokeCoefficientsStatisticsQuery(sQLHelper);
        }
        return hashMap;
    }

    public HashMap getCoefficientStatistics(Connection connection, String string, String string2) throws Exception {
        HashMap hashMap = null;
        SQLHelper sQLHelper = new SQLHelper();
        this.prepareTotalCountCoefficientsRegressionQuery(connection, sQLHelper, string, string2);
        hashMap = this.invokeCoefficientsStatisticsQuery(sQLHelper);
        return hashMap;
    }

    private HashMap invokeCoefficientsStatisticsQuery(SQLHelper sQLHelper) throws Exception {
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        try {
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                Integer n = new Integer(sQLHelper.rs.getInt("TOTAL_COEFFICIENTS"));
                hashMap.put("TOTAL_COEFFICIENTS", n);
                Double d = new Double(sQLHelper.rs.getDouble("MAXIMUM_ABS_COEFFICIENT_VALUE"));
                hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", d);
            } else {
                hashMap.put("TOTAL_COEFFICIENTS", new Integer(0));
                hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", new Double(0.0));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    @Override
    public Vector<GLMModelDetailsRowData> getGlobalDetails(Connection connection, String string, String string2) throws Exception {
        Vector<GLMModelDetailsRowData> vector = new Vector<GLMModelDetailsRowData>();
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string3 = "SELECT \n     global_detail_name,\n     global_detail_value\n   FROM TABLE(dbms_data_mining.get_model_details_global(:model_name_param))\n   order by global_detail_name";
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                Integer n;
                String string4 = sQLHelper.rs.getString("global_detail_name");
                GLMModelDetailsRowData gLMModelDetailsRowData = new GLMModelDetailsRowData(string4);
                Constable constable = string4.equalsIgnoreCase("MODEL_CONVERGED") || string4.equalsIgnoreCase("VALID_COVARIANCE_MATRIX") ? (Comparable<Boolean>)((n = Integer.valueOf(sQLHelper.rs.getInt("global_detail_value"))) == 0 ? Boolean.FALSE : Boolean.TRUE) : (Comparable<Boolean>)Double.valueOf(sQLHelper.rs.getDouble("global_detail_value"));
                gLMModelDetailsRowData.setValue(constable);
                vector.add(gLMModelDetailsRowData);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double[] getMinMaxValue(Connection connection, String string, String string2) {
        SQLHelper sQLHelper = new SQLHelper();
        Double[] doubleArray = null;
        String string3 = QUERY_MIN_MAX;
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                doubleArray = new Double[]{sQLHelper.rs.getDouble("minimum_coefficient"), sQLHelper.rs.getDouble("maximum_coefficient")};
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            doubleArray = null;
        }
        finally {
            sQLHelper.close();
        }
        return doubleArray;
    }

    public Vector<CoefficientRowData> getPropensities(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        SQLHelper sQLHelper = new SQLHelper();
        if (filterSetting.isBinaryClassModel()) {
            sQLHelper = this.prepareBinaryPropensitiesSQL(connection, sQLHelper, string, string2, filterSetting, false);
            vector = this.invokeCompareQuery(sQLHelper);
        }
        return vector;
    }

    public Integer getTotalCountPropensities(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Integer n = null;
        SQLHelper sQLHelper = new SQLHelper();
        if (filterSetting.isBinaryClassModel()) {
            sQLHelper = this.prepareBinaryPropensitiesSQL(connection, sQLHelper, string, string2, filterSetting, true);
            n = this.invokeCompareCountQuery(sQLHelper);
        }
        return n;
    }

    private SQLHelper prepareBinaryPropensitiesSQL(Connection connection, SQLHelper sQLHelper, String string, String string2, FilterSetting filterSetting, boolean bl) throws Exception {
        boolean bl2;
        String string3 = QRY_ALL_PROPENSITIES;
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        String string4 = string;
        String string5 = string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder3 = new StringBuilder();
        Object var14_15 = null;
        Object var15_16 = null;
        Boolean bl3 = null;
        Vector<CoefficientSortSpec> vector = null;
        Object var18_19 = null;
        if (filterSetting != null) {
            bl3 = filterSetting.getFilterAndSortByAbsolute();
            vector = filterSetting.getSortSpecification();
            if (filterSetting.getFetchSize() > 0) {
                stringBuilder3.append(" WHERE rownum <= :fetch_size_param ");
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        if (bl2 = filterSetting.getTargetValue() instanceof Number) {
            string3 = StringUtils.getReplacedString(string3, "<target_value_one>", filterSetting.getTargetValue().toString());
            string3 = StringUtils.getReplacedString(string3, "<target_value_two>", filterSetting.getSecondTargetValue().toString());
        } else {
            string3 = StringUtils.getReplacedString(string3, "<target_value_one>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getTargetValue().toString()) + "'");
            string3 = StringUtils.getReplacedString(string3, "<target_value_two>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getSecondTargetValue().toString()) + "'");
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(" ");
        }
        string3 = StringUtils.getReplacedString(string3, "<where_clause>", stringBuilder.toString());
        string3 = StringUtils.getReplacedString(string3, "<where_clause_like>", stringBuilder2 != null ? stringBuilder2.toString() : "");
        string3 = StringUtils.getReplacedString(string3, "<order>", stringBuffer.toString());
        string3 = filterSetting.getFilterAndSortByAbsolute() ? StringUtils.getReplacedString(string3, "<ABSOLUTE_VALUE>", "ABS") : StringUtils.getReplacedString(string3, "<ABSOLUTE_VALUE>", " ");
        if (bl) {
            string3 = StringUtils.getReplacedString(string3, "<COUNT_ONLY>", "COUNT(*) TOTAL_PROPENSITIES");
            string3 = StringUtils.getReplacedString(string3, "<rownum>", " ");
        } else {
            string3 = StringUtils.getReplacedString(string3, "<COUNT_ONLY>", "*");
            string3 = StringUtils.getReplacedString(string3, "<rownum>", stringBuilder3.toString());
        }
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string4, string5, false));
        if (!bl && stringBuilder3.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        return sQLHelper;
    }

    private Vector<CoefficientRowData> invokeCompareQuery(SQLHelper sQLHelper) throws Exception {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        try {
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string;
                String string2 = sQLHelper.rs.getString("attribute_name_subname");
                if (string2 == null) {
                    string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string = sQLHelper.rs.getString("attribute_value")) == null) {
                    string = "";
                }
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(PROPENSITY_TARGET_ONE);
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal(PROPENSITY_TARGET_TWO);
                if (bigDecimal == null && bigDecimal2 != null) {
                    bigDecimal = new BigDecimal(-1.0 * bigDecimal2.doubleValue());
                } else if (bigDecimal2 == null && bigDecimal != null) {
                    bigDecimal2 = new BigDecimal(-1.0 * bigDecimal.doubleValue());
                }
                CoefficientRowData coefficientRowData = new CoefficientRowData(string2, string, bigDecimal != null ? Double.valueOf(bigDecimal.doubleValue()) : null, bigDecimal2 != null ? Double.valueOf(bigDecimal2.doubleValue()) : null);
                vector.add(coefficientRowData);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    private Integer invokeCompareCountQuery(SQLHelper sQLHelper) throws Exception {
        Integer n = null;
        try {
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            sQLHelper.rs.next();
            n = new Integer(sQLHelper.rs.getInt("TOTAL_PROPENSITIES"));
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return n;
    }
}

