/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.server.model.CoefficientBaseData;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.server.model.CoefficientWhereSpec;
import oracle.dmt.dataminer.server.model.FilterSetting;
import oracle.dmt.dataminer.server.model.ModelLrb;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class CoefficientFilterSetting
implements FilterSetting {
    private BigDecimal _minCoefficient;
    private BigDecimal _maxCoefficient;
    private int _fetchSize;
    private boolean _filterAndSortByAbsolute;
    private Vector<CoefficientSortSpec> _sortSpecs;
    private Vector<CoefficientWhereSpec> _whereSpecs;
    private Object _targetValue;
    private Object _secondTargetValue;
    private CoefViewerState _viewerState;
    private boolean bUseFilterSpec = false;
    private Vector<CoefficientBaseData> _itemFilters;
    public static final double NB_MAX_PROBABILITY = 100.0;
    public static final double NB_MIN_PROBABILITY = 0.0;
    public static final double NB_PROBABILITY_STEP = 1.0;
    public static final double COEFFICIENT_STEP = 0.01;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private Vector<TargetPriorsPredictionSet> _targetValuePriors;

    public CoefficientFilterSetting() throws Exception {
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeOtherModels();
        this._minCoefficient = new BigDecimal(-1.0);
        this._maxCoefficient = new BigDecimal(1.0);
        this._filterAndSortByAbsolute = false;
        this._sortSpecs = new Vector();
        this._sortSpecs.add(new CoefficientSortSpec("coefficient", SortSpec.SORT_DECENDING, true));
        this._sortSpecs.add(new CoefficientSortSpec("attribute_name_subname", SortSpec.SORT_ASCENDING, true));
        this._sortSpecs.add(new CoefficientSortSpec("attribute_value", SortSpec.SORT_ASCENDING, true));
        this._targetValuePriors = null;
        this._whereSpecs = new Vector();
        this._whereSpecs.add(new CoefficientWhereSpec("attribute_name_subname", 1, "", false));
    }

    public CoefficientFilterSetting(CoefViewerState coefViewerState) throws Exception {
        this._viewerState = coefViewerState;
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeOtherModels();
        this._filterAndSortByAbsolute = false;
        this._sortSpecs = new Vector();
        if (this._viewerState.isSVM() || this._viewerState.isAnomaly()) {
            this._sortSpecs.add(new CoefficientSortSpec("coefficient", SortSpec.SORT_DECENDING, true));
            this._sortSpecs.add(new CoefficientSortSpec("attribute_name_subname", SortSpec.SORT_ASCENDING, true));
            this._sortSpecs.add(new CoefficientSortSpec("attribute_value", SortSpec.SORT_ASCENDING, true));
            this._minCoefficient = new BigDecimal(-1.0);
            this._maxCoefficient = new BigDecimal(1.0);
        } else if (this._viewerState.isGLM()) {
            this._sortSpecs.add(new CoefficientSortSpec("coefficient", SortSpec.SORT_DECENDING, true));
            this._sortSpecs.add(new CoefficientSortSpec("attribute_name_subname", SortSpec.SORT_ASCENDING, true));
            this._sortSpecs.add(new CoefficientSortSpec("attribute_value", SortSpec.SORT_ASCENDING, true));
            this._minCoefficient = new BigDecimal(-1000.0);
            this._maxCoefficient = new BigDecimal(1000.0);
        } else if (this._viewerState.isNB()) {
            this._sortSpecs.add(new CoefficientSortSpec("probability", SortSpec.SORT_DECENDING, true));
            this._sortSpecs.add(new CoefficientSortSpec("attribute_name_subname", SortSpec.SORT_ASCENDING, true));
            this._sortSpecs.add(new CoefficientSortSpec("attribute_value", SortSpec.SORT_ASCENDING, true));
            this._minCoefficient = new BigDecimal(0.0);
            this._maxCoefficient = new BigDecimal(100.0);
        } else if (this._viewerState.isNMF()) {
            this._sortSpecs.add(new CoefficientSortSpec("coefficient", SortSpec.SORT_DECENDING, true));
            this._sortSpecs.add(new CoefficientSortSpec("attribute_name_subname", SortSpec.SORT_ASCENDING, true));
            this._sortSpecs.add(new CoefficientSortSpec("attribute_value", SortSpec.SORT_ASCENDING, true));
            this._minCoefficient = new BigDecimal(0.0);
            this._maxCoefficient = new BigDecimal(1.0);
        } else assert (false) : "Filter Panel does not supported specified model type.";
        this._targetValuePriors = null;
        this._whereSpecs = new Vector();
        this._whereSpecs.add(new CoefficientWhereSpec("attribute_name_subname", 1, "", false));
    }

    public CoefficientFilterSetting(int n, BigDecimal bigDecimal, BigDecimal bigDecimal2, boolean bl, Vector<CoefficientSortSpec> vector, Vector<CoefficientWhereSpec> vector2, String string) throws Exception {
        this._fetchSize = n;
        this.setMinCoefficient(bigDecimal);
        this.setMaxCoefficient(bigDecimal2);
        this._filterAndSortByAbsolute = bl;
        this._sortSpecs = vector;
        this._whereSpecs = vector2;
        this._targetValuePriors = null;
    }

    public void setMinCoefficient(BigDecimal bigDecimal) throws Exception {
        if (this._viewerState != null && this._viewerState.isNB() && (bigDecimal.doubleValue() < 0.0 || bigDecimal.doubleValue() > 100.0)) {
            throw new Exception(ModelLrb.get("MINIMUM_COEFFICIENT_RANGE_ERROR"));
        }
        this._minCoefficient = bigDecimal;
    }

    @Override
    public BigDecimal getMinCoefficient() {
        return this._minCoefficient;
    }

    public void setMaxCoefficient(BigDecimal bigDecimal) throws Exception {
        if (this._viewerState != null && this._viewerState.isNB() && (bigDecimal.doubleValue() < 0.0 || bigDecimal.doubleValue() > 100.0)) {
            throw new Exception(ModelLrb.get("MAXIMUM_COEFFICIENT_RANGE_ERROR"));
        }
        this._maxCoefficient = bigDecimal;
    }

    @Override
    public BigDecimal getMaxCoefficient() {
        return this._maxCoefficient;
    }

    @Override
    public boolean getFilterAndSortByAbsolute() {
        return this._filterAndSortByAbsolute;
    }

    public void setFilterByAbsolute(boolean bl) {
        this._filterAndSortByAbsolute = bl;
    }

    @Override
    public int getFetchSize() {
        return this._fetchSize;
    }

    public void setFetchSize(int n) {
        this._fetchSize = n;
    }

    @Override
    public Vector<CoefficientSortSpec> getSortSpecification() {
        return this._sortSpecs;
    }

    public void setSortSpecification(Vector<CoefficientSortSpec> vector) {
        this._sortSpecs = vector;
    }

    @Override
    public Vector<CoefficientWhereSpec> getWhereSpecification() {
        return this._whereSpecs;
    }

    public void setWhereSpecification(Vector<CoefficientWhereSpec> vector) {
        this._whereSpecs = vector;
    }

    public void setTargetValue(Object object) {
        this._targetValue = object;
    }

    @Override
    public Object getTargetValue() {
        return this._targetValue;
    }

    public void setTargetValuePriors(Vector<TargetPriorsPredictionSet> vector) {
        this._targetValuePriors = vector;
    }

    public Vector<TargetPriorsPredictionSet> getTargetValuePriors() {
        return this._targetValuePriors;
    }

    @Override
    public Object getNonSelectedBinaryClassValue() {
        if (this._targetValuePriors == null) {
            return null;
        }
        Object object = null;
        Object object2 = this.getTargetValue();
        for (TargetPriorsPredictionSet targetPriorsPredictionSet : this._targetValuePriors) {
            BigDecimal bigDecimal;
            Object object3 = targetPriorsPredictionSet.getPrediction();
            if (object2 instanceof Integer) {
                bigDecimal = new BigDecimal((Integer)object2);
                if (bigDecimal.equals(targetPriorsPredictionSet.getPrediction())) continue;
                object = targetPriorsPredictionSet.getPrediction();
                continue;
            }
            if (object2 instanceof Float) {
                bigDecimal = new BigDecimal(((Float)object2).doubleValue());
                if (bigDecimal.equals(targetPriorsPredictionSet.getPrediction())) continue;
                object = targetPriorsPredictionSet.getPrediction();
                continue;
            }
            if (object2 instanceof Double) {
                bigDecimal = new BigDecimal((Double)object2);
                if (bigDecimal.equals(targetPriorsPredictionSet.getPrediction())) continue;
                object = targetPriorsPredictionSet.getPrediction();
                continue;
            }
            if (object2.equals(object3)) continue;
            object = targetPriorsPredictionSet.getPrediction();
        }
        return object;
    }

    @Override
    public Object getAnomalyNonSelectedBinaryClassValue() {
        if (this._targetValuePriors == null) {
            return null;
        }
        Object object = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet : this._targetValuePriors) {
            if (this.getTargetValue().equals(targetPriorsPredictionSet.getPrediction())) continue;
            object = targetPriorsPredictionSet.getPrediction();
            break;
        }
        return object;
    }

    @Override
    public boolean isBinaryClassModel() {
        if (this._targetValuePriors == null) {
            return false;
        }
        return this._targetValuePriors.size() == 2;
    }

    public CoefViewerState getViewerState() {
        return this._viewerState;
    }

    public void setSecondTargetValue(Object object) {
        this._secondTargetValue = object;
    }

    @Override
    public Object getSecondTargetValue() {
        return this._secondTargetValue;
    }

    @Override
    public void setUseFilterSpecification(boolean bl) {
        this.bUseFilterSpec = bl;
    }

    @Override
    public boolean isUseFilterSpecification() {
        return this.bUseFilterSpec;
    }

    @Override
    public Vector<CoefficientBaseData> getItemFilters() {
        return this._itemFilters;
    }
}

