/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmCentroids;
import oracle.dmt.dataminer.generated.server.DmChildren;
import oracle.dmt.dataminer.generated.server.DmHistogramBin;
import oracle.dmt.dataminer.generated.server.DmHistograms;
import oracle.dmt.dataminer.generated.server.DmPredicates;
import oracle.dmt.dataminer.generated.server.DmRule;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.Clustering;
import oracle.dmt.dataminer.server.model.ClusteringDetailRow;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class ClusteringDetailsImpl {
    private static final String CLUSTER_DETAIL_QUERY_TOPN = "WITH first_query AS\n  (SELECT a.ID,\n    d.attribute_name,\n    d.attribute_subname,\n    d.attribute_confidence,\n    nvl2 (d.attribute_subname, d.attribute_name\n    || '.'\n    || d.attribute_subname, d.attribute_name) full_name\n   FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(:model_name,:cluster_id,:attribute,0,0,2<SUBNAME_PARAM>)) a,\n    TABLE(a.rule.ANTECEDENT) D\n  ),\n  antecedents_query AS\n  (SELECT id,\n    attribute_name,\n    attribute_subname,\n    attribute_confidence,\n    full_name\n  FROM first_query\n  ),\n  top_items_txn_query AS\n  (SELECT id,\n    attribute_name,\n    attribute_subname,\n    attribute_confidence,\n    full_name,\n    ROW_NUMBER () over (partition BY id order by attribute_confidence DESC) AS rank\n  FROM antecedents_query\n  GROUP BY id,\n    attribute_name,\n    attribute_subname,\n    attribute_confidence,\n    full_name\n  ),\n  top_items_txn_filtered AS\n  (SELECT * FROM top_items_txn_query WHERE rank <= :topN\n  ),\n  centroids_txn AS\n  (SELECT a.id,\n    c.*,\n    top_items_txn_filtered.attribute_confidence,\n    top_items_txn_filtered.rank\n    FROM \n    TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(:model_name,:cluster_id,:attribute,1,0,0<SUBNAME_PARAM>)) a,\n    TABLE (A.centroid) c,\n    top_items_txn_filtered\n  WHERE a.id = top_items_txn_filtered.id\n  AND nvl2 (c.attribute_subname, c.attribute_name\n    || '.'\n    || c.attribute_subname, c.attribute_name) = top_items_txn_filtered.full_name\n  ),\n  top_centroids_txn AS\n  (SELECT *\n  FROM\n    (SELECT id,\n      attribute_name,\n      attribute_subname,\n      attribute_confidence,\n      mean,\n      mode_value,\n      variance,\n      rank\n    FROM centroids_txn\n    )\n  ),\n  top_centroids AS\n  (SELECT id,\n    CAST (collect (DM_CENTROID (attribute_name, attribute_subname, mean, mode_value, variance)) AS DM_CENTROIDS) AS centroid\n  FROM top_centroids_txn\n  GROUP BY ID\n  )\nSELECT clusters.id,\n  clusters.cluster_id,\n  clusters.record_count,\n  clusters.parent,\n  clusters.tree_level,\n  clusters.dispersion,\n  clusters.split_predicate,\n  clusters.child,\n  top_centroids.centroid,\n  clusters.histogram,\n  clusters.rule\nFROM\n  TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(:model_name,:cluster_id,:attribute,0,:histogram,:rules<SUBNAME_PARAM>)) clusters,\n  top_centroids\nWHERE clusters.id = top_centroids.id\n";
    private static String CLUSTER_DETAILS_QUERY = "WITH dup_attributes AS\n  (SELECT a.id            ,\n    a.cluster_id          ,\n    a.rule.rule_id        ,\n    r.attribute_name      ,\n    r.attribute_subname   ,\n    r.attribute_support   ,\n    r.attribute_confidence,\n    NVL2(r.attribute_subname, r.attribute_name\n    || '.'\n    || r.attribute_subname, r.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS1>)a,\n    TABLE(a.rule.antecedent) r\n  ),\n  rule_attributes AS\n  ( SELECT DISTINCT * FROM dup_attributes d\n  ),\n  all_attributes AS\n  (SELECT b.attribute_name,\n    b.attribute_Subname   ,\n    NVL2(b.attribute_subname, b.attribute_name\n    || '.'\n    || b.attribute_subname, b.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS2>)a,\n     TABLE(a.centroid) b),\n  join_attributes AS\n    (SELECT a.attribute_name,\n      a.attribute_subname   ,\n      a.attribute_name_subname ,\n      b.attribute_support   ,\n      b.attribute_confidence\n       FROM all_attributes a,\n      rule_attributes b\n      WHERE a.attribute_name_subname = b.attribute_name_subname(+)\n      <ORDER_BY1>\n    ),\n    filtered_attributes AS\n    (SELECT * FROM join_attributes WHERE rownum <= <FETCH_SIZE>\n      <WHERE_CONFIDENCE> \n    ),\n    centroids AS\n    (SELECT b.attribute_name,\n      b.attribute_subname   ,\n      NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name) attribute_name_subname,  \n      b.mean                ,\n      b.mode_value          ,\n      b.variance            ,\n      CAST(MULTISET\n      (SELECT e.*\n         FROM TABLE(a.histogram)e\n        WHERE NVL2(e.attribute_subname, e.attribute_name\n        || '.'\n        || e.attribute_subname, e.attribute_name) = NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name)\n      ) AS DM_HISTOGRAMS) AS histogram\n       FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS3>)a,\n      TABLE(a.centroid) b\n    )\n   SELECT a.attribute_name                 ,\n    a.attribute_subname                    ,\n    a.attribute_name_subname AS attribute_name_subname, \n    nvl(a.attribute_support,0) attribute_support, \n    nvl(a.attribute_confidence,0)  attribute_confidence, \n    b.attribute_name    AS centroid_name   ,\n    b.attribute_subname AS centroid_subname, \n    b.attribute_name_subname AS centroid_name_subname, \n    b.mean                                 ,\n    b.mode_value                           ,\n    b.variance                             ,\n    b.histogram\n     FROM filtered_attributes a,\n    centroids b\n    WHERE a.attribute_name_subname = b.attribute_name_subname \n    <ORDER_BY2>\n";
    private static String KM_DBMS_API_1 = "GET_MODEL_DETAILS_KM(?,?,NULL,0,0,2,NULL)";
    private static String OC_DBMS_API_1 = "GET_MODEL_DETAILS_OC(?,?,NULL,0,0,2)";
    private static String KM_DBMS_API_2 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,0,0,NULL)";
    private static String OC_DBMS_API_2 = "GET_MODEL_DETAILS_OC(?,?,NULL,1,0,0)";
    private static String KM_DBMS_API_3 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,1,0,NULL)";
    private static String OC_DBMS_API_3 = "GET_MODEL_DETAILS_OC(?,?,NULL,1,1,0)";
    private static String CONFIDENCE_DBMS_API_RANGE = "AND attribute_confidence >= ?  AND attribute_confidence <= ?";
    private static String _compare_sql = "select aname, subname, \n  CASE WHEN mean_val1 IS NULL THEN mode_val1 ELSE TO_CHAR(mean_val1) END centroid1,\n  CASE WHEN mean_val2 IS NULL THEN mode_val2 ELSE TO_CHAR(mean_val2) END centroid2,\n  rnk,\n  sym_kld\nFROM (WITH\nnode1 AS (\n  SELECT t.record_count rec_cnt, histogram, centroid\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(?,?,NULL,1,1)) t),\nnode2 AS (\n  SELECT t. record_count rec_cnt, histogram, centroid\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(?,?,NULL,1,1)) t),\ncent1 AS (\n  SELECT c.attribute_name aname, \n         c.attribute_subname subname,\n         c.mean mean_val,\n         c.mode_value mode_val\n  FROM node1 t, TABLE(centroid) c),\ncent2 AS (\n  SELECT c.attribute_name aname, \n         c.attribute_subname subname,\n         c.mean mean_val,\n         c.mode_value mode_val\n  FROM node2 t, TABLE(centroid) c), \ncent AS (\n  SELECT nvl(c1.aname, c2.aname) aname,\n         nvl(c1.subname, c2.subname) subname,\n         nvl(c1.mean_val, 0)  mean_val1, \n         c1.mode_val mode_val1,\n         nvl(c2.mean_val, 0) mean_val2, \n         c2.mode_val mode_val2\n  FROM cent1 c1 full outer join cent2 c2\n    ON c1.aname = c2.aname AND \n       nvl(c1.subname, c1.aname) = nvl(c2.subname, c2.aname)),\nhist1 AS (\n  SELECT h.attribute_name aname,\n         h.attribute_subname subname,\n         h.bin_id bin_id,\n         h.count/t.rec_cnt prob\n  FROM node1 t, TABLE(t.histogram) h),\nhist2 AS (\n  SELECT h.attribute_name aname,\n       h.attribute_subname subname,\n       h.bin_id bin_id,\n       h.count/rec_cnt prob\n  FROM node2 t, TABLE(t.histogram) h),\nhist_av AS(\n  SELECT nvl(h1.aname, h2.aname) aname,\n          nvl(h1.subname, h2.subname) subname, \n          nvl(h1.bin_id, h2.bin_id) bin_id,\n          (nvl(h1.prob,0) + nvl(h2.prob,0))/2 prob \n  FROM hist1 h1 full outer join hist2 h2 \n      ON h1.aname = h2.aname AND\n         nvl(h1.subname,h1.aname)=nvl(h2.subname, h2.aname) AND \n         h1.bin_id = h2.bin_id),\nkld AS (\n  SELECT aname, subname, sum(kld)/2 sym_kld FROM \n  (SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist1 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname\n  UNION all\n  SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist2 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname)\n  GROUP BY aname, subname)\nSELECT k.aname, k.subname, \n  CASE WHEN c.mode_val1 IS NULL THEN c.mean_val1 ELSE NULL END mean_val1,\n  c.mode_val1, \n  CASE WHEN c.mode_val2 IS NULL THEN c.mean_val2 ELSE NULL END mean_val2,    \n  c.mode_val2, \n  rank() over (order by sym_kld desc) rnk, sym_kld \nFROM kld k, cent c\nWHERE k.aname=c.aname \n    AND nvl(k.subname, k.aname)=nvl(c.subname, c.aname) \n ORDER BY rnk)";
    private static String _DIVERGENCE_SQL = "SELECT ATTRIBUTE_NAME, ATTRIBUTE_SUBNAME, rnk, sym_kld FROM (\nWITH\nnode1 AS (\n  SELECT t.record_count rec_cnt, histogram\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>) t),\nnode2 AS (\n  SELECT t. record_count rec_cnt, histogram\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>) t),\nhist1 AS (\n  SELECT h.attribute_name aname,\n         h.attribute_subname subname,\n         h.bin_id bin_id,\n         h.count/t.rec_cnt prob\n  FROM node1 t, TABLE(t.histogram) h),\nhist2 AS (\n  SELECT h.attribute_name aname,\n       h.attribute_subname subname,\n       h.bin_id bin_id,\n       h.count/rec_cnt prob\n  FROM node2 t, TABLE(t.histogram) h),\nhist_av AS(\n  SELECT nvl(h1.aname, h2.aname) aname,\n          nvl(h1.subname, h2.subname) subname, \n          nvl(h1.bin_id, h2.bin_id) bin_id,\n          (nvl(h1.prob,0) + nvl(h2.prob,0))/2 prob \n  FROM hist1 h1 full outer join hist2 h2 \n      ON h1.aname = h2.aname AND\n         nvl(h1.subname,h1.aname)=nvl(h2.subname, h2.aname) AND \n         h1.bin_id = h2.bin_id),\nkld AS (\n  SELECT aname, subname, sum(kld)/2 sym_kld FROM \n  (SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist1 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname\n  UNION all\n  SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist2 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname)\n  GROUP BY aname, subname)\nSELECT k.aname ATTRIBUTE_NAME, k.subname ATTRIBUTE_SUBNAME,  rank() OVER (ORDER BY sym_kld DESC) rnk, sym_kld FROM kld k\nORDER BY rnk) where rownum <= ?";
    final String KM_API = "GET_MODEL_DETAILS_KM(?,?,NULL, 0, 1, 0)";
    final String OC_API = "GET_MODEL_DETAILS_OC(?,?,NULL, 0, 1, 0)";
    static String ALL_CLUSTERS_ATTRIBUTE_COUNT_QUERY_2 = " with all_attributes AS\n  (SELECT a.id ID, a.cluster_id CLUSTER_ID, a.parent CLUSTER_PARENT, ch.id CHILD_ID \n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>)a,\n     TABLE(a.centroid) b, TABLE(A.CHILD) ch)\n select id, cluster_id, cluster_parent, child_id, count(*) TOTAL_ATTRIBUTE_COUNT from all_attributes\n group by id, cluster_id, cluster_parent, child_id\n order by id";
    private static String _query_kmeans = "WITH \n   all_data AS (\n SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_KM (:model_name, :cluster_id1, null, 1, 1, 0, NULL)) t, TABLE(t.centroid) c\nUNION ALL\n  SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_KM (:model_name, :cluster_id2, null, 1, 1, 0, NULL )) t, TABLE(t.centroid) c\n),\ncent AS (SELECT cluster_id, aname, subname, mean_val, mode_val, histogram  FROM all_data )\n  SELECT cluster_id, NVL2(subname, aname || '.' || subname, aname) attribute_name_subname,\n     CASE WHEN mean_val IS NULL THEN mode_val ELSE TO_CHAR(mean_val) END centroid,\n     histogram from cent \nWHERE NVL2(subname, aname || '.' || subname, aname) IN (\n <list_of_columns>)\n";
    private static String _o_cluster = "WITH \n   all_data AS (\n SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_OC (:model_name, :cluster_id1, null, 1, 1, 0)) t, TABLE(t.centroid) c\nUNION ALL\n  SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_OC (:model_name, :cluster_id2, null, 1, 1, 0)) t, TABLE(t.centroid) c\n),\ncent AS (SELECT cluster_id, aname, subname, mean_val, mode_val, histogram  FROM all_data )\n  SELECT cluster_id, NVL2(subname, aname || '.' || subname, aname) attribute_name_subname,\n     CASE WHEN mean_val IS NULL THEN mode_val ELSE TO_CHAR(mean_val) END centroid,\n     histogram from cent \nWHERE NVL2(subname, aname || '.' || subname, aname) IN (\n <list_of_columns>)\n";

    public Vector<ClusteringDetailRow> getClusterAllDetailsKMTopN(Connection connection, String string, String string2, boolean bl, Clustering.RuleResultType ruleResultType, int n) throws Exception {
        return this.getClusterAllDetailsTopN(connection, string, string2, bl, ruleResultType, n, AlgorithmType.KMEANS);
    }

    public Vector<ClusteringDetailRow> getClusterAllDetailsOCTopN(Connection connection, String string, String string2, boolean bl, Clustering.RuleResultType ruleResultType, int n) throws Exception {
        return this.getClusterAllDetailsTopN(connection, string, string2, bl, ruleResultType, n, AlgorithmType.OCLUSTER);
    }

    public List<CompareClustersModelRow> getDivergenceKM(Connection connection, String string, String string2, Integer n, String string3, Integer n2, String string4, int n3) throws Exception {
        return this.getDivergence(connection, string, string2, n, string3, n2, string4, n3, AlgorithmType.KMEANS);
    }

    public List<CompareClustersModelRow> getDivergenceOC(Connection connection, String string, String string2, Integer n, String string3, Integer n2, String string4, int n3) throws Exception {
        return this.getDivergence(connection, string, string2, n, string3, n2, string4, n3, AlgorithmType.OCLUSTER);
    }

    public void getCenteroidAndHistogramKM(Connection connection, String string, String string2, int n, int n2, List<CompareClustersModelRow> list) throws Exception {
        this.getCenteroidAndHistogram(connection, string, string2, n, n2, list, AlgorithmType.KMEANS);
    }

    public void getCenteroidAndHistogramOC(Connection connection, String string, String string2, int n, int n2, List<CompareClustersModelRow> list) throws Exception {
        this.getCenteroidAndHistogram(connection, string, string2, n, n2, list, AlgorithmType.OCLUSTER);
    }

    private Vector<ClusteringDetailRow> getClusterAllDetailsTopN(Connection connection, String string, String string2, boolean bl, Clustering.RuleResultType ruleResultType, int n, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = CLUSTER_DETAIL_QUERY_TOPN;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<ClusteringDetailRow> vector = new Vector<ClusteringDetailRow>();
        try {
            if (algorithmType == AlgorithmType.KMEANS) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM");
                string3 = StringUtils.getReplacedString(string3, "<SUBNAME_PARAM>", ",:attribute_subname");
            } else {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC");
                string3 = StringUtils.getReplacedString(string3, "<SUBNAME_PARAM>", "");
            }
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setNullAtName("cluster_id", 4);
            sQLHelper.opstmt.setNullAtName("attribute", 12);
            if (algorithmType == AlgorithmType.KMEANS) {
                sQLHelper.opstmt.setNullAtName("attribute_subname", 12);
            }
            sQLHelper.opstmt.setIntAtName("histogram", bl ? 1 : 0);
            sQLHelper.opstmt.setIntAtName("rules", ruleResultType.getValue());
            sQLHelper.opstmt.setIntAtName("topN", n);
            sQLHelper.opstmt.execute();
            ClusteringDetailRow clusteringDetailRow = null;
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                Integer n2 = new Integer(sQLHelper.rs.getInt("ID"));
                String string4 = sQLHelper.rs.getString("CLUSTER_ID");
                Integer n3 = new Integer(sQLHelper.rs.getInt("RECORD_COUNT"));
                Integer n4 = new Integer(sQLHelper.rs.getInt("PARENT"));
                Integer n5 = new Integer(sQLHelper.rs.getInt("TREE_LEVEL"));
                Double d = new Double(sQLHelper.rs.getDouble("DISPERSION"));
                DmPredicates dmPredicates = (DmPredicates)((OracleResultSet)sQLHelper.rs).getORAData("SPLIT_PREDICATE", DmPredicates.getORADataFactory());
                DmChildren dmChildren = (DmChildren)((OracleResultSet)sQLHelper.rs).getORAData("CHILD", DmChildren.getORADataFactory());
                DmCentroids dmCentroids = (DmCentroids)((OracleResultSet)sQLHelper.rs).getORAData("CENTROID", DmCentroids.getORADataFactory());
                DmHistograms dmHistograms = (DmHistograms)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAM", DmHistograms.getORADataFactory());
                DmRule dmRule = (DmRule)((OracleResultSet)sQLHelper.rs).getORAData("RULE", DmRule.getORADataFactory());
                clusteringDetailRow = new ClusteringDetailRow(n2, string4, n3, n4, n5, d, dmPredicates, dmChildren, dmCentroids, dmHistograms, dmRule);
                vector.add(clusteringDetailRow);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public Vector<ClusterDetailsModelRow> getModelAttributeDetailsKM(Connection connection, String string, String string2, ClusteringFilterSetting clusteringFilterSetting) throws Exception {
        return this.getModelAttributeDetails(connection, string, string2, clusteringFilterSetting, AlgorithmType.KMEANS);
    }

    public Vector<ClusterDetailsModelRow> getModelAttributeDetailsOC(Connection connection, String string, String string2, ClusteringFilterSetting clusteringFilterSetting) throws Exception {
        return this.getModelAttributeDetails(connection, string, string2, clusteringFilterSetting, AlgorithmType.OCLUSTER);
    }

    public Vector<ClusterDetailsModelRow> getModelAttributeDetails(Connection connection, String string, String string2, ClusteringFilterSetting clusteringFilterSetting, AlgorithmType algorithmType) throws Exception {
        assert (clusteringFilterSetting != null) : "Condition can not be null.";
        assert (clusteringFilterSetting.getClusterId() != null) : "Cluster id can not be null. Will cause join problems.";
        assert (clusteringFilterSetting.getClusterId() >= 1) : "Cluster id can not be zero or less than one. Will cause join problems.";
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = CLUSTER_DETAILS_QUERY;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<ClusterDetailsModelRow> vector = new Vector<ClusterDetailsModelRow>();
        StringBuffer stringBuffer = new StringBuffer();
        Vector<SortSpec> vector2 = null;
        Double d = clusteringFilterSetting.getMinConfidence() / 100.0;
        Double d2 = clusteringFilterSetting.getMaxConfidence() / 100.0;
        try {
            Object object;
            if (algorithmType == AlgorithmType.KMEANS) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS1>", KM_DBMS_API_1);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS2>", KM_DBMS_API_2);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS3>", KM_DBMS_API_3);
            } else {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS1>", OC_DBMS_API_1);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS2>", OC_DBMS_API_2);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS3>", OC_DBMS_API_3);
            }
            string3 = StringUtils.getReplacedString(string3, "<FETCH_SIZE>", clusteringFilterSetting.getFetchSize() + "");
            vector2 = clusteringFilterSetting.getSortSpecification();
            if (vector2 != null && vector2.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<SortSpec> iterator = vector2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!((SortSpec)object).isUseIt()) continue;
                    stringBuffer.append(((SortSpec)object).getAttributeName() + " ");
                    if (((SortSpec)object).isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
            string3 = StringUtils.getReplacedString(string3, "<ORDER_BY1>", stringBuffer.toString());
            string3 = StringUtils.getReplacedString(string3, "<ORDER_BY2>", stringBuffer.toString());
            string3 = clusteringFilterSetting.isUseFilterSpecification() ? StringUtils.getReplacedString(string3, "<WHERE_CONFIDENCE>", CONFIDENCE_DBMS_API_RANGE) : StringUtils.getReplacedString(string3, "<WHERE_CONFIDENCE>", "");
            sQLHelper.pstmt = connection.prepareStatement(string3);
            int n = 1;
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            if (clusteringFilterSetting.isUseFilterSpecification()) {
                sQLHelper.pstmt.setDouble(n++, d);
                sQLHelper.pstmt.setDouble(n++, d2);
            }
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n, clusteringFilterSetting.getClusterId());
            sQLHelper.pstmt.execute();
            object = null;
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                String string5 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                Double d3 = new Double(sQLHelper.rs.getDouble("ATTRIBUTE_SUPPORT"));
                Double d4 = new Double(sQLHelper.rs.getDouble("ATTRIBUTE_CONFIDENCE"));
                Double d5 = new Double(sQLHelper.rs.getDouble("MEAN"));
                Double d6 = new Double(sQLHelper.rs.getDouble("VARIANCE"));
                String string6 = sQLHelper.rs.getString("MODE_VALUE");
                DmHistograms dmHistograms = (DmHistograms)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAM", DmHistograms.getORADataFactory());
                object = new ClusterDetailsModelRow(string4, string5, dmHistograms, d4, d3, d5, string6, d6);
                vector.add((ClusterDetailsModelRow)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            throw outOfMemoryError;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public Integer getTotalNumberOfModelAttributesKM(Connection connection, String string, String string2, Integer n) throws Exception {
        return this.getTotalNumberOfModelAttributes(connection, string, string2, n, AlgorithmType.KMEANS);
    }

    public Integer getTotalNumberOfModelAttributesOC(Connection connection, String string, String string2, Integer n) throws Exception {
        return this.getTotalNumberOfModelAttributes(connection, string, string2, n, AlgorithmType.OCLUSTER);
    }

    private Integer getTotalNumberOfModelAttributes(Connection connection, String string, String string2, int n, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        assert (n >= 1) : "Cluster id can not be zero or less than one. Will cause join problems.";
        String string3 = "with all_attributes AS\n  (SELECT b.attribute_name,\n    b.attribute_Subname   ,\n    NVL2(b.attribute_subname, b.attribute_name\n    || '.'\n    || b.attribute_subname, b.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>)a,\n     TABLE(a.centroid) b)\n select count(*)TOTAL_ATTRIBUTE_COUNT  from all_attributes\n";
        SQLHelper sQLHelper = new SQLHelper();
        Integer n2 = null;
        try {
            string3 = algorithmType == AlgorithmType.KMEANS ? StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM(?,?,NULL,1,0,0,NULL)") : StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC(?,?,NULL,1,0,0)");
            sQLHelper.pstmt = connection.prepareStatement(string3);
            int n3 = 1;
            sQLHelper.pstmt.setString(n3++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n3++, n);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            boolean bl = sQLHelper.rs.next();
            if (bl) {
                n2 = new Integer(sQLHelper.rs.getInt("TOTAL_ATTRIBUTE_COUNT"));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return n2;
    }

    private HashMap<Integer, Integer> getTotalNumberOfModelAttributesPerCluster(Connection connection, String string, String string2, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = " with all_attributes AS\n  (SELECT a.id ID \n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>)a,\n     TABLE(a.centroid) b)\n select id, count(*)TOTAL_ATTRIBUTE_COUNT  from all_attributes\n group by id\n order by id";
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        SQLHelper sQLHelper = new SQLHelper();
        Integer n = null;
        Integer n2 = null;
        try {
            string3 = algorithmType == AlgorithmType.KMEANS ? StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM(?,NULL,NULL,1,0,0,NULL)") : StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC(?,NULL,NULL,1,0,0)");
            sQLHelper.pstmt = connection.prepareStatement(string3);
            int n3 = 1;
            sQLHelper.pstmt.setString(n3++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                n2 = new Integer(sQLHelper.rs.getInt("ID"));
                n = new Integer(sQLHelper.rs.getInt("TOTAL_ATTRIBUTE_COUNT"));
                hashMap.put(n2, n);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public HashMap<Integer, Integer> getTotalNumberOfModelAttributesPerClusterKM(Connection connection, String string, String string2) throws Exception {
        return this.getTotalNumberOfModelAttributesPerCluster(connection, string, string2, AlgorithmType.KMEANS);
    }

    public Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerClusterKM2(Connection connection, String string, String string2) throws Exception {
        return this.getTotalNumberOfModelAttributesPerCluster2(connection, string, string2, AlgorithmType.KMEANS);
    }

    public Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerClusterOC2(Connection connection, String string, String string2) throws Exception {
        return this.getTotalNumberOfModelAttributesPerCluster2(connection, string, string2, AlgorithmType.OCLUSTER);
    }

    public HashMap<Integer, Integer> getTotalNumberOfModelAttributesPerClusterOC(Connection connection, String string, String string2) throws Exception {
        return this.getTotalNumberOfModelAttributesPerCluster(connection, string, string2, AlgorithmType.OCLUSTER);
    }

    public void getCompareClusterDetailsKM(Connection connection, String string, String string2, int n, int n2, Integer n3, Vector<CompareClustersModelRow> vector) throws Exception {
        this.getCompareClusterDetails(connection, string, string2, n, n2, n3, vector, AlgorithmType.KMEANS);
    }

    public void getCompareClusterDetailsOC(Connection connection, String string, String string2, int n, int n2, Integer n3, Vector<CompareClustersModelRow> vector) throws Exception {
        this.getCompareClusterDetails(connection, string, string2, n, n2, n3, vector, AlgorithmType.OCLUSTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCompareClusterDetails(Connection connection, String string, String string2, int n, int n2, Integer n3, Vector<CompareClustersModelRow> vector, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = algorithmType == AlgorithmType.KMEANS ? StringUtils.getReplacedString(_compare_sql, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM") : StringUtils.getReplacedString(_compare_sql, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC");
        HashMap<String, CompareClustersModelRow> hashMap = new HashMap<String, CompareClustersModelRow>();
        for (CompareClustersModelRow object : vector) {
            hashMap.put(object.getFullAttributeName(), object);
        }
        String string4 = Model.getCombinedUserNameModelName(string, string2, false);
        try {
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string4);
            sQLHelper.pstmt.setInt(2, n);
            sQLHelper.pstmt.setString(3, string4);
            sQLHelper.pstmt.setInt(4, n2);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString("aname");
                String string6 = sQLHelper.rs.getString("subname");
                String string7 = sQLHelper.rs.getString("centroid1");
                String string8 = sQLHelper.rs.getString("centroid2");
                int n4 = sQLHelper.rs.getInt("rnk");
                double d = sQLHelper.rs.getDouble("sym_kld");
                String string9 = this.getFullAttributeName(string5, string6);
                CompareClustersModelRow compareClustersModelRow = (CompareClustersModelRow)hashMap.get(string9);
                if (null == compareClustersModelRow) continue;
                compareClustersModelRow.setCentroid1(string7);
                compareClustersModelRow.setCentroid2(string8);
                compareClustersModelRow.setDivergence(d);
                compareClustersModelRow.setRank(n4);
            }
        }
        finally {
            sQLHelper.close();
        }
    }

    private String getFullAttributeName(String string, String string2) {
        String string3 = string2 != null ? string + "." + string2 : string;
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CompareClustersModelRow> getDivergence(Connection connection, String string, String string2, Integer n, String string3, Integer n2, String string4, int n3, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string5 = _DIVERGENCE_SQL;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<CompareClustersModelRow> vector = new Vector<CompareClustersModelRow>();
        try {
            string5 = algorithmType == AlgorithmType.KMEANS ? StringUtils.getReplacedString(string5, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM(?,?,NULL, 0, 1, 0)") : StringUtils.getReplacedString(string5, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC(?,?,NULL, 0, 1, 0)");
            sQLHelper.pstmt = connection.prepareStatement(string5);
            String string6 = Model.getCombinedUserNameModelName(string, string2, false);
            sQLHelper.pstmt.setString(1, string6);
            if (n != null) {
                sQLHelper.pstmt.setInt(2, n);
            } else {
                sQLHelper.pstmt.setNull(2, 4);
            }
            sQLHelper.pstmt.setString(3, string6);
            if (n2 != null) {
                sQLHelper.pstmt.setInt(4, n2);
            } else {
                sQLHelper.pstmt.setNull(4, 4);
            }
            sQLHelper.pstmt.setInt(5, n3);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string7 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                String string8 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                int n4 = sQLHelper.rs.getInt("rnk");
                double d = sQLHelper.rs.getDouble("sym_kld");
                CompareClustersModelRow compareClustersModelRow = new CompareClustersModelRow(string7, string8, n, n2);
                compareClustersModelRow.setCluster1Label1(string3);
                compareClustersModelRow.setCluster1Label2(string4);
                compareClustersModelRow.setRank(n4);
                compareClustersModelRow.setDivergence(d);
                vector.add(compareClustersModelRow);
            }
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerCluster2(Connection connection, String string, String string2, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = ALL_CLUSTERS_ATTRIBUTE_COUNT_QUERY_2;
        HashMap<String, ClusteringDetailRowShort> hashMap = new HashMap<String, ClusteringDetailRowShort>();
        SQLHelper sQLHelper = new SQLHelper();
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        try {
            string3 = algorithmType == AlgorithmType.KMEANS ? StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM(?,NULL,NULL,1,0,0,NULL)") : StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC(?,NULL,NULL,1,0,0)");
            sQLHelper.pstmt = connection.prepareStatement(string3);
            int n5 = 1;
            sQLHelper.pstmt.setString(n5++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                n2 = new Integer(sQLHelper.rs.getInt("ID"));
                int n6 = sQLHelper.rs.getInt("CLUSTER_PARENT");
                n3 = sQLHelper.rs.wasNull() ? null : new Integer(n6);
                n6 = new Integer(sQLHelper.rs.getInt("CHILD_ID"));
                n4 = sQLHelper.rs.wasNull() ? null : new Integer(n6);
                String string4 = sQLHelper.rs.getString("CLUSTER_ID");
                n = new Integer(sQLHelper.rs.getInt("TOTAL_ATTRIBUTE_COUNT"));
                ClusteringDetailRowShort clusteringDetailRowShort = (ClusteringDetailRowShort)hashMap.get(string4);
                ArrayList<Integer> arrayList = null;
                if (clusteringDetailRowShort == null) {
                    if (n4 != null) {
                        arrayList = new ArrayList<Integer>();
                        arrayList.add(n4);
                    }
                    clusteringDetailRowShort = new ClusteringDetailRowShort(n2, string4, n, n3, arrayList);
                    hashMap.put(string4, clusteringDetailRowShort);
                    continue;
                }
                if (n4 == null) continue;
                clusteringDetailRowShort.getChildren().add(n4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCenteroidAndHistogram(Connection connection, String string, String string2, int n, int n2, List<CompareClustersModelRow> list, AlgorithmType algorithmType) throws Exception {
        Object object;
        Serializable serializable;
        String string3;
        SQLHelper sQLHelper = new SQLHelper();
        StringBuilder stringBuilder = null;
        stringBuilder = algorithmType == AlgorithmType.KMEANS ? new StringBuilder(_query_kmeans) : new StringBuilder(_o_cluster);
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        int n3 = 0;
        for (CompareClustersModelRow object2 : list) {
            StringBuffer stringBuffer = new StringBuffer(object2.getName());
            string3 = null;
            if (algorithmType == AlgorithmType.KMEANS) {
                string3 = object2.getSubName();
            }
            if (string3 != null) {
                stringBuffer.append(".");
                stringBuffer.append(string3);
            }
            serializable = new StringBuffer(StringUtils.addSingleQuotes(stringBuffer.toString()));
            if (n3 > 300 || arrayList.isEmpty()) {
                arrayList.add(new StringBuffer());
                n3 = 0;
            }
            if (((StringBuffer)(object = (StringBuffer)arrayList.get(arrayList.size() - 1))).length() > 0) {
                ((StringBuffer)object).append(",");
            }
            ((StringBuffer)object).append((StringBuffer)serializable);
            ++n3;
        }
        String string4 = Model.getCombinedUserNameModelName(string, string2, false);
        for (StringBuffer stringBuffer : arrayList) {
            string3 = StringUtils.getReplacedString(stringBuilder.toString(), "<list_of_columns>", stringBuffer.toString());
            serializable = new HashMap();
            for (CompareClustersModelRow compareClustersModelRow : list) {
                serializable.put(compareClustersModelRow.getFullAttributeName(), compareClustersModelRow);
            }
            try {
                sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
                sQLHelper.opstmt.setStringAtName("model_name", string4);
                sQLHelper.opstmt.setIntAtName("cluster_id1", n);
                sQLHelper.opstmt.setIntAtName("cluster_id2", n2);
                sQLHelper.opstmt.execute();
                sQLHelper.rs = sQLHelper.opstmt.getResultSet();
                while (sQLHelper.rs.next()) {
                    Object object2;
                    String string5 = sQLHelper.rs.getString("CLUSTER_ID");
                    String string6 = sQLHelper.rs.getString("ATTRIBUTE_NAME_SUBNAME");
                    String string7 = sQLHelper.rs.getString("CENTROID");
                    object = (DmHistograms)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAM", DmHistograms.getORADataFactory());
                    DmHistogramBin[] dmHistogramBinArray = ((DmHistograms)object).getArray();
                    ArrayList<DmHistogramBin> arrayList2 = new ArrayList<DmHistogramBin>();
                    for (int i = 0; i < dmHistogramBinArray.length; ++i) {
                        Object object3 = object2 = dmHistogramBinArray[i].getAttributeSubname() != null ? dmHistogramBinArray[i].getAttributeName() + "." + dmHistogramBinArray[i].getAttributeSubname() : dmHistogramBinArray[i].getAttributeName();
                        if (!string6.equals(object2)) continue;
                        arrayList2.add(new DmHistogramBin(dmHistogramBinArray[i].getAttributeName(), dmHistogramBinArray[i].getAttributeSubname(), dmHistogramBinArray[i].getBinId(), dmHistogramBinArray[i].getLowerBound(), dmHistogramBinArray[i].getUpperBound(), dmHistogramBinArray[i].getLabel(), dmHistogramBinArray[i].getCount()));
                    }
                    dmHistogramBinArray = null;
                    DmHistograms dmHistograms = new DmHistograms();
                    dmHistograms.setArray(arrayList2.toArray(new DmHistogramBin[arrayList2.size()]));
                    object2 = (CompareClustersModelRow)serializable.get(string6);
                    if (null == object2) continue;
                    if (string5.equals(((CompareClustersModelRow)object2).getCluster1Label1())) {
                        ((CompareClustersModelRow)object2).setCentroid1(string7);
                        ((CompareClustersModelRow)object2).setFirstClusterHistogram(dmHistograms);
                        continue;
                    }
                    if (string5.equals(((CompareClustersModelRow)object2).getCluster1Label2())) {
                        ((CompareClustersModelRow)object2).setCentroid2(string7);
                        ((CompareClustersModelRow)object2).setSecondClusterHistogram(dmHistograms);
                        continue;
                    }
                    assert (false);
                }
            }
            finally {
                sQLHelper.close();
            }
        }
    }

    public static class ODM_DM_CLUSTER_COMPARE {
        public static final String ATTRIBUTE_NAME = "aname";
        public static final String ATTRIBUTE_SUBNAME = "subname";
        public static final String CENTROID1 = "centroid1";
        public static final String CENTROID2 = "centroid2";
        public static final String RANK = "rnk";
        public static final String DIVERGENCE = "sym_kld";
    }

    public static class ODM_DM_CLUSTER_ATTRIBUTES {
        public static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
        public static final String ATTRIBUTE_SUBNAME = "ATTRIBUTE_SUBNAME";
        public static final String ATTRIBUTE_SUPPORT = "ATTRIBUTE_SUPPORT";
        public static final String ATTRIBUTE_CONFIDENCE = "ATTRIBUTE_CONFIDENCE";
        public static final String MEAN = "MEAN";
        public static final String MODE_VALUE = "MODE_VALUE";
        public static final String VARIANCE = "VARIANCE";
        public static final String HISTOGRAM = "HISTOGRAM";
    }

    public static class ODM_DM_CLUSTERS {
        public static final String ID = "ID";
        public static final String CLUSTER_ID = "CLUSTER_ID";
        public static final String RECORD_COUNT = "RECORD_COUNT";
        public static final String PARENT = "PARENT";
        public static final String TREE_LEVEL = "TREE_LEVEL";
        public static final String DISPERSION = "DISPERSION";
        public static final String SPLIT_PREDICATE = "SPLIT_PREDICATE";
        public static final String CHILD = "CHILD";
        public static final String CENTROID = "CENTROID";
        public static final String HISTOGRAM = "HISTOGRAM";
        public static final String RULE = "RULE";
    }

    private static enum AlgorithmType {
        KMEANS,
        OCLUSTER;

    }
}

