/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmCentroid;
import oracle.dmt.dataminer.generated.server.DmCentroids;

public class CentroidRowData {
    private String _attribute_name;
    private String _attribute_subname;
    private Double _mean;
    private Double _variance;
    private String _mode;

    public CentroidRowData() {
        this._attribute_name = "";
        this._attribute_subname = "";
        this._mean = new Double(0.0);
        this._mode = "";
        this._variance = new Double(0.0);
    }

    public CentroidRowData(String string, String string2, Double d, Double d2, String string3) {
        this._attribute_name = string;
        this._attribute_subname = string2;
        this._mean = d;
        this._mode = string3;
        this._variance = d2;
    }

    public CentroidRowData(DmCentroid dmCentroid) throws Exception {
        this._attribute_name = dmCentroid.getAttributeName();
        this._attribute_subname = dmCentroid.getAttributeSubname() != null ? dmCentroid.getAttributeSubname() : null;
        this._mean = dmCentroid.getMean() != null ? Double.valueOf(dmCentroid.getMean().doubleValue()) : null;
        this._variance = dmCentroid.getVariance() != null ? Double.valueOf(dmCentroid.getVariance().doubleValue()) : null;
        this._mode = dmCentroid.getModeValue() != null ? dmCentroid.getModeValue() : null;
    }

    public void setAttribute_name(String string) {
        this._attribute_name = string;
    }

    public String getAttribute_name() {
        return this._attribute_name;
    }

    public void setAttribute_subname(String string) {
        this._attribute_subname = string;
    }

    public String getAttribute_subname() {
        return this._attribute_subname;
    }

    public void setMean(Double d) {
        this._mean = d;
    }

    public Double getMean() {
        return this._mean;
    }

    public void setVariance(Double d) {
        this._variance = d;
    }

    public Double getVariance() {
        return this._variance;
    }

    public void setMode(String string) {
        this._mode = string;
    }

    public String getMode() {
        return this._mode;
    }

    public Object getCentroidValue() {
        Object object = null;
        if (this._mean != null) {
            object = this._mean;
        } else if (this._mode != null) {
            object = this._mode;
        }
        return object;
    }

    public static Vector<CentroidRowData> createCentroidsFromDmCentroids(DmCentroids dmCentroids) throws Exception {
        Vector<CentroidRowData> vector = new Vector<CentroidRowData>();
        for (int i = 0; i < dmCentroids.length(); ++i) {
            DmCentroid dmCentroid = dmCentroids.getElement(i);
            CentroidRowData centroidRowData = new CentroidRowData(dmCentroid);
            vector.add(centroidRowData);
        }
        return vector;
    }
}

