/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.runner.RunnerPreferencesSettings;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class RunnerPreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private JCheckBox jAutoSelectCheck;
    private JLabel jConnectionAgeLabel;
    private NumberTextField jMaxAgeEdit;
    private JLabel jTimeMeasureLabel;

    public RunnerPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jConnectionAgeLabel = new JLabel();
        this.jAutoSelectCheck = new JCheckBox();
        this.jTimeMeasureLabel = new JLabel();
        this.jMaxAgeEdit = new NumberTextField();
        this.jConnectionAgeLabel.setText("Don't Display Jobs Older Than");
        this.jAutoSelectCheck.setSelected(true);
        this.jAutoSelectCheck.setText("Automatically Display Connection Selected in Navigator");
        this.jTimeMeasureLabel.setText("Hours");
        this.jMaxAgeEdit.setText("5");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jConnectionAgeLabel).addContainerGap(326, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jAutoSelectCheck, -1, 459, Short.MAX_VALUE).addGap(10, 10, 10))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent((Component)this.jMaxAgeEdit, -2, 34, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTimeMeasureLabel).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jAutoSelectCheck).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jConnectionAgeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jMaxAgeEdit, -2, -1, -2).addComponent(this.jTimeMeasureLabel)).addContainerGap(223, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(RunManagerLrb.get("AUTO_DISPLAY_CONN"), this.jAutoSelectCheck);
        hashMap.put(RunManagerLrb.get("MAX_AGE_TITLE_LABEL"), this.jConnectionAgeLabel);
        hashMap.put(RunManagerLrb.get("MAX_AGE_TIME_MEASURE"), this.jTimeMeasureLabel);
        UIResourceHelper.setComponentText(hashMap);
        this.setHelpID("data_miner_prefs");
    }

    @Override
    public void initUI() {
        this.jMaxAgeEdit.setDataType(Integer.class);
        this.jMaxAgeEdit.setSigned(false);
    }

    public void onEntry(TraversableContext traversableContext) {
        RunnerPreferencesSettings runnerPreferencesSettings = RunnerPreferencesPanel.getPreferences(traversableContext);
        this.jMaxAgeEdit.setNumber((Number)runnerPreferencesSettings.getMaxJobAge());
        this.jAutoSelectCheck.setSelected(runnerPreferencesSettings.getAutoSelectConnection());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.jMaxAgeEdit.getNumber().intValue() < 1) {
            this.jMaxAgeEdit.requestFocusInWindow();
            throw new TraversalException(RunManagerLrb.get("MINIMUM_VALUE_ERROR"));
        }
        RunnerPreferencesSettings runnerPreferencesSettings = RunnerPreferencesPanel.getPreferences(traversableContext);
        runnerPreferencesSettings.setMaxJobAgeName(this.jMaxAgeEdit.getNumber().intValue());
        runnerPreferencesSettings.setAutoSelectConnection(this.jAutoSelectCheck.isSelected());
    }

    private static RunnerPreferencesSettings getPreferences(TraversableContext traversableContext) {
        return RunnerPreferencesSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

