/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerEvent;
import oracle.dmt.dataminer.runner.RunManagerListener;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.NamedTimer;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.PasswordPrompter;

public class RunItem {
    private String _connectionName;
    private Connection _connection;
    private HashMap<BigDecimal, WorkflowJob> _jobs;
    private Map<RunManagerListener, ListenerDetail> _listeners;
    private Map<RunManagerListener, Object> _listenerTokens;
    private Object syncObj;
    private NamedTimer _refreshTimer;
    private boolean _isActive;
    private boolean _isInitialized;
    private boolean _disconnected;
    private static final long POLL_INTERVAL = 2000L;
    private static final long RETRY_DELAY = 60000L;

    RunItem(String string) {
        this._connectionName = string;
        this._jobs = new HashMap();
        this._listeners = new HashMap<RunManagerListener, ListenerDetail>();
        this._listenerTokens = new HashMap<RunManagerListener, Object>();
        this.syncObj = new Object();
        this._connection = null;
        this._isActive = false;
        this._isInitialized = false;
        this._disconnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getListenerCount() {
        Object object = this.syncObj;
        synchronized (object) {
            return this._listeners.size();
        }
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    public boolean isJobRunning(BigDecimal bigDecimal) {
        WorkflowJob workflowJob = this._jobs.get(bigDecimal);
        if (workflowJob == null) {
            return false;
        }
        return !workflowJob.isJobFinished();
    }

    public WorkflowJob getJob(BigDecimal bigDecimal) {
        WorkflowJob workflowJob = this._jobs.get(bigDecimal);
        if (workflowJob == null) {
            return null;
        }
        return workflowJob;
    }

    public static boolean isJobRunning(String string, BigDecimal bigDecimal) throws Exception {
        HashMap<BigDecimal, WorkflowJob> hashMap = WorkflowJob.getJobs(RunItem.getConnection(string), RunManager.getMaxJobAge());
        WorkflowJob workflowJob = hashMap.get(bigDecimal);
        return !workflowJob.isJobFinished();
    }

    public static WorkflowJob getJob(String string, BigDecimal bigDecimal) throws Exception {
        HashMap<BigDecimal, WorkflowJob> hashMap = WorkflowJob.getJobs(RunItem.getConnection(string), RunManager.getMaxJobAge());
        WorkflowJob workflowJob = hashMap.get(bigDecimal);
        return workflowJob;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void setInitialized(boolean bl) {
        this._isInitialized = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initListeners(HashMap<BigDecimal, WorkflowJob> hashMap) {
        Object object = this.syncObj;
        synchronized (object) {
            for (RunManagerListener runManagerListener : this._listeners.keySet()) {
                ListenerDetail listenerDetail = this._listeners.get(runManagerListener);
                if (listenerDetail.isListenerInitialized().booleanValue() || !this.isInitialized()) continue;
                this.initializeListener(listenerDetail, hashMap);
            }
        }
    }

    public void refresh() throws Exception {
        if (!this.isActive()) {
            return;
        }
        try {
            int n = RunManager.getMaxJobAge();
            HashMap<BigDecimal, WorkflowJob> hashMap = WorkflowJob.getJobs(this.getConnectionInstance(), n);
            if (!this.isInitialized()) {
                this.setInitialized(true);
            }
            this.initListeners(this._jobs);
            this.refreshImpl(hashMap);
        }
        catch (Exception exception) {
            this._disconnected = true;
            final Exception exception2 = exception;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunItem.this.fireConnectionLost(RunItem.this._listeners, exception2);
                }
            });
            throw exception;
        }
    }

    private void refreshImpl(HashMap<BigDecimal, WorkflowJob> hashMap) {
        WorkflowJob workflowJob;
        WorkflowJob workflowJob2;
        if (!this.isActive()) {
            return;
        }
        if (this._disconnected) {
            this._disconnected = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunItem.this.fireConnectionReestablished(RunItem.this._listeners);
                }
            });
        }
        for (Map.Entry<BigDecimal, WorkflowJob> entry : hashMap.entrySet()) {
            workflowJob2 = entry.getValue();
            workflowJob = this._jobs.get(workflowJob2.getWorkflowId());
            if (workflowJob == null) {
                this._jobs.put(workflowJob2.getWorkflowId(), workflowJob2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RunItem.this.fireJobAdded(workflowJob2, RunItem.this._listeners);
                    }
                });
                continue;
            }
            if (workflowJob.equalsStateOf(workflowJob2)) continue;
            this._jobs.remove(workflowJob.getWorkflowId());
            this._jobs.put(workflowJob2.getWorkflowId(), workflowJob2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (workflowJob2.isJobFinished()) {
                        RunItem.this.fireJobFinished(workflowJob2, RunItem.this._listeners);
                    } else {
                        RunItem.this.fireJobChanged(workflowJob2, RunItem.this._listeners);
                    }
                }
            });
        }
        Iterator<Map.Entry<BigDecimal, WorkflowJob>> iterator = this._jobs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BigDecimal, WorkflowJob> entry;
            entry = iterator.next();
            workflowJob2 = entry.getValue();
            workflowJob = hashMap.get(workflowJob2.getWorkflowId());
            if (workflowJob != null) continue;
            iterator.remove();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunItem.this.fireJobRemoved(workflowJob2, RunItem.this._listeners);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateListenerToken(ListenerDetail listenerDetail) {
        boolean bl = false;
        Object object = this.syncObj;
        synchronized (object) {
            Object object2 = this._listenerTokens.get(listenerDetail.getListener());
            if (object2 != null && object2 == listenerDetail.getListenerToken()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionLost(Map<RunManagerListener, ListenerDetail> map, Exception exception) {
        Object object = this.syncObj;
        synchronized (object) {
            Iterator<Map.Entry<RunManagerListener, ListenerDetail>> iterator = map.entrySet().iterator();
            RunManagerEvent runManagerEvent = new RunManagerEvent(this, null);
            runManagerEvent.setExceptionInfo(exception);
            while (iterator.hasNext()) {
                Map.Entry<RunManagerListener, ListenerDetail> entry = iterator.next();
                ListenerDetail listenerDetail = entry.getValue();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                runManagerListener.connectionLost(runManagerEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionReestablished(Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            for (Map.Entry<RunManagerListener, ListenerDetail> entry : map.entrySet()) {
                ListenerDetail listenerDetail = entry.getValue();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                runManagerListener.connectionReestablished(new RunManagerEvent(this, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobAdded(WorkflowJob workflowJob, Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            for (Map.Entry<RunManagerListener, ListenerDetail> entry : map.entrySet()) {
                ListenerDetail listenerDetail = entry.getValue();
                BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                if (bigDecimal == null) {
                    runManagerListener.jobAdded(new RunManagerEvent(this, workflowJob));
                    continue;
                }
                if (!bigDecimal.equals(workflowJob.getWorkflowId())) continue;
                runManagerListener.jobAdded(new RunManagerEvent(this, workflowJob));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobFinished(WorkflowJob workflowJob, Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            HashMap<RunManagerListener, ListenerDetail> hashMap = new HashMap<RunManagerListener, ListenerDetail>(map);
            for (Map.Entry entry : hashMap.entrySet()) {
                ListenerDetail listenerDetail = (ListenerDetail)entry.getValue();
                BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail) || bigDecimal != null && (bigDecimal == null || !bigDecimal.equals(workflowJob.getWorkflowId()))) continue;
                runManagerListener.jobFinished(new RunManagerEvent(this, workflowJob));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobChanged(WorkflowJob workflowJob, Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            HashMap<RunManagerListener, ListenerDetail> hashMap = new HashMap<RunManagerListener, ListenerDetail>(map);
            for (Map.Entry entry : hashMap.entrySet()) {
                ListenerDetail listenerDetail = (ListenerDetail)entry.getValue();
                BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                boolean bl = false;
                if (bigDecimal == null) {
                    runManagerListener.jobChanged(new RunManagerEvent(this, workflowJob));
                    bl = true;
                    continue;
                }
                if (!bigDecimal.equals(workflowJob.getWorkflowId())) continue;
                runManagerListener.jobChanged(new RunManagerEvent(this, workflowJob));
                bl = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobRemoved(WorkflowJob workflowJob, Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            HashMap<RunManagerListener, ListenerDetail> hashMap = new HashMap<RunManagerListener, ListenerDetail>(map);
            for (Map.Entry entry : hashMap.entrySet()) {
                ListenerDetail listenerDetail = (ListenerDetail)entry.getValue();
                BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                if (bigDecimal == null) {
                    runManagerListener.jobRemoved(new RunManagerEvent(this, workflowJob));
                    continue;
                }
                if (!bigDecimal.equals(workflowJob.getWorkflowId())) continue;
                runManagerListener.jobRemoved(new RunManagerEvent(this, workflowJob));
            }
        }
    }

    private Connection getConnectionInstance() throws DBException, SQLException, ConnectionException, Exception {
        if (this._connection != null) {
            return this._connection;
        }
        this._connection = RunItem.getConnection(this._connectionName);
        return this._connection;
    }

    private static Connection getConnection(String string) throws SQLException, ConnectionException, Exception {
        Connection connection = null;
        if (!ConfigUtils.isValidUserConnection(string).booleanValue()) {
            throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_PRIVILEGED"));
        }
        Properties properties = DatabaseConnections.getInstance().getProperties(string);
        Properties properties2 = (Properties)properties.clone();
        DatabaseProvider databaseProvider = new DatabaseProvider(properties2);
        databaseProvider.setProperty("SQLDEV_PROMPT_KEY", "ODMR_PWD_PROMPT");
        Connection connection2 = null;
        boolean bl = false;
        while (!bl) {
            try {
                connection2 = databaseProvider.getConnection();
                break;
            }
            catch (ConnectionCanceledException connectionCanceledException) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_NOT_AUTH"));
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 1017) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RunManagerLrb.get("CONNECT_FAIL") + sQLException.getMessage()), (String)RunManagerLrb.get("CONNECT_FAIL_TITLE"), null);
                    if (properties2.getProperty("SavePassword").equalsIgnoreCase("true")) {
                        throw sQLException;
                    }
                } else {
                    if (sQLException.getErrorCode() == 28000) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RunManagerLrb.get("CONNECT_FAIL") + sQLException.getMessage()), (String)RunManagerLrb.get("CONNECT_FAIL_TITLE"), null);
                        throw sQLException;
                    }
                    throw sQLException;
                }
                Properties properties3 = (Properties)properties.clone();
                properties3.remove("password");
                databaseProvider = new DatabaseProvider(properties3);
                PasswordPrompter passwordPrompter = DatabaseProviderHelper.getPasswordPrompter();
                passwordPrompter.disconnect(properties3);
            }
        }
        try {
            if (!ConfigUtils.isValidUserConnection(string).booleanValue()) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_PRIVILEGED"));
            }
            if (!ConfigUtils.isODMRSYSLoaded(connection2)) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_LACKS_REPOS"));
            }
            if (!ConfigUtils.isODMPrivsPresent(connection2)) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_LACKS_PRIVS"));
            }
            connection = connection2;
        }
        catch (Exception exception) {
            if (connection2 != null) {
                connection2.close();
            }
            throw exception;
        }
        return connection;
    }

    public synchronized void close() {
        this.stopMonitor();
    }

    public boolean addListener(RunManagerListener runManagerListener) {
        return this.addListener(runManagerListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(RunManagerListener runManagerListener, BigDecimal bigDecimal) {
        Object object = this.syncObj;
        synchronized (object) {
            ListenerDetail listenerDetail = this._listeners.get(runManagerListener);
            if (listenerDetail != null && this.validateListenerToken(listenerDetail)) {
                return false;
            }
            if (this._listeners.size() == 0 || !this.isActive()) {
                this.startMonitor();
            }
            ListenerDetail listenerDetail2 = new ListenerDetail(runManagerListener, bigDecimal);
            this._listenerTokens.put(runManagerListener, listenerDetail2.getListenerToken());
            this._listeners.put(runManagerListener, listenerDetail2);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(RunManagerListener runManagerListener) {
        Object object = this.syncObj;
        synchronized (object) {
            ListenerDetail listenerDetail = this._listeners.remove(runManagerListener);
            this._listenerTokens.remove(listenerDetail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunManagerListener getListener(RunManagerListener runManagerListener) {
        Object object = this.syncObj;
        synchronized (object) {
            ListenerDetail listenerDetail = this._listeners.get(runManagerListener);
            if (listenerDetail != null) {
                return listenerDetail.getListener();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeListener(final ListenerDetail listenerDetail, HashMap<BigDecimal, WorkflowJob> hashMap) {
        Object object = this.syncObj;
        synchronized (object) {
            if (!this.isActive()) {
                return;
            }
            listenerDetail.setListenerInitialized();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listenerDetail.getListener().jobsListenerInitialized();
                }
            });
            try {
                final HashMap<RunManagerListener, ListenerDetail> hashMap2 = new HashMap<RunManagerListener, ListenerDetail>();
                hashMap2.put(listenerDetail.getListener(), listenerDetail);
                for (Map.Entry<BigDecimal, WorkflowJob> entry : hashMap.entrySet()) {
                    final WorkflowJob workflowJob = entry.getValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunItem.this.fireJobAdded(workflowJob, hashMap2);
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void startMonitor() {
        this.startMonitor(0L);
    }

    private void startMonitor(long l) {
        if (this.isActive()) {
            this.stopMonitor();
        }
        this._isActive = true;
        this._refreshTimer = new NamedTimer("RunManagerTimer:" + this._connectionName, 5, true);
        this._refreshTimer.schedule((TimerTask)new RunTimerTask(), l, 2000L);
    }

    private void restartMonitor(long l) {
        this.stopMonitor();
        this.startMonitor(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitor() {
        if (this._refreshTimer == null) {
            return;
        }
        this._refreshTimer.cancel();
        if (this._connection != null) {
            Connection connection = this._connection;
            synchronized (connection) {
                try {
                    if (this._connection != null) {
                        this._connection.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        this._connection = null;
        this._isActive = false;
        this._isInitialized = false;
        this._refreshTimer = null;
    }

    class ListenerDetail {
        private RunManagerListener _listener;
        private BigDecimal _workflowId;
        private Object _listenerToken;
        private Boolean _listenerInitialized;

        ListenerDetail(RunManagerListener runManagerListener, BigDecimal bigDecimal) {
            this._listener = runManagerListener;
            this._workflowId = bigDecimal;
            this._listenerToken = new Object();
            this._listenerInitialized = false;
        }

        public RunManagerListener getListener() {
            return this._listener;
        }

        public BigDecimal getWorkflowId() {
            return this._workflowId;
        }

        public Object getListenerToken() {
            return this._listenerToken;
        }

        public void setListenerInitialized() {
            this._listenerInitialized = true;
        }

        public Boolean isListenerInitialized() {
            return this._listenerInitialized;
        }
    }

    class RunTimerTask
    extends TimerTask {
        RunTimerTask() {
        }

        @Override
        public void run() {
            if (!RunItem.this.isActive()) {
                return;
            }
            if (RunItem.this._listeners.size() != 0) {
                try {
                    RunItem.this.refresh();
                }
                catch (Exception exception) {
                    if (exception instanceof RunManager.UnmonitorableConnectionException) {
                        RunItem.this.stopMonitor();
                    }
                    if (exception instanceof SQLException && ((SQLException)exception).getErrorCode() == 1035) {
                        RunItem.this.stopMonitor();
                    }
                    if (exception instanceof SQLException && ((SQLException)exception).getErrorCode() == 28000) {
                        RunItem.this.stopMonitor();
                    }
                    RunItem.this.restartMonitor(60000L);
                }
            }
        }
    }
}

