/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dbtools.raptor.dialogs.conn.ConnectionPromptUI;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.panels.TraversalException;

public class PasswordPrompt
implements ConnectionPromptUI {
    private String usernameValue;
    private String connName;
    private PasswordPromptUI ui;

    public void commit(Properties properties) throws TraversalException {
        String string = new String(this.ui.getPassword());
        String string2 = this.ui.getUsername();
        properties.put("password", string);
        properties.put("user", string2);
    }

    public void init(Properties properties) {
        this.usernameValue = (String)properties.get("user");
        this.connName = (String)properties.get("ConnName");
    }

    public Component getComponent() {
        this.ui = new PasswordPromptUI(this.usernameValue, this.connName);
        return this.ui;
    }

    public Component getInitialFocus() {
        return this.ui.getPasswordField();
    }

    public static class PasswordPromptUI
    extends JPanel {
        private String username;
        private String connName;
        JLabel instructionsLabel;
        JPasswordField passwordEdit;
        JLabel passwordLabel;
        JTextField usernameEdit;
        JLabel usernameLabel;

        public PasswordPromptUI(String string, String string2) {
            this.username = string;
            this.connName = string2;
            this.initComponents();
            this.initRes();
        }

        private void initComponents() {
            this.usernameLabel = new JLabel();
            this.passwordLabel = new JLabel();
            this.instructionsLabel = new JLabel();
            this.usernameEdit = new JTextField();
            this.passwordEdit = new JPasswordField();
            this.usernameLabel.setText("Username:");
            this.passwordLabel.setText("Password:");
            this.instructionsLabel.setText("Workflow Jobs monitor is attempting to connect.");
            this.usernameEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PasswordPromptUI.this.usernameEditActionPerformed(actionEvent);
                }
            });
            this.passwordEdit.setText("jPasswordField1");
            GroupLayout groupLayout = new GroupLayout(this);
            this.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.instructionsLabel, -1, 371, Short.MAX_VALUE).addGap(20, 20, 20)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usernameLabel).addComponent(this.passwordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.passwordEdit, -1, 335, Short.MAX_VALUE).addComponent(this.usernameEdit, -1, 335, Short.MAX_VALUE))));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.instructionsLabel, -1, 25, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usernameLabel).addComponent(this.usernameEdit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordEdit, -2, -1, -2).addComponent(this.passwordLabel)).addContainerGap()));
        }

        private void usernameEditActionPerformed(ActionEvent actionEvent) {
        }

        private void initRes() {
            String string = RunManagerLrb.get("PROMPT_PWD_INSTRUCTIONS");
            string = MessageFormat.format(string, this.connName);
            HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
            hashMap.put("<html>" + string + "</html>", this.instructionsLabel);
            hashMap.put(RunManagerLrb.get("PROMPT_USERNAME"), this.usernameLabel);
            hashMap.put(RunManagerLrb.get("PROMPT_PWD"), this.passwordLabel);
            UIResourceHelper.setComponentText(hashMap);
            this.usernameEdit.setText(this.username);
            this.passwordEdit.setText("");
            HelpUtils.setHelpID((JComponent)this, (String)"dm_runmgr_password");
        }

        public char[] getPassword() {
            return this.passwordEdit.getPassword();
        }

        public String getUsername() {
            return this.usernameEdit.getText();
        }

        public JPasswordField getPasswordField() {
            return this.passwordEdit;
        }
    }
}

