/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DbmsDataMiningTransformEx;
import oracle.dmt.dataminer.generated.server.DbmsSqlVarchar2a;
import oracle.dmt.dataminer.generated.server.ODMRPkg_DataGroup;
import oracle.dmt.dataminer.generated.server.OdmrImpactReports;
import oracle.dmt.dataminer.generated.server.OdmrObjectIds;
import oracle.dmt.dataminer.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.generated.server.OdmrTableColumn;
import oracle.dmt.dataminer.generated.server.OdmrTableColumns;
import oracle.dmt.dataminer.repository.Column;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.utils.SQLHelper;

public class GroupTable
extends LoadableRepositoryObject {
    private String _schema;
    private String _type;
    private String _cache;
    private int _cacheSize;
    private String _cacheSizeUnit;
    private Date _cachedTime;
    private String _statistics;
    private int _statisticsSize;
    private Date _statisticsTime;
    private String _snapshot;
    private int _snapshotSize;
    private String _snapshotSizeUnit;
    private Date _snapshotTime;
    private List<Column> _columns = null;
    private List<BigDecimal> _dependentPhysicalTableIds = null;
    private List<Column> _requiredPhysicalTableColumns = null;
    public static final String OBJECT_TYPE_TABLE = "T";
    public static final String OBJECT_TYPE_VIEW = "V";
    public static final String OBJECT_TYPE_JOIN = "J";
    public static final String OBJECT_TYPE_XFORM = "X";
    public static final String OBJECT_TYPE_AGGR = "A";
    public static final String OBJECT_TYPE_TEXT = "X";
    public static final String DG_TABLES_TABLE = "ODMR_USER_DG_TABLES";
    public static final String TABLE_ID = "TABLE_ID";
    public static final String GROUP_ID = "GROUP_ID";
    public static final String SCHEMA_NAME = "SCHEMA_NAME";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String LTAB_EXPRESSION = "LTAB_EXPRESSION";
    public static final String CACHED_TABLE_NAME = "CACHED_TABLE_NAME";
    public static final String CACHED_TABLE_SIZE = "CACHED_TABLE_SIZE";
    public static final String CACHED_TABLE_SIZE_UNIT = "CACHED_TABLE_SIZE_UNIT";
    public static final String LAST_CACHED_TIME = "LAST_CACHED_TIME";
    public static final String STATISTICS_TABLE_NAME = "STATISTICS_TABLE_NAME";
    public static final String STATISTICS_TABLE_SIZE = "STATISTICS_TABLE_SIZE";
    public static final String LAST_STATISTICS_TIME = "LAST_STATISTICS_TIME";
    public static final String SNAPSHOT_TABLE_NAME = "SNAPSHOT_TABLE_NAME";
    public static final String SNAPSHOT_TABLE_SIZE = "SNAPSHOT_TABLE_SIZE";
    public static final String SNAPSHOT_TABLE_SIZE_UNIT = "SNAPSHOT_TABLE_SIZE_UNIT";
    public static final String LAST_SNAPSHOT_TIME = "LAST_SNAPSHOT_TIME";
    public static final String TABLE_TYPE = "TABLE_TYPE";
    public static final String CREATION_TIME = "CREATION_TIME";
    public static final String LAST_UPDATED_TIME = "LAST_UPDATED_TIME";
    public static final String LAST_RUN_TIME = "LAST_RUN_TIME";
    public static final String LAST_SYNC_TIME = "LAST_SYNC_TIME";

    public GroupTable(String string, String string2, String string3, String string4, Date date, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this(string, string2, string3, string4, 0, null, date, null, 0, null, null, 0, null, null, bigDecimal, bigDecimal2);
    }

    public GroupTable(String string, String string2, String string3, String string4, int n, String string5, Date date, String string6, int n2, Date date2, String string7, int n3, String string8, Date date3, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string2, bigDecimal, bigDecimal2);
        this._schema = string;
        this._type = string3;
        this._cache = string4;
        this._cacheSize = n;
        this._cacheSizeUnit = string5;
        this._cachedTime = date;
        this._statistics = string6;
        this._statisticsSize = n2;
        this._statisticsTime = date2;
        this._snapshot = string7;
        this._snapshotSize = n3;
        this._snapshotSizeUnit = string8;
        this._snapshotTime = date3;
    }

    public void setSchema(String string) {
        this._schema = string;
    }

    public String getSchema() {
        return this._schema;
    }

    public void setType(String string) {
        this._type = string;
    }

    public String getType() {
        return this._type;
    }

    public void setCache(String string) {
        this._cache = string;
    }

    public String getCache() {
        return this._cache;
    }

    public void setCachedTime(Date date) {
        this._cachedTime = date;
    }

    public Date getCachedTime() {
        return this._cachedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Connection connection) {
        try {
            this._columns = Column.getColumns(connection, this.getId());
            this.setLoaded(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadDependentPhysicalTables(Connection connection) throws SQLException {
        if (!this._type.equals(OBJECT_TYPE_TABLE)) {
            ODMRPkg_DataGroup oDMRPkg_DataGroup = new ODMRPkg_DataGroup(connection);
            OdmrObjectIds[] odmrObjectIdsArray = new OdmrObjectIds[1];
            OdmrTableColumns[] odmrTableColumnsArray = new OdmrTableColumns[1];
            OdmrTableColumn[] odmrTableColumnArray = null;
            oDMRPkg_DataGroup.getLtabPhysicalTables(this.getId(), odmrObjectIdsArray, odmrTableColumnsArray);
            BigDecimal[] bigDecimalArray = null;
            if (odmrObjectIdsArray[0] != null) {
                bigDecimalArray = odmrObjectIdsArray[0].getArray();
                this._dependentPhysicalTableIds = Arrays.asList(bigDecimalArray);
            }
            if ((odmrTableColumnArray = odmrTableColumnsArray[0].getArray()) != null) {
                for (int i = 0; i < odmrTableColumnArray.length; ++i) {
                    this._requiredPhysicalTableColumns = new ArrayList<Column>();
                    this._requiredPhysicalTableColumns.add(new Column(null, odmrTableColumnArray[i].getColumnId(), null));
                }
            }
        }
    }

    public List<BigDecimal> getDependentPhysicalTableIds() {
        return this._dependentPhysicalTableIds;
    }

    public List<Column> getRequiredPhysicalTableColumnIds() {
        return this._requiredPhysicalTableColumns;
    }

    @Override
    public void unload() throws Exception {
        this.setLoaded(false);
    }

    @Override
    public void refresh(Connection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GroupTable getTable(Connection connection, BigDecimal bigDecimal) throws SQLException {
        GroupTable groupTable = null;
        SQLHelper sQLHelper = new SQLHelper();
        String[] stringArray = new String[]{SCHEMA_NAME, TABLE_NAME, TABLE_ID, TABLE_TYPE, CACHED_TABLE_NAME, CACHED_TABLE_SIZE, CACHED_TABLE_SIZE_UNIT, LAST_CACHED_TIME, STATISTICS_TABLE_NAME, STATISTICS_TABLE_SIZE, LAST_STATISTICS_TIME, SNAPSHOT_TABLE_NAME, SNAPSHOT_TABLE_SIZE, SNAPSHOT_TABLE_SIZE_UNIT, LAST_SNAPSHOT_TIME};
        String[] stringArray2 = new String[]{DG_TABLES_TABLE};
        String string = SQLHelper.buildSimpleQuery(stringArray, stringArray2, "TABLE_ID = ? ");
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.setBigDecimal(1, bigDecimal);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString(SCHEMA_NAME);
                String string3 = sQLHelper.rs.getString(TABLE_NAME);
                String string4 = sQLHelper.rs.getString(TABLE_TYPE);
                String string5 = sQLHelper.rs.getString(CACHED_TABLE_NAME);
                int n = sQLHelper.rs.getInt(CACHED_TABLE_SIZE);
                String string6 = sQLHelper.rs.getString(CACHED_TABLE_SIZE_UNIT);
                Date date = sQLHelper.rs.getDate(LAST_CACHED_TIME);
                String string7 = sQLHelper.rs.getString(STATISTICS_TABLE_NAME);
                int n2 = sQLHelper.rs.getInt(STATISTICS_TABLE_SIZE);
                Date date2 = sQLHelper.rs.getDate(LAST_STATISTICS_TIME);
                String string8 = sQLHelper.rs.getString(SNAPSHOT_TABLE_NAME);
                int n3 = sQLHelper.rs.getInt(SNAPSHOT_TABLE_SIZE);
                String string9 = sQLHelper.rs.getString(SNAPSHOT_TABLE_SIZE_UNIT);
                Date date3 = sQLHelper.rs.getDate(LAST_SNAPSHOT_TIME);
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal(TABLE_ID);
                groupTable = new GroupTable(string2, string3, string4, string5, n, string6, date, string7, n2, date2, string8, n3, string9, date3, bigDecimal2, bigDecimal);
            }
        }
        finally {
            sQLHelper.close();
        }
        return groupTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GroupTable> getTables(Connection connection, BigDecimal bigDecimal) throws SQLException {
        Vector<GroupTable> vector = new Vector<GroupTable>();
        String string = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String[] stringArray = new String[]{SCHEMA_NAME, TABLE_NAME, TABLE_ID, TABLE_TYPE, CACHED_TABLE_NAME, CACHED_TABLE_SIZE, CACHED_TABLE_SIZE_UNIT, LAST_CACHED_TIME, STATISTICS_TABLE_NAME, STATISTICS_TABLE_SIZE, LAST_STATISTICS_TIME, SNAPSHOT_TABLE_NAME, SNAPSHOT_TABLE_SIZE, SNAPSHOT_TABLE_SIZE_UNIT, LAST_SNAPSHOT_TIME};
        String[] stringArray2 = new String[]{DG_TABLES_TABLE};
        string = GroupTable.buildQuery(stringArray, stringArray2, "GROUP_ID = ? ");
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setBigDecimal(1, bigDecimal);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(SCHEMA_NAME);
                String string3 = resultSet.getString(TABLE_NAME);
                String string4 = resultSet.getString(TABLE_TYPE);
                String string5 = resultSet.getString(CACHED_TABLE_NAME);
                int n = resultSet.getInt(CACHED_TABLE_SIZE);
                String string6 = resultSet.getString(CACHED_TABLE_SIZE_UNIT);
                Date date = resultSet.getDate(LAST_CACHED_TIME);
                String string7 = resultSet.getString(STATISTICS_TABLE_NAME);
                int n2 = resultSet.getInt(STATISTICS_TABLE_SIZE);
                Date date2 = resultSet.getDate(LAST_STATISTICS_TIME);
                String string8 = resultSet.getString(SNAPSHOT_TABLE_NAME);
                int n3 = resultSet.getInt(SNAPSHOT_TABLE_SIZE);
                String string9 = resultSet.getString(SNAPSHOT_TABLE_SIZE_UNIT);
                Date date3 = resultSet.getDate(LAST_SNAPSHOT_TIME);
                BigDecimal bigDecimal2 = resultSet.getBigDecimal(TABLE_ID);
                vector.add(new GroupTable(string2, string3, string4, string5, n, string6, date, string7, n2, date2, string8, n3, string9, date3, bigDecimal2, bigDecimal));
            }
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                    resultSet = null;
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                catch (Exception exception) {}
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OdmrImpactReports delete(Connection connection, BigDecimal bigDecimal, BigDecimal[] bigDecimalArray, boolean bl) throws Exception {
        ODMRPkg_DataGroup oDMRPkg_DataGroup = null;
        OdmrImpactReports odmrImpactReports = null;
        try {
            oDMRPkg_DataGroup = new ODMRPkg_DataGroup();
            oDMRPkg_DataGroup.setConnection(connection);
            OdmrObjectIds odmrObjectIds = new OdmrObjectIds(bigDecimalArray);
            odmrImpactReports = oDMRPkg_DataGroup.removeGroupTable(bigDecimal, odmrObjectIds, bl ? "Y" : "N");
        }
        finally {
            if (oDMRPkg_DataGroup != null) {
                try {
                    oDMRPkg_DataGroup.release();
                }
                catch (Exception exception) {}
            }
        }
        return odmrImpactReports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInputData(Connection connection, BigDecimal bigDecimal, BigDecimal bigDecimal2) throws Exception {
        ODMRPkg_DataGroup oDMRPkg_DataGroup = null;
        OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[1];
        DbmsDataMiningTransformEx[] dbmsDataMiningTransformExArray = new DbmsDataMiningTransformEx[1];
        try {
            oDMRPkg_DataGroup = new ODMRPkg_DataGroup();
            oDMRPkg_DataGroup.setConnection(connection);
            oDMRPkg_DataGroup.getInputData(bigDecimal, odmrObjectNamesArray, dbmsDataMiningTransformExArray);
        }
        finally {
            if (oDMRPkg_DataGroup != null) {
                try {
                    oDMRPkg_DataGroup.release();
                }
                catch (Exception exception) {}
            }
        }
        if (dbmsDataMiningTransformExArray.length > 0) {
            DbmsSqlVarchar2a dbmsSqlVarchar2a = dbmsDataMiningTransformExArray[0].getLstmt();
        }
        return "";
    }

    public List<Column> getColumns() {
        return this._columns;
    }

    public static boolean isJoin(String string) {
        return 0 == string.compareTo(OBJECT_TYPE_JOIN);
    }

    public void setCacheSize(int n) {
        this._cacheSize = n;
    }

    public int getCacheSize() {
        return this._cacheSize;
    }

    public void setCacheSizeUnit(String string) {
        this._cacheSizeUnit = string;
    }

    public String getCacheSizeUnit() {
        return this._cacheSizeUnit;
    }

    public void setStatistics(String string) {
        this._statistics = string;
    }

    public String getStatistics() {
        return this._statistics;
    }

    public void setStatisticsSize(int n) {
        this._statisticsSize = n;
    }

    public int getStatisticsSize() {
        return this._statisticsSize;
    }

    public void setStatisticsTime(Date date) {
        this._statisticsTime = date;
    }

    public Date getStatisticsTime() {
        return this._statisticsTime;
    }

    public void setSnapshot(String string) {
        this._snapshot = string;
    }

    public String getSnapshot() {
        return this._snapshot;
    }

    public void setSnapshotSize(int n) {
        this._snapshotSize = n;
    }

    public int getSnapshotSize() {
        return this._snapshotSize;
    }

    public void setSnapshotSizeUnit(String string) {
        this._snapshotSizeUnit = string;
    }

    public String getSnapshotSizeUnit() {
        return this._snapshotSizeUnit;
    }

    public void setSnapshotTime(Date date) {
        this._snapshotTime = date;
    }

    public Date getSnapshotTime() {
        return this._snapshotTime;
    }
}

