/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCs;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;

public class ClassTestResult
extends TestResult {
    public static final String PERFORM_METRICS_TABLE_NAME = "PERFORM_METRICS_TABLE_NAME";
    public static final String CONFUSION_MATRIX_TABLE_NAME = "CONFUSION_MATRIX_TABLE_NAME";
    public static final String PREDICTIVE_CONFIDENCE = "PREDICTIVE_CONFIDENCE";
    public static final String AVG_ACCURACY = "AVG_ACCURACY";
    public static final String ACCURACY = "ACCURACY";
    public static final String COST = "COST";
    public static final String LEAST_TARGET_VALUE = "LEAST_TARGET_VALUE";
    private HashMap<String, String> _liftResultTables;
    private HashMap<String, String> _rocResultTables;
    private HashMap<String, Double> _rocAreaUnderCurves;
    private Vector<String> _targetValues;

    public ClassTestResult(ClassTestResult classTestResult) {
        super(classTestResult);
    }

    public ClassTestResult(Context context, BuildNodeType buildNodeType, MiningResultType miningResultType) {
        super(context, buildNodeType, miningResultType);
        boolean bl = false;
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            CGeneralizedLinearModelType cGeneralizedLinearModelType;
            Object object;
            Object object22;
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list = models.getNaiveBayesModel();
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("CLASSIFICATION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            for (Object object22 : list) {
                if (object22.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                this._data.put("MODEL_NAME", object22.getName());
                this._data.put("MODEL_ID", object22.getId());
                this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_NAIVE_BAYES"));
                bl = true;
                break;
            }
            if (!bl) {
                object = models.getCGeneralizedLinearModel();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    cGeneralizedLinearModelType = (CGeneralizedLinearModelType)object22.next();
                    if (cGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", cGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", cGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_GENERALIZED_LINEAR_MODEL"));
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                object = models.getDecisionTreeModel();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    cGeneralizedLinearModelType = (DecisionTreeModelType)object22.next();
                    if (cGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", cGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", cGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_DECISION_TREE"));
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                object = models.getCSupportVectorMachineModel();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    cGeneralizedLinearModelType = (CSupportVectorMachineModelType)object22.next();
                    if (cGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", cGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", cGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
                    bl = true;
                    break;
                }
            }
            this._data.put(PERFORM_METRICS_TABLE_NAME, ((ClassificationResultType)miningResultType).getTestMetrics().getName());
            this._data.put(CONFUSION_MATRIX_TABLE_NAME, ((ClassificationResultType)miningResultType).getConfusionMatrix().getName());
        }
    }

    public ClassTestResult(Context context, TestNodeType testNodeType, MiningResultType miningResultType) {
        super(context, testNodeType, miningResultType);
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (model.getModelId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("CLASSIFICATION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            this._data.put("MODEL_SCHEMA", model.getSchema());
            this._data.put("MODEL_NAME", model.getName());
            this._data.put("MODEL_ID", model.getModelId());
            this._data.put("MINING_ALGORITHM", ServerConstants.Algorithm.getUIAlgorithmName(model.getMiningAlgorithm().value()));
            break;
        }
        this._data.put(PERFORM_METRICS_TABLE_NAME, ((ClassificationResultType)miningResultType).getTestMetrics().getName());
        this._data.put(CONFUSION_MATRIX_TABLE_NAME, ((ClassificationResultType)miningResultType).getConfusionMatrix().getName());
    }

    public boolean isROCResult() {
        if (this._result instanceof ClassificationResultType) {
            ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
            return classificationResultType.getROCs().getROC().size() > 0;
        }
        return false;
    }

    private void loadResultsTables() {
        String string;
        String string2;
        List list;
        if (this._targetValues == null) {
            this._targetValues = new Vector();
        }
        ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
        if (this._liftResultTables == null) {
            this._liftResultTables = new HashMap();
            if (classificationResultType.getLifts().getLift().size() > 0) {
                list = classificationResultType.getLifts().getLift();
                for (Object object2 : list) {
                    string2 = object2.getTargetValue();
                    string = object2.getName();
                    this._liftResultTables.put(string2, string);
                    this._targetValues.add(string2);
                }
                Collections.sort(this._targetValues, new TargetComparator());
            }
        }
        if (this._rocResultTables == null) {
            this._rocResultTables = new HashMap();
            this._rocAreaUnderCurves = new HashMap();
            if (classificationResultType.getROCs().getROC().size() > 0) {
                Object object2;
                list = classificationResultType.getROCs().getROC();
                for (Object object2 : list) {
                    string2 = object2.getTargetValue();
                    string = object2.getName();
                    this._rocResultTables.put(string2, string);
                }
                List list2 = classificationResultType.getROCs().getAreaUnderCurve();
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    ROCs.AreaUnderCurve areaUnderCurve = (ROCs.AreaUnderCurve)object2.next();
                    string2 = areaUnderCurve.getTargetValue();
                    double d = areaUnderCurve.getArea();
                    this._rocAreaUnderCurves.put(string2, new Double(d));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetrics() {
        String string = null;
        Connection connection = null;
        String string2 = this.getPerformanceMatrixTable();
        string = "Select metric_name, metric_num_value, metric_varchar_value from " + string2 + " where metric_name in ( 'PREDICTIVE_CONFIDENCE', 'AVG_ACCURACY', 'ACCURACY', 'COST', 'LEAST_TARGET_VALUE')";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            connection = Connections.getSharedConnection(this._context);
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(1);
                if (PREDICTIVE_CONFIDENCE.equals(string3)) {
                    this._data.put(PREDICTIVE_CONFIDENCE, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (AVG_ACCURACY.equals(string3)) {
                    this._data.put(AVG_ACCURACY, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (ACCURACY.equals(string3)) {
                    this._data.put(ACCURACY, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (COST.equals(string3)) {
                    this._data.put(COST, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (!LEAST_TARGET_VALUE.equals(string3)) continue;
                this._data.put(LEAST_TARGET_VALUE, sQLHelper.rs.getString(3));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            sQLHelper.close();
        }
    }

    public String getPerformanceMatrixTable() {
        return (String)this._data.get(PERFORM_METRICS_TABLE_NAME);
    }

    public boolean performanceMatrixExists() {
        return this._data.get(PERFORM_METRICS_TABLE_NAME) != null;
    }

    public String geLiftResultTable(String string) {
        if (this._liftResultTables == null) {
            this.loadResultsTables();
        }
        return this._liftResultTables.get(string);
    }

    public boolean liftResultExists() {
        if (this._liftResultTables == null) {
            this.loadResultsTables();
        }
        return this._liftResultTables.size() > 0;
    }

    public String geRocResultTable(String string) {
        if (this._rocResultTables == null) {
            this.loadResultsTables();
        }
        return this._rocResultTables.get(string);
    }

    public boolean rocResultExists() {
        if (this._rocResultTables == null) {
            this.loadResultsTables();
        }
        return this._rocResultTables.size() > 0;
    }

    public Double getRocAreaUnderCurve(String string) {
        if (this._rocAreaUnderCurves == null) {
            this.loadResultsTables();
        }
        return this._rocAreaUnderCurves.get(string);
    }

    public String getConfusionMatrixTable() {
        return (String)this._data.get(CONFUSION_MATRIX_TABLE_NAME);
    }

    public boolean confusionMatrixExists() {
        return this._data.get(CONFUSION_MATRIX_TABLE_NAME) != null;
    }

    public Vector<String> getTargetValues() {
        if (this._targetValues == null) {
            this.loadResultsTables();
        }
        return this._targetValues;
    }

    public String getLeastTargetValue() {
        String string = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string == null) {
            this.loadMetrics();
        }
        return (String)this._data.get(LEAST_TARGET_VALUE);
    }

    public BigDecimal getPredictiveConfidence() {
        String string = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string == null) {
            this.loadMetrics();
        }
        return (BigDecimal)this._data.get(PREDICTIVE_CONFIDENCE);
    }

    public BigDecimal getAvgAccuracy() {
        String string = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string == null) {
            this.loadMetrics();
        }
        return (BigDecimal)this._data.get(AVG_ACCURACY);
    }

    public BigDecimal getOverallAccuracy() {
        String string = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string == null) {
            this.loadMetrics();
        }
        return (BigDecimal)this._data.get(ACCURACY);
    }

    public BigDecimal getCost() {
        String string = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string == null) {
            this.loadMetrics();
        }
        return (BigDecimal)this._data.get(COST);
    }

    private class TargetComparator
    implements Comparator<String> {
        private TargetComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = 0;
            try {
                Integer n2 = Integer.parseInt(string.toString());
                Integer n3 = Integer.parseInt(string2.toString());
                n = n2.compareTo(n3);
            }
            catch (NumberFormatException numberFormatException) {
                n = string.toString().compareTo(string2.toString());
            }
            return n;
        }
    }
}

