/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DataMinerConnections;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.i18n.text.OraDecimalFormatSymbols;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Version;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.PasswordPrompter;

public class ConnectionFolder
extends BaseTreeNode {
    private Connection _conn = null;
    private Boolean connectionIsValid = false;
    private String _user_name = null;
    private Version _dbVersion = null;
    private static final char DECIMAL_SEPARATOR = '.';
    private static final char GROUPING_SEPARATOR = ',';
    private static final String[] ALTER_SESSION_FIXES = new String[]{"ALTER SESSION set \"_optimizer_reuse_cost_annotations\"=false", "ALTER SESSION set NLS_NUMERIC_CHARACTERS=\".,\""};

    @Override
    public boolean isDeleteable() {
        return true;
    }

    protected Connection getSharedConnection() throws Exception {
        if (this._conn == null) {
            this._conn = DataMinerConnections.getInstance().createPrivateConnection(this.getConnectionName());
            this._dbVersion = ConfigUtils.getDatabaseVersion(this._conn);
        }
        return this._conn;
    }

    public Version getDbVersion() throws Exception {
        if (this._dbVersion == null) {
            this.getSharedConnection();
        }
        return this._dbVersion;
    }

    public Connection getUniqueConnection() throws Exception {
        Connection connection = DataMinerConnections.getInstance().createPrivateConnection(this.getLabel());
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeConnectionLocaleNumberFormat(Connection connection) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            String string = "alter session set NLS_NUMERIC_CHARACTERS=\".,\"";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean isNumericFormatChangeRequired() {
        boolean bl = false;
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((Locale)Locale.getDefault());
        OraDecimalFormatSymbols oraDecimalFormatSymbols = new OraDecimalFormatSymbols(oraLocaleInfo);
        bl = oraDecimalFormatSymbols.getDecimalSeparator() != '.' || oraDecimalFormatSymbols.getGroupingSeparator() != ',';
        return bl;
    }

    public static String getNumericFormatForLocale() {
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((Locale)Locale.getDefault());
        OraDecimalFormatSymbols oraDecimalFormatSymbols = new OraDecimalFormatSymbols(oraLocaleInfo);
        String string = String.valueOf(oraDecimalFormatSymbols.getDecimalSeparator()) + String.valueOf(oraDecimalFormatSymbols.getGroupingSeparator());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentNumericNLSSettingsFromDB(Connection connection) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        String string = null;
        String string2 = null;
        try {
            string = "select parameter, value from NLS_SESSION_PARAMETERS \nwhere parameter = 'NLS_NUMERIC_CHARACTERS'";
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString("value");
            }
        }
        finally {
            sQLHelper.close();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConnectionLocaleNumberFormat(Connection connection, String string) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string2 = "alter session set NLS_NUMERIC_CHARACTERS=\"" + string + "\"";
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.pstmt.execute();
        }
        finally {
            sQLHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConnectionAlterSessionFixes(Connection connection) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            for (int i = 0; i < ALTER_SESSION_FIXES.length; ++i) {
                sQLHelper.pstmt = connection.prepareStatement(ALTER_SESSION_FIXES[i]);
                sQLHelper.pstmt.execute();
            }
        }
        finally {
            sQLHelper.close();
        }
    }

    public static String[] getConnectionAlterSessionFixes() {
        return ALTER_SESSION_FIXES;
    }

    public static Connection getSYSDBAConnection(String string, String string2) {
        Connection connection = null;
        try {
            connection = ConnectionFolder.getConnectionAs(string, string2, "SYSDBA");
        }
        catch (Exception exception) {
            SQLException sQLException;
            int n;
            Throwable throwable = exception.getCause();
            if (throwable instanceof SQLException && (n = (sQLException = (SQLException)throwable).getErrorCode()) == 1017) {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("AUTHENTICATION_FAIL_MSG"), (String)DataminerNavigatorLrb.get("AUTHENTICATION_FAIL_TITLE"), null);
                return null;
            }
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Failed to connect to database.");
            return null;
        }
        return connection;
    }

    private static Connection getConnectionAs(String string, String string2, String string3) throws Exception {
        Properties properties = DatabaseConnections.getInstance().getProperties(string);
        Properties properties2 = (Properties)properties.clone();
        properties2.remove("IS_PROXY");
        properties2.remove("PROXY_USER_PASSWORD");
        properties2.remove("PROXY_TYPE");
        properties2.remove("PROXY_USER_NAME");
        properties2.put("user", string2);
        properties2.remove("password");
        properties2.put("role", string3);
        properties2.put("SavePassword", "false");
        properties2.remove("ConnName");
        properties2.remove("UnsharedWorksheetOriginalConnectionName");
        DatabaseProvider databaseProvider = new DatabaseProvider(properties2);
        Connection connection = null;
        boolean bl = true;
        while (bl) {
            try {
                properties2.remove("password");
                connection = databaseProvider.getConnection();
                bl = false;
            }
            catch (SQLException sQLException) {
                if (sQLException instanceof ConnectionCanceledException) {
                    bl = false;
                    continue;
                }
                if (sQLException instanceof SQLException) {
                    int n = sQLException.getErrorCode();
                    if (n != 1017 && n != 28150) continue;
                    MessageDialog.critical((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)"Authentication Failure", null);
                    continue;
                }
                throw sQLException;
            }
        }
        PasswordPrompter passwordPrompter = DatabaseProviderHelper.getPasswordPrompter();
        passwordPrompter.disconnect(properties2);
        return connection;
    }

    public String getUserAccountName() throws Exception {
        if (this._user_name == null) {
            Connection connection = this.getSharedConnection();
            this._user_name = this.getUserNameFromDB(connection);
        }
        return this._user_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUserNameFromDB(Connection connection) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        String string = null;
        try {
            String string2 = "select SYS_CONTEXT ('USERENV', 'SESSION_USER') as USER_NAME from dual";
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string2);
            if (sQLHelper.rs.next()) {
                string = sQLHelper.rs.getString("USER_NAME");
            }
        }
        finally {
            sQLHelper.close();
        }
        return string;
    }

    public String getUserAccountNameFromConnectionProperties() throws ConnectionException, DBException {
        Properties properties = DatabaseConnections.getInstance().getProperties(this.getLabel());
        String string = properties.getProperty("user");
        String string2 = string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
        assert (string != null) : "Username of a connection cannot be null";
        return string != null ? string : null;
    }

    public Icon getIcon() {
        if (this._conn == null) {
            return OracleIcons.getIcon((String)"database.png");
        }
        return OracleIcons.getIcon((String)"dbconn.png");
    }

    public boolean isConnected() {
        return this._conn != null;
    }

    public static ConnectionFolder getConnectionFolder(Context context) {
        Object object;
        ConnectionFolder connectionFolder = null;
        Object object2 = context.getNode();
        if (object2 == null) {
            object = context.getSelection();
            assert (object != null) : "Selection is null";
            object2 = ((Element[])object).length != 0 ? (Node)object[0] : null;
        }
        object = (DataMinerNode)object2;
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Connections) {
            return null;
        }
        connectionFolder = object2 instanceof ConnectionFolder ? (ConnectionFolder)object2 : object.getConnectionFolder();
        assert (connectionFolder != null) : "Unable to get connection folder.";
        return connectionFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() {
        if (this._conn != null) {
            try {
                DataMinerConnections.getInstance().closePrivateConnection(this.getLabel());
                this.connectionIsValid = false;
                this._dbVersion = null;
                this._conn.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this._conn = null;
            }
        }
    }

    public String getConnectionName() {
        return this.getLabel();
    }

    public static void delete(Element[] elementArray) throws Exception {
        DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
        final Connections connections = Connections.getInstance();
        for (Element element : elementArray) {
            final ConnectionFolder connectionFolder = (ConnectionFolder)element;
            databaseConnections.removeConnection(connectionFolder.getConnectionName());
            connectionFolder.closeConnection();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Iterator<Element> iterator = connectionFolder.getChildren();
                    while (iterator.hasNext()) {
                        ((DataMinerNode)iterator.next()).closeChildren();
                    }
                    connections.remove((Element)connectionFolder, true);
                    UpdateMessage.fireChildRemoved((Subject)connections, (Element)connectionFolder);
                    connections.markDirty(false);
                }
            });
        }
        databaseConnections.saveConnections();
    }

    public void disconnect() throws Exception {
        Iterator<Element> iterator = this.getChildren();
        while (iterator.hasNext()) {
            ((DataMinerNode)iterator.next()).closeChildren();
        }
        this.removeAll();
        this.close();
    }

    public BigDecimal getId() {
        return null;
    }

    public void setConnectionValidated(Boolean bl) {
        this.connectionIsValid = bl;
    }

    public Boolean isConnectionValidated() {
        return this.connectionIsValid;
    }

    public static boolean checkDatabase(Connection connection) throws Exception {
        if (!ConfigUtils.isCompatibleDatabase(connection)) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("INCOMPATIBLE_DB"), (String)DataminerNavigatorLrb.get("CONNECTION_ERROR"), null);
            return false;
        }
        if (!ConfigUtils.isDataMiningOptionInstalled(connection)) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("NO_DATAMINING_OPTION"), (String)DataminerNavigatorLrb.get("CONNECTION_ERROR"), null);
            return false;
        }
        return true;
    }

    public boolean checkConnection() throws Exception {
        boolean bl;
        CharSequence charSequence;
        if (this.isConnectionValidated().booleanValue()) {
            return true;
        }
        Connection connection = this.getSharedConnection();
        if (!ConfigUtils.isValidUserConnection(this.getLabel()).booleanValue()) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("SYSDBA_CONN_NOT_ALLOWED"), (String)DataminerNavigatorLrb.get("SYSDBA_CONN_NOT_ALLOWED_TITLE"), null);
            return false;
        }
        if (!ConnectionFolder.checkDatabase(connection)) {
            return false;
        }
        ConfigUtils.TextAndXMLDBState textAndXMLDBState = ConfigUtils.isTextAndXMLDBInstalled(connection);
        if (textAndXMLDBState != ConfigUtils.TextAndXMLDBState.BOTH) {
            String string = "";
            switch (textAndXMLDBState) {
                case NONE: {
                    string = DataminerNavigatorLrb.get("NO_TEXT_OR_XMLDB_OPTION");
                    break;
                }
                case XML_DB_ONLY: {
                    string = DataminerNavigatorLrb.get("NO_TEXT_OPTION");
                    break;
                }
                case TEXT_ONLY: {
                    string = DataminerNavigatorLrb.get("NO_XMLDB_OPTION");
                    break;
                }
                default: {
                    string = DataminerNavigatorLrb.get("NO_DATAMINING_OPTION");
                }
            }
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)string, (String)DataminerNavigatorLrb.get("CONNECTION_ERROR"), (String)"textOrXMLDBAreMissing");
            return false;
        }
        if (this.getDbVersion().toCanonicalString().startsWith("12.")) {
            MessageDialog.optionalInformation((String)"oracle.dmt.dataminer.navigator.ConnectionFolder.12.1Warning", (Component)Ide.getMainWindow(), (String)DataminerNavigatorLrb.get("NOT_CERTIFIED_ON_DB"), (String)DataminerNavigatorLrb.get("CONNECTION_WARNING"), (String)"DataminerSupportOfDB12");
        }
        if (!ConfigUtils.isODMRSYSLoaded(connection)) {
            boolean bl2 = ConfigUtils.isODMRSYSNotLoaded(connection);
            String string = DataminerNavigatorLrb.get("REPOSITORY_MISSING_MSG");
            if (bl2) {
                string = DataminerNavigatorLrb.get("REPOSITORY_NOT_LOADED_MSG");
            }
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)DataminerNavigatorLrb.get("REPOSITORY_MISSING_TITLE"), null)) {
                return false;
            }
            this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.RunMode.INSTALLSCHEMA);
            return false;
        }
        ConfigUtils.Compatibility compatibility = null;
        try {
            compatibility = ConfigUtils.Compatibility.getCompatibility(connection);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            return false;
        }
        int n = compatibility.getCompatibilityLevel();
        if (n != 1) {
            charSequence = UtilsLrb.get("CLIENT_VERSION");
            String string = UtilsLrb.get("REPOS_VERSION");
            if (n == 2) {
                String string2 = UtilsLrb.get("NOT_COMPAT_OLD_APP") + (String)charSequence + compatibility.getClientVersion().toString() + "\n" + (String)string + compatibility.getReposVersion().toString() + "\n";
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)string2, (String)UtilsLrb.get("NOT_COMPAT_OLD_APP_TITLE"), null);
                return false;
            }
            if (n == 5) {
                String string3 = UtilsLrb.get("REPOS_NOT_COMPATIBLE_OVERWRITE_PROMPT") + (String)charSequence + compatibility.getClientVersion().toString() + "\n" + (String)string + compatibility.getReposVersion().toString() + "\n";
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string3, (String)UtilsLrb.get("NOT_COMPAT_OLD_REPOS_TITLE"), null)) {
                    return false;
                }
                this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.RunMode.INSTALLSCHEMA);
                return false;
            }
            if (n == 3) {
                String string4 = UtilsLrb.get("REPOS_NOT_COMPATIBLE_UPGRADE_PROMPT") + (String)charSequence + compatibility.getClientVersion().toString() + "\n" + (String)string + compatibility.getReposVersion().toString() + "\n" + UtilsLrb.get("REPOS_VERSION_AFTER_UPGRADE") + ConfigUtils.getCurrentRepositoryVersion();
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string4, (String)UtilsLrb.get("REPOS_NOT_COMPATIBLE_UPGRADE_TITLE"), (String)"UpgradeRepository")) {
                    return false;
                }
                this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.RunMode.UPGRADE_REPOS);
                return false;
            }
            if (n == 4) {
                String string5 = UtilsLrb.get("REPOS_NOT_COMPATIBLE_MIGRATE_PROMPT") + (String)charSequence + compatibility.getClientVersion().toString() + "\n" + (String)string + compatibility.getReposVersion().toString() + "\n" + UtilsLrb.get("REPOS_VERSION_AFTER_MIGRATE") + ConfigUtils.getCurrentRepositoryVersion();
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string5, (String)UtilsLrb.get("REPOS_NOT_COMPATIBLE_MIGRATE_TITLE"), null)) {
                    return false;
                }
                return false;
            }
            if (n == 6) {
                String string6 = UtilsLrb.get("REPOS_NOT_COMPATIBLE_OR_MIGRATABLE_PROMPT") + (String)charSequence + compatibility.getClientVersion().toString() + "\n" + (String)string + compatibility.getReposVersion().toString() + "\n";
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string6, (String)UtilsLrb.get("NOT_COMPAT_UNKNOWN_REPOS_TITLE"), null)) {
                    return false;
                }
                this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.RunMode.INSTALLSCHEMA);
                return false;
            }
            if (n == 7) {
                String string7 = UtilsLrb.get("XML_SCHEMA_VERSION");
                String string8 = UtilsLrb.get("DB_VERSION");
                String string9 = UtilsLrb.get("REPOS_NOT_COMPATIBLE_SCHEMA_MIGRATE_PROMPT") + (String)charSequence + compatibility.getClientVersion().toString() + "\n" + (String)string + compatibility.getReposVersion().toString() + "\n" + string8 + compatibility.getDBVersion().toString() + "\n" + string7 + compatibility.getXmlSchemaVersion().toString() + "\n";
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string9, (String)UtilsLrb.get("XML_SCHEMA_NOT_COMPATIBLE_MIGRATE_TITLE"), null)) {
                    return false;
                }
                this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.RunMode.UPGRADE_REPOS);
                return false;
            }
        }
        if (!(bl = ConfigUtils.isODMPrivsPresent(connection))) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("GRANTS_MISSING_MSG"), (String)DataminerNavigatorLrb.get("GRANTS_MISSING_TITLE"), null)) {
                return false;
            }
            this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.RunMode.GRANTS);
            return false;
        }
        ArrayList<String> arrayList = ConfigUtils.isODMUserPrivsPresent(connection);
        if (!arrayList.isEmpty()) {
            charSequence = new StringBuffer();
            for (String string : arrayList) {
                ((StringBuffer)charSequence).append(string + "\n");
            }
            System.out.print("Missing DataMiner Grants:\n" + charSequence);
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("GRANTS_DIRECT_USER_MISSING_MSG"), (String)DataminerNavigatorLrb.get("GRANTS_MISSING_TITLE"), null)) {
                return false;
            }
            this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.RunMode.GRANTS);
            return false;
        }
        this.setConnectionValidated(Boolean.TRUE);
        return true;
    }

    public String getQualifiedConnectionName() {
        String string = DMURLFormatHelper.getConnectionName(this.getURL());
        return DataMinerConnections.getQualifiedName(string);
    }

    private void configureConnection(final Context context, final String string, final ConfigUtils.RunMode runMode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigUtils.configureConnection(context, string, runMode);
            }
        });
    }

    protected void closeImpl() throws IOException {
        this.closeConnection();
    }
}

