/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.ScrollPaneLayout;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseTreeTable;
import oracle.dmt.dataminer.controls.GenericTableSimpleTransferHandler;
import oracle.dmt.dataminer.controls.ReadOnlyCostMatrixModel;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerGeneralTreeTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerSignatureTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerState;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ARModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.server.model.MiningAttributeInfo;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.model.TargetValuesPanel;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JTabbedPane2;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class SettingsViewerTabPanel
extends DataMinerViewGUI
implements ActionListener {
    static final String SETTINGS_VIEWER_ID = "SETTINGS_VIEWER_ID";
    SettingsViewerState _state;
    private GenericTable _genericTableModelSignature;
    private GenericTable genericTableCostMatrix;
    private GenericTable genericTableWeights;
    private JCheckBox jCheckBox1;
    private JPanel jCostMatrix;
    private JLabel jLabel2;
    private JLabel jLabelCostMatrix;
    private JLabel jLabelWeifgts;
    private JPanel jModelSettings;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPaneCostMatrix;
    private JScrollPane jScrollPaneSettings;
    private JScrollPane jScrollPaneSignature;
    private JScrollPane jScrollPaneWeights;
    private JScrollPane jScrollPaneXform;
    private JPanel jSignature;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane;
    private JTextArea jTextArea1;
    private JPanel jWeights;
    private int _lastSelectedIindex = -1;
    private SettingsTreeTable _jSettingsTreeTable;
    private static String _target = SettingsLrb.get("ATTRIBUTE_TARGET_YES");
    private static Icon _target_icon = UIResourceHelper.getImageIcon(SettingsViewerTabPanel.class, SettingsLrb.get("TARGET_ATTRIBUTE_ICON"));

    public SettingsViewerTabPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        ModelNode modelNode = (ModelNode)context.getNode();
        if (!modelNode.isModelExists().booleanValue()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        this._state = new SettingsViewerState(this._context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane2();
        this.jModelSettings = new JPanel();
        this.jScrollPaneSettings = new JScrollPane();
        this.jSignature = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPaneSignature = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jScrollPaneXform = new JScrollPane();
        this._genericTableModelSignature = new GenericTable();
        this.jWeights = new JPanel();
        this.jLabelWeifgts = new JLabel();
        this.jScrollPaneWeights = new JScrollPane();
        this.genericTableWeights = new GenericTable();
        this.jCostMatrix = new JPanel();
        this.jScrollPaneCostMatrix = new JScrollPane();
        this.genericTableCostMatrix = new BaseCostMatrixTable();
        this.jLabelCostMatrix = new JLabel();
        GroupLayout groupLayout = new GroupLayout(this.jModelSettings);
        this.jModelSettings.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneSettings, -1, 504, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneSettings, -1, 366, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Settings", this.jModelSettings);
        this.jSplitPane1.setDividerLocation(600);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jScrollPaneSignature.setViewportView(this.jTextArea1);
        this.jLabel2.setText("jLabel2");
        this.jCheckBox1.setText("jCheckBox1");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jLabel2, -2, 166, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 119, Short.MAX_VALUE).addComponent(this.jCheckBox1, -2, 217, -2)).addComponent(this.jScrollPaneSignature, GroupLayout.Alignment.TRAILING, -1, 502, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneSignature, -2, 23, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setBottomComponent(this.jPanel1);
        this._genericTableModelSignature.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneXform.setViewportView((Component)this._genericTableModelSignature);
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneXform, -1, 502, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneXform, -1, 286, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        GroupLayout groupLayout4 = new GroupLayout(this.jSignature);
        this.jSignature.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -1, 528, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -1, 392, Short.MAX_VALUE));
        this.jTabbedPane.addTab("Signature", this.jSignature);
        this.jLabelWeifgts.setText("jLabel3");
        this.genericTableWeights.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneWeights.setViewportView((Component)this.genericTableWeights);
        GroupLayout groupLayout5 = new GroupLayout(this.jWeights);
        this.jWeights.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneWeights, -1, 504, Short.MAX_VALUE).addComponent(this.jLabelWeifgts, -2, 120, -2)).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jLabelWeifgts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneWeights, -1, 343, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Weights", this.jWeights);
        this.genericTableCostMatrix.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneCostMatrix.setViewportView((Component)this.genericTableCostMatrix);
        this.jLabelCostMatrix.setText("jLabel3");
        GroupLayout groupLayout6 = new GroupLayout(this.jCostMatrix);
        this.jCostMatrix.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneCostMatrix, -1, 504, Short.MAX_VALUE).addComponent(this.jLabelCostMatrix, -2, 152, -2)).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.jLabelCostMatrix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneCostMatrix, -1, 343, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane.addTab("Cost Matrix", this.jCostMatrix);
        GroupLayout groupLayout7 = new GroupLayout(this);
        this.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addComponent(this.jTabbedPane, -1, 533, Short.MAX_VALUE).addContainerGap()));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 422, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        this.jCheckBox1.setText(SettingsLrb.get("SHOW_REVERSEOEXPR"));
        this.jLabel2.setText(SettingsLrb.get("MODEL_XFORM"));
        this.jLabelCostMatrix.setText(SettingsLrb.get("COST_MATRIX_TABLE_TITLE"));
        this.jLabelWeifgts.setText(SettingsLrb.get("MODEL_WEIGHTS"));
    }

    @Override
    public void initUI() {
        this.jCheckBox1.addActionListener(this);
        this._jSettingsTreeTable = new SettingsTreeTable(this._state.getGeneralTreeTableModel());
        this._jSettingsTreeTable.setRootInvisible();
        this._jSettingsTreeTable.hideHandles();
        this._jSettingsTreeTable.setShowGrid(true);
        this._jSettingsTreeTable.setAutoResizeMode(3);
        this.jScrollPaneSettings.setLayout(new CustomScrollPaneLayout());
        this.jScrollPaneSettings.setViewportView((Component)((Object)this._jSettingsTreeTable));
        this.setLoading(true);
        this.initializeControls();
        Dimension dimension = new Dimension(0, 0);
        this.jPanel2.setMinimumSize(dimension);
        this.jPanel1.setMinimumSize(dimension);
        this.jSplitPane1.setDividerLocation(700);
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    public String getID() {
        return SETTINGS_VIEWER_ID;
    }

    private void initializeControls() {
        this.setupDummyTreeTable(SettingsLrb.get("SETTINGS_LOADING"));
        int n = this.jTabbedPane.indexOfComponent(this.jModelSettings);
        this.jTabbedPane.setTitleAt(n, SettingsLrb.get("MODEL_SETTINGS"));
        this.hideCostMatrixTab();
        this.hideWeightsTab();
        this.hideSignatureTab();
    }

    private void setupWeights() {
        GenericBaseTableModel genericBaseTableModel = this._state.getWeightsModel();
        if (genericBaseTableModel == null) {
            return;
        }
        this.setupWeightTable(this._state.getWeightsModel());
    }

    private void hideWeightsTab() {
        this.jTabbedPane.remove(this.jWeights);
    }

    private void hideSignatureTab() {
        this.jTabbedPane.remove(this.jSignature);
    }

    private void setupDummyWeights(String string) {
        this.setupWeightTable(this._state.createDummyWeightModel(string));
    }

    private void setupTargetValues() {
        if (this._state.getTargetValues() == null) {
            return;
        }
        MiningAttributeInfo miningAttributeInfo = this._state.getSignatureTableModel().getTargetAttributeInfo();
        String string = "";
        String string2 = "";
        if (miningAttributeInfo != null) {
            string = miningAttributeInfo.getAttributeName();
            string2 = miningAttributeInfo.getDataType();
        }
        TargetValuesPanel targetValuesPanel = new TargetValuesPanel(string, string2, this._state.getTargetValues());
        this.jTabbedPane.addTab(SettingsLrb.get("MODEL_TARGET_VALUES"), targetValuesPanel);
    }

    private void setupWeightTable(GenericBaseTableModel genericBaseTableModel) {
        this.genericTableWeights.setModel((TableModel)genericBaseTableModel);
        this.genericTableWeights.setSorted(false);
        this.genericTableWeights.getTableHeader().setReorderingAllowed(false);
        this.jTabbedPane.addTab(SettingsLrb.get("MODEL_WEIGHTS"), this.jWeights);
    }

    private void setupDummyTreeTable(String string) {
        this._state.loadTempStatusTreeTable(string);
    }

    private void setupTreeTable() {
        this._state.loadTree();
        int n = this._state.getMaxStringLength();
        Dimension dimension = this._jSettingsTreeTable.getPreferredSize();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            int n2;
            Font font = this._jSettingsTreeTable.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            dimension.width = n2 = fontMetrics.stringWidth("W") * n;
            this._jSettingsTreeTable.setPreferredSize(dimension);
        }
        this._jSettingsTreeTable.expandAll(true);
    }

    private void setupDummyCostMatrix(String string) {
        ReadOnlyCostMatrixModel readOnlyCostMatrixModel = this._state.createDummyCostMatrix(string);
        ((BaseCostMatrixTable)this.genericTableCostMatrix).setModel(readOnlyCostMatrixModel);
    }

    private void hideCostMatrixTab() {
        this.jTabbedPane.remove(this.jCostMatrix);
    }

    private void setupCostMatrixTable() {
        ReadOnlyCostMatrixModel readOnlyCostMatrixModel = this._state.getCostMatrix();
        if (readOnlyCostMatrixModel == null) {
            return;
        }
        ((BaseCostMatrixTable)this.genericTableCostMatrix).setModel(this._state.getCostMatrix());
        this.jTabbedPane.addTab(SettingsLrb.get("MODEL_COST_MATRIX"), this.jCostMatrix);
    }

    private void setupSignatureTable(SettingsViewerSignatureTableModel settingsViewerSignatureTableModel) {
        if (settingsViewerSignatureTableModel == null) {
            return;
        }
        this._genericTableModelSignature.setModel((TableModel)((Object)settingsViewerSignatureTableModel));
        this._genericTableModelSignature.setShowGrid(true);
        this._genericTableModelSignature.setSorted(true);
        this._genericTableModelSignature.setUpdateSelectionOnSort(true);
        this._genericTableModelSignature.getTableHeader().setReorderingAllowed(false);
        this._genericTableModelSignature.setSelectionMode(2);
        TableColumn tableColumn = this._genericTableModelSignature.getColumnModel().getColumn(3);
        ModelNode modelNode = (ModelNode)this._context.getNode();
        if (modelNode instanceof DTModelNode || modelNode instanceof GLMCModelNode || modelNode instanceof GLMRModelNode || modelNode instanceof SVMCModelNode || modelNode instanceof SVMRModelNode || modelNode instanceof NBModelNode) {
            tableColumn.setCellRenderer(new CustomTargetCellRenderer());
        } else {
            this._genericTableModelSignature.removeColumn(tableColumn);
        }
        this._genericTableModelSignature.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = SettingsViewerTabPanel.this._genericTableModelSignature.getSelectedRowsInModel();
                if (0 == nArray.length) {
                    SettingsViewerTabPanel.this._lastSelectedIindex = -1;
                    SettingsViewerTabPanel.this._state.setLastSelectedAttribute(SettingsViewerTabPanel.this._lastSelectedIindex);
                    SettingsViewerTabPanel.this.setXfrom();
                    return;
                }
                if (nArray.length > 1) {
                    SettingsViewerTabPanel.this.jTextArea1.setText(SettingsLrb.get("MULTIPLE_ATTRIBUTE_SELECTION"));
                    return;
                }
                int n = nArray[0];
                if (n >= 0 && SettingsViewerTabPanel.this._lastSelectedIindex != n) {
                    SettingsViewerTabPanel.this._lastSelectedIindex = n;
                    SettingsViewerTabPanel.this._state.setLastSelectedAttribute(SettingsViewerTabPanel.this._lastSelectedIindex);
                    SettingsViewerTabPanel.this.setXfrom();
                }
            }
        });
        this._genericTableModelSignature.setSortColumn(0, true);
        this._genericTableModelSignature.setFillsViewportHeight(true);
        this._genericTableModelSignature.setDragEnabled(true);
        this._genericTableModelSignature.setTransferHandler((TransferHandler)new GenericTableSimpleTransferHandler());
        this.jTabbedPane.addTab(SettingsLrb.get("MODEL_SIGNATURE_ATTRIBUTES"), this.jSignature);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.jCheckBox1)) {
            this.setXfrom();
        }
    }

    private void setXfrom() {
        this.jTextArea1.setText("");
        MiningAttributeInfo miningAttributeInfo = this._state.getLastSelectedAttribute();
        if (miningAttributeInfo == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = miningAttributeInfo.getExpression();
        if (stringBuffer2 != null && 0 != stringBuffer2.length()) {
            StringBuffer stringBuffer3;
            stringBuffer.append(SettingsLrb.get("MODEL_XFORM_TITLE"));
            stringBuffer.append("\n\t");
            stringBuffer.append(stringBuffer2);
            if (this.jCheckBox1.isSelected() && (stringBuffer3 = miningAttributeInfo.getRevExpression()) != null && 0 != stringBuffer3.length()) {
                stringBuffer.append("\n");
                stringBuffer.append(SettingsLrb.get("MODEL_REV_XFORM_TITLE"));
                stringBuffer.append("\n\t");
                stringBuffer.append(stringBuffer3);
            }
        }
        this.jTextArea1.setText(stringBuffer.toString());
    }

    public HelpInfo getHelpInfo() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        String string = "Help Topic Not Specified";
        if (modelNode instanceof ARModelNode) {
            string = "ar_view_settings";
        } else if (modelNode instanceof DTModelNode) {
            string = "tree_diagram_settings";
        } else if (modelNode instanceof GLMCModelNode) {
            string = "glmc_settings";
        } else if (modelNode instanceof GLMRModelNode) {
            string = "glmr_settings_help";
        } else if (modelNode instanceof SVMCModelNode) {
            string = "svmc_settings";
        } else if (modelNode instanceof ANModelNode) {
            string = "ad_viewer_settings";
        } else if (modelNode instanceof SVMRModelNode) {
            string = "svmr_settings";
        } else if (modelNode instanceof NMFModelNode) {
            string = "nmf_viewer_settings";
        } else if (modelNode instanceof NBModelNode) {
            string = "nb_viewer_settings";
        } else if (modelNode instanceof OCModelNode) {
            string = "oc_viewer_settings";
        } else if (modelNode instanceof KMModelNode) {
            string = "km_viewer_settings";
        }
        return new HelpInfo(string);
    }

    private class CustomTargetCellRenderer
    extends DefaultTableCellRenderer {
        private CustomTargetCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object.toString().equals(_target)) {
                this.setIcon(_target_icon);
            } else {
                this.setIcon(null);
            }
            this.setText("");
            return component;
        }
    }

    private class CustomCellRenderer
    extends DefaultTreeCellRenderer {
        private SettingsTreeTable _parent;

        CustomCellRenderer(SettingsTreeTable settingsTreeTable) {
            this._parent = settingsTreeTable;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            SettingsViewerGeneralTreeTableModel.ModelSettingsNode modelSettingsNode = (SettingsViewerGeneralTreeTableModel.ModelSettingsNode)object;
            this.setText(modelSettingsNode.getLabel());
            this.setIcon(null);
            if (modelSettingsNode.isFolderNode()) {
                if (this._parent._leaffont == null) {
                    this._parent._leaffont = component.getFont();
                    this._parent._folderfont = component.getFont().deriveFont(1);
                }
                this.setFont(this._parent._folderfont);
            } else if (modelSettingsNode.isLeafNode()) {
                this.setFont(this._parent._leaffont);
            }
            return component;
        }
    }

    class CustomBasicUI
    extends BasicTreeUI {
        CustomBasicUI() {
        }

        @Override
        protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        }

        @Override
        protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        }
    }

    class SettingsTreeTable
    extends BaseTreeTable {
        private Font _leaffont;
        private Font _folderfont;

        SettingsTreeTable(SettingsViewerGeneralTreeTableModel settingsViewerGeneralTreeTableModel) {
            super((TreeTableModel)settingsViewerGeneralTreeTableModel);
            this.setIconRenderer();
        }

        private void setIconRenderer() {
            this.getTree().setCellRenderer(new CustomCellRenderer(this));
        }

        public void hideHandles() {
            SettingsViewerTabPanel.this._jSettingsTreeTable.getTree().setUI(new CustomBasicUI());
        }

        public boolean getScrollableTracksViewportWidth() {
            if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                boolean bl = ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
                return bl;
            }
            return false;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    SettingsViewerTabPanel.this._state.reloadAttributes();
                } else {
                    SettingsViewerTabPanel.this._state.load();
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return SettingsViewerTabPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    SettingsViewerTabPanel.this.setupTreeTable();
                    SettingsViewerTabPanel.this.setupSignatureTable(SettingsViewerTabPanel.this._state.getSignatureTableModel());
                    SettingsViewerTabPanel.this.setupCostMatrixTable();
                    SettingsViewerTabPanel.this.setupWeights();
                    SettingsViewerTabPanel.this.setupTargetValues();
                    SettingsViewerTabPanel.this.setLoaded(true);
                } else {
                    SettingsViewerTabPanel.this.setupDummyTreeTable(SettingsLrb.get("SETTINGS_LOADING_ERROR"));
                    SettingsViewerTabPanel.this.setupDummyCostMatrix(SettingsLrb.get("COST_MATRIX_FAILURE"));
                    SettingsViewerTabPanel.this.setupDummyWeights(SettingsLrb.get("WEIGHTS_FAILURE"));
                    if (SettingsViewerTabPanel.this._state.getSignatureTableModel() != null) {
                        SettingsViewerTabPanel.this._state.getSignatureTableModel().clearRows();
                        MiningAttributeInfo miningAttributeInfo = new MiningAttributeInfo();
                        miningAttributeInfo.setAttributeName(SettingsLrb.get("ATTRIBUTE_FAILURE"));
                        SettingsViewerTabPanel.this._state.getSignatureTableModel().addRow(miningAttributeInfo);
                        SettingsViewerTabPanel.this.setupSignatureTable(SettingsViewerTabPanel.this._state.getSignatureTableModel());
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), (String)SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), (String)SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), (String)SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                SettingsViewerTabPanel.this.setLoading(false);
            }
        }
    }

    private class CustomScrollPaneLayout
    extends ScrollPaneLayout {
        CustomScrollPaneLayout() {
            this.addLayoutComponent("HORIZONTAL_SCROLLBAR", new JScrollBar());
        }
    }
}

