/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dmt.dataminer.controls.BaseTreeTableNode;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;

public class SettingsViewerGeneralTreeTableModel
extends AbstractTreeTableModel {
    private int _maxStrLength;
    private ModelSettingsNode _root = new ModelSettingsNode();
    private static final int COLUMN_COUNT = 2;
    public static final int SETTING_NAME = 0;
    public static final int SETTING_VALUE = 1;
    private static String[] _columnNames = new String[]{SettingsLrb.get("SETTING_NAME"), SettingsLrb.get("SETTING_VALUE")};
    private static String _NOT_BUILT = SettingsLrb.get("BUILD_MODEL_NOT_BUILT");

    public Object getRoot() {
        return this._root;
    }

    public SettingsViewerGeneralTreeTableModel() {
        super((Object)new DefaultMutableTreeNode("-"));
    }

    public int getMaxStringLength() {
        return this._maxStrLength;
    }

    public int getChildCount(Object object) {
        return ((DefaultMutableTreeNode)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((DefaultMutableTreeNode)object).getChildAt(n);
    }

    public Class getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return _columnNames[n];
    }

    public Object getValueAt(Object object, int n) {
        return object instanceof ModelSettingsNode ? ((ModelSettingsNode)object).getValue(n) : "";
    }

    void loadTempStatusNode(String string) {
        if (this._root.getChildCount() > 0) {
            this._root.removeAllChildren();
        }
        ModelSettingsNode modelSettingsNode = new ModelSettingsNode(string);
        this._root.add(modelSettingsNode);
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{this._root}, null, null);
    }

    public void loadTree(Model model) {
        this.loadGeneralSettings(model.getModelGeneralDescription());
        this.loadMiningModelSettings(model.getModelSettings());
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{this._root}, null, null);
    }

    public boolean isCellEditable(Object object, int n) {
        if (n == 0) {
            return true;
        }
        return super.isCellEditable(object, n);
    }

    private void loadGeneralSettings(ModelGeneralDescription modelGeneralDescription) {
        BigDecimal bigDecimal;
        String string;
        BigDecimal bigDecimal2;
        if (this._root.getChildCount() > 0) {
            this._root.removeAllChildren();
        }
        ModelSettingsNode modelSettingsNode = new ModelSettingsNode(SettingsLrb.get("GENERAL"));
        this._root.add(modelSettingsNode);
        String string2 = ServerConstants.MiningFunction.getUIFunctionName(modelGeneralDescription.getMiningFunction());
        ModelSettingsNode modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("MODEL_TYPE"), string2);
        modelSettingsNode.add(modelSettingsNode2);
        this._maxStrLength = string2.length();
        modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("MODEL_OWNER"), modelGeneralDescription.getOwner());
        modelSettingsNode.add(modelSettingsNode2);
        if (null != modelGeneralDescription.getOwner()) {
            this._maxStrLength = Math.max(this._maxStrLength, modelGeneralDescription.getOwner().length());
        }
        modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("MODEL_NAME"), modelGeneralDescription.getModelName());
        modelSettingsNode.add(modelSettingsNode2);
        if (null != modelGeneralDescription.getModelName()) {
            this._maxStrLength = Math.max(this._maxStrLength, modelGeneralDescription.getModelName().length());
        }
        if (modelGeneralDescription.getTargetAttributeName() != null) {
            modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("TARGET_NAME"), modelGeneralDescription.getTargetAttributeName());
            modelSettingsNode.add(modelSettingsNode2);
            if (null != modelGeneralDescription.getTargetAttributeName()) {
                this._maxStrLength = Math.max(this._maxStrLength, modelGeneralDescription.getTargetAttributeName().length());
            }
        }
        Date date = modelGeneralDescription.getCreationDate();
        DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        String string3 = date != null ? dateFormat.format(new java.util.Date(date.getTime())) : _NOT_BUILT;
        modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("CREATION_DATE"), string3);
        modelSettingsNode.add(modelSettingsNode2);
        if (null != string3) {
            this._maxStrLength = Math.max(this._maxStrLength, string3.length());
        }
        if ((bigDecimal2 = modelGeneralDescription.getBuildDuration()) != null) {
            double d = bigDecimal2.doubleValue() / 60.0;
            string = NumericFormat.format(d, true, 4);
        } else {
            string = "";
        }
        modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("DURATION"), string);
        modelSettingsNode.add(modelSettingsNode2);
        if (null != string) {
            this._maxStrLength = Math.max(this._maxStrLength, string.length());
        }
        String string4 = (bigDecimal = modelGeneralDescription.getModelSize()) != null ? NumericFormat.format(bigDecimal.doubleValue(), true, 4) : "";
        modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("SIZE"), string4);
        modelSettingsNode.add(modelSettingsNode2);
        if (null != string4) {
            this._maxStrLength = Math.max(this._maxStrLength, string4.length());
        }
        modelSettingsNode2 = new ModelSettingsNode(SettingsLrb.get("COMMENT"), modelGeneralDescription.getComments());
        modelSettingsNode.add(modelSettingsNode2);
        if (null != modelGeneralDescription.getComments()) {
            this._maxStrLength = Math.max(this._maxStrLength, modelGeneralDescription.getComments().length());
        }
    }

    private void loadMiningModelSettings(Vector<MiningModelSettings> vector) {
        Object object;
        ModelSettingsNode modelSettingsNode = new ModelSettingsNode(SettingsLrb.get("ALGORITHM"));
        this._root.add(modelSettingsNode);
        class NameValueStringPair
        implements Comparable {
            String name;
            String value;

            NameValueStringPair(String string, String string2) {
                this.name = string;
                this.value = string2;
            }

            public int compareTo(Object object) {
                NameValueStringPair nameValueStringPair = (NameValueStringPair)object;
                return this.name.compareTo(nameValueStringPair.name);
            }
        }
        ArrayList<NameValueStringPair> arrayList = new ArrayList<NameValueStringPair>();
        for (int i = 0; i < vector.size(); ++i) {
            MiningModelSettings object2 = vector.get(i);
            object = MiningModelSettings.translateModelSettingsName(object2.getSettingName());
            if (object == null) continue;
            String string = MiningModelSettings.translateModelSettingsValue(object2.getSettingValue());
            String string2 = string != null ? string : object2.getSettingValue();
            arrayList.add(new NameValueStringPair((String)object, string2));
        }
        Collections.sort(arrayList);
        for (NameValueStringPair nameValueStringPair : arrayList) {
            object = new ModelSettingsNode(nameValueStringPair.name, nameValueStringPair.value);
            modelSettingsNode.add((MutableTreeNode)object);
        }
    }

    public static class ModelSettingsNode
    extends BaseTreeTableNode {
        protected int _type;
        protected int _ROOT = 0;
        protected int _FOLDER = 1;
        protected int _LEAF = 2;
        protected HashMap<String, Object> _values = new HashMap();

        public int getColumnCount() {
            return _columnNames.length;
        }

        public String getColumnName(int n) {
            return _columnNames[n];
        }

        public ModelSettingsNode() {
            this._type = this._ROOT;
            this._values.put(_columnNames[0], "-");
            this._values.put(_columnNames[1], "");
        }

        public ModelSettingsNode(String string) {
            this._type = this._FOLDER;
            this._values.put(_columnNames[0], string);
            this._values.put(_columnNames[1], "");
        }

        public ModelSettingsNode(String string, String string2) {
            this._type = this._LEAF;
            this._values.put(_columnNames[0], string);
            this._values.put(_columnNames[1], string2);
        }

        public Object getValue(int n) {
            Object object = this._values.get(_columnNames[n]);
            return object != null ? object : "";
        }

        public void setValue(Object object, int n) {
            this._values.put(_columnNames[n], object);
        }

        public boolean isFolderNode() {
            return this._type == this._FOLDER;
        }

        public boolean isLeafNode() {
            return this._type == this._LEAF;
        }

        public boolean isRootNode() {
            return this._type == this._ROOT;
        }

        @Override
        public String toString() {
            return this._values.get(_columnNames[0]).toString();
        }

        public String getLabel() {
            return this.toString();
        }
    }
}

