/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.util.ArrayList;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;

public class SettingsViewerGeneralTableModel
extends GenericBaseTableModel {
    private static final int COLUMN_COUNT = 2;
    public static final int SETTING_NAME = 0;
    public static final int SETTING_VALUE = 1;
    private ArrayList<NameValuePair> _data;
    private String[] _columnNames = new String[]{SettingsLrb.get("SETTING_NAME"), SettingsLrb.get("SETTING_VALUE")};

    public SettingsViewerGeneralTableModel(NameValuePair[] nameValuePairArray) {
        this.setColumnIdentifiers(this._columnNames);
        this._data = new ArrayList();
        if (nameValuePairArray != null) {
            for (int i = 0; i < nameValuePairArray.length; ++i) {
                this._data.add(nameValuePairArray[i]);
            }
        }
        this.setRowCount(nameValuePairArray != null ? nameValuePairArray.length : 0);
        this.setColumnCount(2);
    }

    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        NameValuePair nameValuePair = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = nameValuePair.getName();
                break;
            }
            case 1: {
                object = nameValuePair.getValue();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (object == null) {
            return "NULL";
        }
        return object;
    }

    public void addRow(NameValuePair nameValuePair) {
        this._data.add(nameValuePair);
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }
}

