/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree.model;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.model.IlvDefaultSDMNode;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dt.schema.ScoreDistribution;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditor;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.RoundedTreeNode;
import oracle.dmt.dataminer.mviewer.dtree.TreeRule;
import oracle.dmt.dataminer.mviewer.dtree.model.DecisionTreeSDMModel;
import oracle.dmt.dataminer.mviewer.dtree.model.TreeLink;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Context;

public class TreeNode
extends IlvDefaultSDMNode
implements PropertyChangeListener {
    protected Node _jaxbData;
    protected String _tag;
    protected Context _context;
    private String _id;
    private String _x;
    private String _y;
    private List<ScoreDistribution> _scoreDistributions;
    private Map<String, ScoreDistribution> _targetValueToScoreDistributionMap;
    private double _recordCount = 0.0;
    private double _totalRecords = 0.0;
    private double _support = 0.0;
    private double _confidence = 0.0;
    private boolean otherIsVisible = false;
    private Integer _expanded = 1;
    private String _splitColumn;
    private Boolean _splitVisible;
    private int maxValuesDisplayed = 0;
    private int valuesDisplayed = 0;
    public static final String OTHER = "other";
    private static String freqBarWidth = "15";
    private static Integer minBarHeight = 0;
    private static Integer maxBarHeight = 20;
    private static Font treeFont = new Font("Dialog", 0, 12);
    private static Font treeTitleFont = new Font("Dialog", 1, 13);
    private static final String LABEL = "label";
    private static final String TOOLTIP = "tooltip";
    private static final String SPLIT = "split";
    private static final String SPLIT_VISIBLE = "isSplitVisible";
    private static final String CONFIDENCE = "confidence";
    private static final String SUPPORT = "support";
    private static final String PREDICTION = "prediction";
    private static final String TITLE = "nodeTitle";
    private static final String TEXT = "text";
    private static final String EXPANDABLE = "isExpandable";
    private static final String EXPANDED = "expanded";
    private static final String HEADER_VISIBLE = "isHeaderDetailVisible";
    private static final String CHART_VISIBLE = "barChartVisible";
    private static final String CHART_BAR_WIDTH = "chartBarWidth";
    private static final String LEGEND_COLOR = "legendColor";
    private static final String FREQ = "freq";
    private static final String MAX_FREQ_HEIGHT = "maxFreqHeight";
    private static final String MIN_FREQ_HEIGHT = "minFreqHeight";
    private static final String SCORE_COUNT = "scoreCount";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String FONT = "font";
    private static final String TITLE_FONT = "titleFont";

    public TreeNode(String string, Node node, List<ScoreDistribution> list, Context context) {
        super(string);
        Object object2;
        this._tag = string;
        this._jaxbData = node;
        this._scoreDistributions = list;
        this._context = context;
        this._x = "-1";
        this._y = "-1";
        this.setMaxValuesDisplayed(this.getModel().getMaxTargetValuesDisplayed());
        this._targetValueToScoreDistributionMap = new HashMap<String, ScoreDistribution>();
        for (Object object2 : this._scoreDistributions) {
            this._targetValueToScoreDistributionMap.put(object2.getValue(), (ScoreDistribution)object2);
        }
        TreeNode treeNode = this.findParentNode();
        object2 = this.getData().getRecordCount();
        String string2 = null;
        string2 = treeNode != null ? treeNode.getData().getRecordCount() : this.getModel().getRootNodeMetadata().getRecordCount();
        this._totalRecords = Double.valueOf(string2);
        this._recordCount = Double.valueOf((String)object2);
        this._support = this._recordCount / this._totalRecords;
        this._confidence = this.getPredictedRecordCount(this.getData().getScore()) / this._recordCount;
        this._splitColumn = null;
        this._splitVisible = null;
    }

    public void setMaxValuesDisplayed(int n) {
        this.maxValuesDisplayed = n;
        if (this.getModel().isSortByConfidence().booleanValue()) {
            if (this._scoreDistributions.size() > this.maxValuesDisplayed) {
                this.otherIsVisible = true;
            }
        } else if (this.getModel().getRootTargetValueCount() > this.maxValuesDisplayed) {
            this.otherIsVisible = true;
        }
    }

    private IlvSDMEngine getEngine() {
        IlvSDMEngine ilvSDMEngine = null;
        DTModelNode dTModelNode = (DTModelNode)this._context.getNode();
        try {
            ilvSDMEngine = dTModelNode.getEngine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return ilvSDMEngine;
    }

    public DecisionTreeSDMModel getModel() {
        DTModelNode dTModelNode = (DTModelNode)this._context.getNode();
        SDMUndoFilter sDMUndoFilter = this.getFilterModel();
        if (sDMUndoFilter == null) {
            return null;
        }
        return (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter);
    }

    public SDMUndoFilter getFilterModel() {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine == null) {
            return null;
        }
        return (SDMUndoFilter)ilvSDMEngine.getModel();
    }

    public void assignPropertyChangeListener(IlvSDMEngine ilvSDMEngine) {
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)this, true);
        if (ilvGraphic == null || !(ilvGraphic instanceof RoundedTreeNode)) {
            throw new RuntimeException("not instanceof RoundedTreeNode");
        }
        RoundedTreeNode roundedTreeNode = (RoundedTreeNode)ilvGraphic;
        roundedTreeNode.addParameterChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        this.getUndoFilter().setObjectProperty((Object)this, string, object);
    }

    public SDMUndoFilter getUndoFilter() {
        DTModelNode dTModelNode = (DTModelNode)this._context.getNode();
        IlvSDMEngine ilvSDMEngine = null;
        try {
            ilvSDMEngine = dTModelNode.getEngine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (ilvSDMEngine == null) {
            return null;
        }
        return (SDMUndoFilter)ilvSDMEngine.getModel();
    }

    public String getTag() {
        return this._tag;
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public Object getProperty(String string) {
        Object object = null;
        try {
            if (string.equals("userObject") || string.equals("CSSclass")) {
                object = this.getData().getId();
            } else if (string.equals(X)) {
                object = this._x;
            } else if (string.equals(Y)) {
                object = this._y;
            } else if (string.endsWith(TITLE)) {
                object = this.getNodeTitle();
            } else if (string.equals(SCORE_COUNT)) {
                object = this.getVisibleTargetValuesCount();
            } else if (string.startsWith(LEGEND_COLOR)) {
                object = this.getTargetValueLegendColor(string);
            } else if (string.startsWith(TEXT)) {
                object = this.getTargetValueText(string);
            } else if (string.startsWith(FREQ)) {
                object = this.getFrequencyPropertyValue(string);
            } else if (string.equals(MIN_FREQ_HEIGHT)) {
                object = minBarHeight.toString();
            } else if (string.equals(MAX_FREQ_HEIGHT)) {
                object = maxBarHeight.toString();
            } else if (string.equals(CHART_BAR_WIDTH)) {
                object = freqBarWidth;
            } else if (string.equals(CHART_VISIBLE)) {
                object = this.getModel().isBarChartVisible().toString();
            } else if (string.equals(HEADER_VISIBLE)) {
                object = this.getModel().isHeaderDetailVisible().toString();
            } else if (string.equals(TOOLTIP)) {
                object = this.getToolTip();
            } else if (string.equals(LABEL)) {
                object = this.getLabel();
            } else if (string.equals(EXPANDED)) {
                object = "" + this._expanded;
            } else if (string.equals(EXPANDABLE)) {
                object = "" + this.hasChildrenMetadata(this.getData());
            } else if (string.equals(PREDICTION)) {
                object = this.getNodePredictionDisplayString();
            } else if (string.equals(SUPPORT)) {
                object = this.getNodeSupportDisplayString();
            } else if (string.equals(CONFIDENCE)) {
                object = this.getNodeConfidenceDisplayString();
            } else {
                if (string.equals(SPLIT_VISIBLE)) {
                    return this.isSplitVisible().toString();
                }
                if (string.equals(SPLIT)) {
                    object = this.getNodeSplitDisplayString();
                } else if (string.equals(FONT)) {
                    object = treeFont;
                } else if (string.equals(TITLE_FONT)) {
                    object = treeTitleFont;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public void setProperty(String string, Object object) {
        if (string.equals(X)) {
            this._x = (String)object;
        } else if (string.equals(Y)) {
            this._y = (String)object;
        } else if (string.equals(EXPANDED)) {
            this._expanded = (Integer)object;
        }
    }

    public String getNodeTitle() {
        return DecisionTreeEditorLrb.get("NODE_ID") + " " + this.getData().getId();
    }

    private String getNodePredictionDisplayString() {
        return DecisionTreeEditorLrb.get("NODE_PREDICTION") + " " + this.getData().getScore();
    }

    private String getNodeSplitDisplayString() {
        return DecisionTreeEditorLrb.get("NODE_SPLIT") + " " + this.getSplitColumn();
    }

    private String getToolTip() {
        String string = "<html>";
        string = string + this.getNodeTitle();
        string = string + "<br>";
        string = string + this.getNodePredictionDisplayString();
        string = string + "<br>";
        string = string + this.getNodeSupportDisplayString();
        string = string + "<br>";
        string = string + this.getNodeConfidenceDisplayString();
        String string2 = this.getSplitColumn();
        if (string2 != null) {
            string = string + "<br>";
            string = string + this.getNodeSplitDisplayString();
        }
        string = string + "</html>";
        return string;
    }

    private String getTargetValueLegendColor(String string) {
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        int n = Integer.valueOf(string.substring(11, 13)) - 1;
        if (n >= this.valuesDisplayed) {
            return null;
        }
        String string2 = this.getTargetValueForIndex(n);
        return decisionTreeSDMModel.getColorForTargetValue(string2);
    }

    private String getTargetValueText(String string) {
        int n = Integer.valueOf(string.substring(4, 6)) - 1;
        if (n >= this.valuesDisplayed) {
            return null;
        }
        return this.getTargetValueDetailString(n);
    }

    public int getTargetValuesCount() {
        return this._scoreDistributions.size();
    }

    private String getVisibleTargetValuesCount() {
        String string = "" + this.maxValuesDisplayed;
        int n = 0;
        n = this.getModel().isSortByConfidence() != false ? this.getTargetValuesCount() : this.getModel().getRootTargetValueCount();
        this.valuesDisplayed = n < this.maxValuesDisplayed ? n : this.maxValuesDisplayed;
        string = "" + this.valuesDisplayed;
        return string;
    }

    private String getNodeSupportDisplayString() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        String string = numberFormat.format(this._support);
        return DecisionTreeEditorLrb.get("NODE_SUPPORT") + " " + this.getData().getRecordCount() + " (" + string + ")";
    }

    private String getNodeConfidenceDisplayString() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        String string = numberFormat.format(this._confidence);
        return DecisionTreeEditorLrb.get("NODE_CONFIDENCE") + " " + string;
    }

    private String getSplitColumn() {
        if (this._splitVisible == null) {
            if (!this.getModel().isLoaded().booleanValue()) {
                return null;
            }
            List<TreeNode> list = this.findChildNodes();
            if (list.size() != 0) {
                TreeNode treeNode = list.get(0);
                this._splitColumn = TreeRule.getSplitField(treeNode.getData());
                this._splitVisible = Boolean.TRUE;
            } else {
                this._splitVisible = Boolean.FALSE;
            }
        }
        return this._splitColumn;
    }

    private Boolean isSplitVisible() {
        if (!this.getModel().isLoaded().booleanValue()) {
            return false;
        }
        if (this._splitVisible == null) {
            this.getSplitColumn();
        }
        return this._splitVisible;
    }

    private boolean hasChildrenMetadata(Node node) {
        List list = node.getSimplePredicateOrSimpleSetPredicateOrCompoundPredicate();
        for (Object e : list) {
            if (!(e instanceof Node)) continue;
            return true;
        }
        return false;
    }

    private boolean isExpanded() {
        return this._expanded == 1;
    }

    private List<TreeNode> findChildNodes() {
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        List<TreeLink> list = decisionTreeSDMModel.findLinksFromNode((IlvSDMNode)this);
        for (TreeLink treeLink : list) {
            arrayList.add((TreeNode)treeLink.getTo());
        }
        return arrayList;
    }

    public void setChildrenVisibility() {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine == null) {
            throw new RuntimeException("Could not obtain engine.");
        }
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)this, false);
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        ilvGrapher.setVisibleBranch(ilvGraphic, 0, this.isExpanded(), true);
        if (this.isExpanded()) {
            List<TreeNode> list = this.findChildNodes();
            for (TreeNode treeNode : list) {
                this.refreshChildrenVisibility(treeNode, ilvSDMEngine, ilvGrapher);
            }
        }
        ilvGrapher.reDraw();
    }

    private void refreshChildrenVisibility(TreeNode treeNode, IlvSDMEngine ilvSDMEngine, IlvGrapher ilvGrapher) {
        if (!treeNode.isExpanded()) {
            ilvGrapher.setVisibleBranch(ilvSDMEngine.getGraphic((Object)treeNode, false), 0, treeNode.isExpanded(), true);
            return;
        }
        List<TreeNode> list = treeNode.findChildNodes();
        for (TreeNode treeNode2 : list) {
            this.refreshChildrenVisibility(treeNode2, ilvSDMEngine, ilvGrapher);
        }
    }

    public String getTargetValueDetailString(int n) {
        double d;
        String string = null;
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        String string2 = null;
        String string3 = null;
        if (decisionTreeSDMModel.isSortByConfidence().booleanValue()) {
            if (this._scoreDistributions.size() <= n) {
                return "";
            }
            ScoreDistribution scoreDistribution = this._scoreDistributions.get(n);
            string2 = scoreDistribution.getValue();
            string3 = scoreDistribution.getRecordCount();
        } else {
            string2 = decisionTreeSDMModel.getRootTargetValue(n);
            ScoreDistribution scoreDistribution = this.getScoreDistributionForTargetValue(string2);
            string3 = scoreDistribution != null ? scoreDistribution.getRecordCount() : "0";
        }
        DecisionTreeEditor decisionTreeEditor = (DecisionTreeEditor)this.getContext().getView();
        string2 = UIResourceHelper.trucateUIStringMiddle(string2, decisionTreeEditor.getMaxAttributeLength());
        if (n == this.maxValuesDisplayed - 1 && this.otherIsVisible) {
            d = this.getOtherRecordCount();
            string = "Other : " + d;
        } else {
            d = Double.valueOf(string3);
            string = string2 + " : " + string3;
        }
        double d2 = d / this._recordCount;
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        string = string + "  (" + numberFormat.format(d2) + ")";
        return string;
    }

    private String getTargetValueForIndex(int n) {
        String string;
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        if (n == this.maxValuesDisplayed - 1 && this.otherIsVisible) {
            return OTHER;
        }
        if (decisionTreeSDMModel.isSortByConfidence().booleanValue() && n >= this._scoreDistributions.size()) {
            return "";
        }
        if (decisionTreeSDMModel.isSortByConfidence().booleanValue()) {
            ScoreDistribution scoreDistribution = this.getScoreDistribution(n);
            string = scoreDistribution.getValue();
        } else {
            string = decisionTreeSDMModel.getRootTargetValue(n);
        }
        return string;
    }

    private Double getFrequencyPropertyValue(String string) {
        double d;
        String string2 = string.substring(4, 6);
        int n = Integer.valueOf(string2) - 1;
        if (n >= this.valuesDisplayed) {
            return null;
        }
        ScoreDistribution scoreDistribution = this.getScoreDistribution(n);
        double d2 = n == this.maxValuesDisplayed - 1 && this.otherIsVisible ? this.getOtherRecordCount() : (scoreDistribution != null ? Double.valueOf(scoreDistribution.getRecordCount()) : 0.0);
        double d3 = d2 / (d = Double.valueOf(this.getData().getRecordCount()).doubleValue()) * 100.0;
        if (d3 == 0.0) {
            d3 = 0.1;
        }
        return d3;
    }

    private ScoreDistribution getScoreDistribution(int n) {
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        if (decisionTreeSDMModel.isSortByConfidence().booleanValue()) {
            if (this._scoreDistributions.size() > n) {
                return this._scoreDistributions.get(n);
            }
            return null;
        }
        return this.getScoreDistributionForTargetValue(decisionTreeSDMModel.getRootTargetValue(n));
    }

    private Double getPredictedRecordCount(String string) {
        Double d = null;
        for (ScoreDistribution scoreDistribution : this._scoreDistributions) {
            if (!string.equals(scoreDistribution.getValue())) continue;
            d = Double.valueOf(scoreDistribution.getRecordCount());
            break;
        }
        return d;
    }

    private ScoreDistribution getScoreDistributionForTargetValue(String string) {
        return this._targetValueToScoreDistributionMap.get(string);
    }

    public List<ScoreDistribution> getScoreDistributions() {
        return this._scoreDistributions;
    }

    public double getOtherRecordCount() {
        if (!this.otherIsVisible) {
            throw new RuntimeException("Unexpectedly calculating other record count when \"other\" not enabled");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.maxValuesDisplayed - 1; ++i) {
            String string = this.getTargetValueForIndex(i);
            hashMap.put(string, string);
        }
        double d = 0.0;
        for (int i = 0; i < this._scoreDistributions.size(); ++i) {
            ScoreDistribution scoreDistribution = this._scoreDistributions.get(i);
            if (hashMap.containsKey(scoreDistribution.getValue())) continue;
            String string = scoreDistribution != null ? scoreDistribution.getRecordCount() : "0";
            d += (double)Integer.valueOf(string).intValue();
        }
        return d;
    }

    public String getLabel() {
        int n = 40;
        TreeRule.Predicate predicate = TreeRule.getPredicate(this.getData());
        if (predicate == null) {
            return "Root";
        }
        String string = "<html>Predicate:<br>" + TreeRule.getFormattedPredicateString(predicate.getRuleElement(), n) + "<br><br>";
        List<TreeRule.RuleElement> list = predicate.getSurrogates();
        if (list.isEmpty()) {
            return string;
        }
        string = string + "Surrogate Rules:<br>";
        int n2 = 1;
        for (TreeRule.RuleElement ruleElement : list) {
            string = string + n2 + ": " + TreeRule.getFormattedPredicateString(ruleElement, n) + "<br>";
        }
        string = string + "</html>";
        return string;
    }

    public static List<ScoreDistribution> getScoreDistributions(Node node) {
        List list = node.getSimplePredicateOrSimpleSetPredicateOrCompoundPredicate();
        ArrayList<ScoreDistribution> arrayList = new ArrayList<ScoreDistribution>();
        for (Object e : list) {
            if (!(e instanceof ScoreDistribution)) continue;
            arrayList.add((ScoreDistribution)e);
        }
        return arrayList;
    }

    public String[] getDependentProperties(String string) {
        return new String[0];
    }

    public final Node getData() {
        return this._jaxbData;
    }

    private static TreeNode createNode(String string, Context context, Node node, List<ScoreDistribution> list) throws Exception {
        TreeNode treeNode = null;
        String string2 = TreeNode.class.getPackage().getName() + "." + string;
        Class<?> clazz = Class.forName(string2);
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructorArray.length && (constructor = constructorArray[i]).getGenericParameterTypes().length != 3; ++i) {
        }
        treeNode = (TreeNode)constructor.newInstance(string, node, list, context);
        if (node == null) {
            treeNode.initNewInstance(context);
        }
        return treeNode;
    }

    public static TreeNode createNode(Node node, Context context) throws Exception, DecisionTreeSDMModel.MalformedModelException {
        List<ScoreDistribution> list = TreeNode.getScoreDistributions(node);
        if (node.getScore() == null) {
            throw new DecisionTreeSDMModel.MalformedModelException();
        }
        if (list != null && list.size() > 0 && list.get(0).getValue() == null) {
            throw new DecisionTreeSDMModel.MalformedModelException();
        }
        TreeNode treeNode = TreeNode.createNode(TreeNode.class.getSimpleName(), context, node, list);
        return treeNode;
    }

    protected void initNewInstance(Context context) {
        try {
            Class<?> clazz = Class.forName(Node.class.getPackage().getName());
            this.setData((Node)clazz.newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._context = context;
    }

    private void setData(Node node) {
        this._jaxbData = node;
    }

    protected Context getContext() {
        return this._context;
    }

    public TreeNode findParentNode() {
        DecisionTreeSDMModel decisionTreeSDMModel = this.getModel();
        TreeNode treeNode = null;
        Node node = this.getData();
        List<TreeLink> list = decisionTreeSDMModel.findLinksToNode((IlvSDMNode)this);
        for (TreeLink treeLink : list) {
            TreeNode treeNode2 = (TreeNode)treeLink.getTo();
            if (!treeNode2.getData().getId().equals(node.getId())) continue;
            treeNode = (TreeNode)treeLink.getFrom();
            break;
        }
        return treeNode;
    }
}

