/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree.model;

import ilog.views.sdm.model.IlvDefaultSDMLink;
import ilog.views.sdm.model.IlvSDMNode;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.TreeRule;
import oracle.dmt.dataminer.mviewer.dtree.model.TreeNode;

public final class TreeLink
extends IlvDefaultSDMLink {
    private String _id;
    private TreeNode _from;
    private TreeNode _to;
    private static String defaultLinkName = DecisionTreeEditorLrb.get("LINK");

    public TreeLink(String string) {
        super(string);
    }

    public static TreeLink createLink(TreeNode treeNode, TreeNode treeNode2) throws Exception {
        TreeLink treeLink = new TreeLink(TreeLink.getCommonTag());
        treeLink.setTo((IlvSDMNode)treeNode);
        treeLink.setFrom((IlvSDMNode)treeNode2);
        return treeLink;
    }

    public static String getCommonTag() {
        return "TreeLink";
    }

    public String getTag() {
        return TreeLink.getCommonTag();
    }

    public IlvSDMNode getFrom() {
        return this._from;
    }

    public void setFrom(IlvSDMNode ilvSDMNode) {
        this._from = (TreeNode)ilvSDMNode;
    }

    public void setTo(IlvSDMNode ilvSDMNode) {
        this._to = (TreeNode)ilvSDMNode;
    }

    public IlvSDMNode getTo() {
        return this._to;
    }

    public String getProperty(String string) {
        String string2 = null;
        try {
            TreeNode treeNode = (TreeNode)this.getTo();
            Node node = treeNode.getData();
            if (string.equals("label")) {
                string2 = "";
            } else if (string.equals("tooltip")) {
                TreeRule.Predicate predicate = TreeRule.getPredicateNoSurrogates(node);
                if (predicate == null) {
                    return DecisionTreeEditorLrb.get("NULL_PREDICATE");
                }
                TreeRule.RuleElement ruleElement = predicate.getRuleElement();
                if (ruleElement == null) {
                    return DecisionTreeEditorLrb.get("NULL_RULE_ELEMENT");
                }
                String string3 = TreeRule.getFormattedExpressionString(ruleElement, 20);
                string2 = "<html>\n" + DecisionTreeEditorLrb.get("NODE_SPLIT_PREDICATE") + "<br>" + string3;
                string2 = string2 + "</html>\n";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public void setProperty(String string, Object object) {
    }

    public String[] getDependentProperties(String string) {
        return new String[0];
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public String getDefaultLinkName() {
        return defaultLinkName;
    }
}

