/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.tree.IlvTreeLayout;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.core.editor.ScrollManagerView;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.framework.menu.DefaultDiagramMainMenuPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.framework.readonly.DefaultDiagramReadOnlyPlugin;
import oracle.diagram.framework.readonly.DiagramReadOnlyPlugin;
import oracle.diagram.framework.toolbar.DefaultDiagramToolbarPlugin;
import oracle.diagram.framework.toolbar.ToolbarPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeContextMenu;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeDiagram;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.dtree.NodeDetailPane;
import oracle.dmt.dataminer.mviewer.dtree.TreeRule;
import oracle.dmt.dataminer.mviewer.dtree.model.DecisionTreeSDMModel;
import oracle.dmt.dataminer.mviewer.dtree.model.TreeLink;
import oracle.dmt.dataminer.mviewer.dtree.model.TreeNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class DecisionTreeEditor
extends DataMinerDiagramEditor {
    private int _treeFlowDirection;
    private int _maxAttributeLength;
    private JSplitPane splitComponent;
    private JScrollPane detailView;
    private JEditorPane textEditorPane;
    private static int DOLAYOUT_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.doDTreelayout");
    private static int TOGGLE_HISTOGRAM_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.toggleDTreeHistogram");
    private static int TOGGLE_DETAIL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.toggleDetailedHeader");
    private static int EXPAND_ALL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.expandAllNodes");
    private static Icon _doFitToWindowIcon = null;
    private static Icon _toggleHistogramIcon = null;
    private static Icon _toggleVerticalTreeIcon = null;
    private static Icon _toggleHorizonaTreeIcon = null;
    private static Icon _toggleHeaderDetailIcon = null;
    private static Icon _expandAllIcon = null;
    private static Icon _sortConfidenceDescIcon = null;
    private static Icon _sortNaturalRootOrderIcon = null;
    private static final int MAX_VISIBLE_TARGET_VALUES = 9;
    private static final int MIN_VISIBLE_TARGET_VALUES = 2;
    private static final int DEFAULT_SELECTED_TARGET_VALUE = 3;

    public DecisionTreeEditor() {
        super((Diagram)new DecisionTreeDiagram());
        DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesSettings.getInstance();
        this._treeFlowDirection = !decisionTreePreferencesSettings.isHorizontalLayout() ? 8 : 2;
        this._maxAttributeLength = decisionTreePreferencesSettings.getMaxTargetValueDisplayLength();
        this.setPreferredLayoutBaseName("Tree");
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("tree_diagram_editor");
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return DecisionTreeContextMenu.getInstance();
    }

    @Override
    public void refresh() {
    }

    protected void installEditorPlugins(Diagram diagram) {
        super.installEditorPlugins(diagram);
        DiagramContext diagramContext = diagram.getDiagramContext();
        diagramContext.addPlugin(DiagramMainMenuPlugin.class, (Plugin)DefaultDiagramMainMenuPlugin.getInstance());
        diagramContext.addPlugin(DiagramReadOnlyPlugin.class, (Plugin)new OdmrReadOnlyPlugin(diagramContext));
        diagramContext.addPlugin(ToolbarPlugin.class, (Plugin)new TreeViewerToolbarPlugin(diagramContext));
        diagramContext.addPlugin(SelectionChangeNotificationPlugin.class, (Plugin)new SelectionChangePlugin());
    }

    public void initializeLayout(Layout layout) {
        super.initializeLayout(layout);
        layout.setProperty("Layout.ShowUnifiedThumbnail", Boolean.TRUE.toString());
    }

    @Override
    public void open() throws OpenAbortedException {
        DTModelNode dTModelNode = (DTModelNode)this.getDiagram().getContext().getNode();
        try {
            final IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
            SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
            final DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter);
            DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesSettings.getInstance();
            decisionTreeSDMModel.setSortByConfidence(!decisionTreePreferencesSettings.isSortByRootOrder());
            decisionTreeSDMModel.setBarChartVisible(decisionTreePreferencesSettings.isShowHistogram());
            decisionTreeSDMModel.setHeaderDetailVisible(decisionTreePreferencesSettings.isShowNodeDetailHeader());
            decisionTreePreferencesSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                    ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                    boolean bl = false;
                    for (int i = 0; i < changeInfoArray.length; ++i) {
                        ChangeInfo changeInfo = changeInfoArray[i];
                        if (!changeInfo.getPropertyName().equals(DecisionTreePreferencesSettings.MAX_TARGET_DISPLAY_LENGTH)) continue;
                        DecisionTreeEditor.this._maxAttributeLength = changeInfo.getNewValueAsInt();
                        bl = true;
                    }
                    if (bl) {
                        decisionTreeSDMModel.fireDataChanged(null);
                        DecisionTreeEditor.this.doLayout(ilvSDMEngine, DecisionTreeEditor.this._treeFlowDirection, false);
                    }
                }
            });
            if (dTModelNode.isModelExists().booleanValue()) {
                this.load(dTModelNode, decisionTreeSDMModel);
                ilvSDMEngine.setModel((IlvSDMModel)sDMUndoFilter);
                this.doLayout(ilvSDMEngine, this._treeFlowDirection, true);
                this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ModelViewerLrb.get("LOAD_MODEL_MISSING"), (String)ModelViewerLrb.get("MODEL_MISSING_TITLE"), null);
                this.abortOpen((oracle.ide.model.Node)dTModelNode, ModelViewerLrb.get("MODEL_DOES_NOT_EXIST"));
            }
        }
        catch (Exception exception) {
            if (exception instanceof OpenAbortedException) {
                throw (OpenAbortedException)exception;
            }
            if (exception instanceof DecisionTreeSDMModel.MalformedModelException) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelViewerLrb.get("FAILED_ERROR_TITLE"), (String)exception.getMessage(), null);
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelViewerLrb.get("FAILED_ERROR_TITLE"), (String)ModelViewerLrb.get("FAILED_OPEN"), null);
            }
            this.abortOpen((oracle.ide.model.Node)dTModelNode);
        }
        super.open();
    }

    public void reload() {
        try {
            DTModelNode dTModelNode = (DTModelNode)this.getDiagram().getContext().getNode();
            IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
            SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
            DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter);
            dTModelNode.load();
            if (dTModelNode.isModelExists().booleanValue()) {
                this.load(dTModelNode, decisionTreeSDMModel);
                ilvSDMEngine.setModel((IlvSDMModel)sDMUndoFilter);
                this.doLayout(ilvSDMEngine, this._treeFlowDirection, false);
                this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ModelViewerLrb.get("RELOAD_MODEL_MISSING"), (String)ModelViewerLrb.get("MODEL_MISSING_TITLE"), null);
            }
        }
        catch (Exception exception) {
            if (!(exception instanceof OpenAbortedException)) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelViewerLrb.get("FAILED_ERROR_TITLE"), (String)ModelViewerLrb.get("FAILED_OPEN"), null);
            }
            throw new OpenAbortedException();
        }
    }

    private void setPropertyChangeListener(IlvSDMEngine ilvSDMEngine, DecisionTreeSDMModel decisionTreeSDMModel) {
        Enumeration enumeration = decisionTreeSDMModel.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof TreeNode)) continue;
            TreeNode treeNode = (TreeNode)e;
            treeNode.assignPropertyChangeListener(ilvSDMEngine);
        }
        decisionTreeSDMModel.addSDMPropertyChangeListener(new ModelListener());
    }

    public int getMaxAttributeLength() {
        return this._maxAttributeLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLayout(IlvSDMEngine ilvSDMEngine, int n, boolean bl) {
        IlvTreeLayout ilvTreeLayout = new IlvTreeLayout();
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        ilvTreeLayout.attach(ilvGrapher);
        ilvTreeLayout.setFlowDirection(n);
        ilvTreeLayout.setGlobalLinkStyle(2);
        try {
            ilvTreeLayout.performLayout();
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            System.out.println(ilvGraphLayoutException.getMessage());
        }
        finally {
            IlvManagerView ilvManagerView;
            if (bl && (ilvManagerView = this.getDiagram().getDiagramContext().getManagerView()) != null) {
                ilvManagerView.fitTransformerToContent();
            }
        }
        ilvTreeLayout.detach();
    }

    public void expandAllNodes() {
        try {
            DTModelNode dTModelNode = (DTModelNode)this.getDiagram().getContext().getNode();
            IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
            SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
            DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter);
            Enumeration enumeration = decisionTreeSDMModel.getObjects();
            if (enumeration == null) {
                return;
            }
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof TreeNode)) continue;
                sDMUndoFilter.setObjectProperty(e, "expanded", (Object)1);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void close() {
        super.close();
    }

    private void load(DTModelNode dTModelNode, DecisionTreeSDMModel decisionTreeSDMModel) throws Exception {
        if (dTModelNode.isModelExists().booleanValue()) {
            decisionTreeSDMModel.load(dTModelNode.getModelLoader().getRootObject(), this.getContext());
            dTModelNode.setReadOnly(true);
        }
    }

    public TreeNode getSelectedDiagramNode() throws Exception {
        List<TreeNode> list = this.getSelectedDiagramNodes();
        if (list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public List<TreeNode> getSelectedDiagramNodes() throws Exception {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof TreeNode)) continue;
                arrayList.add((TreeNode)e);
            }
        }
        return arrayList;
    }

    public TreeLink getSelectedDiagramLink() throws Exception {
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return null;
        }
        IlvManager ilvManager = ilvManagerView.getManager();
        DTModelNode dTModelNode = (DTModelNode)diagram.getContext().getNode();
        IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getSelectedObjects();
        if (ilvManager.getSelectedObjectsCount() > 1 || ilvManager.getSelectedObjectsCount() == 0) {
            return null;
        }
        IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
        Object object = ilvSDMEngine.getObject(ilvGraphic);
        if (object instanceof TreeLink) {
            return (TreeLink)((Object)object);
        }
        return null;
    }

    public List<TreeLink> getSelectedDiagramLinks() throws Exception {
        ArrayList<TreeLink> arrayList = new ArrayList<TreeLink>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof TreeLink)) continue;
                arrayList.add((TreeLink)((Object)e));
            }
        }
        return arrayList;
    }

    public List<Object> getSelectedDiagramObjects() throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    @Override
    public void closeEditor() {
        DecisionTreeEditor decisionTreeEditor = this;
        SwingUtilities.invokeLater(new Runnable((Editor)decisionTreeEditor){
            final /* synthetic */ Editor val$thisEditor;
            {
                this.val$thisEditor = editor;
            }

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(this.val$thisEditor));
            }
        });
    }

    public Component createGUI() {
        DTModelNode dTModelNode = (DTModelNode)this.getContext().getNode();
        if (!dTModelNode.isLoaded()) {
            return null;
        }
        this.detailView = new JScrollPane();
        this.detailView.setLayout(new ScrollPaneLayout());
        this.textEditorPane = new JEditorPane();
        this.textEditorPane.setEditable(false);
        this.textEditorPane.setContentType("text/html");
        this.textEditorPane.setText(DecisionTreeEditorLrb.get("NO_SELECTION"));
        this.detailView.getViewport().add(this.textEditorPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ToolbarPlugin toolbarPlugin = (ToolbarPlugin)this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
        if (toolbarPlugin != null) {
            Toolbar toolbar = toolbarPlugin.getToolbar();
            if (toolbar == null) {
                toolbarPlugin.createToolbar((View)this);
                toolbar = toolbarPlugin.getToolbar();
            }
            jPanel.add((Component)toolbar, "North");
        }
        jPanel.add((Component)new ScrollManagerView(this.getDiagram().getDiagramContext().getManagerView()), "Center");
        this.splitComponent = new JSplitPane(0, jPanel, this.detailView);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DecisionTreeEditor.this.splitComponent.setDividerLocation(0.8);
            }
        });
        return this.splitComponent;
    }

    public Component getDetailView() {
        return this.splitComponent.getBottomComponent();
    }

    public Component getHorizontalScrollBar() {
        return null;
    }

    public Component getVerticalScrollBar() {
        return null;
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        super.update(object, updateMessage);
    }

    private DecisionTreeSDMModel getModel(DTModelNode dTModelNode) throws Exception {
        IlvSDMEngine ilvSDMEngine = dTModelNode.getEngine();
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        DecisionTreeSDMModel decisionTreeSDMModel = (DecisionTreeSDMModel)dTModelNode.getFilteredModel(sDMUndoFilter);
        return decisionTreeSDMModel;
    }

    public class TreeViewerToolbarPlugin
    extends DefaultDiagramToolbarPlugin {
        private IdeAction _doFitToWindow;
        private IdeAction _toggleHistogramAction;
        private IdeAction _toggleHeaderAction;
        private IdeAction _expandAllAction;

        public TreeViewerToolbarPlugin(DiagramContext diagramContext) {
            super(diagramContext);
            this._doFitToWindow = IdeAction.get((int)DOLAYOUT_CMDID);
            this._toggleHistogramAction = IdeAction.get((int)TOGGLE_HISTOGRAM_CMDID);
            this._toggleHeaderAction = IdeAction.get((int)TOGGLE_DETAIL_CMDID);
            this._expandAllAction = IdeAction.get((int)EXPAND_ALL_CMDID);
            if (_doFitToWindowIcon == null) {
                _doFitToWindowIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), DecisionTreeEditorLrb.get("RESET_LAYOUT_ICON"));
                _toggleHistogramIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), DecisionTreeEditorLrb.get("TOGGLE_BAR_GRAPH_ICON"));
                _toggleHeaderDetailIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), DecisionTreeEditorLrb.get("TOGGLE_DETAIL_ICON"));
                _toggleVerticalTreeIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), DecisionTreeEditorLrb.get("TREE_DIAGRAM_V_ICON"));
                _toggleHorizonaTreeIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), DecisionTreeEditorLrb.get("TREE_DIAGRAM_H_ICON"));
                _expandAllIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), DecisionTreeEditorLrb.get("EXPAND_ALL_ICON"));
                _sortConfidenceDescIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), DecisionTreeEditorLrb.get("SORT_CONFIDENCE_ICON"));
                _sortNaturalRootOrderIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), DecisionTreeEditorLrb.get("SORT_NATURAL_ICON"));
            }
        }

        public void update(Context context) {
            super.update(context);
            if (this._doFitToWindow != null) {
                this._doFitToWindow.updateAction(context);
            }
        }

        protected Toolbar createToolbarImpl(View view) {
            DecisionTreeSDMModel decisionTreeSDMModel;
            DTModelNode dTModelNode;
            DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesSettings.getInstance();
            try {
                dTModelNode = (DTModelNode)DecisionTreeEditor.this.getDiagram().getContext().getNode();
                decisionTreeSDMModel = DecisionTreeEditor.this.getModel(dTModelNode);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            final DecisionTreeSDMModel decisionTreeSDMModel2 = decisionTreeSDMModel;
            final DTModelNode dTModelNode2 = dTModelNode;
            Toolbar toolbar = super.createToolbarImpl(view);
            ToolButton toolButton = new ToolButton((Action)this._doFitToWindow);
            toolButton.setIcon(_doFitToWindowIcon);
            toolButton.setToolTipText(ModelViewerLrb.get("FIT_TO_WINDOW_TIP"));
            toolButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                        DecisionTreeEditor.this.doLayout(ilvSDMEngine, DecisionTreeEditor.this._treeFlowDirection, true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            ToolButton toolButton2 = new ToolButton((Action)this._expandAllAction);
            toolButton2.setIcon(_expandAllIcon);
            toolButton2.setToolTipText(ModelViewerLrb.get("EXPAND_ALL_TIP"));
            toolButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DecisionTreeEditor.this.expandAllNodes();
                }
            });
            this._toggleHistogramAction.setState(decisionTreePreferencesSettings.isShowHistogram());
            final ToggleToolButton toggleToolButton = new ToggleToolButton((ToggleAction)this._toggleHistogramAction);
            toggleToolButton.setIcon(_toggleHistogramIcon);
            toggleToolButton.setToolTipText(DecisionTreeEditorLrb.get("SHOW_HISTOGRAM_TIP"));
            toggleToolButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                        decisionTreeSDMModel2.toggleBarChartVisible();
                        toggleToolButton.setToolTipText(decisionTreeSDMModel2.isBarChartVisible() != false ? "Hide Histograms" : "Show Histograms");
                        decisionTreeSDMModel2.fireDataChanged(null);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                        IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                        DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                        dTModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            this._toggleHeaderAction.setState(decisionTreePreferencesSettings.isShowNodeDetailHeader());
            final ToggleToolButton toggleToolButton2 = new ToggleToolButton((ToggleAction)this._toggleHeaderAction);
            toggleToolButton2.setIcon(_toggleHeaderDetailIcon);
            toggleToolButton2.setToolTipText(ModelViewerLrb.get("SHOW_LESS_TIP"));
            toggleToolButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                        decisionTreeSDMModel2.toggleHeaderDetailVisible();
                        toggleToolButton2.setToolTipText(decisionTreeSDMModel2.isHeaderDetailVisible() != false ? "Show Less Details" : "Show More Details");
                        decisionTreeSDMModel2.fireDataChanged(null);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                        IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                        DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                        dTModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            final DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
            final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(DecisionTreeEditorLrb.get("HORIZONTAL_LAYOUT"));
            final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(DecisionTreeEditorLrb.get("VERTICAL_LAYOUT"));
            buttonGroup.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem2);
            jRadioButtonMenuItem2.setIcon(_toggleVerticalTreeIcon);
            jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DecisionTreeEditor.this._treeFlowDirection = 8;
                        dropDownMenuButton.setIcon(_toggleVerticalTreeIcon);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            jRadioButtonMenuItem.setIcon(_toggleHorizonaTreeIcon);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DecisionTreeEditor.this._treeFlowDirection = 2;
                        dropDownMenuButton.setIcon(_toggleHorizonaTreeIcon);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            dropDownMenuButton.setToolTipText(ModelViewerLrb.get("LAYOUT_TIP"));
            jRadioButtonMenuItem2.setSelected(DecisionTreeEditor.this._treeFlowDirection != 2);
            jRadioButtonMenuItem.setSelected(DecisionTreeEditor.this._treeFlowDirection == 2);
            if (DecisionTreeEditor.this._treeFlowDirection == 2) {
                dropDownMenuButton.setIcon(_toggleHorizonaTreeIcon);
            } else if (DecisionTreeEditor.this._treeFlowDirection == 8) {
                dropDownMenuButton.setIcon(_toggleVerticalTreeIcon);
            }
            dropDownMenuButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem2);
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem);
                    } else if (itemEvent.getStateChange() == 2) {
                        dropDownMenuButton.removeAllPopupItems();
                    }
                }
            });
            ButtonGroup buttonGroup2 = new ButtonGroup();
            final DropDownMenuButton dropDownMenuButton2 = new DropDownMenuButton();
            final JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(DecisionTreeEditorLrb.get("SORT_BY_CONFIDENCE"));
            final JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(DecisionTreeEditorLrb.get("SORT_BY_ROOT_ORDER"));
            buttonGroup2.add(jRadioButtonMenuItem3);
            buttonGroup2.add(jRadioButtonMenuItem4);
            jRadioButtonMenuItem3.setIcon(_sortConfidenceDescIcon);
            jRadioButtonMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                        decisionTreeSDMModel2.setSortByConfidence(true);
                        dropDownMenuButton2.setIcon(_sortConfidenceDescIcon);
                        dropDownMenuButton2.setToolTipText(DecisionTreeEditorLrb.get("SORT_TIP"));
                        decisionTreeSDMModel2.fireDataChanged(null);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                        IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                        DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                        dTModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            jRadioButtonMenuItem4.setIcon(_sortNaturalRootOrderIcon);
            jRadioButtonMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                        decisionTreeSDMModel2.setSortByConfidence(false);
                        dropDownMenuButton2.setIcon(_sortNaturalRootOrderIcon);
                        dropDownMenuButton2.setToolTipText(DecisionTreeEditorLrb.get("SORT_TIP"));
                        decisionTreeSDMModel2.fireDataChanged(null);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                        IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                        DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                        dTModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            dropDownMenuButton2.setToolTipText(DecisionTreeEditorLrb.get("SORT_TIP"));
            jRadioButtonMenuItem3.setSelected(decisionTreeSDMModel2.isSortByConfidence());
            jRadioButtonMenuItem4.setSelected(decisionTreeSDMModel2.isSortByConfidence() == false);
            if (decisionTreeSDMModel2.isSortByConfidence().booleanValue()) {
                dropDownMenuButton2.setIcon(_sortConfidenceDescIcon);
            } else {
                dropDownMenuButton2.setIcon(_sortNaturalRootOrderIcon);
            }
            dropDownMenuButton2.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        dropDownMenuButton2.addPopupItem((JMenuItem)jRadioButtonMenuItem3);
                        dropDownMenuButton2.addPopupItem((JMenuItem)jRadioButtonMenuItem4);
                    } else if (itemEvent.getStateChange() == 2) {
                        dropDownMenuButton2.removeAllPopupItems();
                    }
                }
            });
            int n = decisionTreeSDMModel2.getRootTargetValueCount() > 9 ? 9 : decisionTreeSDMModel2.getRootTargetValueCount() - 1;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = i + 2;
            }
            JLabel jLabel = new JLabel();
            jLabel.setText(DecisionTreeEditorLrb.get("MAX_TARGET_VALUES"));
            JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
            Object object = objectArray.length >= 4 ? objectArray[3] : objectArray[objectArray.length - 1];
            jComboBox.setSelectedItem(object);
            jComboBox.setToolTipText(DecisionTreeEditorLrb.get("MAX_TARGET_VALUES_TIP"));
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                        Integer n = (Integer)jComboBox.getSelectedItem();
                        decisionTreeSDMModel2.setMaxTargetValuesDisplayed(n);
                        DecisionTreeEditor.this.doLayout(dTModelNode2.getEngine(), DecisionTreeEditor.this._treeFlowDirection, false);
                        IlvSDMEngine ilvSDMEngine = dTModelNode2.getEngine();
                        DecisionTreeEditor.this.setPropertyChangeListener(ilvSDMEngine, decisionTreeSDMModel2);
                        dTModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            JButton jButton = new JButton();
            jButton.setToolTipText(ClusteringTreeEditorLrb.get("REFRESH_TIP"));
            jButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = TreeViewerToolbarPlugin.this.getSelectedNodeId();
                    DecisionTreeEditor.this.reload();
                    TreeViewerToolbarPlugin.this.setSelectedNodeUsingId(string, decisionTreeSDMModel2, dTModelNode2);
                }
            });
            toolbar.addSeparator();
            toolbar.add((Component)toolButton);
            toolbar.add((Component)dropDownMenuButton);
            toolbar.add((Component)toolButton2);
            toolbar.addSeparator();
            toolbar.addFiller();
            toolbar.add((Component)toggleToolButton);
            toolbar.add((Component)toggleToolButton2);
            toolbar.add((Component)dropDownMenuButton2);
            toolbar.addSeparator(new Dimension(10, 0));
            toolbar.add((Component)jLabel);
            toolbar.addFiller();
            toolbar.add(jComboBox);
            toolbar.addFiller();
            toolbar.addSeparator();
            toolbar.add((Component)jButton);
            toolbar.addSeparator(new Dimension(1000, 0));
            return toolbar;
        }

        private String getSelectedNodeId() {
            String string = null;
            try {
                IlvSDMNode ilvSDMNode;
                List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                if (!list.isEmpty() && (ilvSDMNode = (IlvSDMNode)list.get(0)) instanceof TreeNode) {
                    string = ((TreeNode)ilvSDMNode).getData().getId();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private void setSelectedNodeUsingId(String string, DecisionTreeSDMModel decisionTreeSDMModel, DTModelNode dTModelNode) {
            if (string != null) {
                Enumeration enumeration = decisionTreeSDMModel.getObjects();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    Object e = enumeration.nextElement();
                    if (!(e instanceof TreeNode) || !(string2 = ((TreeNode)e).getData().getId()).equals(string)) continue;
                    try {
                        dTModelNode.getEngine().setSelected(e, true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break;
                }
            }
        }
    }

    public class SelectionChangePlugin
    extends AbstractPlugin
    implements SelectionChangeNotificationPlugin {
        private boolean isEnabled = true;

        public void selectionChanged(DiagramContext diagramContext) {
            try {
                List<Object> list = DecisionTreeEditor.this.getSelectedDiagramObjects();
                if (list.size() > 1) {
                    DecisionTreeEditor.this.textEditorPane.setText(DecisionTreeEditorLrb.get("MULTI_SELECTION"));
                    int n = DecisionTreeEditor.this.splitComponent.getDividerLocation();
                    DecisionTreeEditor.this.splitComponent.setBottomComponent(DecisionTreeEditor.this.detailView);
                    DecisionTreeEditor.this.splitComponent.setDividerLocation(n);
                } else if (list.size() == 1) {
                    Object object = list.get(0);
                    if (object instanceof TreeNode) {
                        TreeNode treeNode = (TreeNode)object;
                        NodeDetailPane nodeDetailPane = new NodeDetailPane(treeNode);
                        int n = DecisionTreeEditor.this.splitComponent.getDividerLocation();
                        DecisionTreeEditor.this.splitComponent.setBottomComponent(nodeDetailPane);
                        DecisionTreeEditor.this.splitComponent.setDividerLocation(n);
                    } else if (object instanceof TreeLink) {
                        TreeLink treeLink = (TreeLink)((Object)object);
                        TreeNode treeNode = (TreeNode)treeLink.getTo();
                        Node node = treeNode.getData();
                        String string = "";
                        string = "<html>\n" + DecisionTreeEditorLrb.get("NODE_SPLIT_PREDICATE") + "<br>" + "<p style=\"font-family: monospace\">" + TreeRule.getFormattedPredicateString(TreeRule.getPredicate(node).getRuleElement()) + "</p>" + "</html>";
                        int n = DecisionTreeEditor.this.splitComponent.getDividerLocation();
                        DecisionTreeEditor.this.splitComponent.setBottomComponent(DecisionTreeEditor.this.detailView);
                        DecisionTreeEditor.this.splitComponent.setDividerLocation(n);
                        DecisionTreeEditor.this.textEditorPane.setText(string);
                        DecisionTreeEditor.this.textEditorPane.select(0, 0);
                    }
                } else {
                    DecisionTreeEditor.this.textEditorPane.setText(DecisionTreeEditorLrb.get("NO_SELECTION"));
                    int n = DecisionTreeEditor.this.splitComponent.getDividerLocation();
                    DecisionTreeEditor.this.splitComponent.setBottomComponent(DecisionTreeEditor.this.detailView);
                    DecisionTreeEditor.this.splitComponent.setDividerLocation(n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    class OdmrReadOnlyPlugin
    extends DefaultDiagramReadOnlyPlugin {
        public OdmrReadOnlyPlugin(DiagramContext diagramContext) {
            super(diagramContext);
        }

        public boolean isPermanentReadOnly() {
            return true;
        }

        protected boolean checkWritableDiagram() {
            return false;
        }
    }

    public class ModelListener
    implements SDMPropertyChangeListener {
        public void propertyChanged(SDMPropertyChangeEvent sDMPropertyChangeEvent) {
            String string = sDMPropertyChangeEvent.getPropertyName();
            Object object = sDMPropertyChangeEvent.getObject();
            if ("expanded".equals(string) && object instanceof TreeNode) {
                ((TreeNode)object).setChildrenVisibility();
            }
        }
    }
}

