/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.controls.GenericTableTooltip;
import oracle.dmt.dataminer.filter.FilterConsumer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.DataMinerViewListenerAdapter;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class RegrCoefficientFilterPanel
extends JPanel
implements GeneralCoefficientFilterPanel {
    private CoefViewerState _state;
    private static Icon _icon;
    private View _consumerView;
    private boolean _loaded;
    private CoefViewerMainPanel _mainPanel;
    private CoefficientFilterSetting _coefFilterSetting;
    private Context _context;
    public static final String FILTER_SETTING_PROPERTY = "FILTER_SETTING_PROPERTY";
    private GenericTable _jItemFilterTable = new GenericTableTooltip();
    private static Preferences _p;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;

    public RegrCoefficientFilterPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public JPanel getUIComponent() {
        return this;
    }

    @Override
    public void updateTarget() {
    }

    public RegrCoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, Context context, CoefViewerState coefViewerState) {
        try {
            this._mainPanel = coefViewerMainPanel;
            this._context = context;
            this._state = coefViewerState;
            this.initComponents();
            this.initRes();
            this.initUI();
            this.initializeUIState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this._jAbsoluteValueFilter = new JCheckBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this._jApplyFilterButton = new JButton();
        this._jAbsoluteValueFilter.setText("Sort by absolute value");
        this._jAbsoluteValueFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jAbsoluteValueFilter.setMargin(new Insets(0, 0, 0, 0));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setHorizontalAlignment(11);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jAbsoluteValueFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 262, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSize, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jApplyFilterButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jAbsoluteValueFilter).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jApplyFilterButton).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel))).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(this.getIcon());
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), CoefficientsLrb.get("QUERY_ICON"));
        }
        return _icon;
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegrCoefficientFilterPanel.this._jAbsoluteValueFilter_actionPerformed(actionEvent);
            }
        });
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegrCoefficientFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        CoefficientItemTableModel coefficientItemTableModel = new CoefficientItemTableModel();
        this._state.setFilterItemTableModel(coefficientItemTableModel);
        this._jItemFilterTable.setModel((TableModel)((Object)coefficientItemTableModel));
        this.enableControls(false);
        this._mainPanel.addDataMinerViewListener(new DataMinerViewListenerAdapter(){

            @Override
            public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
                RegrCoefficientFilterPanel.this.enableControls(true);
            }

            @Override
            public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
                RegrCoefficientFilterPanel.this.enableControls(false);
            }
        });
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
    }

    private boolean isSVM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof SVMCModelNode;
    }

    private boolean isGLM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMCModelNode;
    }

    @Override
    public void setupUI(CoefficientFilterSetting coefficientFilterSetting) {
        this._coefFilterSetting = coefficientFilterSetting;
        this.loadStateAttributes();
        this.enableControls(true);
        this.setLoaded(true);
    }

    public void setupUI(View view) {
        if (this._consumerView == view) {
            return;
        }
        if (view == null) {
            return;
        }
        FilterConsumer filterConsumer = (FilterConsumer)view;
        this._consumerView = view;
        if (!filterConsumer.isLoaded()) {
            this._consumerView = view;
            return;
        }
        this.setupUIDetail();
    }

    private void initializeUIState() throws Exception {
        this._coefFilterSetting = new CoefficientFilterSetting();
        this.loadStateAttributes();
    }

    private void setupUIDetail() {
        FilterConsumer filterConsumer = (FilterConsumer)this._consumerView;
        this._coefFilterSetting = (CoefficientFilterSetting)filterConsumer.getCachedFilterState();
        assert (this._coefFilterSetting != null) : "Coefficient Filter Setting state is null.";
        this.loadStateAttributes();
        this.enableControls(true);
        this.setLoaded(true);
    }

    public void unloadUI() throws Exception {
        this.enableControls(false);
        if (this._consumerView == null) {
            return;
        }
        this.updateInput();
        ((FilterConsumer)this._consumerView).setCachedFilterState(this._coefFilterSetting);
        this.clearState();
        this.setLoaded(false);
    }

    public void updateInput() throws Exception {
        Number number = this.getNumber(this._jFetchSize);
        this._coefFilterSetting.setFetchSize(number.intValue());
        this._coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    private void clearState() {
        this._consumerView = null;
        this.resetUIAttributes();
        this._jApplyFilterButton.setEnabled(false);
        this._coefFilterSetting = null;
    }

    private void resetUIAttributes() {
        this.setNumber(this._jFetchSize, 1000);
    }

    private void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jAbsoluteValueFilter.setEnabled(bl);
    }

    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(true);
        if (!this.isLoaded() && this._consumerView != null) {
            this.setupUIDetail();
        }
    }

    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(false);
    }

    private void loadStateAttributes() {
        if (this._coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this._modelViewerPrefenceSettings.getFetchSizeOtherModels());
            this._jAbsoluteValueFilter.setSelected(this._coefFilterSetting.getFilterAndSortByAbsolute());
        }
    }

    private void _jAbsoluteValueFilter_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setSortByAbsoluteValue(this._jAbsoluteValueFilter.isSelected());
        this._coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this._jApplyFilterButton.setEnabled(false);
            ValidateUpdateState validateUpdateState = new ValidateUpdateState();
            validateUpdateState.setTitle(CoefficientsLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CoefficientsLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
            if (validateUpdateState.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateUpdateState.getException(), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
                this.enableControls(true);
            }
            if (validateUpdateState.getValidation()) {
                this._mainPanel.setFilterState(this._coefFilterSetting);
            } else {
                this.enableControls(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this.enableControls(true);
        }
    }

    private void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    private void setLocale(JSpinner jSpinner, Locale locale) {
        jSpinner.setLocale(locale);
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    static {
        _p = Preferences.getPreferences();
    }

    class ValidateUpdateState
    extends ProgressRunnable {
        private Exception _exception;
        private Boolean _validated;
        private boolean _canceled = false;

        ValidateUpdateState() {
        }

        public boolean getValidation() {
            return this._validated;
        }

        public Exception getException() {
            return this._exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doWork() throws Exception {
            Number number;
            block5: {
                this._validated = false;
                number = RegrCoefficientFilterPanel.this.getNumber(RegrCoefficientFilterPanel.this._jFetchSize);
                if (null != number && number.longValue() > 0L) break block5;
                this._validated = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FETCH_SIZE_RANGE_ERROR"), (String)CoefficientsLrb.get("COEFFICIENT_ERROR_TITLE"), null);
                Boolean bl = this._validated;
                return bl;
            }
            try {
                this._validated = true;
                RegrCoefficientFilterPanel.this._coefFilterSetting.setFetchSize(number.intValue());
                RegrCoefficientFilterPanel.this._coefFilterSetting.setUseFilterSpecification(false);
                RegrCoefficientFilterPanel.this._coefFilterSetting.setFilterByAbsolute(RegrCoefficientFilterPanel.this._jAbsoluteValueFilter.isSelected());
            }
            catch (Exception exception) {
                this._exception = exception;
                this._validated = false;
            }
            return this._validated;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

