/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.HistogramBarRenderer;
import oracle.dmt.dataminer.filter.FilterEvent;
import oracle.dmt.dataminer.filter.FilterListener;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GLMCoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoeffViewer;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.GLMCoefficientRowData;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class RegrCoefViewer
extends JPanel
implements GeneralCoeffViewer {
    CoefViewerState _state;
    Context _context;
    CoefViewerMainPanel _mainPanel;
    JScrollPane jScrollPane1;
    JLabel _jRowsOutOfTotalLabel = new JLabel();
    private JComponent _findPane;
    private GenericTableFixedColumns _jCoefGenericTable = new CustomGenericTable();
    public static final String COEFFICIENT_VIEWER_ID = "COEFFICIENT_VIEWER_ID";
    private SearchField _jFilterCtl = new SearchField();
    public static final int SVM_FILTER_COEFFICIENT_ALL_OR = 0;
    public static final int SVM_FILTER_COEFFICIENT_ALL_AND = 1;
    public static final int SVM_FILTER_COEFFICIENT_NAME = 2;
    public static final int SVM_FILTER_COEFFICIENT_VALUE = 3;
    public static final int SVM_FILTER_COEFFICIENT = 4;
    private static final int SVM_FROZEN_COLUMNS = 0;
    private int _currentSearchCategory = 2;
    private SearchCategory _defaultSVMSearchCategory = new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_NAME"));
    public static final int GLM_FILTER_COEFFICIENT_ALL_OR = 0;
    public static final int GLM_FILTER_COEFFICIENT_ALL_AND = 1;
    public static final int GLM_FILTER_COEFFICIENT_NAME = 2;
    public static final int GLM_FILTER_COEFFICIENT_VALUE = 3;
    public static final int GLM_FILTER_COEFFICIENT = 4;
    public static final int GLM_FILTER_STD_ERROR = 5;
    public static final int GLM_FILTER_TEST_STATISTIC = 6;
    public static final int GLM_FILTER_P_VALUE = 7;
    public static final int GLM_FILTER_STD_COEFFICIENT = 8;
    public static final int GLM_FILTER_LOWER_COEFF_LIMIT = 9;
    public static final int GLM_FILTER_UPPER_COEFF_LIMIT = 10;
    private static final int GLM_FROZEN_COLUMNS = 2;
    private SearchCategory _defaultGLMSearchCategory = new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_NAME"));
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private static String _LOADING_SVM = CoefficientsLrb.get("COEFFICIENT_LOADING");
    private static String _LOADING_GLM = CoefficientsLrb.get("STATISTICS_LOADING");
    private NumberFormat _labelNumericalFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    private NumberFormat _labelPercentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private HistogramBarRenderer _barRenderer;
    private boolean _loadedFilterSetting = false;
    private ComponentWithTitlebar<JComponent> _jCoefViewerComponent;

    public RegrCoefViewer(CoefViewerMainPanel coefViewerMainPanel, Context context, CoefViewerState coefViewerState) throws Exception {
        this._mainPanel = coefViewerMainPanel;
        this._context = context;
        this._state = coefViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jCoefViewerComponent = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jCoefViewerComponent, -1, 484, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jCoefViewerComponent, GroupLayout.Alignment.TRAILING, -1, 208, Short.MAX_VALUE));
    }

    @Override
    public JPanel getUIComponent() {
        return this;
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(new Integer(0), new Integer(0));
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.addListeners();
        this.jScrollPane1 = new JScrollPane((Component)((Object)this._jCoefGenericTable));
        this._jCoefGenericTable.setFillsViewportHeight(true);
        this._jCoefViewerComponent.setComponent((JComponent)this.jScrollPane1);
        this._jCoefViewerComponent.setLabel(this._jRowsOutOfTotalLabel);
        ControlBar controlBar = new ControlBar();
        this.setupFilterControl(controlBar);
        this._jCoefViewerComponent.setControlBar(controlBar);
        this._jCoefGenericTable.setSelectionMode(2);
        this._jCoefGenericTable.setShowGrid(true);
        this.initializeControls();
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = "";
        if (this.isSVM()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        } else if (this.isGLM()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        }
        int n3 = 1;
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (this.isSVM() || this.isGLM()) {
            n3 = 0;
        }
        Integer n4 = new Integer(n2 + n3);
        String string2 = NumericFormat.format(n);
        String string3 = NumericFormat.format(n4);
        String string4 = MessageFormat.format(string, string2, string3);
        this._jRowsOutOfTotalLabel.setText(string4);
    }

    private void setupFilterControl(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._jFilterCtl = this.searchField();
        if (this.isSVM()) {
            this.setupSVMFilterCtl();
        } else if (this.isGLM()) {
            this.setupGLMFilterCtl();
        } else assert (false) : "Unsupported model node";
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._jFilterCtl);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                RegrCoefViewer.this.translateSearchCategoryToConstant(RegrCoefViewer.this._jFilterCtl.getSelectedCategory());
                RegrCoefViewer.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                RegrCoefViewer.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                RegrCoefViewer.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    @Override
    public void setFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(coefficientFilterSetting);
        this.prepareReload();
    }

    public void setFilterState(FilterEvent filterEvent) {
    }

    public CoefficientFilterSetting getFilterState() {
        return this._state.getFilterSetting();
    }

    @Override
    public CoefficientFilterSetting getCachedFilterState() {
        return this._state.getCachedFilterSetting();
    }

    @Override
    public void setCachedFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        this._state.setCachedFilterSetting(coefficientFilterSetting);
    }

    @Override
    public void prepareReload() {
        this.setLoading(true);
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true);
        loadUI.start();
    }

    private void enableControls(boolean bl) {
        this._jFilterCtl.setEnabled(bl);
    }

    void prepareForNewQuery() {
        this._jCoefGenericTable.setLoading(true);
        this._state.clearRows();
        if (this._state.isSVM()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(_LOADING_SVM);
            this._state.addRow(coefficientRowData);
            this._jCoefGenericTable.setModel((TableModel)this._state.getTableModel());
            this._jCoefGenericTable.setSorted(true);
        } else if (this._state.isGLM()) {
            GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(_LOADING_GLM);
            this._state.addRow(gLMCoefficientRowData);
            this._jCoefGenericTable.setModel((TableModel)this._state.getTableModel());
        }
        this.enableControls(false);
    }

    private boolean isSVM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof SVMRModelNode;
    }

    private boolean isGLM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMRModelNode;
    }

    private void initializeControls() {
        this.setupLoadingTable();
        this.enableControls(false);
    }

    private void setupSVMFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultSVMSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("SVM_FILTER_CATEGORY_COEFFICIENT")));
        this._jFilterCtl.setSelectedCategory(this._defaultSVMSearchCategory);
    }

    private void setupGLMFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultGLMSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_COEFFICIENT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_STD_ERROR")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_TEST_STATISTIC")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_P_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("STD_COEFFICIENT_COLUMN")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_LOWER_COEFF_LIMIT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_UPPER_COEFF_LIMIT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_COEFFICIENT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_LOWER_COEFF_LIMIT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_EXP_UPPER_COEFF_LIMIT")));
        this._jFilterCtl.setSelectedCategory(this._defaultGLMSearchCategory);
    }

    private void reviseGLMFilterCtl() {
        this._currentSearchCategory = 2;
        this._jFilterCtl.clearCategories();
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultGLMSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_VALUE")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("GLM_FILTER_CATEGORY_COEFFICIENT")));
        this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("STD_COEFFICIENT_COLUMN")));
        this._jFilterCtl.setSelectedCategory(this._defaultGLMSearchCategory);
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (this._state.isSVM()) {
            if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_ALL_OR"))) {
                this._currentSearchCategory = 0;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_ALL_AND"))) {
                this._currentSearchCategory = 1;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_NAME"))) {
                this._currentSearchCategory = 2;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_VALUE"))) {
                this._currentSearchCategory = 3;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("SVM_FILTER_CATEGORY_COEFFICIENT"))) {
                this._currentSearchCategory = 4;
            } else assert (false) : "Invalid Search Category Code";
        } else if (this._state.isGLM()) {
            if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_OR"))) {
                this._currentSearchCategory = 0;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_ALL_AND"))) {
                this._currentSearchCategory = 1;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_NAME"))) {
                this._currentSearchCategory = 2;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_VALUE"))) {
                this._currentSearchCategory = 3;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_COEFFICIENT"))) {
                this._currentSearchCategory = 4;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_STD_ERROR"))) {
                this._currentSearchCategory = 5;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_TEST_STATISTIC"))) {
                this._currentSearchCategory = 6;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_P_VALUE"))) {
                this._currentSearchCategory = 7;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("STD_COEFFICIENT_COLUMN"))) {
                this._currentSearchCategory = 8;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_LOWER_COEFF_LIMIT"))) {
                this._currentSearchCategory = 9;
            } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("GLM_FILTER_CATEGORY_UPPER_COEFF_LIMIT"))) {
                this._currentSearchCategory = 10;
            } else assert (false) : "Invalid Search Category Code";
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private void addListeners() {
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                RegrCoefViewer.this.translateSearchCategoryToConstant(RegrCoefViewer.this._jFilterCtl.getSelectedCategory());
                RegrCoefViewer.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                RegrCoefViewer.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                RegrCoefViewer.this.processFilter(string);
            }
        });
    }

    private void processFilter(String string) {
        try {
            if (this._state.isSVM()) {
                CoefViewerTableModel coefViewerTableModel = this._state.getSVMFilteredCoefficients(string, this._currentSearchCategory);
                this.setupSVMTable(coefViewerTableModel);
            } else if (this._state.isGLM()) {
                GLMCoefViewerTableModel gLMCoefViewerTableModel = this._state.getGLMFilteredCoefficients(string, this._currentSearchCategory);
                this.setupGLMTable(gLMCoefViewerTableModel);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
    }

    private void setupSVMTable(CoefViewerTableModel coefViewerTableModel) {
        this._jCoefGenericTable.setFixedColumnCount(0);
        this._jCoefGenericTable.setModel((TableModel)((Object)coefViewerTableModel));
        this._jCoefGenericTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jCoefGenericTable.setSorted(true);
        this._jCoefGenericTable.addDynamicCellRenderers();
        this._jCoefGenericTable.setCellRenderers();
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        this._jCoefGenericTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RegrCoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void setupGLMTable(GLMCoefViewerTableModel gLMCoefViewerTableModel) {
        this._jCoefGenericTable.setFixedColumnCount(2);
        gLMCoefViewerTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this._jCoefGenericTable.setModel((TableModel)((Object)gLMCoefViewerTableModel));
        this._jCoefGenericTable.findOrCreateTableRowHeader(this.jScrollPane1);
        String string = gLMCoefViewerTableModel.getColumnName(0);
        this._jCoefGenericTable.setFixedColumnPreferredWidth(string, 175);
        String string2 = gLMCoefViewerTableModel.getColumnName(1);
        this._jCoefGenericTable.setFixedColumnPreferredWidth(string2, 175);
        this._jCoefGenericTable.setSorted(true);
        this._jCoefGenericTable.setAutoResizeMode(3);
        this._jCoefGenericTable.addDynamicCellRenderers();
        TableColumnModel tableColumnModel = this._jCoefGenericTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(150);
        tableColumnModel.getColumn(1).setPreferredWidth(130);
        if (this._state.isCovarianceIndicator()) {
            tableColumnModel.getColumn(5).setPreferredWidth(130);
            tableColumnModel.getColumn(4).setPreferredWidth(100);
            tableColumnModel.getColumn(2).setPreferredWidth(130);
            tableColumnModel.getColumn(3).setPreferredWidth(100);
            tableColumnModel.getColumn(6).setPreferredWidth(130);
            this._jCoefGenericTable.addCellRenderer(this._state.getTableModel().getColumnName(7), new NumberRenderer());
            this._jCoefGenericTable.addCellRenderer(this._state.getTableModel().getColumnName(6), new NumberRenderer());
            this._jCoefGenericTable.addCellRenderer(this._state.getTableModel().getColumnName(4), new NumberRenderer());
            this._jCoefGenericTable.addCellRenderer(this._state.getTableModel().getColumnName(5), new NumberRenderer());
            this._jCoefGenericTable.addCellRenderer(this._state.getTableModel().getColumnName(8), new NumberRenderer());
        }
        this._jCoefGenericTable.setCellRenderers();
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        this._jCoefGenericTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RegrCoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private String formatCellValue(Object object, FormatType formatType) {
        String string = "";
        if (object == null) {
            string = null;
        } else if (object != null) {
            string = object instanceof Double ? (formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel()) + "") : object.toString();
        }
        return string;
    }

    private void setupLoadingTable() {
        this._jCoefGenericTable.setFixedColumnCount(0);
        this._jCoefGenericTable.setModel((TableModel)((Object)new LoadingTableModel()));
        this._jCoefGenericTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jCoefGenericTable.setSorted(true);
        this._jCoefGenericTable.setCellRenderers();
    }

    class LoadingTableModel
    extends GenericBaseTableModel {
        public final int NAME = 0;
        public final int COLUMN_COUNT = 1;
        private String[] columnNames = new String[]{CoefficientsLrb.get("PRIORS_ATTRIBUTE_NAME")};

        LoadingTableModel() {
            this.setColumnIdentifiers(this.columnNames);
            this.setRowCount(1);
            this.setColumnCount(this.columnNames.length);
        }

        public Object getValueAt(int n, int n2) {
            if (RegrCoefViewer.this.isSVM()) {
                return _LOADING_SVM;
            }
            if (RegrCoefViewer.this.isGLM()) {
                return _LOADING_GLM;
            }
            return "unknown details";
        }
    }

    class CoefficientFilterListener
    implements FilterListener {
        CoefficientFilterListener() {
        }

        @Override
        public void applyEvent(FilterEvent filterEvent) {
            RegrCoefViewer.this.setFilterState(filterEvent);
        }
    }

    class NumberRenderer
    extends DefaultTableCellRenderer {
        FormatType _formatType = FormatType.NUMERICAL;

        public NumberRenderer() {
        }

        public NumberRenderer(FormatType formatType) {
            this._formatType = formatType;
        }

        @Override
        public void setValue(Object object) {
            String string = RegrCoefViewer.this.formatCellValue(object, this._formatType);
            super.setValue(string);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    RegrCoefViewer.this._state.reloadCoefficients();
                } else {
                    RegrCoefViewer.this._state.load();
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return RegrCoefViewer.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    if (RegrCoefViewer.this._jFilterCtl.getText().trim().length() > 0) {
                        if (RegrCoefViewer.this._state.isSVM()) {
                            RegrCoefViewer.this.setupSVMTable(RegrCoefViewer.this._state.getSVMFilteredCoefficients(RegrCoefViewer.this._jFilterCtl.getText(), RegrCoefViewer.this._currentSearchCategory));
                        } else if (RegrCoefViewer.this._state.isGLM()) {
                            if (this._reload) {
                                RegrCoefViewer.this.setupGLMTable(RegrCoefViewer.this._state.getGLMFilteredCoefficients(RegrCoefViewer.this._jFilterCtl.getText(), RegrCoefViewer.this._currentSearchCategory));
                            } else {
                                if (!RegrCoefViewer.this._state.isCovarianceIndicator()) {
                                    RegrCoefViewer.this.reviseGLMFilterCtl();
                                }
                                RegrCoefViewer.this.setupGLMTable(RegrCoefViewer.this._state.getGLMFilteredCoefficients(RegrCoefViewer.this._jFilterCtl.getText(), RegrCoefViewer.this._currentSearchCategory));
                            }
                        }
                    } else if (RegrCoefViewer.this._state.isSVM()) {
                        RegrCoefViewer.this.setupSVMTable((CoefViewerTableModel)RegrCoefViewer.this._state.getTableModel());
                    } else if (RegrCoefViewer.this._state.isGLM()) {
                        if (this._reload) {
                            RegrCoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)RegrCoefViewer.this._state.getTableModel());
                        } else {
                            if (!RegrCoefViewer.this._state.isCovarianceIndicator()) {
                                RegrCoefViewer.this.reviseGLMFilterCtl();
                            }
                            RegrCoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)RegrCoefViewer.this._state.getTableModel());
                        }
                    }
                    RegrCoefViewer.this.loadRowsOutOfTotalLabel(new Integer(RegrCoefViewer.this._state.getTableModel().getRowCount()), RegrCoefViewer.this._state.getTotalDetailCount());
                    RegrCoefViewer.this.enableControls(true);
                    RegrCoefViewer.this._labelNumericalFormat.setMaximumFractionDigits(RegrCoefViewer.this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
                    RegrCoefViewer.this._labelPercentageFormat.setMaximumFractionDigits(RegrCoefViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    if (RegrCoefViewer.this._jCoefGenericTable.getRowCount() > 0) {
                        RegrCoefViewer.this._jCoefGenericTable.setSelectedRowsInModel(new int[]{0});
                    }
                    RegrCoefViewer.this.setLoaded(true);
                } else {
                    if (RegrCoefViewer.this._state.getTableModel() != null) {
                        RegrCoefViewer.this._state.clearRows();
                        if (RegrCoefViewer.this._state.isSVM()) {
                            CoefficientRowData coefficientRowData = new CoefficientRowData(CoefficientsLrb.get("COEFFICIENT_FAILURE"));
                            RegrCoefViewer.this._state.addRow(coefficientRowData);
                            RegrCoefViewer.this.setupSVMTable((CoefViewerTableModel)RegrCoefViewer.this._state.getTableModel());
                        } else if (RegrCoefViewer.this._state.isGLM()) {
                            GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(CoefficientsLrb.get("STATISTICS_FAILURE"));
                            RegrCoefViewer.this._state.addRow(gLMCoefficientRowData);
                            RegrCoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)RegrCoefViewer.this._state.getTableModel());
                        } else if (RegrCoefViewer.this._state.isNB()) {
                            CoefficientRowData coefficientRowData = new CoefficientRowData(CoefficientsLrb.get("PROBABILITIES_FAILURE"));
                            RegrCoefViewer.this._state.addRow(coefficientRowData);
                        }
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                RegrCoefViewer.this.setLoading(false);
            }
        }
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        CustomGenericTable() {
        }

        protected void setColumnVisible(TableColumn tableColumn, int n, boolean bl) {
        }

        @Override
        protected void handleSelectionChanged(ListSelectionModel listSelectionModel) {
            System.out.println();
        }

        @Override
        public void addDynamicCellRenderers() {
            if (RegrCoefViewer.this._state.isSVM()) {
                RegrCoefViewer.this._barRenderer = new HistogramBarRenderer(1L, true, RegrCoefViewer.this._labelNumericalFormat);
                this.addCellRenderer(RegrCoefViewer.this._state.getTableModel().getColumnName(2), RegrCoefViewer.this._barRenderer);
            } else if (RegrCoefViewer.this._state.isGLM()) {
                RegrCoefViewer.this._barRenderer = new HistogramBarRenderer(1L, true, RegrCoefViewer.this._labelNumericalFormat);
                this.addCellRenderer(RegrCoefViewer.this._state.getTableModel().getColumnName(2), RegrCoefViewer.this._barRenderer);
                this.addCellRenderer(RegrCoefViewer.this._state.getTableModel().getColumnName(3), RegrCoefViewer.this._barRenderer);
            }
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = RegrCoefViewer.this.formatCellValue(object, FormatType.NUMERICAL);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            Object object = this.getValueAt(n, n2);
            return RegrCoefViewer.this.formatCellValue(object, FormatType.NUMERICAL);
        }
    }

    private static enum FormatType {
        PERCENTAGE,
        NUMERICAL;

    }
}

