/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.controls.ComboBoxListRenderer;
import oracle.dmt.dataminer.controls.GenericTableTooltip;
import oracle.dmt.dataminer.filter.FilterConsumer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.RenameFeatureDialog;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.DataMinerViewListenerAdapter;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class CoefficientFilterPanel
extends JPanel
implements GeneralCoefficientFilterPanel {
    private CoefViewerState _state;
    private static Icon _icon;
    private View _consumerView;
    private boolean _loaded;
    private CoefViewerMainPanel _mainPanel;
    private CoefficientFilterSetting _coefFilterSetting;
    private Context _context;
    public static final String FILTER_SETTING_PROPERTY = "FILTER_SETTING_PROPERTY";
    private GenericTable _jItemFilterTable = new GenericTableTooltip();
    private static Preferences _p;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JComboBox _jTargetValueCombo;
    private JLabel _jTargetValueLabel;
    private JButton jBtnTargetEdit;

    public CoefficientFilterPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public JPanel getUIComponent() {
        return this;
    }

    public CoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, Context context, CoefViewerState coefViewerState) {
        try {
            this._mainPanel = coefViewerMainPanel;
            this._context = context;
            this._state = coefViewerState;
            this.initComponents();
            this.initRes();
            this.initUI();
            this.initializeUIState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this._jTargetValueLabel = new JLabel();
        this._jTargetValueCombo = new JComboBox();
        this.jBtnTargetEdit = new JButton();
        this._jAbsoluteValueFilter = new JCheckBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this._jApplyFilterButton = new JButton();
        this._jTargetValueLabel.setText("Target Value:");
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"", ""}));
        this.jBtnTargetEdit.setText("Edit");
        this.jBtnTargetEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this.jBtnTargetEditActionPerformed(actionEvent);
            }
        });
        this._jAbsoluteValueFilter.setText("Sort by absolute value");
        this._jAbsoluteValueFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jAbsoluteValueFilter.setMargin(new Insets(0, 0, 0, 0));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSizeLabel.setMaximumSize(new Dimension(64, 14));
        this._jFetchSizeLabel.setMinimumSize(new Dimension(64, 14));
        this._jFetchSizeLabel.setPreferredSize(new Dimension(64, 14));
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(87, 20));
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this._jTargetValueLabel, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetValueCombo, -2, 173, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jAbsoluteValueFilter, -1, -1, Short.MAX_VALUE).addGap(37, 37, 37))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnTargetEdit).addGap(280, 384, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jFetchSizeLabel, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jFetchSize, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jApplyFilterButton, GroupLayout.Alignment.LEADING, -1, 110, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jApplyFilterButton, -2, -1, -2).addComponent(this._jTargetValueLabel).addComponent(this._jTargetValueCombo, -2, -1, -2).addComponent(this.jBtnTargetEdit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jAbsoluteValueFilter).addComponent(this._jFetchSizeLabel, -2, -1, -2)).addContainerGap()));
    }

    private void jBtnTargetEditActionPerformed(ActionEvent actionEvent) {
        this.renameFeature(this._jTargetValueCombo);
    }

    @Override
    public void initRes() {
        if (this.isNMF()) {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, (Component)this._jTargetValueCombo, (String)CoefficientsLrb.get("FEATURE_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_VALUE_ADA"));
            ResourceUtils.resButton((AbstractButton)this.jBtnTargetEdit, (String)CoefficientsLrb.get("FEATURE_EDIT"));
            this.jBtnTargetEdit.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_EDIT"));
            this.jBtnTargetEdit.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_EDIT_ADA"));
        } else if (!this.isAnomaly()) {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, (Component)this._jTargetValueCombo, (String)CoefficientsLrb.get("TARGET_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("TARGET_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("TARGET_VALUE_ADA"));
        } else {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, (Component)this._jTargetValueCombo, (String)CoefficientsLrb.get("PREDICTIVE_CLASS"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("PREDICTIVE_CLASS"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("PREDICTIVE_CLASS_ADA"));
        }
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(this.getIcon());
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1000));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this._jAbsoluteValueFilter_actionPerformed(actionEvent);
            }
        });
        CoefficientItemTableModel coefficientItemTableModel = new CoefficientItemTableModel();
        this._state.setFilterItemTableModel(coefficientItemTableModel);
        this._jItemFilterTable.setModel((TableModel)((Object)coefficientItemTableModel));
        this.enableControls(false);
        this._mainPanel.addDataMinerViewListener(new DataMinerViewListenerAdapter(){

            @Override
            public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
                CoefficientFilterPanel.this.enableControls(true);
            }

            @Override
            public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
                CoefficientFilterPanel.this.enableControls(false);
            }
        });
        this._jTargetValueCombo.setRenderer(new ComboBoxListRenderer());
        this._jTargetValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this._jTargetValueCombo_actionPerformed(actionEvent);
            }
        });
        if (this.isAnomaly()) {
            this._jTargetValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{CoefViewerState.TYPICAL, CoefViewerState.OUTLIER}));
            this._jTargetValueCombo.setSelectedItem(CoefViewerState.TYPICAL);
            this._state.setPredictiveValue(CoefViewerState.TYPICAL);
        } else {
            this._jTargetValueCombo.setModel(new DefaultComboBoxModel());
        }
        if (this.isNB() || this.isNMF()) {
            this._jAbsoluteValueFilter.setVisible(false);
        }
        this.jBtnTargetEdit.setVisible(this.isNMF());
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
    }

    private boolean isSVM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof SVMCModelNode;
    }

    private boolean isAnomaly() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof ANModelNode;
    }

    private boolean isNB() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NBModelNode;
    }

    private boolean isGLM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMCModelNode;
    }

    private boolean isNMF() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NMFModelNode;
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), CoefficientsLrb.get("QUERY_ICON"));
        }
        return _icon;
    }

    @Override
    public void setupUI(CoefficientFilterSetting coefficientFilterSetting) {
        this._coefFilterSetting = coefficientFilterSetting;
        if (this.isAnomaly()) {
            this._coefFilterSetting.setFilterByAbsolute(true);
        }
        this.loadStateAttributes();
        this.enableControls(true);
        this.setLoaded(true);
    }

    public void setupUI(View view) {
        if (this._consumerView == view) {
            return;
        }
        if (view == null) {
            return;
        }
        FilterConsumer filterConsumer = (FilterConsumer)view;
        this._consumerView = view;
        if (!filterConsumer.isLoaded()) {
            this._consumerView = view;
            return;
        }
        this.setupUIDetail();
    }

    private void initializeUIState() throws Exception {
        this._coefFilterSetting = new CoefficientFilterSetting();
        this.loadStateAttributes();
    }

    private void setupUIDetail() {
        FilterConsumer filterConsumer = (FilterConsumer)this._consumerView;
        this._coefFilterSetting = (CoefficientFilterSetting)filterConsumer.getCachedFilterState();
        assert (this._coefFilterSetting != null) : "Coefficient Filter Setting state is null.";
        this.loadStateAttributes();
        this.enableControls(true);
        this.setLoaded(true);
    }

    public void unloadUI() throws Exception {
        this.enableControls(false);
        if (this._consumerView == null) {
            return;
        }
        this.updateInput();
        ((FilterConsumer)this._consumerView).setCachedFilterState(this._coefFilterSetting);
        this.clearState();
        this.setLoaded(false);
    }

    public void updateInput() throws Exception {
        Number number = this.getNumber(this._jFetchSize);
        this._coefFilterSetting.setFetchSize(number.intValue());
        this._coefFilterSetting.setUseFilterSpecification(false);
    }

    private void clearState() {
        this._consumerView = null;
        this.resetUIAttributes();
        this._jApplyFilterButton.setEnabled(false);
        this._coefFilterSetting = null;
    }

    private void resetUIAttributes() {
        this.setNumber(this._jFetchSize, 1000);
    }

    private void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jAbsoluteValueFilter.setEnabled(bl);
        this._jTargetValueCombo.setEnabled(bl);
    }

    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(true);
        if (!this.isLoaded() && this._consumerView != null) {
            this.setupUIDetail();
        }
    }

    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
        this._jApplyFilterButton.setEnabled(false);
    }

    private void loadStateAttributes() {
        if (this._coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this._modelViewerPrefenceSettings.getFetchSizeOtherModels());
            this._jAbsoluteValueFilter.setSelected(this._coefFilterSetting.getFilterAndSortByAbsolute());
        }
    }

    private void _jTargetValueCombo_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        if (this.isAnomaly()) {
            this._state.setPredictiveValue(this._jTargetValueCombo.getSelectedItem().toString());
        } else {
            this._state.setSelectedTargetClass(this._jTargetValueCombo.getSelectedItem());
        }
        this.prepareReload();
    }

    private void _jAbsoluteValueFilter_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setSortByAbsoluteValue(this._jAbsoluteValueFilter.isSelected());
        this._coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    private void prepareReload() {
        this._mainPanel.prepareReload();
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this._jApplyFilterButton.setEnabled(false);
            ValidateUpdateState validateUpdateState = new ValidateUpdateState();
            validateUpdateState.setTitle(CoefficientsLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CoefficientsLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
            if (validateUpdateState.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateUpdateState.getException(), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
                this.enableControls(true);
            }
            if (validateUpdateState.getValidation()) {
                this._mainPanel.setFilterState(this._coefFilterSetting);
            } else {
                this.enableControls(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this.enableControls(true);
        }
    }

    private void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    private void setLocale(JSpinner jSpinner, Locale locale) {
        jSpinner.setLocale(locale);
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    @Override
    public void updateTarget() {
        if (this.isAnomaly()) {
            this._jTargetValueCombo.setSelectedItem(this._state.getPredictiveValue());
            return;
        }
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(this._state.getTargetPredictions()));
        this._jTargetValueCombo.setSelectedItem(this._state.getSelectedTargetClass());
    }

    private void renameFeature(JComboBox jComboBox) {
        RenameFeatureDialog renameFeatureDialog = new RenameFeatureDialog();
        String string = jComboBox.getSelectedItem().toString();
        if (renameFeatureDialog.invoke(this._context, this._state, string)) {
            try {
                String string2 = this._state.renameFeatureLabel(renameFeatureDialog.getCurrentName(), string);
                this._state.reloadFeatureValues();
                jComboBox.setModel(new DefaultComboBoxModel<Object>(this._state.getTargetPredictions()));
                jComboBox.getModel().setSelectedItem(string2);
            }
            catch (Exception exception) {
                if (exception.getMessage().equals(CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"))) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), null);
                }
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_MESG"), null);
            }
        }
    }

    static {
        _p = Preferences.getPreferences();
    }

    class ValidateUpdateState
    extends ProgressRunnable {
        private Exception _exception;
        private Boolean _validated;
        private boolean _canceled = false;

        ValidateUpdateState() {
        }

        public boolean getValidation() {
            return this._validated;
        }

        public Exception getException() {
            return this._exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doWork() throws Exception {
            Number number;
            block5: {
                this._validated = false;
                number = CoefficientFilterPanel.this.getNumber(CoefficientFilterPanel.this._jFetchSize);
                if (null != number && number.longValue() > 0L) break block5;
                this._validated = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FETCH_SIZE_RANGE_ERROR"), (String)CoefficientsLrb.get("COEFFICIENT_ERROR_TITLE"), null);
                Boolean bl = this._validated;
                return bl;
            }
            try {
                this._validated = true;
                CoefficientFilterPanel.this._coefFilterSetting.setFetchSize(number.intValue());
                CoefficientFilterPanel.this._coefFilterSetting.setUseFilterSpecification(false);
                CoefficientFilterPanel.this._coefFilterSetting.setFilterByAbsolute(CoefficientFilterPanel.this._jAbsoluteValueFilter.isSelected());
            }
            catch (Exception exception) {
                this._exception = exception;
                this._validated = false;
            }
            return this._validated;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

