/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.util.Vector;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.aeditor.dialog.DialogState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.CoefficientBaseData;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.server.model.CoefficientWhereSpec;
import oracle.ide.Context;

public class CoefficientAddItemFilterState
implements DialogState {
    private Context _context;
    private String _validationError;
    private CoefViewerState _state;
    private Vector<? extends CoefficientBaseData> _allAttributes;
    private Vector<? super CoefficientBaseData> _selectedAttributes;
    private Vector<CoefficientSortSpec> _sortSpecs;
    private Vector<CoefficientSortSpec> _originalSortSpecs;
    private String _nameFilter;
    private String _targetFilter = " ";
    private int _fetchSize = 10000;
    static final String _EMPTY_STRING = " ";

    public CoefficientAddItemFilterState(Context context, CoefViewerState coefViewerState) {
        this._context = context;
        this._state = coefViewerState;
        this._sortSpecs = new Vector();
        this._sortSpecs.addAll(this._state.getSortSpec());
        this._originalSortSpecs = new Vector();
        this._originalSortSpecs.addAll(this._state.getSortSpec());
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    @Override
    public void validate() throws ValidationException {
        if (this._validationError != null) {
            throw new ValidationException(this._validationError);
        }
        if (this._selectedAttributes == null || this._selectedAttributes.isEmpty()) {
            this._validationError = CoefficientsLrb.get("ERROR_MSG_EMPTY_SET");
            throw new ValidationException(this._validationError);
        }
    }

    @Override
    public void load() throws Exception {
        CoefficientFilterSetting coefficientFilterSetting = new CoefficientFilterSetting();
        coefficientFilterSetting.setUseFilterSpecification(false);
        coefficientFilterSetting.setFetchSize(this._fetchSize);
        coefficientFilterSetting.setSortSpecification(this._sortSpecs);
        if (this._targetFilter.equals(_EMPTY_STRING)) {
            coefficientFilterSetting.setTargetValue(null);
        } else {
            coefficientFilterSetting.setTargetValue(this._targetFilter);
        }
        if (this._nameFilter != null && this._nameFilter.length() > 0) {
            Vector<CoefficientWhereSpec> vector = new Vector<CoefficientWhereSpec>();
            String string = this.isNameSortOption() ? "attribute_name" : "attribute_name_subname";
            vector.add(new CoefficientWhereSpec(string, 1, this._nameFilter, true));
            coefficientFilterSetting.setWhereSpecification(vector);
        } else {
            coefficientFilterSetting.setWhereSpecification(null);
        }
        this._allAttributes = this._state.getAllData(coefficientFilterSetting);
    }

    @Override
    public void clear() {
        this._validationError = null;
        this._allAttributes.clear();
    }

    void setValidationError(String string) {
        this._validationError = string;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public Object getUserObject() {
        return this._selectedAttributes;
    }

    public Vector<? extends CoefficientBaseData> getAllAttributes() {
        return this._allAttributes;
    }

    @Override
    public boolean confirm(Component component) {
        return true;
    }

    @Override
    public void finish() {
    }

    public void addSelectedAttribute(CoefficientBaseData coefficientBaseData) {
        if (this._selectedAttributes == null) {
            this._selectedAttributes = new Vector();
        }
        this._selectedAttributes.add(coefficientBaseData);
    }

    public void setSelectedAttributes(Vector<CoefficientBaseData> vector) {
        this._selectedAttributes = new Vector<CoefficientBaseData>(vector);
    }

    public void setSortSpec(Vector<CoefficientSortSpec> vector) {
        this._sortSpecs.clear();
        this._sortSpecs.addAll(vector);
    }

    public Vector<CoefficientSortSpec> getSortSpec() {
        return this._sortSpecs;
    }

    Vector<CoefficientSortSpec> getOriginalSortSpec() {
        return this._originalSortSpecs;
    }

    public boolean isNameSortOption() {
        return CoefViewerState.isNameSortOption(this._sortSpecs);
    }

    public boolean isNameSubnameSortOption() {
        return CoefViewerState.isNameSubnameSortOption(this._sortSpecs);
    }

    public boolean isValueSortOption() {
        return CoefViewerState.isValueSortOption(this._sortSpecs);
    }

    public Vector<CoefficientBaseData> getSelectedFilterItems() {
        return this._state.getSelectedFilterItems();
    }

    public Vector<Object> getTargetPredictions() {
        return this._state.getTargetPredictions();
    }

    public Object getSelectedTargetClass() {
        return this._state.getSelectedTargetClass();
    }

    public void setNameFilter(String string) {
        this._nameFilter = string;
    }

    public String getNameFilter() {
        return this._nameFilter;
    }

    public void setTargetFilter(String string) {
        this._targetFilter = string;
    }

    public String getTargetFilter() {
        return this._targetFilter;
    }

    public void setFetchSize(int n) {
        this._fetchSize = n;
    }

    public int getFetchSize() {
        return this._fetchSize;
    }
}

