/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.aeditor.dialog.BaseDialogPanel;
import oracle.dmt.dataminer.aeditor.dialog.DialogState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientAddItemFilterState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.CoefficientBaseData;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.dmt.javatools.ui.table.table.GenericTableHeaderRenderer;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;

public class CoefficientAddItemFilterPanel
extends BaseDialogPanel
implements ActionListener {
    private JButton _jApplyFilterButton;
    private JButton _jExpandButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JLabel _jFilterLabel;
    private GenericTable _jItemsReplaceTable;
    private JLabel _jItemsRetrievedLabel;
    private JTextField _jItemsRetrievedValue;
    private JLabel _jNameFilterLbl;
    private JTextField _jNameTxtField;
    private JScrollPane _jPageDescPanel;
    private JLabel _jSortByLabel1;
    private JComboBox _jSortNameSubNameValue;
    private JComboBox _jSortOrderNameSubNameValue;
    private JLabel _jTargetLbl;
    private JComboBox _jTargetValueCombo;
    private JScrollPane jFilterScrollPane;
    private JScrollPane jScrollPane1;
    public static final int ITEMS_FILTER_NAME = 0;
    public static final int ITEMS_FILTER_VALUE = 1;
    private SearchField _jFilterCtl = new SearchField();
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(CoefficientsLrb.get("ADD_ITEM_SEARCH_CATEGORY_NAME"));
    private String[] _columnNames = new String[]{CoefficientsLrb.get("ADD_ITEM_NAME_COLUMN"), CoefficientsLrb.get("ADD_ITEM_VALUE_COLUMN")};
    private static final String[] SORT_OPTION_COMBO_VALUES = new String[]{CoefViewerState.SORT_OPTION_NAME, CoefViewerState.SORT_OPTION_NAME_SUBNAME, CoefViewerState.SORT_OPTION_VALUE};
    private static final String ORDER_BY_DESCENDING = CoefficientsLrb.get("DESCENDING");
    private static final String ORDER_BY_ASCENDING = CoefficientsLrb.get("ASCENDING");
    private static final String[] SORT_ORDER_COMBO_VALUES = new String[]{ORDER_BY_DESCENDING, ORDER_BY_ASCENDING};
    private static Icon _collapseIcon;
    private static Icon _expandIcon;
    private boolean _bCollapsed = true;
    private boolean _loading = false;

    public CoefficientAddItemFilterPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jPageDescPanel = new JScrollPane();
        this._jItemsRetrievedLabel = new JLabel();
        this._jItemsRetrievedValue = new JTextField();
        this._jFilterLabel = new JLabel();
        this.jFilterScrollPane = new JScrollPane();
        this.jScrollPane1 = new JScrollPane();
        this._jItemsReplaceTable = new GenericTable();
        this._jApplyFilterButton = new JButton();
        this._jSortByLabel1 = new JLabel();
        this._jSortNameSubNameValue = new JComboBox();
        this._jSortOrderNameSubNameValue = new JComboBox();
        this._jExpandButton = new JButton();
        this._jNameFilterLbl = new JLabel();
        this._jNameTxtField = new JTextField();
        this._jTargetLbl = new JLabel();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this._jTargetValueCombo = new JComboBox();
        this._jPageDescPanel.setBorder(null);
        this._jItemsRetrievedLabel.setText("Items Retrieved:");
        this._jItemsRetrievedValue.setEditable(false);
        this._jItemsRetrievedValue.setText("100");
        this._jItemsRetrievedValue.setBorder(null);
        this._jFilterLabel.setText("Filter:");
        this.jFilterScrollPane.setBorder(null);
        this._jItemsReplaceTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{"CUSTOMER", "Marital Status", "Single"}, {"CUSTOMER", "Marital Status", "Married"}, {"CUSTOMER", "Year of Birth", "1965-1973"}, {"CUSTOMER", "Year of Birth", "1974-1985"}}, new String[]{"Name", "Subname", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jScrollPane1.setViewportView((Component)this._jItemsReplaceTable);
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setHorizontalTextPosition(0);
        this._jSortByLabel1.setText("Sort by:");
        this._jExpandButton.setText("More");
        this._jNameFilterLbl.setText("Name:");
        this._jTargetLbl.setText("Target:");
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 676, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this._jItemsRetrievedLabel, -2, 93, -2).addGap(32, 32, 32).addComponent(this._jItemsRetrievedValue, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 247, Short.MAX_VALUE).addComponent(this._jFilterLabel, -2, 38, -2).addGap(13, 13, 13).addComponent(this.jFilterScrollPane, -2, 170, -2)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jPageDescPanel, GroupLayout.Alignment.LEADING, -1, 590, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this._jTargetLbl, -1, 77, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetValueCombo, -2, 211, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jNameFilterLbl, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jSortByLabel1, GroupLayout.Alignment.LEADING, -1, 54, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jNameTxtField).addComponent(this._jSortNameSubNameValue, 0, 211, Short.MAX_VALUE)))).addGap(16, 16, 16).addComponent(this._jSortOrderNameSubNameValue, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 157, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jApplyFilterButton, -2, 80, -2).addComponent(this._jExpandButton, -2, 72, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jFetchSizeLabel, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSize, -2, 83, -2))).addContainerGap()));
        groupLayout.linkSize(0, this._jFetchSizeLabel, this._jNameFilterLbl, this._jSortByLabel1, this._jTargetLbl);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jPageDescPanel, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jSortByLabel1).addComponent(this._jExpandButton).addComponent(this._jSortOrderNameSubNameValue, -2, -1, -2).addComponent(this._jSortNameSubNameValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jNameFilterLbl).addComponent(this._jNameTxtField, -2, -1, -2))).addComponent(this._jApplyFilterButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetLbl).addComponent(this._jTargetValueCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSizeLabel).addComponent(this._jFetchSize, -2, -1, -2)).addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jItemsRetrievedLabel).addComponent(this._jItemsRetrievedValue, -2, -1, -2)).addComponent(this._jFilterLabel).addComponent(this.jFilterScrollPane, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 250, Short.MAX_VALUE).addContainerGap()));
    }

    private void initRes() {
        this._jPageDescPanel.setViewportView((Component)new JMultiLineLabel(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_DIALOG_DESC")));
        this._jPageDescPanel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_DIALOG_DESC"));
        this._jSortByLabel1.setText(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_DETAIL"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_DETAIL"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_DETAIL_ADA"));
        this._jSortByLabel1.setLabelFor(this._jSortOrderNameSubNameValue);
        this._jSortByLabel1.setToolTipText(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_DETAIL_ADA"));
        this._jItemsRetrievedLabel.setText(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_ITEMS_RETRIEVED"));
        this._jItemsRetrievedLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_ITEMS_RETRIEVED"));
        this._jItemsRetrievedLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_ITEMS_RETRIEVED_ADA"));
        this._jItemsRetrievedLabel.setLabelFor(this._jItemsRetrievedValue);
        this._jItemsRetrievedValue.setToolTipText(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_ITEMS_RETRIEVED_ADA"));
        this.jFilterScrollPane.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ADD_ITEM_NAME_GRID_FILTER"));
        ResourceUtils.resLabel((JLabel)this._jFilterLabel, (Component)this._jFilterCtl, (String)CoefficientsLrb.get("ADD_ITEM_NAME_GRID_FILTER"));
        this._jFilterLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ADD_ITEM_NAME_GRID_FILTER"));
        this._jFilterLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ADD_ITEM_NAME_GRID_FILTER_ADA"));
        ResourceUtils.resLabel((JLabel)this._jNameFilterLbl, (Component)this._jNameTxtField, (String)CoefficientsLrb.get("ADD_ITEM_NAME_NAME"));
        this._jNameFilterLbl.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ADD_ITEM_NAME_NAME"));
        this._jNameFilterLbl.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ADD_ITEM_NAME_NAME_ADA"));
        this._jNameFilterLbl.setToolTipText(CoefficientsLrb.get("ADD_ITEM_NAME_NAME_ADA"));
        ResourceUtils.resLabel((JLabel)this._jTargetLbl, (Component)this._jTargetValueCombo, (String)CoefficientsLrb.get("ADD_ITEM_NAME_TARGET"));
        this._jTargetLbl.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ADD_ITEM_NAME_TARGET"));
        this._jTargetLbl.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ADD_ITEM_NAME_TARGET_ADA"));
        this._jTargetLbl.setToolTipText(CoefficientsLrb.get("ADD_ITEM_NAME_TARGET_ADA"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1));
        this._jExpandButton.setIcon(this.getExpandIcon());
        this._jExpandButton.setText(CoefficientsLrb.get("MORE"));
        this._jExpandButton.setHorizontalTextPosition(10);
    }

    public Icon getCollapseIcon() {
        if (_collapseIcon == null) {
            _collapseIcon = UIResourceHelper.getImageIcon(this.getClass(), CoefficientsLrb.get("COLLAPSE_ICON"));
        }
        return _collapseIcon;
    }

    public Icon getExpandIcon() {
        if (_expandIcon == null) {
            _expandIcon = UIResourceHelper.getImageIcon(this.getClass(), CoefficientsLrb.get("EXPAND_ICON"));
        }
        return _expandIcon;
    }

    private void setLoading(boolean bl) {
        this._loading = bl;
        this.displayLoading(bl);
        this._jApplyFilterButton.setEnabled(!this._loading);
        this._jFilterCtl.setEnabled(!this._loading);
    }

    private void displayLoading(boolean bl) {
        if (bl) {
            this._jItemsReplaceTable.setModel((TableModel)((Object)new LoadingTableModel()));
            this._jItemsReplaceTable.setAutoResizeMode(4);
        }
    }

    protected void _jExpandButton_actionPerformed(ActionEvent actionEvent) {
        this.showExtraFilterControls(true);
        this._jExpandButton.setIcon(this.getExpandIcon());
        ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)CoefficientsLrb.get("LESS"));
        this._jExpandButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("LESS"));
        this._jExpandButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("LESS_ADA"));
        this._jExpandButton.setHorizontalTextPosition(10);
        this._bCollapsed = false;
    }

    protected void _jCollapseButton_actionPerformed(ActionEvent actionEvent) {
        this.showExtraFilterControls(false);
        this._jExpandButton.setIcon(this.getExpandIcon());
        ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)CoefficientsLrb.get("MORE"));
        this._jExpandButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("MORE"));
        this._jExpandButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("MORE_ADA"));
        this._jExpandButton.setHorizontalTextPosition(10);
        this._bCollapsed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        this.setLoading(true);
        Vector<CoefficientSortSpec> vector = this.getState().getSortSpec();
        try {
            Object object = this._jSortNameSubNameValue.getSelectedItem();
            int n = this._jSortOrderNameSubNameValue.getSelectedIndex();
            Vector<CoefficientSortSpec> vector2 = new Vector<CoefficientSortSpec>();
            vector2.add(new CoefficientSortSpec(CoefViewerState.getSortColumnName((String)object), n, true));
            this.getState().setSortSpec(vector2);
            this.getState().setNameFilter(this._jNameTxtField.getText());
            this.getState().setTargetFilter(this._jTargetValueCombo.getSelectedItem().toString());
            this.getState().setFetchSize((Integer)this._jFetchSize.getValue());
            this.enableControls(false);
            BaseDialogPanel.LoadUI loadUI = new BaseDialogPanel.LoadUI(CoefficientsLrb.get("COEFFICIENT_DLG_ERROR_LOADING_TITLE"), CoefficientsLrb.get("COEFFICIENT_DLG_ERROR_MSG"));
            loadUI.start();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this.getState().setSortSpec(vector);
        }
    }

    private void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
    }

    private void initUI() {
        this.setLoading(true);
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientAddItemFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        this._jExpandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CoefficientAddItemFilterPanel.this._bCollapsed) {
                    CoefficientAddItemFilterPanel.this._jExpandButton_actionPerformed(actionEvent);
                } else {
                    CoefficientAddItemFilterPanel.this._jCollapseButton_actionPerformed(actionEvent);
                }
            }
        });
        this._jItemsRetrievedValue.setText("0");
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this.jFilterScrollPane.setViewportView((Component)this._jFilterCtl);
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                CoefficientAddItemFilterPanel.this.translateSearchCategoryToConstant(CoefficientAddItemFilterPanel.this._jFilterCtl.getSelectedCategory());
                CoefficientAddItemFilterPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                CoefficientAddItemFilterPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                CoefficientAddItemFilterPanel.this.processFilter(string);
            }
        });
        this._jSortOrderNameSubNameValue.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_DETAIL"));
        this._jSortOrderNameSubNameValue.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("COEFFICIENT_ADD_ITEM_DETAIL_ADA"));
        this._jSortOrderNameSubNameValue.setModel(new DefaultComboBoxModel<String>(SORT_ORDER_COMBO_VALUES));
        this._jSortOrderNameSubNameValue.setSelectedItem(ORDER_BY_DESCENDING);
        this._jSortOrderNameSubNameValue.setToolTipText(CoefficientsLrb.get("ORDER_ADA"));
        this._jSortNameSubNameValue.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FILTER_SORT_OPTION"));
        this._jSortNameSubNameValue.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FILTER_SORT_OPTION_ADA"));
        this._jSortNameSubNameValue.setModel(new DefaultComboBoxModel<String>(SORT_OPTION_COMBO_VALUES));
        if (CoefViewerState.isNameSortOption(this.getState().getOriginalSortSpec())) {
            this._jSortNameSubNameValue.setSelectedItem(CoefViewerState.SORT_OPTION_NAME);
        } else if (CoefViewerState.isNameSubnameSortOption(this.getState().getOriginalSortSpec())) {
            this._jSortNameSubNameValue.setSelectedItem(CoefViewerState.SORT_OPTION_NAME_SUBNAME);
        } else {
            this._jSortNameSubNameValue.setSelectedItem(CoefViewerState.SORT_OPTION_VALUE);
        }
        this._jSortNameSubNameValue.setToolTipText(CoefficientsLrb.get("FILTER_SORT_OPTION_ADA"));
        this.loadTargetCombo();
        this.showExtraFilterControls(false);
        BaseDialogPanel.LoadUI loadUI = new BaseDialogPanel.LoadUI(CoefficientsLrb.get("COEFFICIENT_DLG_ERROR_LOADING_TITLE"), CoefficientsLrb.get("COEFFICIENT_DLG_ERROR_MSG"));
        loadUI.start();
    }

    void loadTargetCombo() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(" ");
        vector.addAll(this.getState().getTargetPredictions());
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel(vector));
        this._jTargetValueCombo.setSelectedIndex(0);
        this._jTargetValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = CoefficientAddItemFilterPanel.this._jTargetValueCombo.getSelectedItem();
                CoefficientAddItemFilterPanel.this.getState().setTargetFilter(object.toString());
            }
        });
    }

    private void showExtraFilterControls(boolean bl) {
        this._jFetchSize.setVisible(bl);
        this._jFetchSizeLabel.setVisible(bl);
        this._jNameFilterLbl.setVisible(bl);
        this._jNameTxtField.setVisible(bl);
        this._jTargetLbl.setVisible(bl);
        this._jTargetValueCombo.setVisible(bl);
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = 1;
        if (searchCategory.getLabel().equals(CoefficientsLrb.get("ADD_ITEM_SEARCH_CATEGORY_NAME"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(CoefficientsLrb.get("ADD_ITEM_SEARCH_CATEGORY_VALUE"))) {
            this._currentSearchCategory = 1;
        } else {
            n = -1;
            assert (false) : "Invalid Search Category Code";
        }
        return n;
    }

    private void setupFilterCtl() {
        this._jFilterCtl.clearCategories();
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        if (this.getState().isValueSortOption()) {
            this._currentSearchCategory = 1;
            this._jFilterCtl.addCategory(new SearchCategory(CoefficientsLrb.get("ADD_ITEM_SEARCH_CATEGORY_VALUE")));
        } else {
            this._currentSearchCategory = 0;
        }
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
    }

    private void processFilter(String string) {
        try {
            ItemFilterTableModel itemFilterTableModel = (ItemFilterTableModel)((Object)this._jItemsReplaceTable.getModel());
            if (itemFilterTableModel != null) {
                ItemFilterTableModel itemFilterTableModel2 = itemFilterTableModel.getFilteredNames(string, this._currentSearchCategory);
                this.setupTable(itemFilterTableModel2);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("ADD_ITEM_QUERY_FAILURE_TITLE"), (String)CoefficientsLrb.get("ADD_ITEM_QUERY_FAILURE_MESSAGE"), null);
        }
    }

    @Override
    protected CoefficientAddItemFilterState getState() {
        return (CoefficientAddItemFilterState)super.getState();
    }

    @Override
    public void processInput() {
        Vector<CoefficientBaseData> vector;
        int[] nArray = this._jItemsReplaceTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length < 1) {
            return;
        }
        ItemFilterTableModel itemFilterTableModel = (ItemFilterTableModel)((Object)this._jItemsReplaceTable.getModel());
        if (itemFilterTableModel != null && (vector = itemFilterTableModel.getDataVector()) != null) {
            for (int n : nArray) {
                this.getState().addSelectedAttribute(vector.get(n));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void initializeFromState(DialogState dialogState) {
        CoefficientAddItemFilterState coefficientAddItemFilterState = this.getState();
        Vector<? extends CoefficientBaseData> vector = coefficientAddItemFilterState.getAllAttributes();
        Vector<CoefficientBaseData> vector2 = coefficientAddItemFilterState.getSelectedFilterItems();
        Vector<CoefficientBaseData> vector3 = this.chooseUnpickedItems(vector, vector2);
        ItemFilterTableModel itemFilterTableModel = new ItemFilterTableModel(vector3);
        this._jItemsRetrievedValue.setText(NumericFormat.format(vector3.size(), true, 0) + "");
        this.setupTable(itemFilterTableModel);
        this.setupFilterCtl();
        this.setLoading(false);
        this.enableControls(true);
    }

    private Vector<CoefficientBaseData> chooseUnpickedItems(Vector<? extends CoefficientBaseData> vector, Vector<CoefficientBaseData> vector2) {
        Vector vector3;
        boolean bl = CoefViewerState.isValueSortOption(this.getState().getSortSpec());
        CoefficientBaseData.COMPARISON_LEVEL cOMPARISON_LEVEL = bl ? CoefficientBaseData.COMPARISON_LEVEL.NAME_SUBNAME_VALUE : (CoefViewerState.isNameSubnameSortOption(this.getState().getSortSpec()) ? CoefficientBaseData.COMPARISON_LEVEL.NAME_SUBNAME : CoefficientBaseData.COMPARISON_LEVEL.NAME);
        Vector<CoefficientBaseData> vector4 = new Vector<CoefficientBaseData>();
        if (vector2 == null || vector2.isEmpty()) {
            vector4.addAll(vector);
            for (CoefficientBaseData coefficientBaseData : vector4) {
                coefficientBaseData.setComparisonLevel(cOMPARISON_LEVEL);
            }
            return vector4;
        }
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
        for (CoefficientBaseData object2 : vector) {
            vector3 = (Vector)hashMap.get(object2.getAttributeFullName());
            if (vector3 == null) {
                vector3 = new Vector();
                hashMap.put(object2.getAttributeFullName(), vector3);
            }
            object2.setComparisonLevel(cOMPARISON_LEVEL);
            vector3.add(object2);
        }
        for (CoefficientBaseData coefficientBaseData : vector2) {
            if (coefficientBaseData.isNameSubnameValueSort() && bl) {
                vector3 = (Vector)hashMap.get(coefficientBaseData.getAttributeFullName());
                if (vector3 == null) continue;
                vector3.remove(coefficientBaseData);
                continue;
            }
            if (coefficientBaseData.isNameSubnameValueSort() || bl || null == hashMap.get(coefficientBaseData.getAttributeFullName())) continue;
            hashMap.remove(coefficientBaseData.getAttributeFullName());
        }
        Vector vector5 = new Vector(hashMap.values());
        Iterator iterator = vector5.iterator();
        while (iterator.hasNext()) {
            vector3 = (Vector)iterator.next();
            vector4.addAll(vector3);
        }
        hashMap.clear();
        return vector4;
    }

    private void setupTable(ItemFilterTableModel itemFilterTableModel) {
        this._jItemsReplaceTable.setModel((TableModel)((Object)itemFilterTableModel));
        this._jItemsReplaceTable.setSorted(true);
        this._jItemsReplaceTable.setUpdateSelectionOnSort(true);
        this._jItemsReplaceTable.getTableHeader().setReorderingAllowed(false);
        GenericTableHeaderRenderer genericTableHeaderRenderer = (GenericTableHeaderRenderer)this._jItemsReplaceTable.getTableHeader().getDefaultRenderer();
        genericTableHeaderRenderer.setHorizontalAlignment(0);
    }

    class LoadingTableModel
    extends GenericBaseTableModel {
        public final int NAME = 0;
        public final int COLUMN_COUNT = 1;
        private String[] columnNames = new String[]{CoefficientsLrb.get("PRIORS_ATTRIBUTE_NAME")};

        LoadingTableModel() {
            this.setColumnIdentifiers(this.columnNames);
            this.setRowCount(1);
            this.setColumnCount(this.columnNames.length);
        }

        public Object getValueAt(int n, int n2) {
            return CoefficientsLrb.get("COEFFICIENT_DLG_LOADING_ATTRIBUTES");
        }
    }

    class ItemFilterTableModel
    extends GenericBaseTableModel {
        private Vector<CoefficientBaseData> _data;
        private static final int COLUMN_COUNT = 2;
        public static final int NAME = 0;
        public static final int VALUE = 1;

        public ItemFilterTableModel(Vector<? extends CoefficientBaseData> vector) {
            this.setColumnIdentifiers(CoefficientAddItemFilterPanel.this._columnNames);
            this._data = new Vector<CoefficientBaseData>(vector);
            this.setRowCount(vector.size());
            this.setColumnCount(2);
        }

        public int getRowCount() {
            return this._data != null ? this._data.size() : 0;
        }

        public Vector<CoefficientBaseData> getDataVector() {
            return this._data;
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            CoefficientBaseData coefficientBaseData = this._data.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = coefficientBaseData.getAttributeFullName();
                    break;
                }
                case 1: {
                    if (coefficientBaseData != null && coefficientBaseData.isNameSubnameValueSort()) {
                        string = coefficientBaseData.getValue();
                        break;
                    }
                    string = "";
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column when accessing items";
                    break;
                }
            }
            return string;
        }

        public ItemFilterTableModel getFilteredNames(String string, int n) throws Exception {
            Vector<CoefficientBaseData> vector = null;
            SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
            Vector<CoefficientBaseData> vector2 = this.getDataVector();
            vector = new Vector<CoefficientBaseData>();
            Iterator<CoefficientBaseData> iterator = vector2.iterator();
            CoefficientBaseData coefficientBaseData = null;
            boolean bl = string.length() <= 0;
            boolean bl2 = false;
            while (iterator.hasNext()) {
                coefficientBaseData = iterator.next();
                if (bl) {
                    bl2 = true;
                } else {
                    String string2 = "";
                    switch (n) {
                        case 0: {
                            string2 = coefficientBaseData.getAttributeFullName();
                            break;
                        }
                        case 1: {
                            string2 = coefficientBaseData.getValue();
                            break;
                        }
                        default: {
                            assert (false) : "Invalid item filter category.";
                            string2 = coefficientBaseData.getAttributeFullName();
                        }
                    }
                    bl2 = string2 == null ? false : searchMatcher.matches((CharSequence)string2);
                }
                if (!bl2) continue;
                vector.add(coefficientBaseData);
            }
            return new ItemFilterTableModel(vector);
        }
    }
}

