/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.utils.AbsoluteNumberComparator;
import oracle.dmt.dataminer.utils.NumberComparator;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.javatools.ui.search.SearchMatcher;

public class CoefViewerTableModel
extends GenericBaseTableModel {
    private Vector<CoefficientRowData> _data = new Vector(1000, 500);
    private static final int COLUMN_COUNT = 3;
    public static final int ATTRIBUTE = 0;
    public static final int VALUE = 1;
    public static final int COEEFICIENT = 2;
    private boolean _absoluteSort = false;
    private String[] _columnNames = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN")};

    public CoefViewerTableModel() {
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(3);
    }

    public CoefViewerTableModel(Vector<CoefficientRowData> vector) {
        this.setColumnIdentifiers(this._columnNames);
        this._data = vector;
        this.setRowCount(vector.size());
        this.setColumnCount(3);
    }

    public CoefViewerTableModel getFilteredCoefficients(String string, int n) throws Exception {
        SearchMatcher searchMatcher;
        Vector<CoefficientRowData> vector = null;
        boolean bl = n == 0;
        switch (n) {
            case 2: 
            case 3: {
                searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
                break;
            }
            case 0: 
            case 1: 
            case 4: {
                searchMatcher = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)bl);
                break;
            }
            default: {
                assert (false) : "Invalid coefficient filter category.";
                searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
            }
        }
        Vector<CoefficientRowData> vector2 = this.getDataVector();
        vector = new Vector<CoefficientRowData>(1000, 500);
        Iterator<CoefficientRowData> iterator = vector2.iterator();
        CoefficientRowData coefficientRowData = null;
        boolean bl2 = string.length() <= 0;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            coefficientRowData = iterator.next();
            if (bl2) {
                bl3 = true;
            } else {
                String string2;
                switch (n) {
                    case 2: {
                        string2 = coefficientRowData.getAttributeFullName();
                        break;
                    }
                    case 3: {
                        string2 = coefficientRowData.getValue();
                        break;
                    }
                    case 4: {
                        string2 = coefficientRowData.getCoefficient1() != null ? NumericFormat.format(coefficientRowData.getCoefficient1(), true, 8) + "" : "";
                        break;
                    }
                    case 0: 
                    case 1: {
                        String string3 = coefficientRowData.getCoefficient1() != null ? NumericFormat.format(coefficientRowData.getCoefficient1(), true, 8) + "" : "";
                        string2 = coefficientRowData.getAttributeFullName() + " " + coefficientRowData.getValue() + " " + string3;
                        break;
                    }
                    default: {
                        assert (false) : "Invalid coefficient filter category.";
                        string2 = coefficientRowData.getAttributeFullName();
                    }
                }
                bl3 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl3) continue;
            vector.add(coefficientRowData);
        }
        return new CoefViewerTableModel(vector);
    }

    public void addRows(Vector<CoefficientRowData> vector) {
        for (CoefficientRowData coefficientRowData : vector) {
            this.getDataVector().add(coefficientRowData);
        }
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public CoefficientRowData getRow(int n) {
        return this._data.get(n);
    }

    public void addSelection(CoefViewerTableModel coefViewerTableModel, int[] nArray) {
        Vector<CoefficientRowData> vector = coefViewerTableModel.getDataVector();
        CoefficientRowData coefficientRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            coefficientRowData = vector.elementAt(nArray[i]);
            this._data.add(coefficientRowData);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Vector<CoefficientRowData> getDataVector() {
        return this._data;
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        CoefficientRowData coefficientRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            coefficientRowData = this._data.elementAt(nArray[i]);
            vector.add(coefficientRowData);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        comparator = n == 2 ? (this._absoluteSort ? AbsoluteNumberComparator.getComparator() : NumberComparator.getComparator()) : super.getColumnSortComparator(n);
        return comparator;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        CoefficientRowData coefficientRowData = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = coefficientRowData.getAttributeFullName();
                break;
            }
            case 1: {
                object = coefficientRowData.getValue();
                break;
            }
            case 2: {
                object = coefficientRowData.getCoefficient1();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        if (object == null) {
            return "NULL";
        }
        return object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }

    public void addRow(CoefficientRowData coefficientRowData) {
        this._data.add(coefficientRowData);
    }
}

