/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree.model;

import ilog.views.sdm.model.IlvAbstractSDMModel;
import ilog.views.sdm.model.IlvMutableSDMNode;
import ilog.views.sdm.model.IlvSDMNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeLink;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeNode;
import oracle.dmt.dataminer.server.model.ClusteringDetailRow;
import oracle.ide.Context;

public class ClusterTreeSDMModel
extends IlvAbstractSDMModel {
    private Vector<ClusteringDetailRow> clusterDetailRows;
    private ClusteringDetailRow rootNodeMetadata;
    private LinkedHashMap<String, IlvSDMNode> nodeStore = null;
    private Context context;
    private long maxId = 0L;
    private Boolean isLoaded = false;
    private int attributeCount;
    private int maxTargetValues = 5;
    private Boolean headerDetailVisible = true;

    public IlvSDMNode getObject(String string) {
        return this.nodeStore.get(string);
    }

    public void load(Vector<ClusteringDetailRow> vector, Context context) throws Exception {
        TreeNode treeNode;
        HashMap<Integer, TreeNode> hashMap = new HashMap<Integer, TreeNode>();
        this.context = context;
        this.nodeStore = new LinkedHashMap();
        this.attributeCount = 0;
        this.clusterDetailRows = vector;
        this.rootNodeMetadata = null;
        for (ClusteringDetailRow clusteringDetailRow : vector) {
            if (clusteringDetailRow.getParent() != 0) continue;
            this.rootNodeMetadata = clusteringDetailRow;
            break;
        }
        for (ClusteringDetailRow clusteringDetailRow : vector) {
            treeNode = TreeNode.createNode(clusteringDetailRow, this.context);
            hashMap.put(clusteringDetailRow.getId(), treeNode);
        }
        for (ClusteringDetailRow clusteringDetailRow : vector) {
            treeNode = (TreeNode)hashMap.get(clusteringDetailRow.getId());
            TreeNode treeNode2 = (TreeNode)hashMap.get(clusteringDetailRow.getParent());
            if (treeNode2 == null && clusteringDetailRow.getId() != 1) {
                throw new RuntimeException("non root node without parent encountered");
            }
            if (treeNode2 != null) {
                TreeLink treeLink = TreeLink.createLink(treeNode, treeNode2);
                this.addObject((Object)treeLink, null, null);
            }
            this.updateAttributeCount(clusteringDetailRow);
            this.addObject(treeNode, treeNode2, null);
        }
        if (this.rootNodeMetadata == null) {
            throw new RuntimeException("Tree root node not found in content model");
        }
        this.setEditable(true);
        this.isLoaded = true;
    }

    private void updateAttributeCount(ClusteringDetailRow clusteringDetailRow) {
        int n = clusteringDetailRow.getCentroid().size();
        if (this.attributeCount < n) {
            this.attributeCount = n;
        }
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public Boolean isLoaded() {
        return this.isLoaded;
    }

    public void addObject(Object object, Object object2, Object object3) {
        super.addObject(object, object2, object3);
        if (object instanceof TreeNode) {
            this.nodeStore.put(((IlvSDMNode)object).getID(), (IlvSDMNode)object);
        } else if (object instanceof TreeLink) {
            this.nodeStore.put(((IlvSDMNode)object).getID(), (IlvSDMNode)object);
        } else {
            throw new RuntimeException("Unexpected obj type");
        }
        this.fireObjectAdded(object);
    }

    public Enumeration<IlvSDMNode> getObjects() {
        if (this.nodeStore == null) {
            return null;
        }
        return new Vector<IlvSDMNode>(this.nodeStore.values()).elements();
    }

    public void addObjectImpl(Object object, Object object2, Object object3) {
        if (object instanceof IlvMutableSDMNode) {
            IlvMutableSDMNode ilvMutableSDMNode = (IlvMutableSDMNode)object;
            ilvMutableSDMNode.setID(this.getNextNewIdString());
        }
    }

    public List<TreeLink> findLinksToNode(IlvSDMNode ilvSDMNode) {
        ArrayList<TreeLink> arrayList = new ArrayList<TreeLink>();
        for (IlvSDMNode ilvSDMNode2 : this.nodeStore.values()) {
            TreeLink treeLink;
            if (!(ilvSDMNode2 instanceof TreeLink) || !(treeLink = (TreeLink)ilvSDMNode2).getTo().getID().equals(ilvSDMNode.getID())) continue;
            arrayList.add(treeLink);
        }
        return arrayList;
    }

    public boolean isSplitPredicateForNode(TreeNode treeNode) {
        int n;
        int n2 = n = treeNode.getData().getId().intValue();
        TreeNode treeNode2 = treeNode.findParentNode();
        List<TreeLink> list = this.findLinksFromNode((IlvSDMNode)treeNode2);
        for (TreeLink treeLink : list) {
            TreeNode treeNode3 = (TreeNode)treeLink.getTo();
            if (treeNode3.getData().getId() >= n2) continue;
            n2 = treeNode3.getData().getId();
        }
        return n2 == n;
    }

    public List<TreeLink> findLinksFromNode(IlvSDMNode ilvSDMNode) {
        ArrayList<TreeLink> arrayList = new ArrayList<TreeLink>();
        for (IlvSDMNode ilvSDMNode2 : this.nodeStore.values()) {
            TreeLink treeLink;
            if (!(ilvSDMNode2 instanceof TreeLink) || !(treeLink = (TreeLink)ilvSDMNode2).getFrom().getID().equals(ilvSDMNode.getID())) continue;
            arrayList.add(treeLink);
        }
        return arrayList;
    }

    public void clear() {
        this.nodeStore.clear();
    }

    public Context getContext() {
        return this.context;
    }

    public void refresh() {
        try {
            this.load(this.clusterDetailRows, this.context);
            this.fireDataChanged(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public long getNextNewId() {
        ++this.maxId;
        return this.maxId;
    }

    public String getNextNewIdString() {
        ++this.maxId;
        return Long.valueOf(this.maxId).toString();
    }

    public ClusteringDetailRow getRootNodeMetadata() {
        return this.rootNodeMetadata;
    }

    public void toggleHeaderDetailVisible() {
        this.headerDetailVisible = this.headerDetailVisible == false;
    }

    public void setHeaderDetailVisible(boolean bl) {
        this.headerDetailVisible = bl;
    }

    public Boolean isHeaderDetailVisible() {
        return this.headerDetailVisible;
    }

    public int getMaxTargetValuesDisplayed() {
        return this.maxTargetValues;
    }

    public void setMaxTargetValuesDisplayed(int n) {
        this.maxTargetValues = n;
        Set<String> set = this.nodeStore.keySet();
        for (String string : set) {
            IlvSDMNode ilvSDMNode = this.nodeStore.get(string);
            if (!(ilvSDMNode instanceof TreeNode)) continue;
            ((TreeNode)ilvSDMNode).setMaxValuesDisplayed(this.maxTargetValues);
        }
        this.fireDataChanged(null);
    }
}

