/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class TreeNodePreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private JLabel headerLabel;
    private NumberTextField nameMaxLength;
    private JLabel nameMaxLengthLabel;
    private NumberTextField valueMaxLength;
    private JLabel valueMaxLengthLabel;
    private static final int MAX_VALUE = 50;
    private static final int MIN_VALUE = 5;

    public TreeNodePreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.nameMaxLengthLabel = new JLabel();
        this.headerLabel = new JLabel();
        this.valueMaxLengthLabel = new JLabel();
        this.nameMaxLength = new NumberTextField();
        this.valueMaxLength = new NumberTextField();
        this.nameMaxLengthLabel.setLabelFor((Component)this.nameMaxLength);
        this.nameMaxLengthLabel.setText("Name Maximum Length:");
        this.headerLabel.setText("Cluster Tree Node Attributes");
        this.valueMaxLengthLabel.setLabelFor((Component)this.valueMaxLength);
        this.valueMaxLengthLabel.setText("Value Maximum Length:");
        this.nameMaxLength.setText("30");
        this.valueMaxLength.setText("30");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameMaxLengthLabel).addComponent(this.valueMaxLengthLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.valueMaxLength, -1, 132, Short.MAX_VALUE).addComponent((Component)this.nameMaxLength, -1, 132, Short.MAX_VALUE))).addComponent(this.headerLabel)).addGap(126, 126, 126)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.headerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameMaxLengthLabel).addComponent((Component)this.nameMaxLength, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.valueMaxLengthLabel).addComponent((Component)this.valueMaxLength, -2, -1, -2)).addContainerGap(223, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(ClusteringTreeEditorLrb.get("LONG_VALUES_LABEL"), this.headerLabel);
        hashMap.put(ClusteringTreeEditorLrb.get("TRUNCATE_NAME_LABEL"), this.nameMaxLengthLabel);
        hashMap.put(ClusteringTreeEditorLrb.get("TRUNCATE_VALUE_LABEL"), this.valueMaxLengthLabel);
        UIResourceHelper.setComponentText(hashMap);
        this.setHelpID("data_miner_prefs");
    }

    @Override
    public void initUI() {
        this.nameMaxLength.setDataType(Integer.class);
        this.nameMaxLength.setSigned(false);
        this.nameMaxLength.setLocale(this.getLocale());
        this.nameMaxLength.setToolTipText(ClusteringTreeEditorLrb.get("TRUNCATE_NAME_TIP"));
        this.valueMaxLength.setDataType(Integer.class);
        this.valueMaxLength.setSigned(false);
        this.valueMaxLength.setLocale(this.getLocale());
        this.valueMaxLength.setToolTipText(ClusteringTreeEditorLrb.get("TRUNCATE_VALUE_TIP"));
    }

    public void onEntry(TraversableContext traversableContext) {
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = TreeNodePreferencesPanel.getPreferences(traversableContext);
        this.nameMaxLength.setNumber((Number)clusteringTreePreferencesSettings.getMaxAttributeDisplayLength());
        this.valueMaxLength.setNumber((Number)clusteringTreePreferencesSettings.getMaxValueDisplayLength());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = TreeNodePreferencesPanel.getPreferences(traversableContext);
        boolean bl = false;
        boolean bl2 = false;
        int n = this.nameMaxLength.getNumber().intValue();
        if (n < 5) {
            n = 5;
            bl = true;
        } else if (n > 50) {
            n = 50;
            bl2 = true;
        }
        int n2 = this.valueMaxLength.getNumber().intValue();
        if (n2 < 5) {
            n2 = 5;
            bl = true;
        } else if (n2 > 50) {
            n2 = 50;
            bl2 = true;
        }
        if (bl2 || bl) {
            String string = "Numeric range must be between {0} and {1} characters";
            Object[] objectArray = new Object[]{5, 50};
            string = MessageFormat.format(string, objectArray);
            throw new TraversalException(string);
        }
        clusteringTreePreferencesSettings.setMaxValueDisplayLength(n2);
        clusteringTreePreferencesSettings.setMaxAttributeDisplayLength(n);
    }

    private static ClusteringTreePreferencesSettings getPreferences(TraversableContext traversableContext) {
        return ClusteringTreePreferencesSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

