/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class ClusteringTreePreferencesSettings
extends DataMinerPreferenceSettings {
    private static final String DATA_KEY = "oracle.dmt.dataminer.mviewer.dtree.ClusterTreeViewerPreferencesSettings";
    protected static final String SHOW_NODE_DETAIL_HEADER = "showNodeDetailHeader";
    protected static final String HORIZONTAL_LAYOUT = "horizontalLayout";
    protected static final String MAX_ATTRIBUTE_LENGTH = "treeNodeAttributeMaxLength";
    protected static final String MAX_VALUE_LENGTH = "treeNodeAttributeMaxValLength";
    protected static final String WRAP_NODE_RULES = "wrapNodeRules";
    protected static final String TOP_N_RULE_ATTRIBUTES = "topNRuleAttributes";
    protected static final String TOP_N_IMPORTANCE_ATTRIBUTES = "topNImportanceAttributes";
    protected static final String TOP_N_CENTROID_ATTRIBUTES = "topNCentroidAttributes";
    protected static final int MAX_ATTRIBUTE_LENGTH_DEFAULT = 25;
    protected static final int MAX_VALUE_DISPLAY_LENGTH_DEFAULT = 25;
    protected static final int DEFAULT_TOPN_RULE_ATTRIBUTES = 5;
    protected static final int DEFAULT_TOPN_IMPORTANCE_ATTRIBUTES = 5;
    protected static final int DEFAULT_TOPN_CENTROID_ATTRIBUTES = 10;

    public static ClusteringTreePreferencesSettings getInstance() {
        return ClusteringTreePreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private ClusteringTreePreferencesSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static ClusteringTreePreferencesSettings getInstance(PropertyStorage propertyStorage) {
        return new ClusteringTreePreferencesSettings(ClusteringTreePreferencesSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public void setShowNodeDetailHeader(boolean bl) {
        this._hash.putBoolean(SHOW_NODE_DETAIL_HEADER, bl);
    }

    public boolean isShowNodeDetailHeader() {
        return this._hash.getBoolean(SHOW_NODE_DETAIL_HEADER, true);
    }

    public void setHorizontalOrientation(boolean bl) {
        this._hash.putBoolean(HORIZONTAL_LAYOUT, bl);
    }

    public boolean isHorizontalLayout() {
        return this._hash.getBoolean(HORIZONTAL_LAYOUT, false);
    }

    public void setMaxAttributeDisplayLength(int n) {
        this._hash.putInt(MAX_ATTRIBUTE_LENGTH, n);
    }

    public int getMaxAttributeDisplayLength() {
        return this._hash.getInt(MAX_ATTRIBUTE_LENGTH, 25);
    }

    public void setMaxValueDisplayLength(int n) {
        this._hash.putInt(MAX_VALUE_LENGTH, n);
    }

    public int getMaxValueDisplayLength() {
        return this._hash.getInt(MAX_VALUE_LENGTH, 25);
    }

    public void setWrapNodeRules(boolean bl) {
        this._hash.putBoolean(WRAP_NODE_RULES, bl);
    }

    public boolean getWrapNodeRules() {
        return this._hash.getBoolean(WRAP_NODE_RULES, false);
    }

    public void setTopNRuleAttributes(int n) {
        this._hash.putInt(TOP_N_RULE_ATTRIBUTES, n);
    }

    public int getTopNRuleAttributes() {
        return this._hash.getInt(TOP_N_RULE_ATTRIBUTES, 5);
    }

    public void setTopNImportanceAttributes(int n) {
        this._hash.putInt(TOP_N_IMPORTANCE_ATTRIBUTES, n);
    }

    public int getTopNImportanceAttributes() {
        return this._hash.getInt(TOP_N_IMPORTANCE_ATTRIBUTES, 5);
    }

    public void setTopNCentroidAttributes(int n) {
        this._hash.putInt(TOP_N_CENTROID_ATTRIBUTES, n);
    }

    public int getTopNCentroidAttributes() {
        return this._hash.getInt(TOP_N_CENTROID_ATTRIBUTES, 10);
    }
}

