/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.tree.IlvTreeLayout;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.core.editor.ScrollManagerView;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.framework.menu.DefaultDiagramMainMenuPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.framework.readonly.DefaultDiagramReadOnlyPlugin;
import oracle.diagram.framework.readonly.DiagramReadOnlyPlugin;
import oracle.diagram.framework.toolbar.DefaultDiagramToolbarPlugin;
import oracle.diagram.framework.toolbar.ToolbarPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringQuerySettingsDialog;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeContextMenu;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeDiagram;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.NodeDetailPane;
import oracle.dmt.dataminer.mviewer.clustering.tree.TreeRule;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeLink;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeNode;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class ClusteringTreeEditor
extends DataMinerDiagramEditor {
    private int _treeFlowDirection;
    private int _maxAttributeLength;
    private int _maxValueLength;
    private NumberFormat percentFormat;
    private int topNAttributes;
    private JSplitPane splitComponent;
    private JScrollPane detailView;
    private JEditorPane textEditorPane;
    private static int DOLAYOUT_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.doLayout");
    private static int TOGGLE_DETAIL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.toggleDetailedHeader");
    private static int EXPAND_ALL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.expandAllNodes");
    private static Icon _doFitToWindowIcon = null;
    private static Icon _toggleVerticalTreeIcon = null;
    private static Icon _toggleHorizonaTreeIcon = null;
    private static Icon _toggleHeaderDetailIcon = null;
    private static Icon _expandAllIcon = null;
    private static final int MAX_VISIBLE_ATTRIBUTES = 10;
    private static final int MIN_VISIBLE_ATTRIBUTES = 1;
    private static final int DEFAULT_SELECTED_ATTRIBUTES = 4;

    public ClusteringTreeEditor() {
        super((Diagram)new ClusteringTreeDiagram());
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this.topNAttributes = clusteringTreePreferencesSettings.getTopNCentroidAttributes();
        this._treeFlowDirection = !clusteringTreePreferencesSettings.isHorizontalLayout() ? 8 : 2;
        this._maxAttributeLength = clusteringTreePreferencesSettings.getMaxAttributeDisplayLength();
        this._maxValueLength = clusteringTreePreferencesSettings.getMaxValueDisplayLength();
        this.setPreferredLayoutBaseName("Tree");
        Preferences preferences = Preferences.getPreferences();
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)preferences);
        this.percentFormat = NumericFormat.getInstance(true, modelViewerPreferenceSettings.getPercentagePrecisionLevel(), modelViewerPreferenceSettings.getPercentagePrecisionLevel(), 1);
    }

    public NumberFormat getNumberFormat() {
        return this.percentFormat;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("cluster_tree_diagram_editor");
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return ClusteringTreeContextMenu.getInstance();
    }

    @Override
    public void refresh() {
    }

    protected void installEditorPlugins(Diagram diagram) {
        super.installEditorPlugins(diagram);
        DiagramContext diagramContext = diagram.getDiagramContext();
        diagramContext.addPlugin(DiagramMainMenuPlugin.class, (Plugin)DefaultDiagramMainMenuPlugin.getInstance());
        diagramContext.addPlugin(DiagramReadOnlyPlugin.class, (Plugin)new OdmrReadOnlyPlugin(diagramContext));
        diagramContext.addPlugin(ToolbarPlugin.class, (Plugin)new TreeViewerToolbarPlugin(diagramContext));
        diagramContext.addPlugin(SelectionChangeNotificationPlugin.class, (Plugin)new SelectionChangePlugin());
    }

    public void initializeLayout(Layout layout) {
        super.initializeLayout(layout);
        layout.setProperty("Layout.ShowUnifiedThumbnail", Boolean.TRUE.toString());
    }

    @Override
    public void open() throws OpenAbortedException {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this.getDiagram().getContext().getNode();
        try {
            IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
            SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
            final ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)clusteringModelNode.getFilteredModel(sDMUndoFilter);
            ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
            clusterTreeSDMModel.setHeaderDetailVisible(clusteringTreePreferencesSettings.isShowNodeDetailHeader());
            ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance();
            clusteringTreePreferencesSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                    ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                    boolean bl = false;
                    for (int i = 0; i < changeInfoArray.length; ++i) {
                        ChangeInfo changeInfo = changeInfoArray[i];
                        if (changeInfo.getPropertyName().equals("treeNodeAttributeMaxLength")) {
                            ClusteringTreeEditor.this._maxAttributeLength = changeInfo.getNewValueAsInt();
                            bl = true;
                            continue;
                        }
                        if (!changeInfo.getPropertyName().equals("treeNodeAttributeMaxValLength")) continue;
                        ClusteringTreeEditor.this._maxValueLength = changeInfo.getNewValueAsInt();
                        bl = true;
                    }
                    if (bl) {
                        clusterTreeSDMModel.fireDataChanged(null);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, false);
                    }
                }
            });
            modelViewerPreferenceSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                    ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                    boolean bl = false;
                    for (int i = 0; i < changeInfoArray.length; ++i) {
                        ChangeInfo changeInfo = changeInfoArray[i];
                        if (!changeInfo.getPropertyName().equals("percentage_precision_level")) continue;
                        ClusteringTreeEditor.this.percentFormat = NumericFormat.getInstance(true, changeInfo.getNewValueAsInt(), changeInfo.getNewValueAsInt(), 1);
                        bl = true;
                    }
                    if (bl) {
                        clusterTreeSDMModel.fireDataChanged(null);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, false);
                    }
                }
            });
            if (clusteringModelNode.isModelExists().booleanValue()) {
                this.loadTreeModel(clusteringModelNode, clusterTreeSDMModel);
                ilvSDMEngine.setModel((IlvSDMModel)sDMUndoFilter);
                this.doLayout(this._treeFlowDirection, true);
                this.setPropertyChangeListener(ilvSDMEngine, clusterTreeSDMModel);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ModelViewerLrb.get("LOAD_MODEL_MISSING"), (String)ModelViewerLrb.get("MODEL_MISSING_TITLE"), null);
                this.abortOpen((Node)clusteringModelNode, ModelViewerLrb.get("MODEL_DOES_NOT_EXIST"));
            }
        }
        catch (Exception exception) {
            if (exception instanceof OpenAbortedException) {
                throw (OpenAbortedException)exception;
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelViewerLrb.get("FAILED_ERROR_TITLE"), (String)ModelViewerLrb.get("FAILED_OPEN"), null);
            this.abortOpen((Node)clusteringModelNode);
        }
        super.open();
    }

    private IlvSDMEngine getEngine() throws IOException {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this.getDiagram().getContext().getNode();
        return clusteringModelNode.getEngine();
    }

    private void reload() {
        try {
            ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this.getDiagram().getContext().getNode();
            IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
            SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
            ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)clusteringModelNode.getFilteredModel(sDMUndoFilter);
            clusteringModelNode.setTopNAttributes(this.topNAttributes);
            clusteringModelNode.load();
            if (clusteringModelNode.isModelExists().booleanValue()) {
                this.loadTreeModel(clusteringModelNode, clusterTreeSDMModel);
                ilvSDMEngine.setModel((IlvSDMModel)sDMUndoFilter);
                this.doLayout(this._treeFlowDirection, false);
                this.setPropertyChangeListener(ilvSDMEngine, clusterTreeSDMModel);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ModelViewerLrb.get("RELOAD_MODEL_MISSING"), (String)ModelViewerLrb.get("MODEL_MISSING_TITLE"), null);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelViewerLrb.get("FAILED_ERROR_TITLE"), (String)ModelViewerLrb.get("FAILED_OPEN"), null);
        }
    }

    private void setPropertyChangeListener(IlvSDMEngine ilvSDMEngine, ClusterTreeSDMModel clusterTreeSDMModel) {
        Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
        while (enumeration.hasMoreElements()) {
            IlvSDMNode ilvSDMNode = enumeration.nextElement();
            if (!(ilvSDMNode instanceof TreeNode)) continue;
            TreeNode treeNode = (TreeNode)ilvSDMNode;
            treeNode.assignPropertyChangeListener(ilvSDMEngine);
        }
        clusterTreeSDMModel.addSDMPropertyChangeListener(new ModelListener());
    }

    public int getMaxAttributeLength() {
        return this._maxAttributeLength;
    }

    public int getMaxValueLength() {
        return this._maxValueLength;
    }

    public void refreshLayout(TreeNode treeNode) {
        this.doLayout(this._treeFlowDirection, false);
        try {
            this.getEngine().setSelected((Object)treeNode, true);
        }
        catch (IOException iOException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLayout(int n, boolean bl) {
        IlvSDMEngine ilvSDMEngine;
        TreeNode treeNode = null;
        try {
            ilvSDMEngine = this.getEngine();
            treeNode = this.getSelectedDiagramNode();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            return;
        }
        IlvTreeLayout ilvTreeLayout = new IlvTreeLayout();
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        ilvTreeLayout.attach(ilvGrapher);
        ilvTreeLayout.setFlowDirection(n);
        ilvTreeLayout.setGlobalLinkStyle(2);
        try {
            ilvTreeLayout.performLayout();
            if (treeNode != null) {
                ilvSDMEngine.setSelected((Object)treeNode, true);
            }
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            System.out.println(ilvGraphLayoutException.getMessage());
        }
        finally {
            IlvManagerView ilvManagerView;
            if (bl && (ilvManagerView = this.getDiagram().getDiagramContext().getManagerView()) != null) {
                ilvManagerView.fitTransformerToContent();
            }
        }
        ilvTreeLayout.detach();
    }

    public void expandAllNodes() {
        try {
            ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this.getDiagram().getContext().getNode();
            IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
            SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
            ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)clusteringModelNode.getFilteredModel(sDMUndoFilter);
            Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
            if (enumeration == null) {
                return;
            }
            while (enumeration.hasMoreElements()) {
                IlvSDMNode ilvSDMNode = enumeration.nextElement();
                if (!(ilvSDMNode instanceof TreeNode)) continue;
                sDMUndoFilter.setObjectProperty((Object)ilvSDMNode, "expanded", (Object)1);
            }
        }
        catch (IOException iOException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)iOException);
        }
    }

    @Override
    public void close() {
        super.close();
    }

    private void loadTreeModel(ClusteringModelNode clusteringModelNode, ClusterTreeSDMModel clusterTreeSDMModel) throws Exception {
        if (clusteringModelNode.isModelExists().booleanValue()) {
            clusterTreeSDMModel.load(clusteringModelNode.getClusterRowDetails(), this.getContext());
            clusteringModelNode.setReadOnly(true);
        }
    }

    public TreeNode getSelectedDiagramNode() throws Exception {
        List<TreeNode> list = this.getSelectedDiagramNodes();
        if (list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public List<TreeNode> getSelectedDiagramNodes() throws Exception {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof TreeNode)) continue;
                arrayList.add((TreeNode)e);
            }
        }
        return arrayList;
    }

    public TreeLink getSelectedDiagramLink() throws Exception {
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return null;
        }
        IlvManager ilvManager = ilvManagerView.getManager();
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)diagram.getContext().getNode();
        IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getSelectedObjects();
        if (ilvManager.getSelectedObjectsCount() > 1 || ilvManager.getSelectedObjectsCount() == 0) {
            return null;
        }
        IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
        Object object = ilvSDMEngine.getObject(ilvGraphic);
        if (object instanceof TreeLink) {
            return (TreeLink)((Object)object);
        }
        return null;
    }

    public List<TreeLink> getSelectedDiagramLinks() throws Exception {
        ArrayList<TreeLink> arrayList = new ArrayList<TreeLink>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof TreeLink)) continue;
                arrayList.add((TreeLink)((Object)e));
            }
        }
        return arrayList;
    }

    public List<Object> getSelectedDiagramObjects() throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    @Override
    public void closeEditor() {
        ClusteringTreeEditor clusteringTreeEditor = this;
        SwingUtilities.invokeLater(new Runnable((Editor)clusteringTreeEditor){
            final /* synthetic */ Editor val$thisEditor;
            {
                this.val$thisEditor = editor;
            }

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(this.val$thisEditor));
            }
        });
    }

    public Component createGUI() {
        this.detailView = new JScrollPane();
        this.detailView.setLayout(new ScrollPaneLayout());
        this.textEditorPane = new JEditorPane();
        this.textEditorPane.setEditable(false);
        this.textEditorPane.setContentType("text/html");
        this.detailView.getViewport().add(this.textEditorPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ToolbarPlugin toolbarPlugin = (ToolbarPlugin)this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
        if (toolbarPlugin != null) {
            Toolbar toolbar = toolbarPlugin.getToolbar();
            if (toolbar == null) {
                toolbarPlugin.createToolbar((View)this);
                toolbar = toolbarPlugin.getToolbar();
            }
            jPanel.add((Component)toolbar, "North");
        }
        jPanel.add((Component)new ScrollManagerView(this.getDiagram().getDiagramContext().getManagerView()), "Center");
        this.splitComponent = new JSplitPane(0, jPanel, this.detailView);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusteringTreeEditor.this.splitComponent.setDividerLocation(0.8);
            }
        });
        return this.splitComponent;
    }

    public Component getDetailView() {
        return this.splitComponent.getBottomComponent();
    }

    public Component getHorizontalScrollBar() {
        return null;
    }

    public Component getVerticalScrollBar() {
        return null;
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        super.update(object, updateMessage);
    }

    private ClusterTreeSDMModel getModel(ClusteringModelNode clusteringModelNode) throws Exception {
        IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)clusteringModelNode.getFilteredModel(sDMUndoFilter);
        return clusterTreeSDMModel;
    }

    public class TreeViewerToolbarPlugin
    extends DefaultDiagramToolbarPlugin {
        private IdeAction _doFitToWindow;
        private IdeAction _toggleHeaderAction;
        private IdeAction _expandAllAction;

        public TreeViewerToolbarPlugin(DiagramContext diagramContext) {
            super(diagramContext);
            this._doFitToWindow = IdeAction.get((int)DOLAYOUT_CMDID);
            this._toggleHeaderAction = IdeAction.get((int)TOGGLE_DETAIL_CMDID);
            this._expandAllAction = IdeAction.get((int)EXPAND_ALL_CMDID);
            if (_doFitToWindowIcon == null) {
                _doFitToWindowIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), ClusteringTreeEditorLrb.get("RESET_LAYOUT_ICON"));
                _toggleHeaderDetailIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), ClusteringTreeEditorLrb.get("TOGGLE_DETAIL_ICON"));
                _toggleVerticalTreeIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), ClusteringTreeEditorLrb.get("TREE_DIAGRAM_V_ICON"));
                _toggleHorizonaTreeIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), ClusteringTreeEditorLrb.get("TREE_DIAGRAM_H_ICON"));
                _expandAllIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), ClusteringTreeEditorLrb.get("EXPAND_ALL_ICON"));
            }
        }

        public void update(Context context) {
            super.update(context);
            if (this._doFitToWindow != null) {
                this._doFitToWindow.updateAction(context);
            }
        }

        protected Toolbar createToolbarImpl(View view) {
            ClusterTreeSDMModel clusterTreeSDMModel;
            ClusteringModelNode clusteringModelNode;
            ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
            try {
                clusteringModelNode = (ClusteringModelNode)ClusteringTreeEditor.this.getDiagram().getContext().getNode();
                clusterTreeSDMModel = ClusteringTreeEditor.this.getModel(clusteringModelNode);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            final ClusterTreeSDMModel clusterTreeSDMModel2 = clusterTreeSDMModel;
            final ClusteringModelNode clusteringModelNode2 = clusteringModelNode;
            Toolbar toolbar = super.createToolbarImpl(view);
            ToolButton toolButton = new ToolButton((Action)this._doFitToWindow);
            toolButton.setIcon(_doFitToWindowIcon);
            toolButton.setToolTipText(ModelViewerLrb.get("FIT_TO_WINDOW_TIP"));
            toolButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
            });
            ToolButton toolButton2 = new ToolButton((Action)this._expandAllAction);
            toolButton2.setIcon(_expandAllIcon);
            toolButton2.setToolTipText(ModelViewerLrb.get("EXPAND_ALL_TIP"));
            toolButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ClusteringTreeEditor.this.expandAllNodes();
                }
            });
            this._toggleHeaderAction.setState(clusteringTreePreferencesSettings.isShowNodeDetailHeader());
            final ToggleToolButton toggleToolButton = new ToggleToolButton((ToggleAction)this._toggleHeaderAction);
            toggleToolButton.setIcon(_toggleHeaderDetailIcon);
            toggleToolButton.setToolTipText(ModelViewerLrb.get("SHOW_LESS_TIP"));
            toggleToolButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                        clusterTreeSDMModel2.toggleHeaderDetailVisible();
                        toggleToolButton.setToolTipText(clusterTreeSDMModel2.isHeaderDetailVisible() != false ? "Show Less Details" : "Show More Details");
                        clusterTreeSDMModel2.fireDataChanged(null);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, false);
                        ClusteringTreeEditor.this.setPropertyChangeListener(clusteringModelNode2.getEngine(), clusterTreeSDMModel2);
                        clusteringModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            final DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
            final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(ClusteringTreeEditorLrb.get("HORIZONTAL_LAYOUT"));
            final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(ClusteringTreeEditorLrb.get("VERTICAL_LAYOUT"));
            buttonGroup.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem2);
            jRadioButtonMenuItem2.setIcon(_toggleVerticalTreeIcon);
            jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ClusteringTreeEditor.this._treeFlowDirection = 8;
                        dropDownMenuButton.setIcon(_toggleVerticalTreeIcon);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
            });
            jRadioButtonMenuItem.setIcon(_toggleHorizonaTreeIcon);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ClusteringTreeEditor.this._treeFlowDirection = 2;
                        dropDownMenuButton.setIcon(_toggleHorizonaTreeIcon);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
            });
            dropDownMenuButton.setToolTipText(ModelViewerLrb.get("LAYOUT_TIP"));
            jRadioButtonMenuItem2.setSelected(ClusteringTreeEditor.this._treeFlowDirection != 2);
            jRadioButtonMenuItem.setSelected(ClusteringTreeEditor.this._treeFlowDirection == 2);
            if (ClusteringTreeEditor.this._treeFlowDirection == 2) {
                dropDownMenuButton.setIcon(_toggleHorizonaTreeIcon);
            } else if (ClusteringTreeEditor.this._treeFlowDirection == 8) {
                dropDownMenuButton.setIcon(_toggleVerticalTreeIcon);
            }
            dropDownMenuButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem2);
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem);
                    } else if (itemEvent.getStateChange() == 2) {
                        dropDownMenuButton.removeAllPopupItems();
                    }
                }
            });
            JLabel jLabel = new JLabel(ClusteringTreeEditorLrb.get("MAX_DISPLAYED_ATTRIBUTES"));
            final JComboBox jComboBox = new JComboBox();
            this.initTopItemsCombo(jComboBox, clusterTreeSDMModel2);
            jComboBox.setToolTipText(ClusteringTreeEditorLrb.get("MAX_DISPLAYED_ATTRIBUTES_TIP"));
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                        Integer n = (Integer)jComboBox.getSelectedItem();
                        clusterTreeSDMModel2.setMaxTargetValuesDisplayed(n);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, false);
                        ClusteringTreeEditor.this.setPropertyChangeListener(clusteringModelNode2.getEngine(), clusterTreeSDMModel2);
                        clusteringModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
            });
            JButton jButton = new JButton(ClusteringTreeEditorLrb.get("SETTINGS"));
            jButton.setToolTipText(ClusteringTreeEditorLrb.get("SETTINGS_TIP"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n = TreeViewerToolbarPlugin.this.getSelectedNodeId();
                    ClusteringQuerySettingsDialog clusteringQuerySettingsDialog = new ClusteringQuerySettingsDialog((Frame)Ide.getMainWindow(), true);
                    clusteringQuerySettingsDialog.setTopNAttributes(ClusteringTreeEditor.this.topNAttributes);
                    clusteringQuerySettingsDialog.setVisible(true);
                    if (!clusteringQuerySettingsDialog.isCancelled()) {
                        ClusteringTreeEditor.this.topNAttributes = clusteringQuerySettingsDialog.getTopNAttributes();
                        ClusteringTreeEditor.this.reload();
                        TreeViewerToolbarPlugin.this.initTopItemsCombo(jComboBox, clusterTreeSDMModel2);
                        TreeViewerToolbarPlugin.this.setSelectedNodeUsingId(n, clusterTreeSDMModel2, clusteringModelNode2);
                    }
                }
            });
            JButton jButton2 = new JButton();
            jButton2.setToolTipText(ClusteringTreeEditorLrb.get("REFRESH_TIP"));
            jButton2.setIcon(OracleIcons.getIcon((String)"refresh.png"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n = TreeViewerToolbarPlugin.this.getSelectedNodeId();
                    ClusteringTreeEditor.this.reload();
                    TreeViewerToolbarPlugin.this.initTopItemsCombo(jComboBox, clusterTreeSDMModel2);
                    TreeViewerToolbarPlugin.this.setSelectedNodeUsingId(n, clusterTreeSDMModel2, clusteringModelNode2);
                }
            });
            toolbar.addSeparator();
            toolbar.add((Component)toolButton);
            toolbar.add((Component)dropDownMenuButton);
            toolbar.add((Component)toolButton2);
            toolbar.addSeparator();
            toolbar.addFiller();
            toolbar.add((Component)toggleToolButton);
            toolbar.addSeparator(new Dimension(10, 0));
            toolbar.add((Component)jLabel);
            toolbar.addFiller();
            toolbar.add(jComboBox);
            toolbar.addFiller();
            toolbar.addSeparator();
            toolbar.add((Component)jButton2);
            toolbar.add((Component)jButton);
            toolbar.addSeparator(new Dimension(1000, 0));
            return toolbar;
        }

        private Integer getSelectedNodeId() {
            Integer n = null;
            try {
                IlvSDMNode ilvSDMNode;
                List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                if (!list.isEmpty() && (ilvSDMNode = (IlvSDMNode)list.get(0)) instanceof TreeNode) {
                    n = ((TreeNode)ilvSDMNode).getData().getId();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return n;
        }

        private void setSelectedNodeUsingId(Integer n, ClusterTreeSDMModel clusterTreeSDMModel, ClusteringModelNode clusteringModelNode) {
            if (n != null) {
                Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
                while (enumeration.hasMoreElements()) {
                    Integer n2;
                    IlvSDMNode ilvSDMNode = enumeration.nextElement();
                    if (!(ilvSDMNode instanceof TreeNode) || !(n2 = ((TreeNode)ilvSDMNode).getData().getId()).equals(n)) continue;
                    try {
                        clusteringModelNode.getEngine().setSelected((Object)ilvSDMNode, true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break;
                }
            }
        }

        private Object[] getTopItems(ClusterTreeSDMModel clusterTreeSDMModel) {
            int n = clusterTreeSDMModel.getAttributeCount() > 10 ? 10 : clusterTreeSDMModel.getAttributeCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = i + 1;
            }
            return objectArray;
        }

        private void initTopItemsCombo(JComboBox jComboBox, ClusterTreeSDMModel clusterTreeSDMModel) {
            Integer n = (Integer)jComboBox.getSelectedItem();
            Object[] objectArray = this.getTopItems(clusterTreeSDMModel);
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
            jComboBox.setModel(defaultComboBoxModel);
            boolean bl = false;
            if (objectArray.length != 0) {
                for (Object object : objectArray) {
                    if (!((Integer)object).equals(n)) continue;
                    jComboBox.setSelectedItem(object);
                    bl = true;
                }
                if (!bl) {
                    Integer n2 = (Integer)(objectArray.length > 4 ? objectArray[4] : objectArray[objectArray.length - 1]);
                    jComboBox.setSelectedItem(n2);
                }
            }
        }
    }

    public class SelectionChangePlugin
    extends AbstractPlugin
    implements SelectionChangeNotificationPlugin {
        private boolean isEnabled = true;

        public void selectionChanged(DiagramContext diagramContext) {
            try {
                List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                ClusteringModelNode clusteringModelNode = (ClusteringModelNode)ClusteringTreeEditor.this.getDiagram().getContext().getNode();
                if (list.size() > 1) {
                    this.displayNoSelectionMessage(clusteringModelNode);
                } else if (list.size() == 1) {
                    Object object = list.get(0);
                    if (object instanceof TreeNode) {
                        TreeNode treeNode = (TreeNode)object;
                        NodeDetailPane nodeDetailPane = new NodeDetailPane(treeNode);
                        int n = ClusteringTreeEditor.this.splitComponent.getDividerLocation();
                        ClusteringTreeEditor.this.splitComponent.setBottomComponent(nodeDetailPane);
                        ClusteringTreeEditor.this.splitComponent.setDividerLocation(n);
                    } else if (object instanceof TreeLink && clusteringModelNode instanceof OCModelNode) {
                        TreeLink treeLink = (TreeLink)((Object)object);
                        TreeNode treeNode = (TreeNode)treeLink.getTo();
                        String string = TreeRule.getSplitRulesHtml(treeNode, true);
                        int n = ClusteringTreeEditor.this.splitComponent.getDividerLocation();
                        ClusteringTreeEditor.this.splitComponent.setBottomComponent(ClusteringTreeEditor.this.detailView);
                        ClusteringTreeEditor.this.splitComponent.setDividerLocation(n);
                        ClusteringTreeEditor.this.textEditorPane.setText(string);
                        ClusteringTreeEditor.this.textEditorPane.select(0, 0);
                    }
                } else {
                    this.displayNoSelectionMessage(clusteringModelNode);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
        }

        private void displayNoSelectionMessage(ClusteringModelNode clusteringModelNode) {
            String string;
            if (clusteringModelNode instanceof KMModelNode) {
                string = ClusteringTreeEditorLrb.get("KM_NOSELECT_MESSAGE");
            } else if (clusteringModelNode instanceof OCModelNode) {
                string = ClusteringTreeEditorLrb.get("OC_NOSELECT_MESSAGE");
            } else {
                throw new RuntimeException("Unknown clustering node type");
            }
            ClusteringTreeEditor.this.textEditorPane.setText(string);
            int n = ClusteringTreeEditor.this.splitComponent.getDividerLocation();
            ClusteringTreeEditor.this.splitComponent.setBottomComponent(ClusteringTreeEditor.this.detailView);
            ClusteringTreeEditor.this.splitComponent.setDividerLocation(n);
        }

        public void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    class OdmrReadOnlyPlugin
    extends DefaultDiagramReadOnlyPlugin {
        public OdmrReadOnlyPlugin(DiagramContext diagramContext) {
            super(diagramContext);
        }

        protected boolean checkWritableDiagram() {
            return false;
        }
    }

    public class ModelListener
    implements SDMPropertyChangeListener {
        public void propertyChanged(SDMPropertyChangeEvent sDMPropertyChangeEvent) {
            String string = sDMPropertyChangeEvent.getPropertyName();
            Object object = sDMPropertyChangeEvent.getObject();
            if ("expanded".equals(string) && object instanceof TreeNode) {
                ((TreeNode)object).setChildrenVisibility();
            }
        }
    }
}

