/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class ClusteringQuerySettingsDialog
extends JDialog {
    private int topNAttributes;
    private boolean cancelled = false;
    private JButton btnApply;
    private JButton btnCancel;
    private JCheckBox chkDefault;
    private JLabel labelTopN;
    private NumberTextField textTopN;

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringQuerySettingsDialog.this.cancelled = true;
                ClusteringQuerySettingsDialog.this.setVisible(false);
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }

    public ClusteringQuerySettingsDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.labelTopN = new JLabel();
        this.btnCancel = new JButton();
        this.chkDefault = new JCheckBox();
        this.btnApply = new JButton();
        this.textTopN = new NumberTextField();
        this.setDefaultCloseOperation(2);
        this.labelTopN.setLabelFor((Component)this.textTopN);
        this.labelTopN.setText("Fetch Top N Attributes:");
        this.btnCancel.setText("Cancel");
        this.chkDefault.setText("Set as New Default");
        this.chkDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringQuerySettingsDialog.this.chkDefaultActionPerformed(actionEvent);
            }
        });
        this.btnApply.setText("Apply");
        this.textTopN.setText("10");
        this.textTopN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringQuerySettingsDialog.this.textTopNActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.labelTopN).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkDefault).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.btnApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel)).addComponent((Component)this.textTopN, -1, 191, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelTopN).addComponent((Component)this.textTopN, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnApply)).addContainerGap()));
        this.pack();
    }

    private void chkDefaultActionPerformed(ActionEvent actionEvent) {
    }

    private void textTopNActionPerformed(ActionEvent actionEvent) {
    }

    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(ClusteringTreeEditorLrb.get("APPLY"), this.btnApply);
        hashMap.put(ClusteringTreeEditorLrb.get("CANCEL"), this.btnCancel);
        hashMap.put(ClusteringTreeEditorLrb.get("SET_AS_DEFAULT"), this.chkDefault);
        hashMap.put(ClusteringTreeEditorLrb.get("TOPN_ATTRIBUTES"), this.labelTopN);
        UIResourceHelper.setComponentText(hashMap);
    }

    public void initUI() {
        this.setTitle(ClusteringTreeEditorLrb.get("QUERY_SETTINGS_TITLE"));
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this.textTopN.setNumber((Number)clusteringTreePreferencesSettings.getTopNCentroidAttributes());
        this.textTopN.setSigned(false);
        this.setLocationRelativeTo((Component)Ide.getMainWindow());
        this.setDefaultCloseOperation(0);
        this.btnApply.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.btnApply);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringQuerySettingsDialog.this.cancelled = true;
                ClusteringQuerySettingsDialog.this.setVisible(false);
            }
        });
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringQuerySettingsDialog.this.cancelled = false;
                Number number = ClusteringQuerySettingsDialog.this.textTopN.getNumber();
                if (number == null) {
                    MessageDialog.error((Component)ClusteringQuerySettingsDialog.this, (Object)ClusteringTreeEditorLrb.get("ERROR_NO_INPUT"), (String)ClusteringTreeEditorLrb.get("ERROR_NO_INPUT_TITLE"), null);
                    return;
                }
                if (number.intValue() < 1) {
                    MessageDialog.error((Component)ClusteringQuerySettingsDialog.this, (Object)ClusteringTreeEditorLrb.get("ERROR_MIN_VALUE"), (String)ClusteringTreeEditorLrb.get("ERROR_MIN_VALUE_TITLE"), null);
                    return;
                }
                ClusteringQuerySettingsDialog.this.topNAttributes = number.intValue();
                if (ClusteringQuerySettingsDialog.this.chkDefault.isSelected()) {
                    ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
                    clusteringTreePreferencesSettings.setTopNCentroidAttributes(ClusteringQuerySettingsDialog.this.topNAttributes);
                }
                ClusteringQuerySettingsDialog.this.setVisible(false);
            }
        });
    }

    public int getTopNAttributes() {
        return this.topNAttributes;
    }

    public void setTopNAttributes(int n) {
        this.topNAttributes = n;
        this.textTopN.setNumber((Number)n);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

