/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.HistogramBarRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.TreeNode;
import oracle.dmt.dataminer.server.model.PredicateRowData;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.dmt.javatools.ui.table.table.GenericTableModel;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class AttributeImportancePane
extends JPanel
implements DataminerGUIPanel {
    private TreeNode treeNode;
    private JComboBox _topItemSelect;
    private JLabel _componentLabel;
    private JLabel _comboLabel;
    private final Color _confidenceBarColor;
    private GenericTable table;
    private JScrollPane tableScrollPane;
    private int topNAttributes;
    private static final ClusteringTreePreferencesSettings prefs = ClusteringTreePreferencesSettings.getInstance();
    private static final Preferences p = Preferences.getPreferences();
    private static final ModelViewerPreferenceSettings modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)p);
    private JPanel contentPanel;
    private static final int ATTRIBUTE = 0;
    private static final int CONFIDENCE = 1;
    private static final int COLUMN_COUNT = 2;

    public AttributeImportancePane(TreeNode treeNode) {
        this.treeNode = treeNode;
        String[] stringArray = new String[11];
        stringArray[0] = ClusteringTreeEditorLrb.get("ALL_ITEMS");
        stringArray[1] = new Integer(1).toString();
        new Integer(1);
        stringArray[2] = Integer.toString(2);
        new Integer(1);
        stringArray[3] = Integer.toString(3);
        new Integer(1);
        stringArray[4] = Integer.toString(4);
        new Integer(1);
        stringArray[5] = Integer.toString(5);
        new Integer(1);
        stringArray[6] = Integer.toString(6);
        new Integer(1);
        stringArray[7] = Integer.toString(7);
        new Integer(1);
        stringArray[8] = Integer.toString(8);
        new Integer(1);
        stringArray[9] = Integer.toString(9);
        new Integer(1);
        stringArray[10] = Integer.toString(10);
        String[] stringArray2 = stringArray;
        this._topItemSelect = new JComboBox<String>(stringArray2);
        this._componentLabel = new JLabel();
        this._comboLabel = new JLabel();
        this._comboLabel.setLabelFor(this._topItemSelect);
        this._confidenceBarColor = new Color(10, 140, 143);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 2));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, 475, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, 111, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(ClusteringTreeEditorLrb.get("IMPORTANCE_CONTAINER_LABEL"), this._componentLabel);
        hashMap.put(ClusteringTreeEditorLrb.get("TOP_N_ITEMS_LABEL"), this._comboLabel);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        this.table = new GenericTable();
        this.tableScrollPane = new JScrollPane();
        this.table.setAutoCreateRowSorter(true);
        this.table.setColumnSelectorAvailable(true);
        this.table.setAutoResizeMode(3);
        this.topNAttributes = prefs.getTopNImportanceAttributes();
        this._topItemSelect.setSelectedIndex(this.topNAttributes);
        this._topItemSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeImportancePane.this.topNAttributes = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                prefs.setTopNImportanceAttributes(AttributeImportancePane.this.topNAttributes);
                AttributeImportancePane.this.initTable();
            }
        });
        modelViewerPrefenceSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                for (int i = 0; i < changeInfoArray.length; ++i) {
                    ChangeInfo changeInfo = changeInfoArray[i];
                    if (!changeInfo.getPropertyName().equals("numerical_precision_level")) continue;
                    AttributeImportancePane.this.initTable();
                    break;
                }
            }
        });
        this.initTable();
        this.tableScrollPane.setViewportView((Component)this.table);
        ControlBar controlBar = new ControlBar();
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setControlBar(controlBar);
        componentWithTitlebar.setLabel(this._componentLabel);
        componentWithTitlebar.add((Component)this.tableScrollPane);
        controlBar.add((Component)this._comboLabel);
        controlBar.add((Component)new JLabel(" "));
        controlBar.add((Component)this._topItemSelect);
        this.contentPanel.add((Component)componentWithTitlebar);
    }

    private void initTable() {
        List<PredicateRowData> list = new ArrayList<PredicateRowData>(this.treeNode.getTopItems().values());
        if (this.topNAttributes != 0 && list.size() >= this.topNAttributes) {
            list = list.subList(0, this.topNAttributes);
        }
        String[] stringArray = new String[]{ClusteringTreeEditorLrb.get("ATTRIBUTE_COLUMN"), ClusteringTreeEditorLrb.get("CONFIDENCE_COLUMN")};
        ValuesTableModel valuesTableModel = new ValuesTableModel(list, stringArray);
        this.table.setModel((TableModel)valuesTableModel);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
        NumberFormat numberFormat = NumericFormat.getInstance(true, modelViewerPrefenceSettings.getNumericalPrecisionLevel(), modelViewerPrefenceSettings.getNumericalPrecisionLevel(), 1);
        tableColumn.setCellRenderer(new HistogramBarRenderer(1L, true, numberFormat));
        this.table.setRolloverHighlightingEnabled(false);
    }

    class ValuesTableModel
    extends DefaultTableModel
    implements GenericTableModel {
        private List<PredicateRowData> _data;

        public ValuesTableModel(List<PredicateRowData> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this._data.size());
            this.setColumnCount(2);
        }

        public int getColumnAlignment(int n) {
            return 2;
        }

        public boolean canHide(int n) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return Double.class;
            }
            return String.class;
        }

        public void reload(List<PredicateRowData> list) {
            this._data = list;
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            PredicateRowData predicateRowData = this._data.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = TreeNode.getQualifiedAttributeName(predicateRowData);
                    break;
                }
                case 1: {
                    object = predicateRowData.getAttribute_confidence();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        public List<PredicateRowData> getDataList() {
            return this._data;
        }
    }
}

