/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.compare;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.generated.server.DmHistogramBin;
import oracle.dmt.dataminer.generated.server.DmHistograms;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetails;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.ClusterCompareTableModel;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.Clustering;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.server.model.ClusteringKM;
import oracle.dmt.dataminer.server.model.ClusteringOC;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdbc.OraclePreparedStatement;

public class CompareClusterViewerState
implements GraphModelProvider {
    static final Color[] colors = new Color[]{Color.RED, Color.BLUE};
    static final Color[] color = new Color[]{Color.RED};
    private static int _DEPTH_RADIUS = 0;
    private int _depthRadius = _DEPTH_RADIUS;
    private boolean _loaded;
    private Context _context;
    private String clusterLabel1;
    private String clusterLabel2;
    private ModelViewerState1 _modelViewerState1;
    private ClusteringOC _modelOCClustering;
    private ClusteringKM _modelKMClustering;
    private String _modelName;
    private String _userName;
    private boolean _leafsOnly = true;
    private boolean _maxPrecision = false;
    private int _precisionLevelOfHistogramLabels = 5;
    private Map<String, ClusteringDetailRowShort> _clusterCountsMap;
    private List<String> _clusterLabels;
    private ClusteringFilterSetting _filterSetting;
    private static Preferences _p = Preferences.getPreferences();
    private static ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    static final int _initial_fetchsize = _modelViewerPrefenceSettings.getFetchSizeClusteringModel();
    private GenericBaseTableModel _tableModel;
    public static String alter_reverse_expression_cluster_id = "when value = [CLUSTER_ID] then ";
    public static String alter_reverse_expression_case_rename = "'[NEW_NAME]'\n";
    public static String alter_reverse_expression_case_keep_old = "'[OLD_NAME]'\n";
    public static String alter_reverse_expression_case_end = "                else TO_CHAR(value) end";
    public static String alter_reverse_expression_final = "BEGIN\n  dbms_data_mining.alter_reverse_expression(\n :MODEL_NAME, :CASE_STATEMENT);\nEND;\n";

    public CompareClusterViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this._tableModel = new ClusterCompareTableModel();
    }

    public boolean isKmeans() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof KMModelNode;
    }

    public boolean isOC() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof OCModelNode;
    }

    public void loadClusterLabelsNew() {
        Map<String, ClusteringDetailRowShort> map = this._leafsOnly ? this.getLeafsOnlyMap(this._clusterCountsMap) : this._clusterCountsMap;
        this._clusterLabels = new ArrayList<String>(map.keySet());
        Collections.sort(this._clusterLabels, new ClusterComparator());
    }

    private Map<String, ClusteringDetailRowShort> getLeafsOnlyMap(Map<String, ClusteringDetailRowShort> map) {
        HashMap<String, ClusteringDetailRowShort> hashMap = new HashMap<String, ClusteringDetailRowShort>();
        for (String string : map.keySet()) {
            ClusteringDetailRowShort clusteringDetailRowShort = map.get(string);
            if (clusteringDetailRowShort.hasChildren()) continue;
            hashMap.put(string, clusteringDetailRowShort);
        }
        return hashMap;
    }

    public void reloadClusterLabelsNew(String string, String string2) {
        ClusteringDetailRowShort clusteringDetailRowShort = new ClusteringDetailRowShort(this._clusterCountsMap.get(string2));
        this._clusterCountsMap.remove(string2);
        this._clusterCountsMap.put(string, clusteringDetailRowShort);
        this.loadClusterLabelsNew();
        if (this.clusterLabel1.equals(string2)) {
            this.clusterLabel1 = string;
        }
        if (this.clusterLabel2 != null && this.clusterLabel2.equals(string2)) {
            this.clusterLabel2 = string;
        }
    }

    public void reloadClusterCacheNew() {
        this.loadClusterLabelsNew();
    }

    private Map<String, ClusteringDetailRowShort> getMap() {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        Map<String, ClusteringDetailRowShort> map = clusteringModelNode.getClusterCountsMap(this._userName, this._modelName);
        return map;
    }

    private void setMap(Map<String, ClusteringDetailRowShort> map) {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        clusteringModelNode.setClusterCountsMap(this._userName, this._modelName, map);
    }

    private void loadDataNew(Connection connection, boolean bl) throws Exception {
        if (this.isKmeans()) {
            if (this._clusterCountsMap == null) {
                this._clusterCountsMap = this.getMap();
                if (this._clusterCountsMap == null) {
                    this._clusterCountsMap = this._modelKMClustering.getTotalNumberOfModelAttributesPerCluster2(connection, this._userName, this._modelName);
                    this.setMap(this._clusterCountsMap);
                }
            }
        } else if (this.isOC()) {
            if (this._clusterCountsMap == null) {
                this._clusterCountsMap = this.getMap();
                if (this._clusterCountsMap == null) {
                    this._clusterCountsMap = this._modelOCClustering.getTotalNumberOfModelAttributesPerCluster2(connection, this._userName, this._modelName);
                    this.setMap(this._clusterCountsMap);
                }
            }
        } else assert (false) : this.getClass().getName() + " not loaded.";
        if (bl) {
            this._filterSetting = new ClusteringFilterSetting();
            this._filterSetting.setFetchSize(_initial_fetchsize);
            this.loadDefaultClustersNew();
        }
        this.loadClusterLabelsNew();
        List<CompareClustersModelRow> list = null;
        if (this.isKmeans()) {
            list = this._modelKMClustering.getDivergenceKM(connection, this._userName, this._modelName, this.getClusterIdNew(this.clusterLabel1), this.clusterLabel1, this.getClusterIdNew(this.clusterLabel2), this.clusterLabel2, this._filterSetting.getFetchSize());
            this._modelKMClustering.getCenteroidAndHistogramKM(connection, this._userName, this._modelName, this.getClusterIdNew(this.clusterLabel1), this.getClusterIdNew(this.clusterLabel2), list);
        } else {
            list = this._modelOCClustering.getDivergenceOC(connection, this._userName, this._modelName, this.getClusterIdNew(this.clusterLabel1), this.clusterLabel1, this.getClusterIdNew(this.clusterLabel2), this.clusterLabel2, this._filterSetting.getFetchSize());
            Integer n = this.getClusterIdNew(this.clusterLabel1);
            Integer n2 = this.getClusterIdNew(this.clusterLabel2);
            if (n2 == null) {
                n2 = n;
            }
            this._modelOCClustering.getCenteroidAndHistogramOC(connection, this._userName, this._modelName, n, n2, list);
        }
        if (this._tableModel instanceof ClusterCompareTableModel) {
            ((ClusterCompareTableModel)this._tableModel).clear();
        }
        this._tableModel = list != null ? new ClusterCompareTableModel(list, this.getClusterIdNew(this.clusterLabel1), this.getClusterIdNew(this.clusterLabel2)) : new EmptyClusterCompareTableModel();
        this.createAllGraphDataModelsTotalPopulation();
    }

    private void loadDefaultClustersNew() throws Exception {
        this.clusterLabel1 = null;
        this.clusterLabel2 = null;
        Iterator<String> iterator = this._clusterCountsMap.keySet().iterator();
        while (iterator.hasNext() && (this.clusterLabel1 == null || this.clusterLabel2 == null)) {
            String string = iterator.next();
            ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(string);
            if (this._leafsOnly) {
                if (clusteringDetailRowShort.hasChildren()) continue;
                if (this.clusterLabel1 == null) {
                    this.clusterLabel1 = string;
                    continue;
                }
                if (this.clusterLabel2 != null) continue;
                this.clusterLabel2 = string;
                continue;
            }
            if (this.clusterLabel1 == null) {
                this.clusterLabel1 = string;
                continue;
            }
            if (this.clusterLabel2 != null) continue;
            this.clusterLabel2 = string;
        }
    }

    public CompareClusterViewerState load() throws Exception {
        this._modelViewerState1 = new ModelViewerState1(this._context);
        this._modelViewerState1.load(null);
        Clustering clustering = null;
        if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClusteringModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isKmeansAlgorithm()) {
            this._modelKMClustering = clustering = new ClusteringKM(this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
        } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClusteringModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isOClusterAlgorithm()) {
            clustering = new ClusteringOC(this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
            this._modelOCClustering = (ClusteringOC)clustering;
        } else {
            throw new Exception(ClusterLrb.get("DETAIL_CLUSTER_UNRECOGNIZED_MODEL_TYPE"));
        }
        this._modelName = this._modelViewerState1.getModelName();
        this._userName = this._modelViewerState1.getUserName();
        Connection connection = null;
        try {
            this._loaded = false;
            connection = Connections.getUniqueConnection(this._context);
            this.loadDataNew(connection, true);
            this._loaded = true;
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return this;
    }

    public void reload() throws Exception {
        Connection connection = null;
        try {
            this._loaded = false;
            connection = Connections.getUniqueConnection(this._context);
            this.loadDataNew(connection, false);
            this._loaded = true;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        return null;
    }

    @Override
    public String getStyleSelection() {
        return null;
    }

    private ClusterDetails getClusterDetails() {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        return clusteringModelNode.getClusterDetails();
    }

    private boolean isClusterDetailsLoaded() {
        ClusteringModelNode clusteringModelNode = (ClusteringModelNode)this._context.getNode();
        return clusteringModelNode.isClusterDetailsLoaded();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public GenericBaseTableModel getFilteredStatistics(String string, int n) throws Exception {
        if (this._tableModel instanceof EmptyClusterCompareTableModel) {
            return this._tableModel;
        }
        return ((ClusterCompareTableModel)this._tableModel).getFilteredStatistics(string, n);
    }

    public GenericBaseTableModel getTableModel() {
        return this._tableModel;
    }

    public void setFilterSetting(ClusteringFilterSetting clusteringFilterSetting) {
        this._filterSetting = clusteringFilterSetting;
    }

    public ClusteringFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    private void createAllGraphDataModelsTotalPopulation() throws Exception {
        if (this._tableModel instanceof EmptyClusterCompareTableModel) {
            return;
        }
        Vector<CompareClustersModelRow> vector = ((ClusterCompareTableModel)this._tableModel).getDataVector();
        for (CompareClustersModelRow compareClustersModelRow : vector) {
            String string = compareClustersModelRow.getFullAttributeName();
            GraphDataModel graphDataModel = this.createGraphDataModelClusterPopulationGeneric(string, false);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(0);
            graphDataModel.setLineDataLineDisplayed(false);
            compareClustersModelRow.setGraphDataModel(graphDataModel);
        }
    }

    public GraphDataModel createGraphDataModelForAttribute(String string) throws Exception {
        return this.createGraphDataModelClusterPopulationGeneric(string, true);
    }

    private GraphDataModel createGraphDataModelClusterPopulationGeneric(String string, boolean bl) throws Exception {
        if (this._tableModel instanceof EmptyClusterCompareTableModel) {
            return null;
        }
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 20, null, null, null);
        CompareClustersModelRow compareClustersModelRow = ((ClusterCompareTableModel)this._tableModel).getClusterDetailRow(string);
        DmHistograms dmHistograms = compareClustersModelRow.getFirstClusterHistogram();
        DmHistograms dmHistograms2 = compareClustersModelRow.getSecondClusterHistogram();
        if (!(dmHistograms != null && dmHistograms.length() != 0 || dmHistograms2 != null && dmHistograms2.length() != 0)) {
            return defaultGraphDataModel;
        }
        ArrayList<DmHistograms> arrayList = new ArrayList<DmHistograms>();
        if (dmHistograms != null && dmHistograms.length() > 0) {
            arrayList.add(dmHistograms);
        }
        if (dmHistograms2 != null && dmHistograms2.length() > 0) {
            arrayList.add(dmHistograms2);
        }
        int n = dmHistograms != null ? dmHistograms.length() : dmHistograms2.length();
        int n2 = arrayList.size();
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        objectArray3[0] = CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SERIES") + this.clusterLabel1;
        if (n2 > 1) {
            objectArray3[1] = CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SERIES") + this.clusterLabel2;
        }
        for (int i = 0; i < n2; ++i) {
            BigDecimal bigDecimal;
            DmHistogramBin dmHistogramBin;
            int n3;
            DmHistograms dmHistograms3 = (DmHistograms)arrayList.get(i);
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                dmHistogramBin = dmHistograms3.getElement(n3);
                bigDecimal = dmHistogramBin.getCount();
                n4 += bigDecimal.intValue();
            }
            for (n3 = 0; n3 < n; ++n3) {
                dmHistogramBin = dmHistograms3.getElement(n3);
                bigDecimal = dmHistogramBin.getCount();
                BigDecimal bigDecimal2 = dmHistogramBin.getUpperBound();
                BigDecimal bigDecimal3 = dmHistogramBin.getLowerBound();
                int n5 = dmHistogramBin.getBinId().intValue();
                String string2 = bigDecimal2 != null && bigDecimal3 != null ? (this._maxPrecision ? dmHistogramBin.getLabel() : this.formatLabelFromBoundaries(bigDecimal3, bigDecimal2)) : dmHistogramBin.getLabel();
                objectArray[n5 - 1][i] = this.isKmeans() ? (n4 == 0 ? new Double(bigDecimal.doubleValue() * 100.0) : new Double(bigDecimal.doubleValue() / (double)n4 * 100.0)) : new Double(bigDecimal.doubleValue() * 100.0);
                objectArray2[n5 - 1] = bl ? string2 : "";
            }
        }
        defaultGraphDataModel.addColumnLabels(objectArray2);
        defaultGraphDataModel.addRowLabels(objectArray3);
        defaultGraphDataModel.addGraphData(objectArray);
        if (bl) {
            defaultGraphDataModel.setDepthRadius(this._depthRadius);
        }
        defaultGraphDataModel.setLineDataLineDisplayed(false);
        if (n2 > 1) {
            defaultGraphDataModel.addRowColors(colors);
        } else {
            defaultGraphDataModel.addRowColors(color);
        }
        defaultGraphDataModel.setTitle(string);
        return defaultGraphDataModel;
    }

    public void setLeafsOnlyNew(boolean bl) {
        if (this.isLoaded() && this._leafsOnly != bl) {
            this._leafsOnly = bl;
            this.loadClusterLabelsNew();
        }
    }

    public boolean isLeafsOnly() {
        return this._leafsOnly;
    }

    public void setMaxPrecision(boolean bl) {
        this._maxPrecision = bl;
    }

    public boolean isMaxPrecision() {
        return this._maxPrecision;
    }

    private String formatLabelFromBoundaries(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        double d = bigDecimal.doubleValue();
        double d2 = bigDecimal2.doubleValue();
        String string = NumericFormat.format(d, true, this._precisionLevelOfHistogramLabels) + "";
        String string2 = NumericFormat.format(d2, true, this._precisionLevelOfHistogramLabels) + "";
        return string + " : " + string2;
    }

    public void setPrecisionLevelOfHistogramLabels(int n) {
        this._precisionLevelOfHistogramLabels = n;
    }

    public int getPrecisionLevelOfHistogramLabels() {
        return this._precisionLevelOfHistogramLabels;
    }

    public int getTotalNumberOfModelAttributesNew() {
        return this._clusterCountsMap.get(this.getClusterLabel1()).getAttributeCount();
    }

    public List<String> getClusterLabels() {
        return this._clusterLabels;
    }

    public int getDepthRadius() {
        return this._depthRadius;
    }

    public void setClusterLabel1(String string) {
        this.clusterLabel1 = string;
    }

    public String getClusterLabel1() {
        return this.clusterLabel1;
    }

    public void setClusterLabel2(String string) {
        this.clusterLabel2 = string;
    }

    public String getClusterLabel2() {
        return this.clusterLabel2;
    }

    public Integer getClusterIdNew(String string) {
        if (string == null) {
            return null;
        }
        ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(string);
        return clusteringDetailRowShort.getId();
    }

    public boolean isClusterLabelUniquieNew(String string) {
        return null != this._clusterCountsMap.get(string);
    }

    public String renameClusterLabelNew(String string, String string2) throws Exception {
        Connection connection = null;
        ClusteringDetailRowShort clusteringDetailRowShort = this._clusterCountsMap.get(string2);
        StringBuilder stringBuilder = new StringBuilder("case ");
        for (String object2 : this._clusterCountsMap.keySet()) {
            ClusteringDetailRowShort clusteringDetailRowShort2 = this._clusterCountsMap.get(object2);
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = StringUtils.getReplacedString(alter_reverse_expression_cluster_id, "[CLUSTER_ID]", clusteringDetailRowShort2.getId().toString());
            stringBuilder2.append(string3);
            if (clusteringDetailRowShort.getId().equals(clusteringDetailRowShort2.getId())) {
                clusteringDetailRowShort2.setClusterId(string);
                string3 = StringUtils.getReplacedString(alter_reverse_expression_case_rename, "[NEW_NAME]", string);
            } else {
                string3 = StringUtils.getReplacedString(alter_reverse_expression_case_keep_old, "[OLD_NAME]", clusteringDetailRowShort2.getClusterId());
            }
            stringBuilder2.append(string3);
            stringBuilder.append(stringBuilder2.toString());
        }
        stringBuilder.append(alter_reverse_expression_case_end);
        SQLHelper sQLHelper = new SQLHelper();
        try {
            connection = Connections.getUniqueConnection(this._context);
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(alter_reverse_expression_final);
            sQLHelper.opstmt.setStringAtName("MODEL_NAME", Model.getCombinedUserNameModelName(this._userName, this._modelName, true));
            sQLHelper.opstmt.setStringAtName("CASE_STATEMENT", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            this.reloadClusterLabelsNew(string, string2);
            if (this.getClusterDetails() != null) {
                this.getClusterDetails().triggerUpdate();
            }
        }
        catch (Exception exception) {
            if (exception.getMessage().startsWith("ORA-01031")) {
                throw new Exception(CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"));
            }
            throw exception;
        }
        finally {
            sQLHelper.close();
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    public Map<String, ClusteringDetailRowShort> getClusterCountsMap() {
        return this._clusterCountsMap;
    }

    class EmptyClusterCompareTableModel
    extends GenericBaseTableModel {
        public static final int _COLUMN_NAME = 0;
        private Vector<String> _data = new Vector();

        public EmptyClusterCompareTableModel() {
            Object[] objectArray = new String[]{CompareClustersLrb.get("COMPARE_CLUSTERS_NOT_ENOUGH_ERROR")};
            String string = CompareClustersLrb.get("COMPARE_CLUSTERS_NOT_ENOUGH_CLUSTERS");
            this.setColumnIdentifiers(objectArray);
            this._data.add(string);
            this.setRowCount(this._data.size());
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            String string = this._data.get(n);
            String string2 = null;
            switch (n2) {
                case 0: {
                    string2 = string;
                }
            }
            return string2 != null ? string2 : "";
        }
    }

    private class ClusterComparator
    implements Comparator<String> {
        private ClusterComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = 0;
            try {
                Integer n2 = Integer.parseInt(string.toString());
                Integer n3 = Integer.parseInt(string2.toString());
                n = n2.compareTo(n3);
            }
            catch (NumberFormatException numberFormatException) {
                n = string.toString().compareTo(string2.toString());
            }
            return n;
        }
    }
}

