/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.compare;

import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.utils.NumberComparator;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.search.SearchMatcher;

public class ClusterCompareTableModel
extends GenericBaseTableModel {
    static Vector<String> _colNames = new Vector();
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_RANK = 1;
    public static final int _COLUMN_DIVERGENCE = 2;
    public static final int _COLUMN_DISTRIBUTION = 3;
    public static final int _COLUMN_CENTROID1 = 4;
    public static final int _COLUMN_CENTROID2 = 5;
    private Integer cluster1;
    private Integer cluster2;
    private Vector<CompareClustersModelRow> _data = new Vector();
    private Hashtable<String, CompareClustersModelRow> _attributeNameToRowMap = new Hashtable();
    private static Preferences _p;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);

    public ClusterCompareTableModel(Vector<CompareClustersModelRow> vector, Integer n, Integer n2) {
        this.cluster1 = n;
        this.cluster2 = n2;
        Object[] objectArray = _colNames.toArray(new String[_colNames.size()]);
        objectArray[4] = n != null ? objectArray[4] + "(" + n.toString() + ")" : "";
        objectArray[5] = n2 != null ? (String)objectArray[5] + "(" + n2.toString() + ")" : "";
        this.setColumnIdentifiers(objectArray);
        this.setDataVector(vector);
        this.setColumnCount(objectArray.length);
    }

    public ClusterCompareTableModel(List<CompareClustersModelRow> list, Integer n, Integer n2) {
        this.cluster1 = n;
        this.cluster2 = n2;
        Object[] objectArray = _colNames.toArray(new String[_colNames.size()]);
        objectArray[4] = n != null ? objectArray[4] + "(" + n.toString() + ")" : "";
        objectArray[5] = n2 != null ? (String)objectArray[5] + "(" + n2.toString() + ")" : "";
        this.setColumnIdentifiers(objectArray);
        this.setDataList(list);
        this.setColumnCount(objectArray.length);
    }

    public ClusterCompareTableModel() {
        this.setColumnIdentifiers(_colNames);
        CompareClustersModelRow compareClustersModelRow = new CompareClustersModelRow(ClusterLrb.get("DETAIL_CLUSTER_EDITOR_LOADING"));
        this.addDataItem(compareClustersModelRow);
        this.setRowCount(this.getDataSize());
        this.setColumnCount(_colNames.size());
    }

    private void addDataItem(CompareClustersModelRow compareClustersModelRow) {
        this._data.add(compareClustersModelRow);
    }

    public void clear() {
        for (CompareClustersModelRow compareClustersModelRow : this._data) {
            compareClustersModelRow.setGraphDataModel(null);
            compareClustersModelRow.setFirstClusterHistogram(null);
            compareClustersModelRow.setSecondClusterHistogram(null);
        }
        this._data.clear();
        this._attributeNameToRowMap.clear();
    }

    private int getDataSize() {
        return this._data.size();
    }

    public CompareClustersModelRow getClusterDetailRow(String string) {
        return this._attributeNameToRowMap.get(string);
    }

    public void setDataVector(Vector<CompareClustersModelRow> vector) {
        this._data = vector;
        this.setRowCount(this._data.size());
        this._attributeNameToRowMap.clear();
        for (CompareClustersModelRow compareClustersModelRow : vector) {
            this._attributeNameToRowMap.put(compareClustersModelRow.getFullAttributeName(), compareClustersModelRow);
        }
    }

    public void setDataList(List<CompareClustersModelRow> list) {
        this._data.addAll(list);
        this.setRowCount(this._data.size());
        this._attributeNameToRowMap.clear();
        for (CompareClustersModelRow compareClustersModelRow : list) {
            this._attributeNameToRowMap.put(compareClustersModelRow.getFullAttributeName(), compareClustersModelRow);
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        CompareClustersModelRow compareClustersModelRow = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = compareClustersModelRow.getFullAttributeName();
                break;
            }
            case 1: {
                object = compareClustersModelRow.getRank();
                break;
            }
            case 2: {
                object = compareClustersModelRow.getDivergence();
                break;
            }
            case 4: {
                object = this.getCentroid(compareClustersModelRow.getCentroid1());
                break;
            }
            case 5: {
                object = this.getCentroid(compareClustersModelRow.getCentroid2());
                break;
            }
            case 3: {
                object = compareClustersModelRow.getGraphDataModel();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing cluster details";
                break;
            }
        }
        return object != null ? object : "";
    }

    private String getCentroid(String string) {
        String string2 = string;
        try {
            NumberFormat numberFormat = NumberFormat.getInstance();
            Number number = numberFormat.parse(string);
            string2 = NumericFormat.format((Double)number, true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel()) + "";
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        switch (n) {
            case 0: {
                comparator = super.getColumnSortComparator(n);
                break;
            }
            case 1: {
                comparator = NumberComparator.getComparator();
                break;
            }
            case 2: {
                comparator = NumberComparator.getComparator();
                break;
            }
            case 3: {
                comparator = super.getColumnSortComparator(n);
                break;
            }
            default: {
                comparator = super.getColumnSortComparator(n);
            }
        }
        return comparator;
    }

    public ClusterCompareTableModel getFilteredStatistics(String string, int n) throws Exception {
        Vector<CompareClustersModelRow> vector = null;
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Vector<CompareClustersModelRow> vector2 = this.getDataVector();
        vector = new Vector<CompareClustersModelRow>();
        Iterator<CompareClustersModelRow> iterator = vector2.iterator();
        CompareClustersModelRow compareClustersModelRow = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            compareClustersModelRow = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = null;
                switch (n) {
                    case 0: {
                        string2 = compareClustersModelRow.getFullAttributeName();
                        break;
                    }
                    case 1: {
                        string2 = compareClustersModelRow.getRank().toString();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid table filter category.";
                        string2 = compareClustersModelRow.getName();
                    }
                }
                if (string2 == null) {
                    string2 = "";
                }
                bl2 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(compareClustersModelRow);
        }
        return new ClusterCompareTableModel(vector, this.cluster1, this.cluster2);
    }

    public Vector<CompareClustersModelRow> getDataVector() {
        return this._data;
    }

    static {
        _colNames.add(CompareClustersLrb.get("DETAIL_TABLE_COLUMN_NAME"));
        _colNames.add(CompareClustersLrb.get("DETAIL_TABLE_COLUMN_RANK"));
        _colNames.add(CompareClustersLrb.get("DETAIL_TABLE_COLUMN_DIVERGENCE"));
        _colNames.add(CompareClustersLrb.get("DETAIL_TABLE_COLUMN_DISTRIBUTION"));
        _colNames.add(CompareClustersLrb.get("DETAIL_TABLE_COLUMN_CENTROID"));
        _colNames.add(CompareClustersLrb.get("DETAIL_TABLE_COLUMN_CENTROID"));
        _p = Preferences.getPreferences();
    }
}

