/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModel;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterMainPanel;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterViewerState;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class SingleClusterViewer
extends DataMinerViewGUI {
    private SearchField _jFilterCtl = new SearchField();
    private SingleClusterViewerState _state;
    SingleClusterMainPanel _mainPanel;
    private JPanel jGraphPanel;
    private GraphPanel _graphPanel;
    private JPanel _loadingPanel;
    private JPanel _singleAttributeMessagePanel;
    public static final int FILTER_DETAIL_COLUMN_NAME = 0;
    public static final int FILTER_DETAIL_COLUMN_MODE = 1;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(ClusterLrb.get("DETAIL_TABLE_COLUMN_NAME"));
    private int FIXED_COLUMNS = 0;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _labelNumericalFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    private NumberFormat _labelPercentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private boolean _loadedFilterSetting = false;
    private Dimension _histogramRowDimension = new Dimension(120, 25);
    private GenericTableFixedColumns _jClusterDetailGenericTable = new CustomGenericTable();
    private JScrollPane jScrollPane1;
    JLabel _jRowsOutOfTotalLabel = new JLabel();
    private ComponentWithTitlebar<JComponent> _jClusterViewerComponent = new ComponentWithTitlebar();
    private JComponent _findPane;
    private JPanel _jDetailPanel;
    private JSplitPane _jMasterSplitPanel;

    public SingleClusterViewer(Editor editor, SingleClusterMainPanel singleClusterMainPanel, Context context, SingleClusterViewerState singleClusterViewerState) {
        super(editor, context);
        this._mainPanel = singleClusterMainPanel;
        this._context = context;
        this._state = singleClusterViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jMasterSplitPanel = new JSplitPane();
        this._jDetailPanel = new JPanel();
        this._jMasterSplitPanel.setDividerLocation(300);
        this._jMasterSplitPanel.setOrientation(0);
        this._jMasterSplitPanel.setResizeWeight(0.8);
        this._jMasterSplitPanel.setLastDividerLocation(400);
        this._jDetailPanel.setMinimumSize(new Dimension(300, 300));
        GroupLayout groupLayout = new GroupLayout(this._jDetailPanel);
        this._jDetailPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 544, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 263, Short.MAX_VALUE));
        this._jMasterSplitPanel.setRightComponent(this._jDetailPanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this._jMasterSplitPanel).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jMasterSplitPanel, -1, 585, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(new Integer(0), new Integer(0));
        this._labelNumericalFormat.setMinimumIntegerDigits(1);
        this._labelNumericalFormat.setMinimumFractionDigits(this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
        this._labelPercentageFormat.setMinimumIntegerDigits(1);
        this._labelPercentageFormat.setMinimumFractionDigits(this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
    }

    @Override
    public void initUI() {
        this.jGraphPanel = new JPanel();
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jGraphPanel.setPreferredSize(new Dimension(300, 300));
        this._jMasterSplitPanel.setResizeWeight(0.8);
        this._jMasterSplitPanel.setDividerLocation(400);
        this._jMasterSplitPanel.setOneTouchExpandable(true);
        this._jMasterSplitPanel.setRightComponent(this.jGraphPanel);
        this.jScrollPane1 = new JScrollPane((Component)((Object)this._jClusterDetailGenericTable));
        this._jClusterDetailGenericTable.setFillsViewportHeight(true);
        this._jClusterViewerComponent.setComponent((JComponent)this.jScrollPane1);
        this._jClusterViewerComponent.setLabel(this._jRowsOutOfTotalLabel);
        ControlBar controlBar = new ControlBar();
        this.setupFilterControl(controlBar);
        this._jClusterViewerComponent.setControlBar(controlBar);
        this._jClusterDetailGenericTable.setShowGrid(true);
        this._jClusterViewerComponent.setPreferredSize(new Dimension(400, 400));
        this._jMasterSplitPanel.setTopComponent((Component)this._jClusterViewerComponent);
        this.setLoading(true);
        this.initializeControls();
        this.addListeners();
        this._jMasterSplitPanel.updateUI();
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    public JPanel createLoadingPanelOLD() {
        this._loadingPanel = new JPanel();
        this._loadingPanel.setLayout(new BoxLayout(this._loadingPanel, 3));
        JLabel jLabel = new JLabel(ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY"));
        jLabel.setBackground(this._jClusterDetailGenericTable.getBackground());
        jLabel.setPreferredSize(new Dimension(150, 25));
        this._loadingPanel.add(jLabel);
        this._loadingPanel.setBackground(this._jClusterDetailGenericTable.getBackground());
        this._loadingPanel.setPreferredSize(new Dimension(200, 150));
        return this._loadingPanel;
    }

    public JPanel createMessagePanel(String string) {
        this.jGraphPanel.removeAll();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        int n = this.jGraphPanel.getGraphics() != null ? this.jGraphPanel.getGraphics().getFontMetrics(font2).stringWidth(string) : 200;
        Dimension dimension = this.jGraphPanel.getSize();
        jPanel.add(Box.createHorizontalStrut((dimension.width - n) / 2));
        jPanel.add(jLabel);
        this.jGraphPanel.add(jPanel);
        this.jGraphPanel.updateUI();
        return this.jGraphPanel;
    }

    public JPanel createSelectOnlyOneAttributePanelOLD() {
        this._singleAttributeMessagePanel = new JPanel();
        this._singleAttributeMessagePanel.setLayout(new BoxLayout(this._singleAttributeMessagePanel, 3));
        JLabel jLabel = new JLabel(ClusterLrb.get("SELECT_SINGLE_ATTRIBUTE"));
        jLabel.setBackground(this._jClusterDetailGenericTable.getBackground());
        jLabel.setPreferredSize(new Dimension(150, 25));
        this._singleAttributeMessagePanel.add(jLabel);
        this._singleAttributeMessagePanel.setBackground(this._jClusterDetailGenericTable.getBackground());
        this._singleAttributeMessagePanel.setPreferredSize(new Dimension(200, 150));
        return this._singleAttributeMessagePanel;
    }

    public void setFilterState(ClusteringFilterSetting clusteringFilterSetting, boolean bl) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(clusteringFilterSetting);
        this.prepareReload(bl);
    }

    @Override
    public void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    @Override
    public void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    @Override
    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    private void initializeControls() {
        this.setupTable(new ClusterDetailsModel());
        this.enableControls(false);
    }

    private void setupFilterControl(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._jFilterCtl = this.searchField();
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(ClusterLrb.get("DETAIL_TABLE_COLUMN_MODE")));
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._jFilterCtl);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                SingleClusterViewer.this.translateSearchCategoryToConstant(SingleClusterViewer.this._jFilterCtl.getSelectedCategory());
                SingleClusterViewer.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                SingleClusterViewer.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                SingleClusterViewer.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void enableControls(boolean bl) {
        this._jFilterCtl.setEnabled(bl);
    }

    private void setupTable(ClusterDetailsModel clusterDetailsModel) {
        this._jClusterDetailGenericTable.setFixedColumnCount(this.FIXED_COLUMNS);
        this._jClusterDetailGenericTable.setModel((TableModel)((Object)clusterDetailsModel));
        this._jClusterDetailGenericTable.setSelectionMode(2);
        this._jClusterDetailGenericTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jClusterDetailGenericTable.setSorted(true);
        this._jClusterDetailGenericTable.addDynamicCellRenderers();
        this._jClusterDetailGenericTable.disallowSorting(ClusterDetailsModel._colNames.get(1));
        this._jClusterDetailGenericTable.setCellRenderers();
        this._jClusterDetailGenericTable.setUpdateSelectionOnSort(true);
        this._jClusterDetailGenericTable.setAutoResizeMode(0);
        this._jClusterDetailGenericTable.getTableHeader().setReorderingAllowed(false);
        this._jClusterDetailGenericTable.setColumnSelectorAvailable(false);
        TableColumnModel tableColumnModel = this._jClusterDetailGenericTable.getColumnModel();
        tableColumnModel.getColumn(0 - this.FIXED_COLUMNS).setPreferredWidth(200);
        tableColumnModel.getColumn(1 - this.FIXED_COLUMNS).setPreferredWidth(150);
        tableColumnModel.getColumn(2 - this.FIXED_COLUMNS).setPreferredWidth(110);
        tableColumnModel.getColumn(5 - this.FIXED_COLUMNS).setPreferredWidth(90);
        tableColumnModel.getColumn(4 - this.FIXED_COLUMNS).setPreferredWidth(150);
        tableColumnModel.getColumn(3 - this.FIXED_COLUMNS).setPreferredWidth(90);
        tableColumnModel.getColumn(6 - this.FIXED_COLUMNS).setPreferredWidth(90);
    }

    private void addListeners() {
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                SingleClusterViewer.this.translateSearchCategoryToConstant(SingleClusterViewer.this._jFilterCtl.getSelectedCategory());
                SingleClusterViewer.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                SingleClusterViewer.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                SingleClusterViewer.this.processFilter(string);
            }
        });
    }

    void prepareReload(boolean bl) {
        this.setLoading(true);
        this.enableControls(false);
        this._state.clearRows();
        this._jClusterDetailGenericTable.repaint();
        this.createMessagePanel(ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY"));
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true, bl);
        loadUI.start();
    }

    void prepareForNewQuery() {
        this._state.clearRows();
        this.enableControls(false);
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ClusterLrb.get("ATTRIBUTES_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format(n != null ? n : 0);
        String string3 = NumericFormat.format(n2 != null ? n2 : 0);
        String string4 = MessageFormat.format(string, string2, string3);
        this._jRowsOutOfTotalLabel.setText(string4);
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(ClusterLrb.get("DETAIL_TABLE_COLUMN_NAME"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(ClusterLrb.get("DETAIL_TABLE_COLUMN_MODE"))) {
            this._currentSearchCategory = 1;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private void processFilter(String string) {
        try {
            ClusterDetailsModel clusterDetailsModel = this._state.getFilteredStatistics(string, this._currentSearchCategory);
            this.setupTable(clusterDetailsModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"), null);
        }
    }

    private void handleSelectionChanged(ListSelectionModel listSelectionModel) {
        boolean bl = false;
        if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
            bl = true;
        }
        if (!bl) {
            this.createMessagePanel(ClusterLrb.get("SELECT_SINGLE_ATTRIBUTE"));
            return;
        }
        int[] nArray = this._jClusterDetailGenericTable.getSelectedRowsInModel();
        if (!this._state.isLoaded()) {
            return;
        }
        LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray[0]);
        loadGraphPanel.start();
    }

    private String formatCellValue(Object object, FormatType formatType) {
        String string = "";
        if (object == null) {
            string = null;
        } else if (object != null) {
            string = object instanceof Double ? (formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel()) + "") : object.toString();
        }
        return string;
    }

    public HelpInfo getHelpInfo() {
        String string = "cluster_detail_help";
        return new HelpInfo(string);
    }

    private class LoadGraphPanel
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        GraphDataModel localGraphModel = null;
        int _selectedRowsInModel;
        GraphDataModel _graphDataModel;

        public LoadGraphPanel(int n) {
            this._selectedRowsInModel = n;
        }

        public Object construct() {
            try {
                ClusterDetailsModel clusterDetailsModel = (ClusterDetailsModel)((Object)SingleClusterViewer.this._jClusterDetailGenericTable.getBaseModel());
                Vector<ClusterDetailsModelRow> vector = clusterDetailsModel.getDataVector();
                ClusterDetailsModelRow clusterDetailsModelRow = vector.get(this._selectedRowsInModel);
                String string = clusterDetailsModelRow.getFullAttributeName();
                this.localGraphModel = SingleClusterViewer.this._state.createGraphDataModelForAttribute(string);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                exception.printStackTrace();
            }
            return SingleClusterViewer.this._state;
        }

        public void finished() {
            if (this._success && this._ex == null) {
                SingleClusterViewer.this._graphPanel = new GraphPanel(this.localGraphModel);
                this.localGraphModel.setDepthRadius(SingleClusterViewer.this._state.getDepthRadius());
                SingleClusterViewer.this._graphPanel.initGraph();
                this.localGraphModel.setStyleSelection(SingleClusterViewer.this._state.getStyleSelection());
                SingleClusterViewer.this._graphPanel.updateGraphStyle();
                SingleClusterViewer.this.jGraphPanel.removeAll();
                SingleClusterViewer.this.jGraphPanel.add((Component)SingleClusterViewer.this._graphPanel, "Center");
                SingleClusterViewer.this.jGraphPanel.updateUI();
            }
            SingleClusterViewer.this.setLoading(false);
        }
    }

    private class NumberRenderer
    extends DefaultTableCellRenderer {
        FormatType _formatType = FormatType.NUMERICAL;

        public NumberRenderer() {
        }

        public NumberRenderer(FormatType formatType) {
            this._formatType = formatType;
        }

        @Override
        public void setValue(Object object) {
            String string = SingleClusterViewer.this.formatCellValue(object, this._formatType);
            super.setValue(string);
        }
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        CustomGenericTable() {
            this.adjustRowHeight((int)SingleClusterViewer.this._histogramRowDimension.getHeight());
            this.addCellRenderer(ClusterDetailsModel._colNames.get(5), new NumberRenderer(FormatType.NUMERICAL));
            this.addCellRenderer(ClusterDetailsModel._colNames.get(3), new NumberRenderer(FormatType.NUMERICAL));
            this.addCellRenderer(ClusterDetailsModel._colNames.get(6), new NumberRenderer(FormatType.NUMERICAL));
        }

        @Override
        protected void handleSelectionChanged(ListSelectionModel listSelectionModel) {
            SingleClusterViewer.this.handleSelectionChanged(listSelectionModel);
        }

        @Override
        public void addDynamicCellRenderers() {
            this.addCellRenderer(ClusterDetailsModel._colNames.get(1), new MiniHistogramCellRenderer((GraphModelProvider)SingleClusterViewer.this._state, SingleClusterViewer.this._histogramRowDimension));
            this.addCellRenderer(SingleClusterViewer.this._state.getTableModel().getColumnName(2), new HistogramBarRenderer(100L, true, SingleClusterViewer.this._labelPercentageFormat));
            this.addCellRenderer(SingleClusterViewer.this._state.getTableModel().getColumnName(5), new NumberCellRenderer());
            this.addCellRenderer(SingleClusterViewer.this._state.getTableModel().getColumnName(6), new NumberCellRenderer());
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = n2 == 2 ? SingleClusterViewer.this.formatCellValue(object, FormatType.PERCENTAGE) : (n2 + SingleClusterViewer.this.FIXED_COLUMNS == 1 ? MessageFormat.format(ClusterLrb.get("DETAIL_TABLE_TOOL_TIP_HISTOGRAM"), this.getValueAt(n, 0)) : SingleClusterViewer.this.formatCellValue(object, FormatType.NUMERICAL));
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Object object = null;
            String string = "";
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = n2 + SingleClusterViewer.this.FIXED_COLUMNS == 2 ? SingleClusterViewer.this.formatCellValue(object, FormatType.PERCENTAGE) : (n2 + SingleClusterViewer.this.FIXED_COLUMNS == 1 ? MessageFormat.format(ClusterLrb.get("DETAIL_TABLE_TOOL_TIP_HISTOGRAM"), this.getValueAt(n, 0)) : SingleClusterViewer.this.formatCellValue(object, FormatType.NUMERICAL));
            return string;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        boolean _external = false;

        public LoadUI(boolean bl, boolean bl2) {
            this._reload = bl;
            this._external = bl2;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    SingleClusterViewer.this._state.reload(this._external);
                } else {
                    SingleClusterViewer.this._state.load();
                }
                this._success = SingleClusterViewer.this._state.isLoaded();
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                exception.printStackTrace();
            }
            return SingleClusterViewer.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    if (SingleClusterViewer.this._jFilterCtl.getText().trim().length() > 0) {
                        SingleClusterViewer.this.setupTable(SingleClusterViewer.this._state.getFilteredStatistics(SingleClusterViewer.this._jFilterCtl.getText(), SingleClusterViewer.this._currentSearchCategory));
                    } else {
                        SingleClusterViewer.this.setupTable(SingleClusterViewer.this._state.getTableModel());
                    }
                    SingleClusterViewer.this._labelPercentageFormat.setMaximumFractionDigits(SingleClusterViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    SingleClusterViewer.this._labelNumericalFormat.setMaximumFractionDigits(SingleClusterViewer.this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
                    SingleClusterViewer.this.loadRowsOutOfTotalLabel(new Integer(SingleClusterViewer.this._state.getTableModel().getRowCount()), SingleClusterViewer.this._state.getTotalNumberOfModelAttributes());
                    SingleClusterViewer.this.enableControls(true);
                    if (SingleClusterViewer.this._jClusterDetailGenericTable.getRowCount() > 0) {
                        int n = SingleClusterViewer.this._jClusterDetailGenericTable.convertRowIndexToModel(0);
                        SingleClusterViewer.this._jClusterDetailGenericTable.setSelectedRowsInModel(new int[]{n});
                    }
                    if (!this._reload) {
                        SingleClusterViewer.this._mainPanel.updateClusterIDs();
                    }
                    if (this._external) {
                        SingleClusterViewer.this._mainPanel.updateClusterIDs();
                    }
                    SingleClusterViewer.this.setLoaded(true);
                } else {
                    if (SingleClusterViewer.this._state.getTableModel() != null) {
                        SingleClusterViewer.this._state.getTableModel().setFailedStatus();
                        SingleClusterViewer.this.setupTable(SingleClusterViewer.this._state.getTableModel());
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"), null);
            }
            finally {
                SingleClusterViewer.this.setLoading(false);
            }
        }
    }

    private static enum FormatType {
        PERCENTAGE,
        NUMERICAL;

    }
}

