/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.utils.NumberComparator;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.javatools.ui.search.SearchMatcher;

public class ClusterDetailsModel
extends GenericBaseTableModel {
    private Vector<ClusterDetailsModelRow> _data = new Vector();
    private Hashtable<String, ClusterDetailsModelRow> _attributeNameToRowMap = new Hashtable();
    static Vector<String> _colNames = new Vector();
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_HISTOGRAM = 1;
    public static final int _COLUMN_CONFIDENCE = 2;
    public static final int _COLUMN_SUPPORT = 3;
    public static final int _COLUMN_MEAN = 5;
    public static final int _COLUMN_MODE = 4;
    public static final int _COLUMN_VARIANCE = 6;

    private void addDataItem(ClusterDetailsModelRow clusterDetailsModelRow) {
        this._data.add(clusterDetailsModelRow);
    }

    private void clear() {
        this._data.clear();
        this._attributeNameToRowMap.clear();
    }

    private int getDataSize() {
        return this._data.size();
    }

    public ClusterDetailsModel(Vector<ClusterDetailsModelRow> vector) {
        this.setColumnIdentifiers(_colNames);
        this.setDataVector(vector);
        this.setColumnCount(_colNames.size());
    }

    public ClusterDetailsModelRow getClusterDetailRow(String string) {
        return this._attributeNameToRowMap.get(string);
    }

    public void setDataVector(Vector<ClusterDetailsModelRow> vector) {
        this._data = vector;
        this.setRowCount(this._data.size());
        this._attributeNameToRowMap.clear();
        for (ClusterDetailsModelRow clusterDetailsModelRow : vector) {
            this._attributeNameToRowMap.put(clusterDetailsModelRow.getFullAttributeName(), clusterDetailsModelRow);
        }
    }

    public ClusterDetailsModel() {
        this.setColumnIdentifiers(_colNames);
        ClusterDetailsModelRow clusterDetailsModelRow = new ClusterDetailsModelRow(ClusterLrb.get("DETAIL_CLUSTER_EDITOR_LOADING"));
        this.addDataItem(clusterDetailsModelRow);
        this.setRowCount(this.getDataSize());
        this.setColumnCount(_colNames.size());
    }

    public void clearRows() {
        for (ClusterDetailsModelRow clusterDetailsModelRow : this._data) {
            clusterDetailsModelRow.setGraphDataModel(null);
            clusterDetailsModelRow.setHistogram(null);
        }
        this._data.clear();
        ClusterDetailsModelRow clusterDetailsModelRow = new ClusterDetailsModelRow(ClusterLrb.get("DETAIL_CLUSTER_EDITOR_LOADING"));
        this.addDataItem(clusterDetailsModelRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ClusterDetailsModelRow clusterDetailsModelRow = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = clusterDetailsModelRow.getFullAttributeName();
                break;
            }
            case 1: {
                object = clusterDetailsModelRow.getGraphDataModel();
                break;
            }
            case 2: {
                if (clusterDetailsModelRow.getConfidence() != null) {
                    object = clusterDetailsModelRow.getConfidence() * 100.0;
                    break;
                }
                object = clusterDetailsModelRow.getConfidence();
                break;
            }
            case 3: {
                object = clusterDetailsModelRow.getSupport();
                break;
            }
            case 5: {
                if (clusterDetailsModelRow.getMean() == null) {
                    object = "";
                    break;
                }
                if (clusterDetailsModelRow.getMean() == 0.0) {
                    object = "";
                    break;
                }
                object = clusterDetailsModelRow.getMean();
                break;
            }
            case 4: {
                object = clusterDetailsModelRow.getMode();
                break;
            }
            case 6: {
                if (clusterDetailsModelRow.getVariance() == null) {
                    object = "";
                    break;
                }
                if (clusterDetailsModelRow.getVariance() == 0.0) {
                    object = "";
                    break;
                }
                object = clusterDetailsModelRow.getVariance();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing cluster details";
                break;
            }
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        switch (n) {
            case 0: {
                comparator = super.getColumnSortComparator(n);
                break;
            }
            case 2: {
                comparator = NumberComparator.getComparator();
                break;
            }
            case 1: {
                comparator = super.getColumnSortComparator(n);
                break;
            }
            case 3: {
                comparator = NumberComparator.getComparator();
                break;
            }
            case 4: {
                comparator = super.getColumnSortComparator(n);
                break;
            }
            case 5: {
                comparator = NumberComparator.getComparator();
                break;
            }
            case 6: {
                comparator = NumberComparator.getComparator();
                break;
            }
            default: {
                comparator = super.getColumnSortComparator(n);
            }
        }
        return comparator;
    }

    public void setFailedStatus() {
        ClusterDetailsModelRow clusterDetailsModelRow = new ClusterDetailsModelRow(ClusterLrb.get("DETAIL_CLUSTER_FAILED_TO_LOAD"));
        this.addDataItem(clusterDetailsModelRow);
        this.clear();
        this.addDataItem(clusterDetailsModelRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public ClusterDetailsModel getFilteredStatistics(String string, int n) throws Exception {
        Vector<ClusterDetailsModelRow> vector = null;
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Vector<ClusterDetailsModelRow> vector2 = this.getDataVector();
        vector = new Vector<ClusterDetailsModelRow>();
        Iterator<ClusterDetailsModelRow> iterator = vector2.iterator();
        ClusterDetailsModelRow clusterDetailsModelRow = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            clusterDetailsModelRow = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = null;
                switch (n) {
                    case 0: {
                        string2 = clusterDetailsModelRow.getFullAttributeName();
                        break;
                    }
                    case 1: {
                        string2 = clusterDetailsModelRow.getMode();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid table filter category.";
                        string2 = clusterDetailsModelRow.getName();
                    }
                }
                if (string2 == null) {
                    string2 = "";
                }
                bl2 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(clusterDetailsModelRow);
        }
        return new ClusterDetailsModel(vector);
    }

    public Vector<ClusterDetailsModelRow> getDataVector() {
        return this._data;
    }

    static {
        _colNames.add(ClusterLrb.get("DETAIL_TABLE_COLUMN_NAME"));
        _colNames.add(ClusterLrb.get("DETAIL_TABLE_COLUMN_HISTOGRAM"));
        _colNames.add(ClusterLrb.get("DETAIL_TABLE_COLUMN_CONFIDENCE"));
        _colNames.add(ClusterLrb.get("DETAIL_TABLE_COLUMN_SUPPORT"));
        _colNames.add(ClusterLrb.get("DETAIL_TABLE_COLUMN_MODE"));
        _colNames.add(ClusterLrb.get("DETAIL_TABLE_COLUMN_MEAN"));
        _colNames.add(ClusterLrb.get("DETAIL_TABLE_COLUMN_VARIANCE"));
    }
}

