/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.server.model.RuleContentOption;
import oracle.dmt.dataminer.server.model.RuleRowData;
import oracle.dmt.dataminer.utils.NumberComparator;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.javatools.ui.search.SearchMatcher;

public class ARRulesViewerTableModel
extends GenericBaseTableModel {
    private Vector<RuleRowData> _data = new Vector(1000, 500);
    private static final int COLUMN_COUNT = 9;
    public static final int RULE_ID = 0;
    public static final int CONDITION = 1;
    public static final int ASSOCIATION = 2;
    public static final int LIFT = 3;
    public static final int CONFIDENCE = 4;
    public static final int SUPPORT = 5;
    public static final int NUMBER_OF_ITEMS = 6;
    public static final int CONDITION_SUPPORT = 7;
    public static final int ASSOCIATION_SUPPPORT = 8;
    private RuleContentOption _ruleContentOption = RuleContentOption.SUBNAME_VALUE;
    private String[] _columnNames = new String[]{ARRulesLrb.get("RULE_ID_COLUMN"), ARRulesLrb.get("CONDITION_COLUMN"), ARRulesLrb.get("ASSOCIATION_COLUMN"), ARRulesLrb.get("LIFT_COLUMN"), ARRulesLrb.get("CONFIDENCE_COLUMN"), ARRulesLrb.get("SUPPORT_COLUMN"), ARRulesLrb.get("RULE_LENGTH_COLUMN"), ARRulesLrb.get("CONDITION_SUPPORT_COLUMN"), ARRulesLrb.get("ASSOCIATION_SUPPORT_COLUMN")};

    public ARRulesViewerTableModel() {
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(9);
    }

    public ARRulesViewerTableModel(Vector<RuleRowData> vector) {
        this.setColumnIdentifiers(this._columnNames);
        this._data = vector;
        this.setRowCount(vector.size());
        this.setColumnCount(9);
    }

    public ARRulesViewerTableModel getFilteredRules(String string, int n) throws Exception {
        Vector<RuleRowData> vector = null;
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Object object = this.getDataVector();
        vector = new Vector<RuleRowData>(1000, 500);
        Iterator<RuleRowData> iterator = ((Vector)object).iterator();
        RuleRowData ruleRowData = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            ruleRowData = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = "";
                switch (n) {
                    case 1: {
                        string2 = ruleRowData.getFullAntecedent();
                        break;
                    }
                    case 2: {
                        string2 = ruleRowData.getFullConsequent();
                        break;
                    }
                    case 0: {
                        string2 = ruleRowData.getFullAntecedent() + " " + ruleRowData.getFullConsequent();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid rule filter category.";
                        string2 = ruleRowData.getFullAntecedent() + " " + ruleRowData.getFullConsequent();
                    }
                }
                bl2 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(ruleRowData);
        }
        object = new ARRulesViewerTableModel(vector);
        ((ARRulesViewerTableModel)((Object)object)).setRuleContentOption(this._ruleContentOption);
        return object;
    }

    public void addRows(Vector<RuleRowData> vector) {
        for (RuleRowData ruleRowData : vector) {
            this.getDataVector().add(ruleRowData);
        }
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public RuleRowData getRow(int n) {
        return this._data.get(n);
    }

    public void addSelection(ARRulesViewerTableModel aRRulesViewerTableModel, int[] nArray) {
        Vector<RuleRowData> vector = aRRulesViewerTableModel.getDataVector();
        RuleRowData ruleRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            ruleRowData = vector.elementAt(nArray[i]);
            this._data.add(ruleRowData);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Vector<RuleRowData> getDataVector() {
        return this._data;
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<RuleRowData> vector = new Vector<RuleRowData>();
        RuleRowData ruleRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            ruleRowData = this._data.elementAt(nArray[i]);
            vector.add(ruleRowData);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        RuleRowData ruleRowData = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = ruleRowData.getRule_id();
                break;
            }
            case 1: {
                object = ruleRowData.getFullAntecedent(this._ruleContentOption);
                break;
            }
            case 2: {
                object = ruleRowData.getFullConsequent(this._ruleContentOption);
                break;
            }
            case 3: {
                object = ruleRowData.getRule_lift();
                break;
            }
            case 4: {
                if (ruleRowData.getRule_confidence() != null) {
                    object = ruleRowData.getRule_confidence() * 100.0;
                    break;
                }
                object = ruleRowData.getRule_confidence();
                break;
            }
            case 5: {
                if (ruleRowData.getRule_support() != null) {
                    object = ruleRowData.getRule_support() * 100.0;
                    break;
                }
                object = ruleRowData.getRule_support();
                break;
            }
            case 6: {
                object = ruleRowData.getNumber_of_items();
                break;
            }
            case 7: {
                if (ruleRowData.getConsequent_support() != null) {
                    object = ruleRowData.getConsequent_support() * 100.0;
                    break;
                }
                object = ruleRowData.getConsequent_support();
                break;
            }
            case 8: {
                if (ruleRowData.getAntecedent_support() != null) {
                    object = ruleRowData.getAntecedent_support() * 100.0;
                    break;
                }
                object = ruleRowData.getAntecedent_support();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing rules";
                break;
            }
        }
        if (object == null) {
            return "NULL";
        }
        return object;
    }

    public void addRow(RuleRowData ruleRowData) {
        this._data.add(ruleRowData);
    }

    public void setRuleContentOption(RuleContentOption ruleContentOption) {
        this._ruleContentOption = ruleContentOption;
        this.fireTableDataChanged();
    }

    public RuleContentOption getRuleContentOption() {
        return this._ruleContentOption;
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                comparator = NumberComparator.getComparator();
                break;
            }
            default: {
                comparator = super.getColumnSortComparator(n);
            }
        }
        return comparator;
    }
}

