/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.HistogramBarRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesDetailViewer;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesMainPanel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerState;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerTableModel;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.ARRulesFilterSetting;
import oracle.dmt.dataminer.server.model.RuleContentOption;
import oracle.dmt.dataminer.server.model.RuleRowData;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class ARRulesViewer
extends JPanel {
    public static final int RULES_FILTER_ALL = 0;
    public static final int RULES_FILTER_CONDITION = 1;
    public static final int RULES_FILTER_ASSOCIATION = 2;
    private static final int FROZEN_COLUMNS = 1;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _labelFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    ARRulesViewerState _state;
    ARRulesMainPanel _mainPanel;
    ARRulesDetailViewer _detailPanel;
    Context _context;
    private SearchField _jFilterCtl;
    private HistogramBarRenderer _barRenderer = new HistogramBarRenderer(4L, true, this._labelFormat);
    private boolean _loadedFilterSetting = false;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(ARRulesLrb.get("FILTER_CATEGORY_ALL"));
    private RuleContentOption _currentRuleContentOption = RuleContentOption.SUBNAME;
    JLabel _jRowsOutOfTotalLabel = new JLabel();
    private GenericTableFixedColumns _jRulesNiceTable = new ARRulesNiceTable();
    JScrollPane jScrollPane1;
    private JComponent _findPane;
    private String _htmlHeader = "<html>\n<body>";
    private String _htmlFooter = "</body>\n</html>";
    private StringBuffer _ruleHTMLTemplate = new StringBuffer();
    private String _jSelectSingleRuleMesg;
    String RULE_ID_LABEL = "[RULE_ID_LABEL]";
    String RULE_ID_VALUE = "[RULE_ID_VALUE]";
    String DETAIL_LABEL = "[DETAIL_LABEL]";
    String IF_LABEL = "[IF_LABEL]";
    String RULE_DETAIL = "[RULE_DETAIL]";
    String IF_DETAIL = "[IF_DETAIL]";
    String THEN_LABEL = "[THEN_LABEL]";
    String THEN_DETAIL = "[THEN_DETAIL]";
    String METRICS_LABEL = "[METRICS_LABEL]";
    String LIFT_LABEL = "[LIFT_LABEL]";
    String LIFT_VALUE = "[LIFT_VALUE]";
    String CONFIDENCE_LABEL = "[CONFIDENCE_LABEL]";
    String CONFIDENCE_VALUE = "[CONFIDENCE_VALUE]";
    String SUPPORT_LABEL = "[SUPPORT_LABEL]";
    String SUPPORT_VALUE = "[SUPPORT_VALUE]";
    String CONFIDENCE_SUPPORT_LABEL = "[CONFIDENCE_SUPPORT_LABEL]";
    String CONFIDENCE_SUPPORT_VALUE = "[CONFIDENCE_SUPPORT_VALUE]";
    String ASSOCIATION_SUPPORT_LABEL = "[ASSOCIATION_SUPPORT_LABEL]";
    String ASSOCIATION_SUPPORT_VALUE = "[ASSOCIATION_SUPPORT_VALUE]";
    String LENGTH_LABEL = "[LENGTH_LABEL]";
    String LENGTH_VALUE = "[LENGTH_VALUE]";
    private ComponentWithTitlebar<JComponent> _jRuleViewerComponent;
    private JLabel _jShowRuleContent;
    private JComboBox _jShowRuleContentValue;
    private JSeparator jSeparator1;

    public ARRulesViewer(ARRulesMainPanel aRRulesMainPanel, Context context, ARRulesDetailViewer aRRulesDetailViewer) throws Exception {
        this._mainPanel = aRRulesMainPanel;
        this._context = context;
        this._detailPanel = aRRulesDetailViewer;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jShowRuleContent = new JLabel();
        this._jShowRuleContentValue = new JComboBox();
        this._jRuleViewerComponent = new ComponentWithTitlebar();
        this.jSeparator1 = new JSeparator();
        this._jShowRuleContent.setText("Rule Content:");
        this._jShowRuleContentValue.setModel(new DefaultComboBoxModel<String>(new String[]{"Name,Subname,Value", "Subname,Value", "Name,Subname", "Subname"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this._jRuleViewerComponent, GroupLayout.Alignment.LEADING, -1, 624, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 624, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this._jShowRuleContent, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jShowRuleContentValue, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 359, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jShowRuleContent).addComponent(this._jShowRuleContentValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._jRuleViewerComponent, -1, 228, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jShowRuleContent, (Component)this._jShowRuleContentValue, (String)ARRulesLrb.get("SHOW_RULE_CONTENT"));
        this._jShowRuleContent.getAccessibleContext().setAccessibleName(ARRulesLrb.get("SHOW_RULE_CONTENT"));
        this._jShowRuleContent.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("SHOW_RULE_CONTENT_ADA"));
        this._jShowRuleContentValue.setModel(new DefaultComboBoxModel<RuleContentOption>(RuleContentOption.values()));
        this._jShowRuleContentValue.setSelectedItem((Object)this._currentRuleContentOption);
        this._jShowRuleContentValue.setToolTipText(ARRulesLrb.get("SHOW_RULE_CONTENT_ADA"));
        this._jSelectSingleRuleMesg = ARRulesLrb.get("SELECT_SINGLE_RULE");
        this.loadRuleHTMLTemplate();
    }

    private void loadRuleHTMLTemplate() {
        String string = "/oracle/dmt/dataminer/mviewer/res/ARRuleTemplate.html";
        try {
            this._ruleHTMLTemplate = FileHelper.loadFile(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initUI() {
        this.jScrollPane1 = new JScrollPane((Component)((Object)this._jRulesNiceTable));
        this.loadEmptyRulesTable(RuleQueryMessages.LOADING);
        this._detailPanel.setRuleDisplay(ARRulesLrb.get("NO_RULE_TO_DISPLAY"));
        this._jRulesNiceTable.setFillsViewportHeight(true);
        this._jRuleViewerComponent.setComponent((JComponent)this.jScrollPane1);
        this._jRuleViewerComponent.setLabel(this._jRowsOutOfTotalLabel);
        ControlBar controlBar = new ControlBar();
        this.setupFilterControl(controlBar);
        this._jRuleViewerComponent.setControlBar(controlBar);
        this.initializeControls();
        this.addListeners();
        this._jRulesNiceTable.setSelectionMode(2);
        this._jRulesNiceTable.setShowGrid(true);
        this.setLoading(true);
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void setupGlobalMetrics() {
        this.loadRowsOutOfTotalLabel(0, this._state.getTotal_rules_count());
        if (this._state.getTotal_rules_count() == 0) {
            this.loadEmptyRulesTable(RuleQueryMessages.NO_RULES_IN_MODEL);
            this.enableControls(false);
            return;
        }
        if (this._state.getMaximum_lift_value() != null && this._state.getMaximum_lift_value() != 0.0) {
            Double d = new Double(this._state.getMaximum_lift_value());
            if (d.longValue() == 0L) {
                this._barRenderer.setMaximumValue(1L);
            } else {
                this._barRenderer.setMaximumValue(d.longValue());
            }
        } else {
            this._barRenderer.setMaximumValue(100L);
        }
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        return searchField;
    }

    private void setupFilterControl(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._jFilterCtl = this.searchField();
        this._currentSearchCategory = 0;
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(ARRulesLrb.get("FILTER_CATEGORY_CONDITION")));
        this._jFilterCtl.addCategory(new SearchCategory(ARRulesLrb.get("FILTER_CATEGORY_ASSOCIATION")));
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._jFilterCtl);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void addListeners() {
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                ARRulesViewer.this.translateSearchCategoryToConstant(ARRulesViewer.this._jFilterCtl.getSelectedCategory());
                ARRulesViewer.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                ARRulesViewer.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                ARRulesViewer.this.processFilter(string);
            }
        });
        this._jShowRuleContentValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RuleContentOption ruleContentOption = (RuleContentOption)((Object)ARRulesViewer.this._jShowRuleContentValue.getSelectedItem());
                if (ARRulesViewer.this._currentRuleContentOption != ruleContentOption) {
                    ARRulesViewer.this._currentRuleContentOption = ruleContentOption;
                    ARRulesViewer.this._state.setRuleContentOption(ARRulesViewer.this._currentRuleContentOption);
                    if (ARRulesViewer.this._jRulesNiceTable.getModel() instanceof ARRulesViewerTableModel && !((Object)((Object)ARRulesViewer.this._state.getTableModel())).equals(ARRulesViewer.this._jRulesNiceTable.getModel())) {
                        ((ARRulesViewerTableModel)((Object)ARRulesViewer.this._jRulesNiceTable.getModel())).setRuleContentOption(ARRulesViewer.this._currentRuleContentOption);
                    }
                    ARRulesViewer.this.handleSelectionChanged(ARRulesViewer.this._jRulesNiceTable.getSelectionModel());
                }
            }
        });
    }

    private void processFilter(String string) {
        try {
            ARRulesViewerTableModel aRRulesViewerTableModel = this._state.getFilteredRules(string, this._currentSearchCategory);
            this.setupTable(aRRulesViewerTableModel, true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"), null);
        }
    }

    private void setupTable(ARRulesViewerTableModel aRRulesViewerTableModel, boolean bl) {
        if (this._state.getTotal_rules_count() == 0) {
            this.loadEmptyRulesTable(RuleQueryMessages.NO_RULES_IN_MODEL);
            this.enableControls(false);
            return;
        }
        if (aRRulesViewerTableModel.getRowCount() == 0 && !bl) {
            this.loadEmptyRulesTable(RuleQueryMessages.NO_RESULTS_RETURNED);
            return;
        }
        this._jRulesNiceTable.setFixedColumnCount(1);
        this._jRulesNiceTable.setModel((TableModel)((Object)aRRulesViewerTableModel));
        this._jRulesNiceTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jRulesNiceTable.setSorted(true);
        this._jRulesNiceTable.setAutoResizeMode(0);
        this._jRulesNiceTable.addDynamicCellRenderers();
        this._jRulesNiceTable.setColumnPreferredWidth(this._state.getTableModel().getColumnName(0), 65);
        TableColumnModel tableColumnModel = this._jRulesNiceTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(220);
        tableColumnModel.getColumn(1).setPreferredWidth(150);
        tableColumnModel.getColumn(2).setPreferredWidth(120);
        tableColumnModel.getColumn(3).setPreferredWidth(90);
        tableColumnModel.getColumn(4).setPreferredWidth(90);
        tableColumnModel.getColumn(6).setPreferredWidth(130);
        tableColumnModel.getColumn(7).setPreferredWidth(130);
        tableColumnModel.getColumn(5).setPreferredWidth(70);
        this._jRulesNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(4), new NumberRenderer());
        this._jRulesNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(5), new NumberRenderer());
        this._jRulesNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(7), new NumberRenderer());
        this._jRulesNiceTable.addCellRenderer(this._state.getTableModel().getColumnName(8), new NumberRenderer());
        this._jRulesNiceTable.setCellRenderers();
        this.loadRowsOutOfTotalLabel(this._state.getTableModel().getRowCount(), this._state.getTotal_rules_count());
        if (this._jRulesNiceTable.getModel().getRowCount() > 0) {
            this._jRulesNiceTable.setRowSelectionInterval(0, 0);
        } else {
            this._detailPanel.setRuleDisplay("");
        }
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ARRulesLrb.get("RULES_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format(n);
        String string3 = NumericFormat.format(n2);
        String string4 = MessageFormat.format(string, string2, string3);
        this._jRowsOutOfTotalLabel.setText(string4);
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = 1;
        if (searchCategory.getLabel().equals(ARRulesLrb.get("FILTER_CATEGORY_ALL"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(ARRulesLrb.get("FILTER_CATEGORY_CONDITION"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(ARRulesLrb.get("FILTER_CATEGORY_ASSOCIATION"))) {
            this._currentSearchCategory = 2;
        } else {
            n = -1;
            assert (false) : "Invalid Search Category Code";
        }
        return n;
    }

    private void initializeControls() {
        this.enableControls(false);
    }

    private void enableControls(boolean bl) {
        this._jFilterCtl.setEnabled(bl);
        this._jShowRuleContentValue.setEnabled(bl);
    }

    private void setupDefaultRuleContent() {
        RuleContentOption ruleContentOption = this._state.isOnlyOneColumnNameInModelItems() && !this._state.isNoSubNameColumnsInModelItems() && this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.SUBNAME : (this._state.isOnlyOneColumnNameInModelItems() && !this._state.isNoSubNameColumnsInModelItems() && !this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.SUBNAME_VALUE : (this._state.isNoSubNameColumnsInModelItems() && this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.NAME_SUBNAME : (this._state.isNoSubNameColumnsInModelItems() && !this._state.isOnlyOneConstantValueInModelItems() ? RuleContentOption.NAME_SUBNAME_VALUE : RuleContentOption.NAME_SUBNAME_VALUE)));
        this._jShowRuleContentValue.setSelectedItem((Object)ruleContentOption);
        this._state.setRuleContentOption(ruleContentOption);
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
        this.enableControls(!bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    public void setFilterState(ARRulesFilterSetting aRRulesFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(aRRulesFilterSetting);
        this.prepareReload();
    }

    public ARRulesFilterSetting getFilterState() {
        return this._state.getFilterSetting();
    }

    public ARRulesFilterSetting getCachedFilterState() {
        return this._state.getCachedFilterSetting();
    }

    public void setCachedFilterState(ARRulesFilterSetting aRRulesFilterSetting) {
        this._state.setCachedFilterSetting(aRRulesFilterSetting);
    }

    private void prepareReload() {
        this.setLoading(true);
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true);
        loadUI.start();
    }

    private void prepareForNewQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ARRulesViewer.this._detailPanel.setRuleDisplay(ARRulesLrb.get("NO_RULE_TO_DISPLAY"));
            }
        });
        this.loadEmptyRulesTable(RuleQueryMessages.LOADING);
        this.loadRowsOutOfTotalLabel(0, this._state.getTotal_rules_count());
        this.enableControls(false);
    }

    private void handleSelectionChanged(ListSelectionModel listSelectionModel) {
        boolean bl = false;
        if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
            bl = true;
        }
        if (!bl) {
            this._detailPanel.setRuleDisplay(this._jSelectSingleRuleMesg);
            return;
        }
        if (!(this._jRulesNiceTable.getBaseModel() instanceof ARRulesViewerTableModel)) {
            return;
        }
        int[] nArray = this._jRulesNiceTable.getSelectedRowsInModel();
        ARRulesViewerTableModel aRRulesViewerTableModel = (ARRulesViewerTableModel)((Object)this._jRulesNiceTable.getBaseModel());
        Vector<RuleRowData> vector = aRRulesViewerTableModel.getDataVector();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._htmlHeader);
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("<BR>");
            }
            stringBuffer.append(this.getDetailRuleString(vector.get(nArray[i])));
        }
        stringBuffer.append(this._htmlFooter);
        this._detailPanel.setRuleDisplay("");
        try {
            this._detailPanel.setRuleDisplay(stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._detailPanel.setRuleDisplay("Failed to Load Rule");
        }
    }

    private String getDetailRuleString(RuleRowData ruleRowData) {
        assert (ruleRowData != null) : "Rule can not be null";
        String string = this._ruleHTMLTemplate.toString();
        String string2 = "<span style=\"font-weight: bold;\">" + ARRulesLrb.get("RULE_ID_COLUMN") + ":" + "</span>";
        string = StringUtils.getReplacedString(string, this.RULE_ID_LABEL, string2);
        string = StringUtils.getReplacedString(string, this.RULE_ID_VALUE, ruleRowData.getRule_id() + "");
        String string3 = "<span style=\"font-weight: bold;\">" + ARRulesLrb.get("IF") + "</span>";
        string = StringUtils.getReplacedString(string, this.IF_LABEL, string3);
        String string4 = ruleRowData.getFullAntecedent(this._currentRuleContentOption, true);
        string = StringUtils.getReplacedString(string, this.IF_DETAIL, string4);
        String string5 = "<span style=\"font-weight: bold;\">" + ARRulesLrb.get("THEN") + "</span>";
        string = StringUtils.getReplacedString(string, this.THEN_LABEL, string5);
        String string6 = ruleRowData.getFullConsequent(this._currentRuleContentOption, true);
        string = StringUtils.getReplacedString(string, this.THEN_DETAIL, string6);
        string = StringUtils.getReplacedString(string, this.LIFT_LABEL, ARRulesLrb.get("LIFT_COLUMN"));
        string = StringUtils.getReplacedString(string, this.LIFT_VALUE, NumericFormat.format(ruleRowData.getRule_lift(), true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.CONFIDENCE_LABEL, ARRulesLrb.get("CONFIDENCE_COLUMN"));
        string = StringUtils.getReplacedString(string, this.CONFIDENCE_VALUE, NumericFormat.format(ruleRowData.getRule_confidence() * 100.0, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.SUPPORT_LABEL, ARRulesLrb.get("SUPPORT_COLUMN"));
        string = StringUtils.getReplacedString(string, this.SUPPORT_VALUE, NumericFormat.format(ruleRowData.getRule_support() * 100.0, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.CONFIDENCE_SUPPORT_LABEL, ARRulesLrb.get("CONDITION_SUPPORT_COLUMN"));
        string = StringUtils.getReplacedString(string, this.CONFIDENCE_SUPPORT_VALUE, NumericFormat.format(ruleRowData.getConsequent_support() * 100.0, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.ASSOCIATION_SUPPORT_LABEL, ARRulesLrb.get("ASSOCIATION_SUPPORT_COLUMN"));
        string = StringUtils.getReplacedString(string, this.ASSOCIATION_SUPPORT_VALUE, NumericFormat.format(ruleRowData.getAntecedent_support() * 100.0, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()));
        string = StringUtils.getReplacedString(string, this.LENGTH_LABEL, ARRulesLrb.get("RULE_LENGTH_COLUMN"));
        string = StringUtils.getReplacedString(string, this.LENGTH_VALUE, ruleRowData.getNumber_of_items() + "");
        return string;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("ar_view_rules");
    }

    private String formatValue(Object object) {
        String string = "";
        if (object == null) {
            string = null;
        } else if (object != null) {
            string = object instanceof Double ? NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()) + "" : object.toString();
        }
        return string;
    }

    public void setState(ARRulesViewerState aRRulesViewerState) {
        this._state = aRRulesViewerState;
    }

    public ARRulesViewerState getState() {
        return this._state;
    }

    private void loadEmptyRulesTable(RuleQueryMessages ruleQueryMessages) {
        String string = ARRulesLrb.get("LOADING_RULES_HEADER");
        String string2 = "";
        switch (ruleQueryMessages) {
            case ERROR: {
                string2 = ARRulesLrb.get("FAILURE_LOADING_RULES_ROW");
                break;
            }
            case LOADING: {
                string2 = ARRulesLrb.get("LOADING_RULES_ROW");
                break;
            }
            case NO_RESULTS_RETURNED: {
                string2 = ARRulesLrb.get("NO_RULES_RETURNED_FROM_QUERY");
                break;
            }
            case NO_RULES_IN_MODEL: {
                string2 = ARRulesLrb.get("NO_RULES_IN_MODEL");
            }
        }
        this._jRulesNiceTable.setFixedColumnCount(0);
        this._jRulesNiceTable.setModel((TableModel)new GenericBaseTableModel(new Object[][]{{string2}}, new String[]{string}){

            public boolean canHide(int n) {
                return false;
            }

            public int getColumnAlignment(int n) {
                return 2;
            }
        });
        this._jRulesNiceTable.setShowHorizontalLines(false);
        this._jRulesNiceTable.findOrCreateTableRowHeader(this.jScrollPane1);
        this._jRulesNiceTable.setAutoResizeMode(3);
    }

    class ARRulesNiceTable
    extends GenericTableFixedColumns {
        public ARRulesNiceTable() {
            this.setShowHorizontalLines(true);
            this.setShowVerticalLines(true);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            Object object = this.getValueAt(n, n2);
            string = ARRulesViewer.this.formatValue(object);
            return string;
        }

        protected void setColumnVisible(TableColumn tableColumn, int n, boolean bl) {
        }

        @Override
        protected void handleSelectionChanged(ListSelectionModel listSelectionModel) {
            ARRulesViewer.this.handleSelectionChanged(listSelectionModel);
        }

        @Override
        public void addDynamicCellRenderers() {
            this.addCellRenderer(ARRulesViewer.this._state.getTableModel().getColumnName(3), ARRulesViewer.this._barRenderer);
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = ARRulesViewer.this.formatValue(object);
            return string;
        }
    }

    class NumberRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object object) {
            String string = "";
            string = ARRulesViewer.this.formatValue(object);
            super.setValue(string);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    ARRulesViewer.this._state.reloadRules();
                } else {
                    ARRulesViewer.this._state = new ARRulesViewerState(ARRulesViewer.this._context);
                    ARRulesViewer.this._state.load();
                    ARRulesViewer.this.setupDefaultRuleContent();
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ARRulesViewer.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    if (!this._reload) {
                        ARRulesViewer.this.setupGlobalMetrics();
                    }
                    if (ARRulesViewer.this._jFilterCtl.getText().trim().length() > 0) {
                        ARRulesViewer.this.setupTable(ARRulesViewer.this._state.getFilteredRules(ARRulesViewer.this._jFilterCtl.getText(), ARRulesViewer.this._currentSearchCategory), true);
                    } else {
                        ARRulesViewer.this.setupTable(ARRulesViewer.this._state.getTableModel(), false);
                    }
                    ARRulesViewer.this.enableControls(true);
                    ARRulesViewer.this._labelFormat.setMaximumFractionDigits(ARRulesViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    ARRulesViewer.this._labelFormat.setMinimumFractionDigits(ARRulesViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    ARRulesViewer.this._labelFormat.setMinimumIntegerDigits(1);
                    if (ARRulesViewer.this._jRulesNiceTable.getRowCount() > 0 && ARRulesViewer.this._jRulesNiceTable.getModel() instanceof ARRulesViewerTableModel) {
                        ARRulesViewer.this._jRulesNiceTable.setSelectedRowsInModel(new int[]{0});
                    }
                    ARRulesViewer.this.setLoaded(true);
                } else {
                    if (ARRulesViewer.this._state.getTableModel() != null) {
                        ARRulesViewer.this._state.clearRows();
                        ARRulesViewer.this.loadEmptyRulesTable(RuleQueryMessages.ERROR);
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), (String)ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ARRulesViewer.this.setLoading(false);
            }
        }
    }

    private static enum RuleQueryMessages {
        ERROR,
        LOADING,
        NO_RESULTS_RETURNED,
        NO_RULES_IN_MODEL;

    }
}

