/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.JLabelTableCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARItemTableModel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesFilterSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesMainPanel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerState;
import oracle.dmt.dataminer.mviewer.arrules.AddItemFilterDialog;
import oracle.dmt.dataminer.server.model.ARRulesFilterSetting;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.JLabelListCellRenderer;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class ARRulesFilterPanel
extends JPanel {
    private static Icon _icon;
    private static Icon _collapseIcon;
    private static Icon _expandIcon;
    private boolean _loaded;
    private ARRulesMainPanel _mainPanel;
    private ARRulesFilterSetting _filterSetting;
    private Context _context;
    private ARItemTableModel _filterItemTableModel;
    private JLabelListCellRenderer _comboRenderer = new JLabelListCellRenderer();
    private ARItemTableModel.NAME_DISPLAY _nameDisplay;
    private boolean _filterExpanded = false;
    private static final String SORT_BY_LIFT;
    private static final String SORT_BY_CONFIDENCE;
    private static final String SORT_BY_SUPPORT;
    private static final String SORT_BY_ITEM;
    private static final String[] RULES_SORT_COMBO_VALUES;
    private static final String ORDER_BY_DESCENDING;
    private static final String ORDER_BY_ASCENDING;
    private static final String[] SORT_ORDER_COMBO_VALUES;
    private static Icon _bothIcon;
    private static Icon _associationIcon;
    private static Icon _conditionIcon;
    private GenericTable _jItemFilterTable = new ARItemSetsGenericTable();
    private JButton _removeItemBtn;
    private JButton _addItemBtn;
    private JButton _bothItemBtn;
    private JButton _associationItemBtn;
    private JButton _conditionItemBtn;
    private static Preferences _p;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private ARRulesFilterSettings _arRulesFilterSettings = ARRulesFilterSettings.getInstance((PropertyStorage)_p);
    private JButton _jApplyFilterButton;
    private JCheckBox _jChkBoxUseFilter;
    private JButton _jExpandButton;
    private JLabel _jFetchSizeLabel;
    private JSpinner _jFetchSizeValue;
    private JPanel _jFilterControlsPanel;
    private ComponentWithTitlebar<JComponent> _jItemFilterComponent;
    private JLabel _jMaximumItems;
    private JSpinner _jMaximumItemsValue;
    private JLabel _jMinimumConfidence;
    private JSpinner _jMinimumConfidenceValue;
    private JLabel _jMinimumItems;
    private JSpinner _jMinimumItemsValue;
    private JLabel _jMinimumLift;
    private JSpinner _jMinimumLiftValue;
    private JLabel _jMinimumSupport;
    private JSpinner _jMinimumSupportValue;
    private JLabel _jSortByLabel1;
    private JComboBox _jSortCombo1;
    private JComboBox _jSortOrderCombo1;

    public ARRulesFilterPanel(ARRulesMainPanel aRRulesMainPanel, Context context) {
        try {
            this._mainPanel = aRRulesMainPanel;
            this._context = context;
            this.initComponents();
            this.initRes();
            this.initUI();
            this.initializeUIState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this._jSortByLabel1 = new JLabel();
        this._jSortCombo1 = new JComboBox();
        this._jSortOrderCombo1 = new JComboBox();
        this._jFilterControlsPanel = new JPanel();
        this._jMinimumLift = new JLabel();
        this._jMinimumLiftValue = new JSpinner();
        this._jMinimumSupport = new JLabel();
        this._jMinimumSupportValue = new JSpinner();
        this._jMinimumConfidence = new JLabel();
        this._jMinimumConfidenceValue = new JSpinner();
        this._jMaximumItems = new JLabel();
        this._jMaximumItemsValue = new JSpinner();
        this._jMinimumItems = new JLabel();
        this._jMinimumItemsValue = new JSpinner();
        this._jChkBoxUseFilter = new JCheckBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSizeValue = new JSpinner();
        this._jApplyFilterButton = new JButton();
        this._jExpandButton = new JButton();
        this._jItemFilterComponent = new ComponentWithTitlebar();
        this._jSortByLabel1.setText("Sort by:");
        this._jFilterControlsPanel.setBorder(BorderFactory.createTitledBorder("Filter"));
        this._jMinimumLift.setText("Minimum Lift (%):");
        this._jMinimumSupport.setText("Minimum Support (%):");
        this._jMinimumConfidence.setText("Minimum Confidence (%):");
        this._jMaximumItems.setText("Maximum Items Per Rule:");
        this._jMinimumItems.setText("Miniimum Items Per Rule:");
        GroupLayout groupLayout = new GroupLayout(this._jFilterControlsPanel);
        this._jFilterControlsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jMinimumLift, -2, 139, -2).addComponent(this._jMinimumConfidence, -1, 182, Short.MAX_VALUE).addComponent(this._jMinimumSupport, -1, 182, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jMinimumConfidenceValue).addComponent(this._jMinimumSupportValue).addComponent(this._jMinimumLiftValue, -1, 60, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addComponent(this._jMaximumItems, -1, 182, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jMaximumItemsValue, -1, 60, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this._jMinimumItems, -2, 182, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jMinimumItemsValue, -1, 60, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this._jMaximumItems, this._jMinimumConfidence, this._jMinimumItems, this._jMinimumLift, this._jMinimumSupport);
        groupLayout.linkSize(0, this._jMaximumItemsValue, this._jMinimumConfidenceValue, this._jMinimumItemsValue, this._jMinimumLiftValue, this._jMinimumSupportValue);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jMinimumLift).addGroup(groupLayout.createSequentialGroup().addComponent(this._jMinimumLiftValue, -2, -1, -2).addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMinimumSupportValue, -2, -1, -2).addComponent(this._jMinimumSupport)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMinimumConfidenceValue, -2, -1, -2).addComponent(this._jMinimumConfidence)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMaximumItemsValue, -2, -1, -2).addComponent(this._jMaximumItems)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMinimumItems).addComponent(this._jMinimumItemsValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this._jChkBoxUseFilter.setText("Use filter");
        this._jChkBoxUseFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jChkBoxUseFilter.setMargin(new Insets(0, 0, 0, 0));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this._jExpandButton.setText("More");
        this._jExpandButton.setMaximumSize(new Dimension(87, 23));
        this._jExpandButton.setMinimumSize(new Dimension(87, 23));
        this._jExpandButton.setPreferredSize(new Dimension(87, 23));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jFetchSizeLabel, -1, -1, Short.MAX_VALUE).addComponent(this._jSortByLabel1, -1, 101, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jSortCombo1, -2, 117, -2).addComponent(this._jFetchSizeValue, -2, 117, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSortOrderCombo1, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 390, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jExpandButton, -2, 119, -2).addComponent(this._jApplyFilterButton, -2, 119, -2))).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jChkBoxUseFilter, -2, 242, -2).addComponent(this._jFilterControlsPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._jItemFilterComponent, -1, 539, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(40, 40, 40).addComponent(this._jExpandButton, -2, -1, -2)).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this._jApplyFilterButton, -2, -1, -2)).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jSortByLabel1).addComponent(this._jSortOrderCombo1, -2, -1, -2).addComponent(this._jSortCombo1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFetchSizeLabel, -2, 14, -2).addComponent(this._jFetchSizeValue, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this._jChkBoxUseFilter, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFilterControlsPanel, -1, -1, Short.MAX_VALUE)).addComponent((Component)this._jItemFilterComponent, -1, 199, Short.MAX_VALUE)).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)ARRulesLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(this.getIcon());
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSizeValue, (String)ARRulesLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(ARRulesLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSizeValue.setToolTipText(ARRulesLrb.get("FETCH_SIZE_ADA") + "\n" + ARRulesLrb.get("FETCH_SIZE_RANGE"));
        ResourceUtils.resLabel((JLabel)this._jMinimumLift, (Component)this._jMinimumLiftValue, (String)ARRulesLrb.get("MINIMUM_LIFT"));
        this._jMinimumLift.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MINIMUM_LIFT"));
        this._jMinimumLift.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MINIMUM_LIFT_ADA"));
        this._jMinimumLiftValue.setToolTipText(ARRulesLrb.get("MINIMUM_LIFT_ADA"));
        ResourceUtils.resLabel((JLabel)this._jMinimumConfidence, (Component)this._jMinimumConfidenceValue, (String)ARRulesLrb.get("MINIMUM_CONFIDENCE"));
        this._jMinimumConfidence.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MINIMUM_CONFIDENCE"));
        this._jMinimumConfidence.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MINIMUM_CONFIDENCE_ADA"));
        this._jMinimumConfidenceValue.setToolTipText(ARRulesLrb.get("MINIMUM_CONFIDENCE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jMinimumSupport, (Component)this._jMinimumSupportValue, (String)ARRulesLrb.get("MINIMUM_SUPPORT"));
        this._jMinimumSupport.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MINIMUM_SUPPORT"));
        this._jMinimumSupport.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MINIMUM_SUPPORT_ADA"));
        this._jMinimumSupportValue.setToolTipText(ARRulesLrb.get("MINIMUM_SUPPORT_ADA"));
        ResourceUtils.resLabel((JLabel)this._jMaximumItems, (Component)this._jMaximumItemsValue, (String)ARRulesLrb.get("MAXIMUM_ITEMS_RULE"));
        this._jMaximumItems.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MAXIMUM_ITEMS_RULE"));
        this._jMaximumItems.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MAXIMUM_ITEMS_RULE_ADA"));
        this._jMaximumItemsValue.setToolTipText(ARRulesLrb.get("MAXIMUM_ITEMS_RULE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jMinimumItems, (Component)this._jMinimumItemsValue, (String)ARRulesLrb.get("MINIMUM_ITEMS_RULE"));
        this._jMinimumItems.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MINIMUM_ITEMS_RULE"));
        this._jMinimumItems.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MINIMUM_ITEMS_RULE_ADA"));
        this._jMinimumItemsValue.setToolTipText(ARRulesLrb.get("MINIMUM_ITEMS_RULE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jSortByLabel1, (Component)this._jSortCombo1, (String)ARRulesLrb.get("SORT_BY"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleName(ARRulesLrb.get("SORT_BY"));
        this._jSortByLabel1.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("SORT_BY_ADA"));
        this._jSortCombo1.setModel(new DefaultComboBoxModel<String>(RULES_SORT_COMBO_VALUES));
        this._jSortCombo1.setSelectedItem(SORT_BY_LIFT);
        this._jSortCombo1.setToolTipText(ARRulesLrb.get("SORT_BY_ADA"));
        this._jSortOrderCombo1.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ORDER"));
        this._jSortOrderCombo1.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ORDER_ADA"));
        this._jSortOrderCombo1.setModel(new DefaultComboBoxModel<String>(SORT_ORDER_COMBO_VALUES));
        this._jSortOrderCombo1.setSelectedItem(ORDER_BY_DESCENDING);
        this._jSortOrderCombo1.setToolTipText(ARRulesLrb.get("ORDER_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("MORE"));
        this._jExpandButton.setIcon(this.getExpandIcon());
        this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MORE"));
        this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MORE_ADA"));
        this._jExpandButton.setHorizontalTextPosition(10);
        this._jExpandButton.setHorizontalTextPosition(10);
        this._jFetchSizeValue.setModel(new SpinnerNumberModel(this._modelViewerPrefenceSettings.getFetchSizeARModel(), 1, Integer.MAX_VALUE, 100));
        this._jMaximumItemsValue.setModel(new SpinnerNumberModel(this._arRulesFilterSettings.getMaximumItems(), 1, Integer.MAX_VALUE, 1));
        this._jMinimumItemsValue.setModel(new SpinnerNumberModel(this._arRulesFilterSettings.getMinimumItems(), 1, Integer.MAX_VALUE, 1));
        this._jMinimumConfidenceValue.setModel(new SpinnerNumberModel(this._arRulesFilterSettings.getMinimumConfidence(), 0.0, 100.0, 1.0));
        this._jMinimumConfidenceValue.setEditor(new JSpinner.NumberEditor(this._jMinimumConfidenceValue, "#,##0.######;(#)"));
        this._jMinimumLiftValue.setModel(new SpinnerNumberModel((Number)this._arRulesFilterSettings.getMinimumLift(), Double.valueOf(0.0), null, (Number)1.0));
        this._jMinimumLiftValue.setEditor(new JSpinner.NumberEditor(this._jMinimumLiftValue, "#,##0.######;(#)"));
        this._jMinimumSupportValue.setModel(new SpinnerNumberModel(this._arRulesFilterSettings.getMinimumSupport(), 0.0, 100.0, 1.0));
        this._jMinimumSupportValue.setEditor(new JSpinner.NumberEditor(this._jMinimumSupportValue, "#,##0.######;(#)"));
        ResourceUtils.resButton((AbstractButton)this._jChkBoxUseFilter, (String)ARRulesLrb.get("FILTER_USE_FILTER"));
        this._jChkBoxUseFilter.getAccessibleContext().setAccessibleName("FILTER_USE_FILTER");
        this._jChkBoxUseFilter.getAccessibleContext().setAccessibleDescription("FILTER_USE_FILTER_ADA");
        TitledBorder titledBorder = (TitledBorder)this._jFilterControlsPanel.getBorder();
        titledBorder.setTitle(ARRulesLrb.get("FILTER_BORDER_TITLE"));
        this._jFetchSizeValue.setVisible(true);
        this._jFetchSizeLabel.setVisible(true);
    }

    public void initUI() {
        if (_bothIcon == null) {
            _bothIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("BOTH_ITEM_ICON"));
            _associationIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("ASSOCIATION_ITEM_ICON"));
            _conditionIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("CONDITION_ITEM_ICON"));
        }
        ToolTipManager.sharedInstance().registerComponent((JComponent)this._comboRenderer);
        this._filterItemTableModel = new ARItemTableModel(false);
        this._jItemFilterTable.setModel((TableModel)((Object)this._filterItemTableModel));
        JScrollPane jScrollPane = new JScrollPane((Component)this._jItemFilterTable);
        this._jItemFilterComponent.setComponent((JComponent)jScrollPane);
        this._jItemFilterComponent.setLabel(new JLabel(ARRulesLrb.get("ITEM_FILTER_LBL")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        this._jItemFilterComponent.setControlBar(controlBar);
        this.setupItemsTable();
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARRulesFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        this._jExpandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARRulesFilterPanel.this._jExpandButton_actionPerformed(actionEvent);
            }
        });
        this._jChkBoxUseFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ARRulesFilterPanel.this._jChkBoxUseFilter_actionPerformed(actionEvent);
            }
        });
        this.enableAllControls(true);
        this.showExtraFilterControls(false);
        this.setupComboAttributeNames();
        this.enableAdvFilterControls(false);
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
    }

    private void _jChkBoxUseFilter_actionPerformed(ActionEvent actionEvent) {
        boolean bl = this._jChkBoxUseFilter.isSelected();
        this.enableAdvFilterControls(bl);
        this._filterSetting.setUseFilterSpecification(bl);
    }

    private void enableAdvFilterControls(boolean bl) {
        this._jMaximumItems.setEnabled(bl);
        this._jMaximumItemsValue.setEnabled(bl);
        this._jMinimumItems.setEnabled(bl);
        this._jMinimumItemsValue.setEnabled(bl);
        this._jMinimumConfidence.setEnabled(bl);
        this._jMinimumConfidenceValue.setEnabled(bl);
        this._jMinimumLift.setEnabled(bl);
        this._jMinimumLiftValue.setEnabled(bl);
        this._jMinimumSupport.setEnabled(bl);
        this._jMinimumSupportValue.setEnabled(bl);
        this._jMinimumConfidence.setEnabled(bl);
        this._jMinimumConfidence.setEnabled(bl);
        this._jMinimumConfidence.setEnabled(bl);
        this._addItemBtn.setEnabled(bl);
        this.enableItemFilterControls();
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._addItemBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addItemBtn.setToolTipText(ARRulesLrb.get("ADD_ITEM_ICON_ADA"));
        this._addItemBtn.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ADD_ITEM_ICON_NAME"));
        this._addItemBtn.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ADD_ITEM_ICON_ADA"));
        this._addItemBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddItemFilterDialog addItemFilterDialog = new AddItemFilterDialog();
                addItemFilterDialog.invoke(ARRulesFilterPanel.this._context, ARRulesFilterPanel.this._filterItemTableModel, ARRulesFilterPanel.this._jItemFilterTable, ((ARRulesFilterPanel)ARRulesFilterPanel.this)._mainPanel._rulesViewerPanel._state);
            }
        });
        controlBar.add((Component)this._addItemBtn);
        this._removeItemBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeItemBtn.setToolTipText(ARRulesLrb.get("REMOVE_ITEM_ICON_ADA"));
        this._removeItemBtn.getAccessibleContext().setAccessibleName(ARRulesLrb.get("REMOVE_ITEM_ICON_NAME"));
        this._removeItemBtn.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("REMOVE_ITEM_ICON_ADA"));
        this._removeItemBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ARRulesFilterPanel.this._jItemFilterTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    ARItemTableModel aRItemTableModel = (ARItemTableModel)((Object)ARRulesFilterPanel.this._jItemFilterTable.getModel());
                    aRItemTableModel.removeSelectedRows(nArray);
                    int n = nArray[0] - 1 >= 0 ? nArray[0] - 1 : 0;
                    ARRulesFilterPanel.this.setTableSelection(n);
                }
            }
        });
        controlBar.add((Component)this._removeItemBtn);
        this._bothItemBtn = new JButton(_bothIcon);
        this._bothItemBtn.setToolTipText(ARRulesLrb.get("BOTH_ITEM_ICON_ADA"));
        this._bothItemBtn.getAccessibleContext().setAccessibleName(ARRulesLrb.get("BOTH_ITEM_ICON_NAME"));
        this._bothItemBtn.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("BOTH_ITEM_ICON_ADA"));
        this._bothItemBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ARRulesFilterPanel.this._jItemFilterTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    ARItemTableModel aRItemTableModel = (ARItemTableModel)((Object)ARRulesFilterPanel.this._jItemFilterTable.getModel());
                    aRItemTableModel.setFilterActionForSelected(0, nArray);
                    ARRulesFilterPanel.this.setTableSelection(nArray[0]);
                }
            }
        });
        controlBar.add((Component)this._bothItemBtn);
        this._associationItemBtn = new JButton(_associationIcon);
        this._associationItemBtn.setToolTipText(ARRulesLrb.get("ASSOCIATION_ITEM_ICON_ADA"));
        this._associationItemBtn.getAccessibleContext().setAccessibleName(ARRulesLrb.get("ASSOCIATION_ITEM_ICON_NAME"));
        this._associationItemBtn.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("ASSOCIATION_ITEM_ICON_ADA"));
        this._associationItemBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ARRulesFilterPanel.this._jItemFilterTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    ARItemTableModel aRItemTableModel = (ARItemTableModel)((Object)ARRulesFilterPanel.this._jItemFilterTable.getModel());
                    aRItemTableModel.setFilterActionForSelected(2, nArray);
                    ARRulesFilterPanel.this.setTableSelection(nArray[0]);
                }
            }
        });
        controlBar.add((Component)this._associationItemBtn);
        this._conditionItemBtn = new JButton(_conditionIcon);
        this._conditionItemBtn.setToolTipText(ARRulesLrb.get("CONDITION_ITEM_ICON_ADA"));
        this._conditionItemBtn.getAccessibleContext().setAccessibleName(ARRulesLrb.get("CONDITION_ITEM_ICON_NAME"));
        this._conditionItemBtn.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("CONDITION_ITEM_ICON_ADA"));
        this._conditionItemBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ARRulesFilterPanel.this._jItemFilterTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    ARItemTableModel aRItemTableModel = (ARItemTableModel)((Object)ARRulesFilterPanel.this._jItemFilterTable.getModel());
                    aRItemTableModel.setFilterActionForSelected(1, nArray);
                    ARRulesFilterPanel.this.setTableSelection(nArray[0]);
                }
            }
        });
        controlBar.add((Component)this._conditionItemBtn);
        ListSelectionModel listSelectionModel = this._jItemFilterTable.getSelectionModel();
        this._addItemBtn.setEnabled(false);
        this._removeItemBtn.setEnabled(false);
        this._conditionItemBtn.setEnabled(false);
        this._associationItemBtn.setEnabled(false);
        this._bothItemBtn.setEnabled(false);
    }

    private void setTableSelection(int n) {
        if (this._jItemFilterTable.getRowCount() > 0) {
            this._jItemFilterTable.setRowSelectionInterval(n, n);
            this._jItemFilterTable.scrollToSelection();
        }
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("QUERY_ICON"));
        }
        return _icon;
    }

    public Icon getExpandIcon() {
        if (_expandIcon == null) {
            _expandIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("EXPAND_ICON"));
        }
        return _expandIcon;
    }

    public Icon getCollapseIcon() {
        if (_collapseIcon == null) {
            _collapseIcon = UIResourceHelper.getImageIcon(this.getClass(), ARRulesLrb.get("COLLAPSE_ICON"));
        }
        return _collapseIcon;
    }

    private void initializeUIState() throws Exception {
        this._filterSetting = new ARRulesFilterSetting();
        this.loadStateAttributes();
    }

    public void setupUI(ARRulesFilterSetting aRRulesFilterSetting) {
        this._filterSetting = aRRulesFilterSetting;
        this.adjustColumnsInItemsTable();
        this.loadStateAttributes();
        this.enableAllControls(true);
        this.setLoaded(true);
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    private void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    private void adjustColumnsInItemsTable() {
        ARRulesViewerState aRRulesViewerState = this._mainPanel.getARRulesViewerState();
        if (aRRulesViewerState.isOnlyOneConstantValueInModelItems()) {
            this._jItemFilterTable.setHiddenColumns(new int[]{1});
        } else {
            this._jItemFilterTable.setHiddenColumns(new int[0]);
        }
        this._nameDisplay = aRRulesViewerState.isOnlyOneColumnNameInModelItems() && !aRRulesViewerState.isNoSubNameColumnsInModelItems() ? ARItemTableModel.NAME_DISPLAY.SUB_NAME_ONLY : (aRRulesViewerState.isNoSubNameColumnsInModelItems() ? ARItemTableModel.NAME_DISPLAY.NAME_ONLY : ARItemTableModel.NAME_DISPLAY.NAME_SUBNAME);
        ((ARItemTableModel)((Object)this._jItemFilterTable.getModel())).setNameDisplay(this._nameDisplay);
    }

    private void setupItemsTable() {
        this._jItemFilterTable.setSorted(true);
        this._jItemFilterTable.setSortColumn(0, true);
        this._jItemFilterTable.setAutoResizeMode(4);
        TableColumnModel tableColumnModel = this._jItemFilterTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(100);
        tableColumnModel.getColumn(2).setPreferredWidth(100);
        JLabel jLabel = new JLabel(ARRulesLrb.get("FILTER_BOTH"), _bothIcon, 10);
        JLabel jLabel2 = new JLabel(ARRulesLrb.get("FILTER_ASSOCIATION"), _associationIcon, 10);
        JLabel jLabel3 = new JLabel(ARRulesLrb.get("FILTER_CONDITION"), _conditionIcon, 10);
        Object[] objectArray = new JLabel[]{jLabel, jLabel3, jLabel2};
        JComboBox jComboBox = new JComboBox();
        jComboBox.setModel(new DefaultListComboBoxModel(objectArray));
        jComboBox.setRenderer(this._comboRenderer);
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.setCellRenderer(new JLabelTableCellRenderer());
        this._jItemFilterTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler());
    }

    private void loadStateAttributes() {
        this.setNumber(this._jFetchSizeValue, this._filterSetting.getFetchSize());
        this.setNumber(this._jMaximumItemsValue, this._filterSetting.getMaxRuleLength());
        this.setNumber(this._jMinimumItemsValue, this._filterSetting.getMinRuleLength());
        this.setNumber(this._jMinimumConfidenceValue, this._filterSetting.getMinConfidence() * 100.0);
        this.setNumber(this._jMinimumLiftValue, this._filterSetting.getMinLift());
        this.setNumber(this._jMinimumSupportValue, this._filterSetting.getMinSupport() * 100.0);
        this._jSortCombo1.setSelectedItem(this.getSortState(0));
        this._jSortOrderCombo1.setSelectedItem(this.getSortOrderState(0));
    }

    private boolean getSortEnabled(int n) {
        SortSpec sortSpec = this._filterSetting.getSortSpecification().get(n);
        return sortSpec.isUseIt();
    }

    private String getSortState(int n) {
        String string = "";
        SortSpec sortSpec = this._filterSetting.getSortSpecification().get(n);
        if (sortSpec.getAttributeName() == "NUMBER_OF_ITEMS") {
            string = SORT_BY_ITEM;
        } else if (sortSpec.getAttributeName() == "RULE_CONFIDENCE") {
            string = SORT_BY_CONFIDENCE;
        } else if (sortSpec.getAttributeName() == "RULE_LIFT") {
            string = SORT_BY_LIFT;
        } else if (sortSpec.getAttributeName() == "RULE_SUPPORT") {
            string = SORT_BY_SUPPORT;
        } else {
            assert (false) : "Unrecognized sorting attribute selection";
            string = "Unrecognized";
        }
        return string;
    }

    private String getSortOrderState(int n) {
        String string = "";
        SortSpec sortSpec = this._filterSetting.getSortSpecification().get(n);
        if (sortSpec.getSortDirection() == SortSpec.SORT_DECENDING) {
            string = ORDER_BY_DESCENDING;
        } else if (sortSpec.getSortDirection() == SortSpec.SORT_ASCENDING) {
            string = ORDER_BY_ASCENDING;
        } else {
            assert (false) : "Unrecognized sort order selection";
            string = "Unrecognized";
        }
        return string;
    }

    private void setSortState(int n, boolean bl, String string, String string2) throws Exception {
        SortSpec sortSpec = this._filterSetting.getSortSpecification().get(n);
        sortSpec.setUseIt(bl);
        if (string == SORT_BY_LIFT) {
            sortSpec.setAttributeName("RULE_LIFT");
        } else if (string == SORT_BY_CONFIDENCE) {
            sortSpec.setAttributeName("RULE_CONFIDENCE");
        } else if (string == SORT_BY_SUPPORT) {
            sortSpec.setAttributeName("RULE_SUPPORT");
        } else if (string == SORT_BY_ITEM) {
            sortSpec.setAttributeName("NUMBER_OF_ITEMS");
        } else {
            throw new Exception("Unrecognized sort value selection: " + string);
        }
        if (string2 == ORDER_BY_DESCENDING) {
            sortSpec.setSortDirection(SortSpec.SORT_DECENDING);
        } else if (string2 == ORDER_BY_ASCENDING) {
            sortSpec.setSortDirection(SortSpec.SORT_ASCENDING);
        } else {
            throw new Exception("Unrecognized sort order selection: " + string2);
        }
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this._jApplyFilterButton.setEnabled(false);
            this._arRulesFilterSettings.setMaximumItems(this.getNumber(this._jMaximumItemsValue).intValue());
            this._arRulesFilterSettings.setMinimumItems(this.getNumber(this._jMinimumItemsValue).intValue());
            this._arRulesFilterSettings.setMinimumConfidence(this.getNumber(this._jMinimumConfidenceValue).doubleValue() / 100.0);
            this._arRulesFilterSettings.setMinimumLift(this.getNumber(this._jMinimumLiftValue).doubleValue());
            this._arRulesFilterSettings.setMinimumSupport(this.getNumber(this._jMinimumSupportValue).doubleValue() / 100.0);
            ValidateUpdateState validateUpdateState = new ValidateUpdateState();
            validateUpdateState.start();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ARRulesLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ARRulesLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
        }
    }

    protected void _jExpandButton_actionPerformed(ActionEvent actionEvent) {
        if (this._filterExpanded) {
            this._filterExpanded = false;
            this.showExtraFilterControls(this._filterExpanded);
            ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("MORE"));
            this._jExpandButton.setIcon(this.getExpandIcon());
            this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MORE"));
            this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MORE_ADA"));
            this._jExpandButton.setHorizontalTextPosition(10);
        } else {
            this._filterExpanded = true;
            this.showExtraFilterControls(this._filterExpanded);
            ResourceUtils.resButton((AbstractButton)this._jExpandButton, (String)ARRulesLrb.get("HIDE"));
            this._jExpandButton.setIcon(this.getCollapseIcon());
            this._jExpandButton.getAccessibleContext().setAccessibleName(ARRulesLrb.get("HIDE"));
            this._jExpandButton.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("HIDE_ADA"));
            this._jExpandButton.setHorizontalTextPosition(10);
        }
    }

    private void showExtraFilterControls(boolean bl) {
        this._jFilterControlsPanel.setVisible(bl);
        this._jChkBoxUseFilter.setVisible(bl);
        this._jItemFilterComponent.setVisible(bl);
    }

    private void enableAllControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSizeValue.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jItemFilterComponent.setEnabled(bl);
        if (this._jChkBoxUseFilter.isSelected()) {
            this.enableAdvFilterControls(bl);
        }
        this._jSortByLabel1.setEnabled(bl);
        this._jSortCombo1.setEnabled(bl);
        this._jSortOrderCombo1.setEnabled(bl);
        this._jChkBoxUseFilter.setEnabled(bl);
        this._jFetchSizeValue.setEnabled(bl);
    }

    private void enableItemFilterControls() {
        if (this._jItemFilterTable.getSelectedRowCount() == 0) {
            this._removeItemBtn.setEnabled(false);
            this._conditionItemBtn.setEnabled(false);
            this._associationItemBtn.setEnabled(false);
            this._bothItemBtn.setEnabled(false);
        } else if (this._jChkBoxUseFilter.isSelected()) {
            this._removeItemBtn.setEnabled(true);
            this._conditionItemBtn.setEnabled(true);
            this._associationItemBtn.setEnabled(true);
            this._bothItemBtn.setEnabled(true);
            this._jItemFilterTable.setEnabled(true);
        } else {
            this._removeItemBtn.setEnabled(false);
            this._conditionItemBtn.setEnabled(false);
            this._associationItemBtn.setEnabled(false);
            this._bothItemBtn.setEnabled(false);
            this._jItemFilterTable.setEnabled(false);
        }
    }

    private void setupComboAttributeNames() {
        this.loadComboValues(RULES_SORT_COMBO_VALUES);
    }

    private void loadComboValues(String[] stringArray) {
        this._jSortCombo1.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    public void setLoading(boolean bl) {
        this.enableAllControls(!bl);
    }

    private String formatValue(Object object) {
        String string = "";
        if (object == null) {
            string = null;
        } else if (object != null) {
            string = object instanceof Double ? NumericFormat.format((Double)object, true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel()) + "" : (object instanceof JLabel ? ((JLabel)object).getText() : object.toString());
        }
        return string;
    }

    static {
        SORT_BY_LIFT = ARRulesLrb.get("SORT_BY_LIFT");
        SORT_BY_CONFIDENCE = ARRulesLrb.get("SORT_BY_CONFIDENCE");
        SORT_BY_SUPPORT = ARRulesLrb.get("SORT_BY_SUPPORT");
        SORT_BY_ITEM = ARRulesLrb.get("RULE_LENGTH_COLUMN");
        RULES_SORT_COMBO_VALUES = new String[]{SORT_BY_LIFT, SORT_BY_CONFIDENCE, SORT_BY_SUPPORT, SORT_BY_ITEM};
        ORDER_BY_DESCENDING = ARRulesLrb.get("DESCENDING");
        ORDER_BY_ASCENDING = ARRulesLrb.get("ASCENDING");
        SORT_ORDER_COMBO_VALUES = new String[]{ORDER_BY_DESCENDING, ORDER_BY_ASCENDING};
        _p = Preferences.getPreferences();
    }

    class ARItemSetsGenericTable
    extends GenericTable {
        public ARItemSetsGenericTable() {
            this.setShowHorizontalLines(true);
            this.setShowVerticalLines(true);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            Object object = this.getValueAt(n, n2);
            String string = "";
            string = ARRulesFilterPanel.this.formatValue(object);
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = ARRulesFilterPanel.this.formatValue(object);
            return string;
        }
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        SelectedItemSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                ARRulesFilterPanel.this._removeItemBtn.setEnabled(false);
                ARRulesFilterPanel.this._conditionItemBtn.setEnabled(false);
                ARRulesFilterPanel.this._associationItemBtn.setEnabled(false);
                ARRulesFilterPanel.this._bothItemBtn.setEnabled(false);
            } else if (ARRulesFilterPanel.this._jChkBoxUseFilter.isSelected()) {
                ARRulesFilterPanel.this._removeItemBtn.setEnabled(true);
                ARRulesFilterPanel.this._conditionItemBtn.setEnabled(true);
                ARRulesFilterPanel.this._associationItemBtn.setEnabled(true);
                ARRulesFilterPanel.this._bothItemBtn.setEnabled(true);
            } else {
                ARRulesFilterPanel.this._removeItemBtn.setEnabled(false);
                ARRulesFilterPanel.this._conditionItemBtn.setEnabled(false);
                ARRulesFilterPanel.this._associationItemBtn.setEnabled(false);
                ARRulesFilterPanel.this._bothItemBtn.setEnabled(false);
            }
        }
    }

    class NumberRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object object) {
            String string = "";
            string = ARRulesFilterPanel.this.formatValue(object);
            super.setValue(string);
        }
    }

    class ValidateUpdateState
    extends SwingWorker {
        private Exception _exception;
        private Boolean _validated;

        ValidateUpdateState() {
        }

        public boolean getValidation() {
            return this._validated;
        }

        public Exception getException() {
            return this._exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            Number number;
            block5: {
                this._validated = false;
                number = ARRulesFilterPanel.this.getNumber(ARRulesFilterPanel.this._jFetchSizeValue);
                if (null != number && number.longValue() > 0L) break block5;
                this._validated = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ARRulesLrb.get("FETCH_SIZE_RANGE_ERROR"), (String)ARRulesLrb.get("FILTER_ERROR_TITLE"), null);
                Boolean bl = this._validated;
                return bl;
            }
            try {
                this._validated = true;
                ARRulesFilterPanel.this._filterSetting.setFetchSize(number.intValue());
                ARRulesFilterPanel.this._filterSetting.setMaxRuleLength(ARRulesFilterPanel.this.getNumber(ARRulesFilterPanel.this._jMaximumItemsValue).intValue());
                ARRulesFilterPanel.this._filterSetting.setMinRuleLength(ARRulesFilterPanel.this.getNumber(ARRulesFilterPanel.this._jMinimumItemsValue).intValue());
                ARRulesFilterPanel.this._filterSetting.setMinConfidence(ARRulesFilterPanel.this.getNumber(ARRulesFilterPanel.this._jMinimumConfidenceValue).doubleValue() / 100.0);
                ARRulesFilterPanel.this._filterSetting.setMinLift(ARRulesFilterPanel.this.getNumber(ARRulesFilterPanel.this._jMinimumLiftValue).doubleValue());
                ARRulesFilterPanel.this._filterSetting.setMinSupport(ARRulesFilterPanel.this.getNumber(ARRulesFilterPanel.this._jMinimumSupportValue).doubleValue() / 100.0);
                ARRulesFilterPanel.this.setSortState(0, true, (String)ARRulesFilterPanel.this._jSortCombo1.getSelectedItem(), (String)ARRulesFilterPanel.this._jSortOrderCombo1.getSelectedItem());
                ARRulesFilterPanel.this._filterSetting.setFilterItems(((ARItemTableModel)((Object)ARRulesFilterPanel.this._jItemFilterTable.getModel())).getDataVector());
            }
            catch (Exception exception) {
                this._exception = exception;
                this._validated = false;
            }
            return this._validated;
        }

        public void finished() {
            if (this._validated.booleanValue()) {
                ARRulesFilterPanel.this._mainPanel.setFilterState(ARRulesFilterPanel.this._filterSetting);
            } else {
                ARRulesFilterPanel.this._jApplyFilterButton.setEnabled(true);
                if (this._exception != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._exception, (String)ARRulesLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ARRulesLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)ARRulesLrb.get("FILTER_PROCESS_FAILURE_MESG"), (String)ARRulesLrb.get("FILTER_PROCESS_FAILURE_TITLE"), null);
                }
            }
        }
    }
}

