/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TimeStampCellRenderer
extends DefaultTableCellRenderer {
    private JLabel timestampLabel = new JLabel();
    private DateFormat df;

    public TimeStampCellRenderer() {
        this((DateFormat)null);
        this.df = DateFormat.getDateTimeInstance(3, 2);
    }

    public TimeStampCellRenderer(DateFormat dateFormat) {
        this.timestampLabel.setOpaque(true);
        this.df = dateFormat;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (!(object instanceof Timestamp) && !(object instanceof Date)) {
            throw new RuntimeException("Table cell value must be of type Timestamp or Date");
        }
        Date date = object instanceof Timestamp ? new Date(((Timestamp)object).getTime()) : (Date)object;
        this.timestampLabel.setText(this.df.format(date));
        if (bl) {
            this.timestampLabel.setForeground(jTable.getSelectionForeground());
            this.timestampLabel.setBackground(jTable.getSelectionBackground());
        } else {
            this.timestampLabel.setForeground(jTable.getForeground());
            this.timestampLabel.setBackground(jTable.getBackground());
        }
        return this.timestampLabel;
    }
}

