/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class TimeEditPanel
extends JPanel {
    private Locale _locale;
    private JSpinner _timeSpinner;
    private JComboBox _timeZoneCombo;
    private Calendar _cal;

    public TimeEditPanel(Locale locale, Calendar calendar) {
        this._locale = locale;
        this._cal = calendar;
        this._init();
    }

    private void _init() {
        this._timeSpinner = new JSpinner(new SpinnerDateModel(this._cal.getTime(), null, null, 11));
        this._updateTimeSpinnerFormat();
        this._timeZoneCombo = new JComboBox<TimeZone>(this._getTimeZoneIDs());
        this._timeZoneCombo.setRenderer(new TimeZoneRenderer());
        this._timeZoneCombo.setBackground(UIManager.getColor("TextArea.background"));
        this._timeZoneCombo.setFont(UIManager.getFont("Label.font"));
        this._timeZoneCombo.setPrototypeDisplayValue("WWWWWWWWWWWWWWW");
        this._timeZoneCombo.setBorder(null);
        this._timeSpinner.setAlignmentX(0.5f);
        this._timeZoneCombo.setAlignmentX(0.5f);
        this.setOpaque(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagLayout.setConstraints(this._timeSpinner, gridBagConstraints);
        gridBagLayout.setConstraints(this._timeZoneCombo, gridBagConstraints);
        this.add(this._timeSpinner);
        this.add(this._timeZoneCombo);
        this.updateTimeDisplay();
        this.updateTimeZoneDisplay();
        TimeChangeListener timeChangeListener = new TimeChangeListener();
        this._timeSpinner.addChangeListener(timeChangeListener);
        this._timeZoneCombo.addItemListener(timeChangeListener);
    }

    public void updateDisplay() {
        this.updateTimeDisplay();
        this.updateTimeZoneDisplay();
    }

    public void updateTimeDisplay() {
        this._timeSpinner.setValue(this._cal.getTime());
        this._updateTimeSpinnerFormat();
    }

    public void updateTimeZoneDisplay() {
        TimeZone timeZone = this._cal.getTimeZone();
        timeZone = this.getNearestTimeZoneMatch(timeZone);
        this._timeZoneCombo.setSelectedItem(timeZone);
    }

    public TimeZone getNearestTimeZoneMatch(TimeZone timeZone) {
        String string = timeZone.getDisplayName(true, 1, this._locale);
        for (int i = 0; i < this._timeZoneCombo.getItemCount(); ++i) {
            TimeZone timeZone2 = (TimeZone)this._timeZoneCombo.getItemAt(i);
            if (!timeZone2.getDisplayName(true, 1, this._locale).equals(string)) continue;
            return timeZone2;
        }
        return null;
    }

    private void _updateTimeSpinnerFormat() {
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this._timeSpinner.getEditor();
        dateEditor.getTextField().setHorizontalAlignment(0);
        DateFormat dateFormat = SimpleDateFormat.getTimeInstance(2, this._locale);
        dateFormat.setTimeZone(this._cal.getTimeZone());
        DateFormatter dateFormatter = new DateFormatter(dateFormat);
        DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(dateFormatter);
        dateEditor.getTextField().setFormatterFactory(defaultFormatterFactory);
    }

    private TimeZone[] _getTimeZoneIDs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<TimeZone> linkedList2 = new LinkedList<TimeZone>();
        for (String string : TimeZone.getAvailableIDs()) {
            try {
                TimeZone timeZone = TimeZone.getTimeZone(string);
                String string2 = timeZone.getDisplayName(true, 1, this._locale);
                if (linkedList.contains(string2)) continue;
                linkedList.add(string2);
                linkedList2.add(timeZone);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return linkedList2.toArray(new TimeZone[0]);
    }

    private class TimeChangeListener
    implements ChangeListener,
    ItemListener {
        private TimeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Date date = (Date)TimeEditPanel.this._timeSpinner.getValue();
            Calendar calendar = (Calendar)TimeEditPanel.this._cal.clone();
            calendar.setTime(date);
            TimeEditPanel.this._cal.set(11, calendar.get(11));
            TimeEditPanel.this._cal.set(12, calendar.get(12));
            TimeEditPanel.this._cal.set(13, calendar.get(13));
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            TimeEditPanel.this._cal.setTimeZone((TimeZone)TimeEditPanel.this._timeZoneCombo.getSelectedItem());
            TimeEditPanel.this.updateTimeDisplay();
        }
    }

    private class TimeZoneRenderer
    extends DefaultListCellRenderer {
        private TimeZoneRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof TimeZone) {
                TimeZone timeZone = (TimeZone)object;
                jLabel.setText(timeZone.getDisplayName(true, 1, TimeEditPanel.this._locale));
            } else if (object instanceof String) {
                jLabel.setText((String)object);
            }
            jLabel.setHorizontalAlignment(n == -1 ? 0 : 10);
            jLabel.setAlignmentX(n == -1 ? 0.5f : 0.0f);
            return jLabel;
        }
    }
}

