/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.jdbc.OraclePreparedStatement;

public class SchemaChooserTableModel
extends GenericBaseTableModel {
    private Vector<String> _data = new Vector(100);
    private static final int COLUMN_COUNT = 1;
    public static final int SCHEMA_NAME = 0;
    private String[] _columnNames = new String[]{ControlsLrb.get("SCHEMA_CHOOSER_SCHEMA_NAME")};

    public SchemaChooserTableModel() {
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(1);
    }

    public SchemaChooserTableModel(Vector<String> vector) {
        assert (vector != null) : "Can not pass  null data in to the constructor";
        this.setColumnIdentifiers(this._columnNames);
        this._data = vector;
        this.setRowCount(vector.size());
        this.setColumnCount(1);
    }

    public String getRow(int n) {
        return this._data.get(n);
    }

    public Vector<String> getDataVector() {
        return this._data;
    }

    public void removeDuplicateRows(Vector<String> vector) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : vector) {
            hashMap.put(string, string);
        }
        Iterator<String> iterator = this._data.iterator();
        while (iterator.hasNext()) {
            String string;
            string = iterator.next();
            String string2 = (String)hashMap.get(string);
            if (string2 == null) continue;
            iterator.remove();
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    private void clear() {
        this._data.clear();
    }

    private void addDataItem(String string) {
        this._data.add(string);
    }

    public void setFailedStatus() {
        String string = ControlsLrb.get("TABLE_CHOOSER_FAILED_TO_LOAD");
        this.clear();
        this.addDataItem(string);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public void setLoadingStatus() {
        String string = ControlsLrb.get("TABLE_CHOOSER_LOADING");
        this.clear();
        this.addDataItem(string);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public void load(Connection connection, String string) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string2 = null;
            string2 = "select SCHEMA FROM (\nselect DISTINCT(OWNER) SCHEMA from all_tables\n where OWNER NOT IN (:owner_schema_param)\nUNION \nselect DISTINCT(OWNER) SCHEMA from all_views\n where OWNER NOT IN (:owner_schema_param))\n ORDER BY SCHEMA";
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string2);
            sQLHelper.opstmt.setStringAtName("owner_schema_param", string);
            sQLHelper.opstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            String string3 = null;
            while (sQLHelper.rs.next()) {
                string3 = sQLHelper.rs.getString("SCHEMA");
                this._data.add(string3);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        this.setRowCount(this._data.size());
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        String string = this._data.get(n);
        String string2 = null;
        switch (n2) {
            case 0: {
                string2 = string;
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing list of schemas";
                break;
            }
        }
        return string2;
    }
}

