/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.GraphPanel;

public class MiniHistogramCellRenderer
extends JComponent
implements TableCellRenderer {
    private static JLabel _emptyDisplay = new JLabel();
    private GraphPanel _panel;
    private static GraphDataModel _loadingGraphDataModel = MiniHistogramCellRenderer.createLoadingStatusModel();
    private GraphModelProvider _graphModelProvider;
    public static Dimension _DEFAULT_PREFFERRED_WIDTH;
    private static Dimension _preferred_width;
    private Integer graphType;

    public MiniHistogramCellRenderer(GraphModelProvider graphModelProvider) {
        this(graphModelProvider, 18);
    }

    public MiniHistogramCellRenderer(GraphModelProvider graphModelProvider, Dimension dimension) {
        this(graphModelProvider);
        _preferred_width = dimension;
    }

    public MiniHistogramCellRenderer(GraphModelProvider graphModelProvider, Dimension dimension, Integer n) {
        this(graphModelProvider, n);
        _preferred_width = dimension;
    }

    public MiniHistogramCellRenderer(GraphModelProvider graphModelProvider, Integer n) {
        this.graphType = n;
        this._graphModelProvider = graphModelProvider;
        this._panel = new GraphPanel(new DefaultGraphDataModel(null, n, null, null, null));
        this.setLayout(new BorderLayout());
        this.add("Center", this._panel);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        GraphDataModel graphDataModel = null;
        graphDataModel = object instanceof GraphDataModel ? (GraphDataModel)object : _loadingGraphDataModel;
        graphDataModel.setStyleSelection(this._graphModelProvider.getStyleSelection());
        this._panel.initGraph(graphDataModel);
        this._panel.updateGraphStyle();
        this._panel.getGraph().getO1Axis().setVisible(false);
        this._panel.getGraph().getX1Axis().setVisible(false);
        this._panel.getGraph().getY1Axis().setVisible(false);
        this._panel.getGraph().getLegendArea().setVisible(false);
        this._panel.getGraph().setAutoLayout(0);
        this._panel.getGraph().doAutoLayout(1);
        if (bl) {
            this._panel.getGraph().setBackground(jTable.getSelectionBackground());
            this._panel.getGraph().setBorder((Border)BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground()));
            this._panel.getGraph().getGraphBackground().setBackground(jTable.getSelectionBackground());
        } else {
            this._panel.getGraph().setBorder((Border)BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground()));
            this._panel.getGraph().setBackground(jTable.getBackground());
            this._panel.getGraph().getGraphBackground().setBackground(jTable.getBackground());
        }
        if (object instanceof GraphDataModel) {
            return this._panel.getGraph();
        }
        return _emptyDisplay;
    }

    @Override
    public Dimension getPreferredSize() {
        return _preferred_width;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        if (dimension != null) {
            _preferred_width = dimension;
        }
    }

    private static GraphDataModel createLoadingStatusModel() {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 18, null, null, null);
        int n = 5;
        int n2 = 1;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray3[i] = "";
            for (int j = 0; j < n; ++j) {
                objectArray[j][i] = j < n / 2 + 1 ? Double.valueOf(100.0 * (((double)j + 1.0) / (double)n)) : Double.valueOf(100.0 * (((double)j - 1.0) / (double)n));
                objectArray2[j] = "";
            }
        }
        defaultGraphDataModel.addColumnLabels(objectArray2);
        defaultGraphDataModel.addRowLabels(objectArray3);
        defaultGraphDataModel.addGraphData(objectArray);
        defaultGraphDataModel.setLegendVisible(false);
        return defaultGraphDataModel;
    }

    static {
        _preferred_width = _DEFAULT_PREFFERRED_WIDTH = new Dimension(120, 25);
    }
}

