/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Container;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public class GraphicalPreferencesPanel
extends DefaultTraversablePanel {
    private JComboBox jComboBoxStyle;
    private JLabel jLabelStyle;
    private JSlider jSliderDeptRadius;
    private String _selectedStyle = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int _radiusDepthValue = 50;

    public GraphicalPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSliderDeptRadius = new JSlider();
        this.jLabelStyle = new JLabel();
        this.jComboBoxStyle = new JComboBox();
        this.jSliderDeptRadius.setMajorTickSpacing(20);
        this.jSliderDeptRadius.setMinorTickSpacing(5);
        this.jSliderDeptRadius.setPaintLabels(true);
        this.jSliderDeptRadius.setPaintTicks(true);
        this.jSliderDeptRadius.setBorder(BorderFactory.createTitledBorder("Depth Radius"));
        this.jSliderDeptRadius.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GraphicalPreferencesPanel.this.jSliderDeptRadiusdepthRadiusStateChanged(changeEvent);
            }
        });
        this.jLabelStyle.setText("Chart Style:");
        this.jComboBoxStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderDeptRadius, -1, 383, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLabelStyle, -2, 118, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxStyle, 0, 261, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jSliderDeptRadius, -2, -1, -2).addGap(56, 56, 56).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelStyle).addComponent(this.jComboBoxStyle, -2, -1, -2)).addContainerGap(171, Short.MAX_VALUE)));
    }

    private void jSliderDeptRadiusdepthRadiusStateChanged(ChangeEvent changeEvent) {
    }

    public void initRes() {
        this.jLabelStyle.setText(ControlsLrb.get("GRAPH_PREF_CHART_STYLE"));
        this.jLabelStyle.setLabelFor(this.jComboBoxStyle);
        this.jSliderDeptRadius.setBorder(BorderFactory.createTitledBorder(ControlsLrb.get("HISTOGRAM_DEPTH_RADIUS")));
        this.setHelpID("data_miner_prefs");
    }

    public void initUI() {
        this.jSliderDeptRadius.setPaintTicks(true);
        this.jSliderDeptRadius.setPaintLabels(true);
        this.jSliderDeptRadius.setMajorTickSpacing(20);
        this.jSliderDeptRadius.setMinorTickSpacing(5);
        this.jSliderDeptRadius.setMinimum(0);
        this.jSliderDeptRadius.setMaximum(100);
        int n = DefaultGraphDataModel.GRAPH_STYLES.size();
        Vector<String> vector = new Vector<String>(n);
        Set<String> set = DefaultGraphDataModel.GRAPH_STYLES.keySet();
        String[] stringArray = set.toArray(new String[n]);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        this.jComboBoxStyle.setModel(new DefaultComboBoxModel(vector));
        this.jComboBoxStyle.setSelectedItem(this._selectedStyle);
    }

    public void onEntry(TraversableContext traversableContext) {
        GraphicalPreferencesSettings graphicalPreferencesSettings = GraphicalPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this._selectedStyle = graphicalPreferencesSettings.getGraphStyle();
        this.jComboBoxStyle.setSelectedItem(this._selectedStyle);
        this._radiusDepthValue = graphicalPreferencesSettings.getRadiusDepthValue();
        this.jSliderDeptRadius.setValue(this._radiusDepthValue);
    }

    public void onExit(TraversableContext traversableContext) {
        GraphicalPreferencesSettings graphicalPreferencesSettings = GraphicalPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this._selectedStyle = (String)this.jComboBoxStyle.getSelectedItem();
        graphicalPreferencesSettings.setGraphStyle(this._selectedStyle);
        this._radiusDepthValue = this.jSliderDeptRadius.getValue();
        graphicalPreferencesSettings.setRadiusDepthValue(this._radiusDepthValue);
    }

    private static GraphicalPreferencesSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return GraphicalPreferencesSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

