/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphExporter;
import oracle.dss.graph.ExceptionalRiser;
import oracle.dss.graph.Graph;
import oracle.dss.graph.Series;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.SeriesOutOfRangeException;

public class GraphPanel
extends JPanel {
    GraphDataModel _dataModel;
    GraphExporter _exporter;
    Graph _graph;
    public static final JTextArea LOADING_GRAPH = new JTextArea(ControlsLrb.get("CHART_LOADING"));

    public GraphPanel(GraphDataModel graphDataModel, GraphExporter graphExporter) {
        this(graphDataModel);
    }

    public GraphPanel(GraphDataModel graphDataModel) {
        this._dataModel = graphDataModel;
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        defaultErrorHandler.setDebugMode(2);
        this._graph = new Graph((ErrorHandler)defaultErrorHandler);
        this._graph.setLocale(Locale.getDefault());
        this.setLayout(new BorderLayout());
        this.add((Component)this._graph, "Center");
    }

    public Graph getGraph() {
        return this._graph;
    }

    public GraphExporter getExporter() {
        return this._exporter;
    }

    public GraphDataModel getGraphDataModel() {
        return this._dataModel;
    }

    public void initGraph(GraphDataModel graphDataModel) {
        this._dataModel = graphDataModel;
        this.initGraph();
    }

    public void setLoadingStyle(String string) {
        if (this._dataModel == null || this._dataModel.getRowLabels().length < 1) {
            return;
        }
        this._graph.getTitle().setText(string);
        Series series = this._graph.getSeries();
        for (int i = 0; i < this._dataModel.getRowLabels().length; ++i) {
            try {
                series.setColor(Color.lightGray, i);
                continue;
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                seriesOutOfRangeException.printStackTrace();
                assert (false) : seriesOutOfRangeException;
                continue;
            }
        }
    }

    public void setDepthRadius() {
        this._graph.setDepthRadius(this._dataModel.getDepthRadius().intValue());
        this._graph.updateUI();
    }

    public void updateGraphStyle() {
        this.setGraphStyle(this._dataModel.getStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGraphStyle(String string) {
        if (string == null) {
            return;
        }
        try {
            this._graph.setStylePath(string);
            this._graph.updateUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initGraph() {
        if (this._dataModel != null) {
            int n;
            int n2;
            Color[][] colorArray;
            Object object;
            Integer n3;
            this.setMinimumSize(new Dimension(0, 0));
            this._graph.setGridData(this._dataModel.getColumnLabels(), this._dataModel.getRowLabels(), this._dataModel.getGraphData());
            this._graph.setMinimumSize(new Dimension(0, 0));
            String string = this._dataModel.getTitle();
            this._graph.setDepthRadius(this._dataModel.getDepthRadius().intValue());
            Integer n4 = this._dataModel.getLegendSeriesStart();
            if (n4 != null) {
                this._graph.setLegendSeriesStart(n4.intValue());
            }
            if ((n3 = this._dataModel.getLegendSeriesCount()) != null) {
                this._graph.setLegendSeriesCount(n3.intValue());
            }
            this._graph.getLegendArea().setVisible(this._dataModel.isLegendVisible());
            this._graph.setLegendScrollbarPresence(0);
            this._graph.getLegendArea().setAutomaticPlacement(0);
            this._graph.getLegendArea().setPosition(1);
            String string2 = this._dataModel.getStyle();
            this.setGraphStyle(string2);
            this._graph.setLineDataLineDisplayed(this._dataModel.isLineDataLineDisplayed());
            this._graph.setMarkerDisplayed(this._dataModel.isLineDataLineDisplayed());
            if (string != null) {
                object = this._graph.getTitle();
                object.setVisible(true);
                object.setText(this._dataModel.getTitle());
            } else {
                this._graph.getTitle().setVisible(false);
            }
            object = this._dataModel.getGraphType();
            if (object != null) {
                this._graph.setGraphType(((Integer)object).intValue());
                if ((Integer)object == 61) {
                    this._graph.setScatterDataLineDisplayed(this._dataModel.isScatterDataLineDisplayed());
                }
            }
            String string3 = this._dataModel.getX1Title();
            Double d = (Double)this._dataModel.maxX1Value();
            Double d2 = (Double)this._dataModel.minX1Value();
            if (string3 != null) {
                this._graph.getX1Title().setText(string3);
                this._graph.getX1Title().setVisible(true);
            }
            if (d == null) {
                this._graph.getX1Axis().setAxisMaxAutoScaled(true);
            } else {
                this._graph.getX1Axis().setAxisMinValue(d2.doubleValue());
                this._graph.getX1Axis().setAxisMaxValue(d.doubleValue());
                this._graph.getX1Axis().setAxisMinAutoScaled(false);
                this._graph.getX1Axis().setAxisMaxAutoScaled(false);
            }
            String string4 = this._dataModel.getY1Title();
            Double d3 = (Double)this._dataModel.maxY1Value();
            Double d4 = (Double)this._dataModel.minY1Value();
            if (string4 != null) {
                this._graph.getY1Title().setText(string4);
                this._graph.getY1Title().setVisible(true);
            }
            this._graph.getY2Axis().setVisible(false);
            if (d3 == null) {
                this._graph.getY1Axis().setAxisMaxAutoScaled(true);
            } else {
                this._graph.getY1Axis().setAxisMinValue(d4.doubleValue());
                this._graph.getY1Axis().setAxisMaxValue(d3.doubleValue());
                this._graph.getY1Axis().setAxisMinAutoScaled(false);
                this._graph.getY1Axis().setAxisMaxAutoScaled(false);
            }
            Color[] colorArray2 = this._dataModel.getRowColors();
            if (colorArray2 != null && colorArray2.length == this._dataModel.getRowLabels().length) {
                colorArray = this._graph.getSeries();
                for (n2 = 0; n2 < colorArray2.length; ++n2) {
                    try {
                        colorArray.setColor(colorArray2[n2], n2);
                        n = 2;
                        colorArray.setLineWidth(n, n2);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        seriesOutOfRangeException.printStackTrace();
                        assert (false) : seriesOutOfRangeException;
                        continue;
                    }
                }
            }
            if (this._dataModel.getRowMarkerShapes().length > 0) {
                for (int i = 0; i < this._dataModel.getRowMarkerShapes().length; ++i) {
                    try {
                        Object object2 = this._dataModel.getRowMarkerShapes()[i];
                        this._graph.getSeries().setMarkerShape(((Integer)object2).intValue(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        seriesOutOfRangeException.printStackTrace();
                        assert (false) : seriesOutOfRangeException;
                        continue;
                    }
                }
            }
            if (this._dataModel.getRowMarkerTypes().length > 0) {
                for (int i = 0; i < this._dataModel.getRowMarkerTypes().length; ++i) {
                    try {
                        Object object3 = this._dataModel.getRowMarkerTypes()[i];
                        this._graph.getSeries().setMarkerType(((Integer)object3).intValue(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        seriesOutOfRangeException.printStackTrace();
                        assert (false) : seriesOutOfRangeException;
                        continue;
                    }
                }
            }
            if ((colorArray = this._dataModel.getRowColors2()) != null) {
                for (n2 = 0; n2 < colorArray.length; ++n2) {
                    for (n = 0; n < colorArray[n2].length; ++n) {
                        Color color = colorArray[n2][n];
                        ExceptionalRiser exceptionalRiser = this._graph.createExceptionalRiser(n, n2);
                        if (exceptionalRiser == null) continue;
                        exceptionalRiser.getSFX().setFillType(1);
                        exceptionalRiser.setFillColor(color);
                    }
                }
            }
            this._graph.setLineDataLineDisplayed(false);
        }
    }

    public void refreshGraph() {
        if (this._dataModel != null) {
            this._graph.setGridData(this._dataModel.getColumnLabels(), this._dataModel.getRowLabels(), this._dataModel.getGraphData());
            Color[] colorArray = this._dataModel.getRowColors();
            if (colorArray != null && colorArray.length == this._dataModel.getRowLabels().length) {
                Series series = this._graph.getSeries();
                for (int i = 0; i < colorArray.length; ++i) {
                    try {
                        series.setColor(colorArray[i], i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        seriesOutOfRangeException.printStackTrace();
                        assert (false) : seriesOutOfRangeException;
                        continue;
                    }
                }
            }
        }
    }

    static {
        LOADING_GRAPH.setEditable(false);
    }
}

