/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.DefaultRowSorter;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumnsTableModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumnsTableRowSorter;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;

public class GenericTableFixedColumns
extends GenericTable
implements ActionListener {
    private boolean loading;
    private static final int MIN_COL_WIDTH = 5;
    private FixedTable _rowHeader;
    private int _numberFixedColumns = 1;
    private int _selectionMode = 0;
    private HashMap<String, TableCellRenderer> _map = new HashMap();
    private HashMap<String, Integer> _mapFixedColumnsPreferedWidth = new HashMap();
    private HashSet<String> _nonSortableColumns = new HashSet();
    GenericTableFixedColumnsTableModel _wrapper;

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public void setSortRetainsSelection(boolean bl) {
        this.setUpdateSelectionOnSort(bl);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public GenericTableFixedColumns() {
        this.setAutoResizeMode(4);
        this.getTableHeader().setAutoscrolls(true);
        this.setDragEnabled(false);
        this.getTableHeader().setReorderingAllowed(false);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(65, 2, false);
        this.registerKeyboardAction(this, "All", keyStroke, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(67, 2, false);
        this.registerKeyboardAction(this, "Copy", keyStroke2, 0);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        this.setSelectionModel(listSelectionModel);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (GenericTableFixedColumns.this.loading) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                int[] nArray = GenericTableFixedColumns.this.getSelectedRowsInModel();
                int[] nArray2 = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray2[i] = GenericTableFixedColumns.this.convertRowIndexToModel(nArray[i]);
                }
                if (GenericTableFixedColumns.this._rowHeader != null) {
                    GenericTableFixedColumns.this._rowHeader.setSelectionModel(listSelectionModel);
                }
                if (listSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                GenericTableFixedColumns.this.handleSelectionChanged(listSelectionModel);
            }
        });
        this.setAutoCreateColumnsFromModel(true);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectorAvailable(false);
    }

    public void setSorted(boolean bl) {
        if (this.isSorted() != bl) {
            this.setRowSorter(bl ? new GenericTableFixedColumnsTableRowSorter<TableModel>(this.getModel()) : null);
        }
    }

    public void copySelectionToClipBoard() {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.getSelectedRows();
        String string = "\t";
        String string2 = "\n";
        int n = this._wrapper.getColumnCountForAllColumns();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = this.convertRowIndexToModel(nArray[i]);
                stringBuffer.append(this.convertValueToText(this._wrapper.getValueAtForAllColumns(n2, j), true, true, n2, j));
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().compareTo("All") == 0) {
            try {
                this.selectAll();
                if (this._rowHeader != null) {
                    this._rowHeader.selectAll();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().compareTo("Copy") == 0) {
            try {
                this.copySelectionToClipBoard();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void disallowSorting(String string) {
        if (this._nonSortableColumns == null) {
            this._nonSortableColumns = new HashSet();
        }
        this._nonSortableColumns.add(string);
    }

    public void setSortColumn(int n, boolean bl) {
        super.setSortColumn(n, bl);
    }

    protected void handleSelectionChanged(ListSelectionModel listSelectionModel) {
    }

    public void addCellRenderer(String string, TableCellRenderer tableCellRenderer) {
        this._map.put(string, tableCellRenderer);
    }

    public void setColumnPreferredWidth(String string, int n) {
        Dimension dimension = super.getPreferredSize();
        this.addCellRenderer(string, new CustomWidthTableCellRenderer(new Dimension(n, (int)dimension.getHeight())));
    }

    public void setFixedColumnPreferredWidth(String string, int n) {
        this._mapFixedColumnsPreferedWidth.put(string, n);
    }

    public void addDynamicCellRenderers() {
    }

    public void setCellRenderers() {
        this.setupRenderers((JTable)((Object)this));
    }

    public void setRowHeaderCellRenderers() {
        if (this._rowHeader != null) {
            this.setupRenderers(this._rowHeader);
        }
    }

    public void setSelectionMode(int n) {
        super.setSelectionMode(n);
        this._selectionMode = n;
        if (this._rowHeader != null) {
            this._rowHeader.setSelectionMode(this._selectionMode);
        }
    }

    public void findOrCreateTableRowHeader(JScrollPane jScrollPane) {
        Dimension dimension = jScrollPane.getPreferredSize();
        JTable jTable = this.getCustomRowHeader();
        Dimension dimension2 = this.getRowHeaderSize();
        Dimension dimension3 = null;
        if (dimension2.getWidth() > dimension.getWidth()) {
            dimension3 = new Dimension((int)dimension.getWidth(), (int)dimension2.getHeight());
            this.setAutoResizeMode(2);
        } else {
            dimension3 = new Dimension(dimension2);
        }
        JViewport jViewport = new JViewport();
        jViewport.setPreferredSize(dimension3);
        jViewport.setView(jTable);
        jScrollPane.setRowHeader(jViewport);
        JTableHeader jTableHeader = jTable.getTableHeader();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jTableHeader);
    }

    public void setFixedColumnCount(int n) {
        this._numberFixedColumns = n;
    }

    public TableModel getModel() {
        TableModel tableModel = super.getModel();
        return tableModel;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel instanceof GenericBaseTableModel) {
            GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)tableModel;
            this._wrapper = new GenericTableFixedColumnsTableModel<GenericBaseTableModel>(genericBaseTableModel, this._numberFixedColumns);
            super.setModel((TableModel)this._wrapper);
            if (this.dataModel != tableModel && !this.getAutoCreateRowSorter() && this.isSorted()) {
                this.setRowSorter(new GenericTableFixedColumnsTableRowSorter<TableModel>(tableModel));
            }
        } else {
            super.setModel(tableModel);
        }
    }

    public TableModel getBaseModel() {
        GenericTableFixedColumnsTableModel genericTableFixedColumnsTableModel;
        TableModel tableModel = super.getModel();
        if (tableModel instanceof GenericTableFixedColumnsTableModel && (genericTableFixedColumnsTableModel = (GenericTableFixedColumnsTableModel)tableModel) != null) {
            return genericTableFixedColumnsTableModel.getBaseModel();
        }
        return tableModel;
    }

    public void adjustRowHeight(int n) {
        this.setRowHeight(n);
    }

    private JTable getCustomRowHeader() {
        if (this._rowHeader == null) {
            this._rowHeader = new FixedTable(this);
            this._rowHeader.setSelectionModel(this.getSelectionModel());
            KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 2, false);
            this._rowHeader.registerKeyboardAction(this, "Copy", keyStroke, 0);
        }
        this._rowHeader.setModel(this.getModel());
        this._rowHeader.setupTable();
        return this._rowHeader;
    }

    private TableCellRenderer getCellCustomRenderer(String string) {
        return this._map.get(string);
    }

    private void autoScrollColumn(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x, point.y, 0, 0);
            this.scrollRectToVisible(rectangle3);
        }
    }

    private void setupRenderers(JTable jTable) {
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = enumeration.nextElement();
            Object object = tableColumn.getHeaderValue();
            if (object == null || (tableCellRenderer = this._map.get(object.toString())) == null) continue;
            tableColumn.setCellRenderer(tableCellRenderer);
        }
    }

    private Dimension getRowHeaderSize() {
        return this._rowHeader != null ? this._rowHeader.getRowHeaderSize() : null;
    }

    private void scrollToVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, false);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n == -1 || n2 == -1) {
            return null;
        }
        Object object = this.getValueAt(n, n2);
        return this.customToolTipConverter(object, n, n2);
    }

    protected String customToolTipConverter(Object object, int n, int n2) {
        return object != null ? object.toString() : "";
    }

    public static void main(String[] stringArray) {
        GenericTableFixedColumns genericTableFixedColumns = new GenericTableFixedColumns();
        genericTableFixedColumns.setFixedColumnCount(2);
        genericTableFixedColumns.setModel((TableModel)((Object)new TestModel()));
        genericTableFixedColumns.setSelectionMode(0);
        genericTableFixedColumns.setColumnPreferredWidth("First Name", 100);
        genericTableFixedColumns.setColumnPreferredWidth("Last Name", 200);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)((Object)genericTableFixedColumns));
        genericTableFixedColumns.findOrCreateTableRowHeader(jScrollPane);
        genericTableFixedColumns.setColumnSelectorAvailable(true);
        genericTableFixedColumns.setSorted(true);
        genericTableFixedColumns.setCellRenderers();
        genericTableFixedColumns.autoSizeColumnsToFit();
        genericTableFixedColumns.setAutoResizeMode(0);
        genericTableFixedColumns.getTableHeader().setReorderingAllowed(false);
        JFrame jFrame = new JFrame("GenericTableFixedColumns Test");
        jFrame.getContentPane().add((Component)jScrollPane, "Center");
        jFrame.pack();
        jFrame.setLocation(200, 100);
        jFrame.setSize(250, 150);
        jFrame.setVisible(true);
    }

    static class TestModel
    extends GenericBaseTableModel {
        private String[] columnNames = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        private Object[][] data = new Object[][]{{"Mary", "Campione", "Snowboarding", new Integer(5), false}, {"Alison", "Huml", "Rowing", new Integer(3), true}, {"Kathy", "Walrath", "Knitting", new Integer(2), false}, {"Sharon", "Zakhour", "Speed reading", new Integer(20), true}, {"Philip", "Milne", "Pool", new Integer(10), false}};

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        TestModel() {
            this.setColumnIdentifiers(this.columnNames);
            this.setRowCount(4);
            this.setColumnCount(this.columnNames.length);
        }
    }

    private class FixedTable
    extends JTable
    implements GenericTableFixedColumnsRowConverter,
    ActionListener {
        private int _maxWidth = 0;
        private GenericTableFixedColumns _masterTable;

        public FixedTable(GenericTableFixedColumns genericTableFixedColumns2) {
            this._masterTable = genericTableFixedColumns2;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(65, 2, false);
            this.registerKeyboardAction(this, "All", keyStroke, 0);
        }

        private void setupTable() {
            this.setBackground(GenericTableFixedColumns.this.getBackground());
            this.getTableHeader().setReorderingAllowed(false);
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            this.setSelectionModel(listSelectionModel);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    FixedTable.this._masterTable.setSelectionModel(listSelectionModel);
                }
            });
            this.setColumnSelectionAllowed(false);
            this.setAutoResizeMode(0);
            this._maxWidth = 0;
            for (int i = 0; i < GenericTableFixedColumns.this._numberFixedColumns; ++i) {
                this._maxWidth += this.adjustColumnWidth(i);
            }
            GenericTableFixedColumns.this._rowHeader.setSelectionMode(GenericTableFixedColumns.this._selectionMode);
            GenericTableFixedColumns.this._rowHeader.setRowHeight(GenericTableFixedColumns.this.getRowHeight());
            GenericTableFixedColumns.this._rowHeader.setFillsViewportHeight(true);
            GenericTableFixedColumns.this.setupRenderers(GenericTableFixedColumns.this._rowHeader);
        }

        protected int translateHeaderRowToModel() {
            int n = super.getSelectedRow();
            int n2 = this.convertRowIndexToModel(n);
            return n2;
        }

        @Override
        public int convertHeaderRowToModel(int n) {
            int n2 = this.convertRowIndexToModel(n);
            return n2;
        }

        protected Dimension getRowHeaderSize() {
            return new Dimension(this._maxWidth, GenericTableFixedColumns.this.getRowHeight());
        }

        private int adjustColumnWidth(int n) {
            Object object;
            int n2;
            int n3 = 5;
            int n4 = this.getModel().getRowCount();
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            for (n2 = 0; n2 < n4; ++n2) {
                object = this.getValueAt(n2, n);
                TableCellRenderer tableCellRenderer = GenericTableFixedColumns.this.getCellCustomRenderer(tableColumn.getHeaderValue().toString());
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.getCellRenderer(n2, n);
                }
                if (tableCellRenderer == null || object == null) continue;
                int n5 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)n2, (int)n).getPreferredSize().width;
                n3 = Math.max(n5, n3);
            }
            n2 = tableColumn.getPreferredWidth();
            object = (Integer)GenericTableFixedColumns.this._mapFixedColumnsPreferedWidth.get(tableColumn.getHeaderValue());
            if (object != null) {
                n2 = Math.max((Integer)object, n2);
            }
            n3 = Math.max(n3, n2);
            tableColumn.setPreferredWidth(n3);
            this.setMaximumSize(new Dimension(n3, Integer.MAX_VALUE));
            this.setShowGrid(false);
            tableColumn.setResizable(false);
            return n3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TableModel tableModel = this.getModel();
            RowSorter rowSorter = GenericTableFixedColumns.this.getRowSorter();
            Object object = null;
            if (rowSorter == null) {
                try {
                    n = GenericTableFixedColumns.this.convertRowIndexToModel(n);
                    object = tableModel.getValueAt(n, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return object;
            }
            int n3 = 0;
            if (rowSorter instanceof DefaultRowSorter) {
                DefaultRowSorter defaultRowSorter = (DefaultRowSorter)rowSorter;
                n3 = defaultRowSorter.getModelRowCount();
            } else {
                n3 = rowSorter.getModelRowCount();
            }
            if (n < n3) {
                try {
                    n = GenericTableFixedColumns.this.convertRowIndexToModel(n);
                    object = tableModel.getValueAt(n, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return object;
        }

        @Override
        public void setModel(TableModel tableModel) {
            TableModel tableModel2;
            if (tableModel instanceof GenericTableFixedColumnsTableModel && (tableModel2 = ((GenericTableFixedColumnsTableModel)tableModel).getBaseModel()) instanceof GenericBaseTableModel) {
                GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)tableModel2;
                GenericTableFixedColumnsTableModel<GenericBaseTableModel> genericTableFixedColumnsTableModel = new GenericTableFixedColumnsTableModel<GenericBaseTableModel>(genericBaseTableModel, 0);
                super.setModel(genericTableFixedColumnsTableModel);
                return;
            }
            super.setModel(tableModel);
        }

        @Override
        public TableModel getModel() {
            TableModel tableModel = super.getModel();
            return tableModel;
        }

        @Override
        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            super.changeSelection(n, n2, bl, bl2);
        }

        @Override
        public void scrollRectToVisible(Rectangle rectangle) {
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            Object object = this.getValueAt(n, n2);
            return GenericTableFixedColumns.this.customToolTipConverter(object, n, n2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().compareTo("All") == 0) {
                try {
                    if (this._masterTable != null) {
                        this._masterTable.selectAll();
                    }
                    if (GenericTableFixedColumns.this._rowHeader != null) {
                        GenericTableFixedColumns.this._rowHeader.selectAll();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private class CustomWidthTableCellRenderer
    extends DefaultTableCellRenderer {
        private Dimension _dimension;

        public CustomWidthTableCellRenderer(Dimension dimension) {
            this._dimension = dimension;
        }

        @Override
        public Dimension getPreferredSize() {
            return this._dimension;
        }
    }

    public static interface GenericTableFixedColumnsRowConverter {
        public int convertHeaderRowToModel(int var1);
    }
}

