/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.GenericTableCheckBoxLabelCellValidator;
import oracle.dmt.dataminer.controls.GenericTableCheckBoxLabelTableModel;
import oracle.dmt.dataminer.controls.PairComparator;
import oracle.dmt.dataminer.controls.TextIcon;
import oracle.dmt.dataminer.workflow.ModelNameValidationDocument;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.dmt.javatools.ui.table.table.RolloverTableRenderer;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.javatools.util.Pair;

public class GenericTableCheckBoxLabel
extends GenericTable
implements KeyListener,
MouseListener {
    private static PairComparator _COMPARATOR = new PairComparator();
    private transient GenericTableCheckBoxLabelCellValidator validator;
    private int checkBoxColumn = 0;
    private GenericTableCheckBoxLabelCellEditor _editorCheckBox = new GenericTableCheckBoxLabelCellEditor();
    private boolean inPlaceEdit = false;

    public GenericTableCheckBoxLabel(GenericTableCheckBoxLabelTableModel genericTableCheckBoxLabelTableModel, int n) {
        super((TableModel)genericTableCheckBoxLabelTableModel);
        this.init(n);
    }

    public static PairComparator getComparatorInstance() {
        return _COMPARATOR;
    }

    public GenericTableCheckBoxLabel(int n) {
        this.init(n);
    }

    private void init(int n) {
        this.validator = null;
        this.setCheckBoxColumn(n);
        super.addKeyListener((KeyListener)this);
        super.addMouseListener((MouseListener)this);
        this.setDefaultRenderer(Object.class, (TableCellRenderer)new RolloverTableRenderer((TableCellRenderer)new GenericTableCheckBoxLabelCellRenderer()));
    }

    private GenericTableCheckBoxLabelTableModel getThisBaseModel() {
        return (GenericTableCheckBoxLabelTableModel)this.getModel();
    }

    public void setValidator(GenericTableCheckBoxLabelCellValidator genericTableCheckBoxLabelCellValidator) {
        this.validator = genericTableCheckBoxLabelCellValidator;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == ' ') {
            this._editorCheckBox.toggleCheckboxes();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        RolloverTableRenderer rolloverTableRenderer;
        TableCellRenderer tableCellRenderer;
        GenericTableCheckBoxLabelCellRenderer genericTableCheckBoxLabelCellRenderer;
        Component component;
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        if (n != -1 && (component = (genericTableCheckBoxLabelCellRenderer = (GenericTableCheckBoxLabelCellRenderer)(tableCellRenderer = (rolloverTableRenderer = (RolloverTableRenderer)this.getDefaultRenderer(Object.class)).getBaseRenderer())).getTableCellRendererComponent((JTable)((Object)this), this.getModel().getValueAt(n, this.checkBoxColumn), this.isCellSelected(n, this.checkBoxColumn), false, n, this.checkBoxColumn)) instanceof JLabeledCheckBox) {
            int n2 = ((JLabeledCheckBox)component).checkBox.getWidth();
            if (point.x < n2) {
                this.setEditingRow(n);
                this.setEditingColumn(this.checkBoxColumn);
                this._editorCheckBox.toggleCheckbox();
            } else {
                this.inPlaceEdit = true;
                this.setEditingRow(n);
                this.setEditingColumn(this.checkBoxColumn);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 == this.checkBoxColumn) {
            return this._editorCheckBox;
        }
        return super.getCellEditor(n, n2);
    }

    private void setCheckBoxColumn(int n) {
        this.checkBoxColumn = n;
    }

    class GenericTableCheckBoxLabelCellRenderer
    extends DefaultTableCellRenderer {
        private JLabeledCheckBox _check = new JLabeledCheckBox();

        GenericTableCheckBoxLabelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 != GenericTableCheckBoxLabel.this.checkBoxColumn) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                this._check.label.setEnabled(true);
                this._check.checkBox.setEnabled(true);
                this._check.checkBox.setSelected((Boolean)pair.getSecond());
                this._check.label.setSelected(bl);
                Object object2 = pair.getFirst();
                if (object2 instanceof TextIcon) {
                    TextIcon textIcon = (TextIcon)object2;
                    this._check.label.setIcon(textIcon.getIcon());
                    this._check.label.setText(textIcon.getText());
                } else {
                    this._check.label.setText((String)pair.getFirst());
                }
                this._check.label.setHasFocus(bl2);
                this._check.checkBox.setOpaque(false);
                this._check.label.setOpaque(false);
            }
            return this._check;
        }
    }

    private class GenericTableCheckBoxLabelCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private JLabeledCheckBox _component;
        private JTextField _editField;
        private transient String originalModelName;

        public GenericTableCheckBoxLabelCellEditor() {
            super(new JTextField());
            this._component = new JLabeledCheckBox();
            this._editField = new JTextField();
            this._editField.setDocument(new ModelNameValidationDocument(25, true));
        }

        @Override
        public Object getCellEditorValue() {
            if (!GenericTableCheckBoxLabel.this.inPlaceEdit) {
                return this._component.checkBox.getText();
            }
            return this._editField.getText();
        }

        @Override
        public Component getComponent() {
            if (!GenericTableCheckBoxLabel.this.inPlaceEdit) {
                return this._component;
            }
            return this._editField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                this._component.checkBox.setSelected((Boolean)pair.getSecond());
                Object object2 = pair.getFirst();
                if (object2 instanceof TextIcon) {
                    TextIcon textIcon = (TextIcon)object2;
                    this._component.label.setIcon(textIcon.getIcon());
                    this._component.label.setText(textIcon.getText());
                    this._editField.setText(textIcon.getText());
                } else {
                    this._component.label.setText((String)pair.getFirst());
                    this._editField.setText((String)pair.getFirst());
                }
                this._component.label.setSelected(true);
            }
            if (GenericTableCheckBoxLabel.this.inPlaceEdit) {
                this.originalModelName = this._editField.getText();
                return this._editField;
            }
            return this._component;
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl;
            if (GenericTableCheckBoxLabel.this.inPlaceEdit) {
                String string = (String)this.getCellEditorValue();
                if (GenericTableCheckBoxLabel.this.validator != null && !GenericTableCheckBoxLabel.this.validator.validate(string, this.originalModelName)) {
                    return false;
                }
            }
            if (bl = super.stopCellEditing()) {
                GenericTableCheckBoxLabel.this.inPlaceEdit = false;
            }
            return bl;
        }

        public void toggleCheckbox() {
            int n;
            GenericTableCheckBoxLabelTableModel genericTableCheckBoxLabelTableModel = GenericTableCheckBoxLabel.this.getThisBaseModel();
            Pair pair = genericTableCheckBoxLabelTableModel.getValueAtCheckBoxColumn(n = GenericTableCheckBoxLabel.this.convertRowIndexToModel(GenericTableCheckBoxLabel.this.getEditingRow()));
            Boolean bl = (Boolean)pair.getSecond();
            bl = bl.equals(Boolean.TRUE) ? Boolean.FALSE : Boolean.TRUE;
            pair.setSecond((Object)bl);
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            arrayList.add(pair);
            genericTableCheckBoxLabelTableModel.setValueAt(arrayList, -1, GenericTableCheckBoxLabel.this.checkBoxColumn);
        }

        public void toggleCheckboxes() {
            GenericTableCheckBoxLabelTableModel genericTableCheckBoxLabelTableModel = GenericTableCheckBoxLabel.this.getThisBaseModel();
            int[] nArray = GenericTableCheckBoxLabel.this.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            ArrayList<Pair> arrayList = new ArrayList<Pair>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                int n = GenericTableCheckBoxLabel.this.convertRowIndexToModel(nArray[i]);
                Pair pair = genericTableCheckBoxLabelTableModel.getValueAtCheckBoxColumn(n);
                Boolean bl = (Boolean)pair.getSecond();
                bl = bl.equals(Boolean.TRUE) ? Boolean.FALSE : Boolean.TRUE;
                pair.setSecond((Object)bl);
                arrayList.add(pair);
            }
            genericTableCheckBoxLabelTableModel.setValueAt(arrayList, -1, GenericTableCheckBoxLabel.this.checkBoxColumn);
        }
    }
}

