/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.repository.Column;
import oracle.dmt.dataminer.server.Compatibles;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;

public class ColumnChooserPane
extends JPanel {
    private String _selectedColumn;
    private Vector<Column> _allColumns;
    private DefaultListModel _listModel;
    private String _restrictToColDataType;
    private List _compatibleColDataTypes;
    private JLabel _jAvailableColumnsLbl;
    private JList _jColumnList;
    private JScrollPane _jColumnListScrollPane;
    private JLabel _jFilterLabel;
    private JTextField _jFilterTxtField;
    private JButton _jGoBtn;

    public ColumnChooserPane(Vector<Column> vector, String string, String string2) {
        this.initComponents();
        this._allColumns = vector;
        this._listModel = new DefaultListModel();
        this._restrictToColDataType = string;
        this._selectedColumn = string2;
        this._compatibleColDataTypes = Compatibles._columnDataTypes.get(this._restrictToColDataType);
        if (string == null || this._compatibleColDataTypes == null) {
            for (Column column : vector) {
                this._listModel.addElement(column.getName());
            }
        } else {
            this.processFiltering(null);
        }
        this.initRes();
        this.initUI();
    }

    public String getSelectedColumnName() {
        return this._selectedColumn;
    }

    private void initComponents() {
        this._jColumnListScrollPane = new JScrollPane();
        this._jColumnList = new JList();
        this._jFilterLabel = new JLabel();
        this._jFilterTxtField = new JTextField();
        this._jGoBtn = new JButton();
        this._jAvailableColumnsLbl = new JLabel();
        this._jColumnList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this._jColumnListScrollPane.setViewportView(this._jColumnList);
        this._jFilterLabel.setText("Filter Colums:");
        this._jGoBtn.setText("Go");
        this._jAvailableColumnsLbl.setText("Available Columns:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jColumnListScrollPane, -2, 224, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this._jFilterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFilterTxtField, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jGoBtn)).addComponent(this._jAvailableColumnsLbl)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jFilterLabel).addComponent(this._jFilterTxtField, -2, -1, -2).addComponent(this._jGoBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jAvailableColumnsLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jColumnListScrollPane, -1, 229, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        this._jAvailableColumnsLbl.setText(ControlsLrb.get("AVAILABLE_COLUMNS"));
        this._jFilterLabel.setText(ControlsLrb.get("FILTER_COLUMNS"));
        this._jGoBtn.setText(ControlsLrb.get("GO_BTN"));
    }

    public void initUI() {
        this._jColumnList.setModel(this._listModel);
        this._jColumnList.setSelectedValue(this._selectedColumn, true);
        this._jGoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnChooserPane.this.processFiltering(actionEvent);
            }
        });
    }

    private void processFiltering(ActionEvent actionEvent) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        ideMainWindow.setCursor(new Cursor(3));
        try {
            String string = this._jFilterTxtField.getText();
            for (Column column : this._allColumns) {
                if (this._compatibleColDataTypes != null && !this._compatibleColDataTypes.contains(column.getDataType())) continue;
                if (column.getName().startsWith(string)) {
                    if (this._listModel.contains(column.getName())) continue;
                    this._listModel.addElement(column.getName());
                    continue;
                }
                this._listModel.removeElement(column.getName());
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        ideMainWindow.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeDialog() {
        boolean bl = false;
        try {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, "Select Column", n);
            jEWTDialog.setContent((Component)this);
            jEWTDialog.setTitle("Select Column");
            jEWTDialog.setResizable(true);
            ColumnChooserPane columnChooserPane = (ColumnChooserPane)jEWTDialog.getContent();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                        ColumnChooserPane.this._selectedColumn = (String)ColumnChooserPane.this._jColumnList.getSelectedValue();
                    }
                }
            });
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowDialogLrb.get("SYSTEM_FAILURE"), (String)WorkflowDialogLrb.get("SYSTEM_FAILURE"), null);
        }
        finally {
            if (bl) {
                // empty if block
            }
        }
        return bl;
    }
}

