/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import oracle.dmt.dataminer.controls.CheckedItemData;
import oracle.dmt.dataminer.controls.LabeledCheckBoxRenderer;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.util.TriStateBoolean;

public class CheckBoxTableListener
implements MouseListener,
MouseMotionListener,
KeyListener {
    private LabeledCheckBoxRenderer _tableCellRenderer = new LabeledCheckBoxRenderer();
    private boolean _isArmed = false;
    private long _pressedTime = -1L;
    private int _pressedRow = -1;
    private int _checkBoxWidth = -1;
    private boolean _trackingMousePress = false;
    private boolean _trackingKeyPress = false;
    private static final int BOUNCE_TIME = 150;

    public CheckBoxTableListener(LabeledCheckBoxRenderer labeledCheckBoxRenderer) {
        this._tableCellRenderer = labeledCheckBoxRenderer;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this._trackingKeyPress) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                this.mouseReleased(mouseEvent);
            }
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this._pressedTime = mouseEvent.getWhen();
        JTable jTable = (JTable)mouseEvent.getComponent();
        this.pressRow(jTable, this.getCurrentRow(mouseEvent));
        if (this._pressedRow >= 0) {
            this._trackingMousePress = true;
            jTable.addMouseMotionListener(this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._trackingKeyPress) {
            return;
        }
        long l = mouseEvent.getWhen();
        JTable jTable = (JTable)mouseEvent.getComponent();
        this.releaseRow(jTable, this.getCurrentRow(mouseEvent), l);
        this._trackingMousePress = false;
        jTable.removeMouseMotionListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._pressedRow == -1) {
            return;
        }
        int n = this.getCurrentRow(mouseEvent);
        if (n != this._pressedRow && this._isArmed || n == this._pressedRow && !this._isArmed) {
            JTable jTable = (JTable)mouseEvent.getComponent();
            CheckedItemData checkedItemData = (CheckedItemData)jTable.getModel().getValueAt(jTable.convertRowIndexToModel(this._pressedRow), 0);
            this._isArmed = n == this._pressedRow;
            checkedItemData.setArmed(this._isArmed);
            Rectangle rectangle = jTable.getCellRect(this._pressedRow, 0, true);
            jTable.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = this._tableCellRenderer.getLastRowWithFocus();
        JTable jTable = (JTable)keyEvent.getComponent();
        if (n < 0 || keyEvent.getKeyCode() != 32) {
            return;
        }
        this.keyReleaseRow(jTable, n);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = this._tableCellRenderer.getLastRowWithFocus();
        JTable jTable = (JTable)keyEvent.getComponent();
        if (this._trackingKeyPress && keyEvent.getKeyCode() == 27) {
            this._trackingKeyPress = false;
            this.keyReleaseRow(jTable, -1);
            return;
        }
        if (n < 0 || keyEvent.getKeyCode() != 32) {
            return;
        }
        this.keyPressRow(jTable, n);
        if (keyEvent.getKeyCode() == 27) {
            this.keyReleaseRow(jTable, -1);
            return;
        }
    }

    void keyPressRow(JTable jTable, int n) {
        if (this._trackingMousePress || this._trackingKeyPress) {
            return;
        }
        this._trackingKeyPress = true;
        this.pressRow(jTable, n);
    }

    void keyReleaseRow(JTable jTable, int n) {
        if (this._trackingMousePress || !this._trackingKeyPress) {
            return;
        }
        this._trackingKeyPress = false;
        this.releaseRow(jTable, n, 0L);
    }

    private void pressRow(JTable jTable, int n) {
        if (n < 0) {
            this._pressedRow = -1;
            return;
        }
        if (this._pressedRow >= 0) {
            throw new IllegalStateException("Can't invoke pressRow() when a different row is already being pressed");
        }
        CheckedItemData checkedItemData = (CheckedItemData)jTable.getModel().getValueAt(jTable.convertRowIndexToModel(n), 0);
        boolean bl = checkedItemData.getHasCheckBox();
        boolean bl2 = checkedItemData.isCheckBoxSelectable();
        if (!bl || !bl2) {
            this._pressedRow = -1;
            return;
        }
        this._isArmed = true;
        checkedItemData.setArmed(true);
        checkedItemData.setPressed(true);
        this._pressedRow = n;
        Rectangle rectangle = jTable.getCellRect(this._pressedRow, 0, true);
        jTable.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void releaseRow(JTable jTable, int n, long l) {
        this._checkBoxWidth = -1;
        this._isArmed = false;
        if (this._pressedRow < 0) {
            this._pressedTime = -1L;
            return;
        }
        long l2 = l > 0L ? l - this._pressedTime : 0L;
        CheckedItemData checkedItemData = (CheckedItemData)jTable.getModel().getValueAt(jTable.convertRowIndexToModel(this._pressedRow), 0);
        checkedItemData.setPressed(false);
        checkedItemData.setArmed(false);
        if (n >= 0 && (this._pressedRow == n || l2 <= 150L)) {
            TriStateBoolean triStateBoolean = checkedItemData.getCheckBoxState();
            TriStateBoolean triStateBoolean2 = triStateBoolean.toggle();
            checkedItemData.setCheckBoxState(triStateBoolean2);
            if (triStateBoolean2.isTrue()) {
                this.itemChecked(n);
            } else {
                this.itemUnchecked(n);
            }
        }
        jTable.repaint();
        this._pressedRow = -1;
    }

    protected void itemChecked(int n) {
    }

    protected void itemUnchecked(int n) {
    }

    private int getCurrentRow(MouseEvent mouseEvent) {
        Object object;
        JTable jTable = (JTable)mouseEvent.getComponent();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = jTable.rowAtPoint(new Point(n, n2));
        int n4 = jTable.columnAtPoint(new Point(n, n2));
        if (n3 < 0) {
            return -1;
        }
        if (this._checkBoxWidth < 0) {
            Component component;
            object = jTable.getModel().getValueAt(n3, n4);
            TableCellRenderer tableCellRenderer = jTable.getColumnModel().getColumn(n4).getCellRenderer();
            this._checkBoxWidth = tableCellRenderer != null ? ((component = tableCellRenderer.getTableCellRendererComponent(jTable, object, true, true, n3, n4)) instanceof JLabeledCheckBox ? ((JLabeledCheckBox)component).checkBox.getWidth() : 0) : 0;
        }
        object = jTable.getCellRect(n3, n4, true);
        if (n > ((Rectangle)object).x + this._checkBoxWidth) {
            return -1;
        }
        return n3;
    }
}

