/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer;

import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorManager;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.runner.RunManagerDockableFactory;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DataMinerConnections;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.dialogs.MessageDialog;

public class ToolsMenuAddin
implements Controller,
Addin {
    private static final String DATA_MINER_UI_TOOL_MENU_NAME = StringUtils.stripMnemonic((String)PreferencesLrb.get("DATA_MINER_DISPLAY_UI"));
    private static final String DATA_MINER_DROP_REPOS_MENU_NAME = StringUtils.stripMnemonic((String)PreferencesLrb.get("DATA_MINER_DROP_REPOS"));
    private static final int DATA_MINER_UI_TOOL_MENU_NAME_MNEMONIC = StringUtils.getMnemonicKeyCode((String)PreferencesLrb.get("DATA_MINER_DISPLAY_UI"));
    private Icon _icon;
    public static final int TOOLS_DATA_MINER_DISPLAY_UI = Ide.createCmdID((String)"dataminer.toolsDataMinerDisplayUI");
    public static final int TOOLS_DATA_MINER_DROP_REPOS = Ide.createCmdID((String)"dataminer.dropRepos");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == TOOLS_DATA_MINER_DISPLAY_UI) {
            DataminerNavigatorManager.getNavigatorInstance().show();
            RunManagerDockableFactory runManagerDockableFactory = RunManagerDockableFactory.getInstance();
            DockableWindow dockableWindow = (DockableWindow)runManagerDockableFactory.getDockable(runManagerDockableFactory.getDockableViewId());
            dockableWindow.setDockableVisible(true);
            return true;
        }
        if (n == TOOLS_DATA_MINER_DROP_REPOS) {
            String string;
            Node node = context.getNode();
            String string2 = null;
            if (node instanceof ConnectionFolder) {
                string2 = ((ConnectionFolder)node).getShortLabel();
                string2 = DataMinerConnections.getQualifiedName(string2);
            }
            if ((string = ConnectionSelectorUI.getConnection((String)PreferencesLrb.get("SELECT_CONN_TITLE"), (String)PreferencesLrb.get("SELECT_CONN_MSG"), (String)string2, (boolean)true)) == null) {
                return true;
            }
            String string3 = DataMinerConnections.getUnqualifiedName(string);
            Context context2 = null;
            URL uRL = DMURLFormatHelper.getURL(string3);
            ConnectionFolder connectionFolder = (ConnectionFolder)NodeFactory.find((URL)uRL);
            if (connectionFolder != null) {
                context2 = Context.newIdeContext((Node)connectionFolder);
            }
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)PreferencesLrb.get("DROP_REPOS_CONFIRM"), (String)PreferencesLrb.get("DROP_REPOS_CONFIRM_TITLE"), null, (boolean)true)) {
                return true;
            }
            ConfigUtils.configureConnection(context2, string3, ConfigUtils.RunMode.DROP_REPOS);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == TOOLS_DATA_MINER_DISPLAY_UI || n == TOOLS_DATA_MINER_DROP_REPOS) {
            if (n == TOOLS_DATA_MINER_DISPLAY_UI) {
                boolean bl = DataminerNavigatorManager.getNavigatorInstance().isVisible();
                RunManagerDockableFactory runManagerDockableFactory = RunManagerDockableFactory.getInstance();
                DockableWindow dockableWindow = (DockableWindow)runManagerDockableFactory.getDockable(runManagerDockableFactory.getDockableViewId());
                boolean bl2 = dockableWindow.isVisible();
                ideAction.setEnabled(!bl || !bl2);
            }
            return true;
        }
        return false;
    }

    public void initialize() {
        this.createActions();
    }

    private void createActions() {
        Menubar menubar = Ide.getMenubar();
        IdeAction ideAction = IdeAction.get((int)TOOLS_DATA_MINER_DISPLAY_UI, null, (String)DATA_MINER_UI_TOOL_MENU_NAME, (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)DATA_MINER_UI_TOOL_MENU_NAME_MNEMONIC, null, null, (boolean)true);
        IdeAction ideAction2 = IdeAction.get((int)TOOLS_DATA_MINER_DROP_REPOS, null, (String)DATA_MINER_DROP_REPOS_MENU_NAME, (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, null, null, (boolean)true);
        ideAction.addController((Controller)this);
        ideAction2.addController((Controller)this);
        JMenu jMenu = menubar.createMenu(PreferencesLrb.get("DATA_MINER_SUBMENU"), (float)StringUtils.getMnemonicKeyCode((String)"&a"));
        jMenu.setIcon(this.getIcon());
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction);
        JMenuItem jMenuItem2 = menubar.createMenuItem((ToggleAction)ideAction2);
        JMenu jMenu2 = MenuManager.getJMenu((String)"Tools");
        menubar.add((Component)jMenuItem, jMenu, 1.0f);
        menubar.add((Component)jMenuItem2, jMenu, 2.0f);
        menubar.add((Component)jMenu, jMenu2, MenuConstants.SECTION_TOOLS_ADDINS);
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("GENERIC_MODEL_NODE_ICON"));
        }
        return this._icon;
    }
}

